/*
 * Decompiled with CFR 0.152.
 */
package defaults;

import CryptoServerJCE.CryptoServerProvider;
import defaults.crypt_AES;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.DSAPublicKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class sign_DSA {
    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2;
        String string;
        System.out.println("\n--- Utimaco CryptoServer JCE - sign_DSA ---\n");
        if (System.getProperty("os.name").indexOf("AIX") >= 0) {
            string = "IBMJCE";
            stringArray2 = new String[]{"SHA1withDSA"};
        } else {
            string = "BC";
            stringArray2 = new String[]{"SHA1withDSA", "SHA256withDSA", "SHA224withDSA", "SHA384withDSA", "SHA512withDSA", "SHA3-224withDSA", "SHA3-256withDSA", "SHA3-384withDSA", "SHA3-512withDSA", "NONEwithDSA"};
        }
        int[] nArray = new int[]{1024};
        CryptoServerProvider cryptoServerProvider = null;
        try {
            cryptoServerProvider = stringArray.length > 0 ? new CryptoServerProvider(stringArray[0]) : new CryptoServerProvider(crypt_AES.class.getResourceAsStream("/CryptoServer.cfg"));
            Security.addProvider((Provider)cryptoServerProvider);
            Security.addProvider((Provider)new BouncyCastleProvider());
            cryptoServerProvider.loginPassword("JCE", "12345678");
            for (int i = 0; i < 2; ++i) {
                for (String string2 : stringArray2) {
                    Provider provider;
                    Object object;
                    System.out.println("algo: " + string2);
                    if (i == 0) {
                        object = cryptoServerProvider;
                        provider = Security.getProvider(string);
                    } else {
                        object = Security.getProvider(string);
                        provider = cryptoServerProvider;
                    }
                    System.out.println("  Sign on  : " + ((Provider)object).getName());
                    System.out.println("  Verify on: " + provider.getName());
                    for (int n : nArray) {
                        System.out.println("    size: " + n);
                        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA", (Provider)object);
                        keyPairGenerator.initialize(n);
                        KeyPair keyPair = keyPairGenerator.generateKeyPair();
                        PrivateKey privateKey = keyPair.getPrivate();
                        KeyFactory keyFactory = KeyFactory.getInstance("DSA", (Provider)object);
                        DSAPublicKeySpec dSAPublicKeySpec = keyFactory.getKeySpec(keyPair.getPublic(), DSAPublicKeySpec.class);
                        keyFactory = KeyFactory.getInstance("DSA", provider);
                        PublicKey publicKey = keyFactory.generatePublic(dSAPublicKeySpec);
                        Signature signature = Signature.getInstance(string2, (Provider)object);
                        Signature signature2 = Signature.getInstance(string2, provider);
                        for (int j = 1; j < 33; j += 3) {
                            byte[] byArray = string2.indexOf("NONE") < 0 ? sign_DSA.getRandom(j) : sign_DSA.getRandom(10);
                            for (int k = 1; k < 22; k += 2) {
                                byte[] byArray2 = string2.indexOf("NONE") < 0 ? sign_DSA.getRandom(k) : sign_DSA.getRandom(10);
                                signature.initSign(privateKey);
                                signature.update(byArray);
                                signature.update(byArray2);
                                byte[] byArray3 = signature.sign();
                                byte[] byArray4 = sign_DSA.cat(byArray, byArray2);
                                signature2.initVerify(publicKey);
                                signature2.update(byArray4);
                                if (signature2.verify(byArray3)) continue;
                                throw new Exception("Signature Verification failed");
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (cryptoServerProvider != null) {
                cryptoServerProvider.close();
            }
        }
        System.out.println("Done");
    }

    private static byte[] getRandom(int n) {
        try {
            byte[] byArray = new byte[n];
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            do {
                secureRandom.nextBytes(byArray);
            } while (byArray[0] == 0);
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static byte[] cat(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2;
        }
        if (byArray2 == null) {
            return byArray;
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }
}

