/*
 * Decompiled with CFR 0.152.
 */
package defaults;

import CryptoServerJCE.CryptoServerKeyGenParameterSpec;
import CryptoServerJCE.CryptoServerProvider;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.util.Date;
import java.util.Enumeration;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class key_Generate {
    public static void main(String[] stringArray) throws Exception {
        System.out.println("\n--- Utimaco CryptoServer JCE: key_Generate ---\n");
        CryptoServerProvider cryptoServerProvider = null;
        try {
            cryptoServerProvider = stringArray.length > 0 ? new CryptoServerProvider(stringArray[0]) : new CryptoServerProvider(key_Generate.class.getResourceAsStream("/CryptoServer.cfg"));
            cryptoServerProvider.loginPassword("JCE", "12345678");
            KeyStore keyStore = KeyStore.getInstance("CryptoServer", (Provider)cryptoServerProvider);
            keyStore.load(null, null);
            System.out.println("generate AES key...");
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", (Provider)cryptoServerProvider);
            CryptoServerKeyGenParameterSpec cryptoServerKeyGenParameterSpec = new CryptoServerKeyGenParameterSpec();
            cryptoServerKeyGenParameterSpec.setExportable(true);
            cryptoServerKeyGenParameterSpec.setKeySize(256);
            keyGenerator.init((AlgorithmParameterSpec)cryptoServerKeyGenParameterSpec, null);
            SecretKey secretKey = keyGenerator.generateKey();
            keyStore.setKeyEntry("AES_gen_1", secretKey, null, null);
            System.out.println("generate DES key...");
            keyGenerator = KeyGenerator.getInstance("DESede", (Provider)cryptoServerProvider);
            keyGenerator.init(112, null);
            SecretKey secretKey2 = keyGenerator.generateKey();
            keyStore.setKeyEntry("DES_gen_1", secretKey2, null, null);
            System.out.println("generate RSA key...");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", (Provider)cryptoServerProvider);
            keyPairGenerator.initialize(2048, null);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            keyStore.setKeyEntry("{U}RSA_prv_gen_1", privateKey, null, (Certificate[])cryptoServerProvider.getDumyCertificateChain());
            System.out.println("generate EC key...");
            keyPairGenerator = KeyPairGenerator.getInstance("EC", (Provider)cryptoServerProvider);
            keyPairGenerator.initialize(new ECGenParameterSpec("NIST-P256"));
            KeyPair keyPair2 = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey2 = keyPair2.getPrivate();
            PublicKey publicKey2 = keyPair2.getPublic();
            keyStore.setKeyEntry("EC_prv_gen_1", privateKey2, null, (Certificate[])cryptoServerProvider.getDumyCertificateChain());
            System.out.println("generate DSA key...");
            keyPairGenerator = KeyPairGenerator.getInstance("DSA", (Provider)cryptoServerProvider);
            keyPairGenerator.initialize(1024, null);
            KeyPair keyPair3 = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey3 = keyPair3.getPrivate();
            PublicKey publicKey3 = keyPair3.getPublic();
            keyStore.setKeyEntry("DSA_prv_gen_1", privateKey3, null, (Certificate[])cryptoServerProvider.getDumyCertificateChain());
            System.out.println("generate EC_Edwards key...");
            keyPairGenerator = KeyPairGenerator.getInstance("EdDSA", (Provider)cryptoServerProvider);
            keyPairGenerator.initialize(new ECGenParameterSpec("Ed25519"));
            KeyPair keyPair4 = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey4 = keyPair4.getPrivate();
            PublicKey publicKey4 = keyPair4.getPublic();
            keyStore.setKeyEntry("ECEd_prv_gen_1", privateKey4, null, (Certificate[])cryptoServerProvider.getDumyCertificateChain());
            Enumeration<String> enumeration = keyStore.aliases();
            System.out.println(String.format("%-12s %-20s %s", "type", "name", "creation date"));
            System.out.println("----------------------------------------------------------------------");
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Date date = keyStore.getCreationDate(string);
                String string2 = keyStore.isKeyEntry(string) ? "Key" : (keyStore.isCertificateEntry(string) ? "Certificate" : "???");
                System.out.println(String.format("%-12s %-20s %s", string2, string, date));
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (cryptoServerProvider != null) {
                cryptoServerProvider.close();
            }
        }
        System.out.println("Done");
    }
}

