/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import CryptoServerCXI.Item;
import com.utimaco.javacpp.global.UcapiWrapperGlobal;
import com.utimaco.javacpp.ucapi.UcapiBuffer;
import com.utimaco.javacpp.ucapi.UcapiExportPolicy;
import com.utimaco.javacpp.ucapi.UcapiKeyBlob;
import com.utimaco.javacpp.ucapi.UcapiKeyExport;
import com.utimaco.javacpp.ucapi.UcapiKeyHandle;
import com.utimaco.javacpp.ucapi.UcapiKeyProperties;
import com.utimaco.javacpp.ucapi.UcapiVectorU8;
import com.utimaco.jce.hsm.HSM;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class ToolBox {
    public static final String DATE_PATTERN = "yyMMddHHmmss";
    public static final HashMap<String, String> curveNameAliases = new HashMap();
    private static final BigInteger TWO_COMPL_REF;
    private static final char[] HEX_ARRAY;

    public static String getCurveAlias(String string) {
        return curveNameAliases.getOrDefault(string, string);
    }

    public static String getOidString(byte[] byArray) {
        String string = null;
        Oid oid = null;
        try {
            oid = new Oid(byArray);
            string = oid.toString();
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
        return string;
    }

    public static String strlcpy(String string, int n) {
        int n2 = string.length();
        if (n < n2) {
            return string.substring(0, n);
        }
        return string.substring(0, n2);
    }

    public static int strlen(String string) {
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    public static String format(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "?";
        }
        return string.replaceFirst("%s", string2);
    }

    public static String format(String string, String[] stringArray) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                stringArray[i] = "?";
            }
            string = string.replaceFirst("%s", stringArray[i]);
        }
        return string;
    }

    public static String toHexString(byte[] byArray) {
        return new String(ToolBox.binToHex(byArray, 0, byArray.length));
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        return new String(ToolBox.binToHex(byArray, n, n2));
    }

    public static String toHexString(int n) {
        String string = new String();
        for (int i = 28; i >= 0; i -= 4) {
            string = string + (n >> i & 0xF);
        }
        return string;
    }

    public static String toDateString(long l) {
        Date date = new Date(l * 1000L);
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        return dateFormat.format(date);
    }

    public static void arraycopy(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 >= n4) {
            System.arraycopy(byArray, n, byArray2, n3, n4);
        } else {
            System.arraycopy(byArray, n, byArray2, n3, n2);
            Arrays.fill(byArray2, n3 + n2, n3 + n4, (byte)0);
        }
    }

    public static int arraycmp(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (byArray2.length < n2 || byArray.length < n + n2) {
            return -1;
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return -1;
        }
        return 0;
    }

    public static byte[] createCXIKeyBlob(byte[] byArray) {
        byte[] byArray2 = Item.mkItemList(CryptoServerCXI.TAG_BH, Item.mkItemList(CryptoServerCXI.TAG_PL, new byte[0]), CryptoServerCXI.TAG_KC, byArray);
        byArray2 = Item.mkItemList(CryptoServerCXI.TAG_KB, byArray2);
        return byArray2;
    }

    public static byte[] binToHex(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        byte[] byArray3 = new byte[n2 * 2];
        for (int i = 0; i < n2; ++i) {
            byArray3[2 * i] = byArray2[byArray[n + i] >> 4 & 0xF];
            byArray3[2 * i + 1] = byArray2[byArray[n + i] & 0xF];
        }
        return byArray3;
    }

    public static byte[] hexToBin(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2 /= 2];
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[n + 2 * i];
            int n4 = byArray[n + 2 * i + 1];
            n3 = n3 >= 97 ? (n3 -= 87) : (n3 >= 65 ? (n3 -= 55) : (n3 -= 48));
            n4 = n4 >= 97 ? (n4 -= 87) : (n4 >= 65 ? (n4 -= 55) : (n4 -= 48));
            byArray2[i] = (byte)((n3 << 4) + n4);
        }
        return byArray2;
    }

    public static int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static long load_long4(byte[] byArray, int n) {
        long l = byArray[n] & 0xFF;
        long l2 = byArray[n + 1] & 0xFF;
        long l3 = byArray[n + 2] & 0xFF;
        long l4 = byArray[n + 3] & 0xFF;
        return (l << 24) + (l2 << 16) + (l3 << 8) + l4;
    }

    public static byte[] store_int4(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return byArray;
    }

    public static void store_int4(int n, byte[] byArray) {
        byArray[0] = (byte)(n >> 24);
        byArray[1] = (byte)(n >> 16);
        byArray[2] = (byte)(n >> 8);
        byArray[3] = (byte)n;
    }

    public static void store_int4(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 24);
        byArray[n2 + 1] = (byte)(n >> 16);
        byArray[n2 + 2] = (byte)(n >> 8);
        byArray[n2 + 3] = (byte)n;
    }

    public static int load_int4(byte[] byArray) {
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = byArray[2] & 0xFF;
        int n4 = byArray[3] & 0xFF;
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    public static int load_int4(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        int n4 = byArray[n + 2] & 0xFF;
        int n5 = byArray[n + 3] & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    public static int load_int2(byte[] byArray) {
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        return (n << 8) + n2;
    }

    public static int load_int2(byte[] byArray, int n) {
        int n2 = byArray[0 + n] & 0xFF;
        int n3 = byArray[1 + n] & 0xFF;
        return (n2 << 8) + n3;
    }

    public static void store_int2(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 8);
        byArray[n2 + 1] = (byte)n;
    }

    public static byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static byte[] copyOf(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static byte[] ltrim(byte[] byArray) {
        int n;
        int n2 = 0;
        for (n = byArray.length; n > 0 && byArray[n2] == 0; --n) {
            ++n2;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, n2, byArray2, 0, n);
        return byArray2;
    }

    static String getToken(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n < 0 || n + string2.length() >= string.length()) {
            return null;
        }
        int n2 = string.indexOf(string3, n += string2.length());
        if (n2 < 0) {
            return string.substring(n);
        }
        return string.substring(n, n2);
    }

    public static byte[] ucapiVecU8ToByteArray(UcapiVectorU8 ucapiVectorU8) {
        return ucapiVectorU8.get();
    }

    public static byte[] certificateToByteArray(Certificate[] certificateArray) throws CertificateEncodingException {
        byte[] byArray = new byte[]{};
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        for (Certificate certificate : certificateArray) {
            byArray3 = certificate.getEncoded();
            byArray2 = (byte[])byArray.clone();
            byArray = new byte[byArray2.length + byArray3.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray, byArray2.length, byArray3.length);
        }
        return byArray;
    }

    public static byte[] bigIntegerToByteArrayNoSign(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        return byArray;
    }

    public static UcapiVectorU8 bigIntegerToU8(BigInteger bigInteger) {
        byte[] byArray = ToolBox.bigIntegerToByteArrayNoSign(bigInteger);
        return new UcapiVectorU8(byArray);
    }

    public static int getAlgoFromString(String string) {
        switch (string) {
            case "AES": {
                return 21;
            }
            case "DES": {
                return 20;
            }
        }
        return 0;
    }

    public static byte[] addZeroTOLeft(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return byArray2;
    }

    public static byte[] substractFirstTOLeft(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length - 1];
        System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
        return byArray2;
    }

    public static byte[] unifyCoords(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[1 + byArray.length + byArray2.length];
        byArray3[0] = 4;
        System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, 1 + byArray.length, byArray2.length);
        return byArray3;
    }

    public static UcapiWrapperGlobal.HashAlgo getHashAlgoFromString(String string) {
        String string2 = string.startsWith("SHA3") ? string.replace("-", "_") : string.replace("-", "");
        return UcapiWrapperGlobal.HashAlgo.valueOf(string2);
    }

    public static byte[] toUnsignedByteArray(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            bigInteger = bigInteger.add(TWO_COMPL_REF);
        }
        byte[] byArray = bigInteger.toByteArray();
        return byArray;
    }

    public static CryptoServerCXI.KeyAttAndComp exportClearKey(byte[] byArray, int n) throws IOException, CryptoServerException {
        if (byArray[0] == 75 && byArray[1] == 66) {
            byArray = Item.getItem(CryptoServerCXI.TAG_KB, byArray, 0);
        }
        return new CryptoServerCXI.KeyAttAndComp(Item.getItem(CryptoServerCXI.TAG_BH, byArray, 0), Item.getItem(CryptoServerCXI.TAG_KC, byArray, 0));
    }

    public static byte[] getEncodedByCurveName(String string) throws IOException {
        byte[] byArray = null;
        InputStream inputStream = ToolBox.class.getResourceAsStream("/curves/" + string);
        if (inputStream != null) {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[512];
            while ((n = inputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            inputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
            inputStream.close();
        }
        return byArray;
    }

    public static byte[] getEncodedCurve(UcapiKeyHandle ucapiKeyHandle, HSM hSM) throws Exception {
        short[] sArray = new short[]{UcapiWrapperGlobal.PropertyID.KEY_EC_CURVE.value};
        UcapiKeyProperties ucapiKeyProperties = hSM.getKeyProperties(ucapiKeyHandle, sArray);
        byte[] byArray = ToolBox.ucapiVecU8ToByteArray(ucapiKeyProperties.get_ec_curve_oid().value());
        byte[] byArray2 = ToolBox.getEncodedByCurveName(ToolBox.getCurveAlias(new String(byArray)));
        if (byArray2 == null && (byArray2 = ToolBox.getEncodedByCurveName(ToolBox.getCurveAlias(ToolBox.getOidString(byArray)))) == null) {
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static String getCurveName(int n) {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        hashMap.put("brainpoolP", new String[]{"r1", "t1"});
        hashMap.put("NIST-P", new String[]{""});
        hashMap.put("secp", new String[]{"r1", "r2", "k1"});
        hashMap.put("sect", new String[]{"r1", "r2", "k1"});
        String string = null;
        for (String string2 : hashMap.keySet()) {
            String[] stringArray;
            for (String string3 : stringArray = (String[])hashMap.get(string2)) {
                string = string2 + n + string3;
                URL uRL = ToolBox.class.getResource("/curves/" + string);
                if (uRL == null) continue;
                return string;
            }
        }
        return null;
    }

    public static String getEdwardsCurveName(String string) throws NoSuchAlgorithmException {
        if ("Ed25519".equalsIgnoreCase(string)) {
            return "edwards25519";
        }
        if ("Ed448".equalsIgnoreCase(string)) {
            return "edwards448";
        }
        throw new NoSuchAlgorithmException("Unsupported Edwards curvename " + string);
    }

    public static String getCodeException(Exception exception) {
        Pattern pattern = Pattern.compile("error_code = 0[xX]([0-9a-fA-F]{8})");
        Matcher matcher = pattern.matcher(exception.getMessage());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static int getErrorCode(String string) {
        long l = Long.parseLong(string.toLowerCase(), 16);
        return (int)l;
    }

    public static UcapiExportPolicy setDefaultExportPolicy(UcapiExportPolicy ucapiExportPolicy) {
        ucapiExportPolicy = ucapiExportPolicy == null ? new UcapiExportPolicy() : ucapiExportPolicy;
        ucapiExportPolicy.allow_backup(true);
        ucapiExportPolicy.allow_plain_export(false);
        ucapiExportPolicy.allow_wrapped_export(false);
        return ucapiExportPolicy;
    }

    public static byte[] exportKeyToByteArray(UcapiKeyExport ucapiKeyExport) {
        byte[] byArray = null;
        try (UcapiKeyBlob ucapiKeyBlob = new UcapiKeyBlob(ucapiKeyExport);){
            UcapiBuffer ucapiBuffer = ucapiKeyBlob.buffer();
            byArray = new byte[(int)ucapiBuffer.size()];
            ucapiKeyBlob.buffer().data().get(byArray);
        }
        return byArray;
    }

    public static UcapiWrapperGlobal.HashAlgo getHashMechanism(int n) {
        switch (n) {
            case 10: {
                return UcapiWrapperGlobal.HashAlgo.SHA1;
            }
            case 11: {
                return UcapiWrapperGlobal.HashAlgo.SHA224;
            }
            case 12: {
                return UcapiWrapperGlobal.HashAlgo.SHA256;
            }
            case 13: {
                return UcapiWrapperGlobal.HashAlgo.SHA384;
            }
            case 14: {
                return UcapiWrapperGlobal.HashAlgo.SHA512;
            }
            case 16: {
                return UcapiWrapperGlobal.HashAlgo.SHA3_224;
            }
            case 17: {
                return UcapiWrapperGlobal.HashAlgo.SHA3_256;
            }
            case 18: {
                return UcapiWrapperGlobal.HashAlgo.SHA3_384;
            }
            case 19: {
                return UcapiWrapperGlobal.HashAlgo.SHA3_512;
            }
            case 15: {
                return UcapiWrapperGlobal.HashAlgo.MD5;
            }
        }
        return UcapiWrapperGlobal.HashAlgo.NONE;
    }

    public static String generateFormatCurrentDate() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_PATTERN);
        return simpleDateFormat.format(date);
    }

    public static Date parseDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_PATTERN);
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
    }

    public static byte[] encodePoint(ECPoint eCPoint, EllipticCurve ellipticCurve) {
        int n = ellipticCurve.getField().getFieldSize() + 7 >> 3;
        byte[] byArray = ToolBox.trimZeroes(eCPoint.getAffineX().toByteArray());
        byte[] byArray2 = ToolBox.trimZeroes(eCPoint.getAffineY().toByteArray());
        if (byArray.length > n || byArray2.length > n) {
            throw new RuntimeException("Point coordinates do not match field size");
        }
        byte[] byArray3 = new byte[1 + (n << 1)];
        byArray3[0] = 4;
        System.arraycopy(byArray, 0, byArray3, n - byArray.length + 1, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
        return byArray3;
    }

    public static ECPoint decodePoint(byte[] byArray, EllipticCurve ellipticCurve) throws IOException {
        if (byArray.length == 0 || byArray[0] != 4) {
            throw new IOException("Only uncompressed point format supported");
        }
        int n = (byArray.length - 1) / 2;
        if (n != ellipticCurve.getField().getFieldSize() + 7 >> 3) {
            throw new IOException("Point does not match field size");
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, 1, 1 + n);
        byte[] byArray3 = Arrays.copyOfRange(byArray, n + 1, n + 1 + n);
        return new ECPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    public static byte[] trimZeroes(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length - 1 && byArray[n] == 0; n = (int)((byte)(n + 1))) {
        }
        if (n == 0) {
            return byArray;
        }
        return Arrays.copyOfRange(byArray, n, byArray.length);
    }

    public static byte[] hexStringToByteArray(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return byArray;
    }

    public static String bytesToHexString(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray[i * 2] = HEX_ARRAY[n >>> 4];
            cArray[i * 2 + 1] = HEX_ARRAY[n & 0xF];
        }
        return new String(cArray);
    }

    static {
        curveNameAliases.put("secp192r1", "NIST-P192");
        curveNameAliases.put("secp224r1", "NIST-P224");
        curveNameAliases.put("secp256r1", "NIST-P256");
        curveNameAliases.put("secp384r1", "NIST-P384");
        curveNameAliases.put("secp521r1", "NIST-P521");
        curveNameAliases.put("1.2.840.10045.3.1.1", "NIST-P192");
        curveNameAliases.put("1.2.840.10045.3.1.7", "NIST-P256");
        curveNameAliases.put("1.3.132.0.1", "sect163k1");
        curveNameAliases.put("1.3.132.0.4", "sect113r1");
        curveNameAliases.put("1.3.132.0.6", "secp112r1");
        curveNameAliases.put("1.3.132.0.7", "secp112r2");
        curveNameAliases.put("1.3.132.0.8", "secp160r1");
        curveNameAliases.put("1.3.132.0.9", "secp160k1");
        curveNameAliases.put("1.3.132.0.10", "secp256k1");
        curveNameAliases.put("1.3.132.0.15", "sect163r2");
        curveNameAliases.put("1.3.132.0.16", "sect283k1");
        curveNameAliases.put("1.3.132.0.17", "sect283r1");
        curveNameAliases.put("1.3.132.0.26", "sect233k1");
        curveNameAliases.put("1.3.132.0.27", "sect233r1");
        curveNameAliases.put("1.3.132.0.28", "secp128r1");
        curveNameAliases.put("1.3.132.0.29", "secp128r2");
        curveNameAliases.put("1.3.132.0.30", "secp160r2");
        curveNameAliases.put("1.3.132.0.31", "secp192k1");
        curveNameAliases.put("1.3.132.0.32", "secp224k1");
        curveNameAliases.put("1.3.132.0.33", "NIST-P224");
        curveNameAliases.put("1.3.132.0.34", "NIST-P384");
        curveNameAliases.put("1.3.132.0.35", "NIST-P521");
        curveNameAliases.put("1.3.132.0.36", "sect409k1");
        curveNameAliases.put("1.3.132.0.37", "sect409r1");
        curveNameAliases.put("1.3.132.0.38", "sect571k1");
        curveNameAliases.put("1.3.132.0.39", "sect571r1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.1", "brainpoolP160r1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.2", "brainpoolP160t1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.3", "brainpoolP192r1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.4", "brainpoolP192t1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.5", "brainpoolP224r1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.6", "brainpoolP224t1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.7", "brainpoolP256r1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.8", "brainpoolP256t1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.9", "brainpoolP320r1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.10", "brainpoolP320t1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.11", "brainpoolP384r1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.12", "brainpoolP384t1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.13", "brainpoolP512r1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.14", "brainpoolP512t1");
        curveNameAliases.put("1.3.132.0.5", "sect113r2");
        curveNameAliases.put("1.3.132.0.22", "sect131r1");
        curveNameAliases.put("1.3.132.0.23", "sect131r2");
        curveNameAliases.put("1.3.132.0.2", "sect163r1");
        curveNameAliases.put("1.3.132.0.24", "sect193r1");
        curveNameAliases.put("1.3.132.0.25", "sect193r2");
        curveNameAliases.put("1.3.132.0.3", "sect239k1");
        curveNameAliases.put("1.3.6.1.4.1.3029.1.5.1", "curve25519");
        curveNameAliases.put("1.2.250.1.223.101.256.1", "FRP256v1");
        curveNameAliases.put("1.2.156.10197.1.301", "sm2p256v1");
        TWO_COMPL_REF = BigInteger.ONE.shiftLeft(64);
        HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    }

    public static enum CXIErrorCodes {
        ERROR_CXI_CRYPT_ILLEGAL_BLOCK_SIZE("b08b0001"),
        ERROR_CXI_CRYPT_BAD_PADDING("b0680030"),
        ERROR_CXI_CRYPT_AEAD_BAD_TAG("b08b000e"),
        ERROR_KEY_EXPORT_IS_DENIED("B068002B"),
        ERROR_UNKNOWN_USER("B0830016"),
        ERROR_INVALID_PASSWORD("B0830013");

        String value;

        private CXIErrorCodes(String string2) {
            this.value = string2;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(String string) {
            return string != null ? this.value.equalsIgnoreCase(string) : false;
        }
    }
}

