/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerJCE.CryptoServerJCEConfig;
import CryptoServerJCE.CryptoServerProviderBuilder;
import CryptoServerJCE.LogLevel;
import java.io.IOException;
import java.util.Calendar;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class Log {
    public static int level;
    public static int size;
    public static String filename;
    public static String extension;
    private static final String name = "CryptoServerJCE";
    private static final Logger log;
    private static boolean initialized;

    private static void init(String string, LogLevel logLevel, int n) throws SecurityException, IOException {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL %4$-7s %5$s %6$s%n");
        Level level = Log.getLogLevel(logLevel);
        filename = string.substring(0, string.lastIndexOf(".")) + "-" + Calendar.getInstance().getTimeInMillis();
        extension = string.substring(string.lastIndexOf("."));
        FileHandler fileHandler = new FileHandler(filename + extension, n, 1, true);
        fileHandler.setLevel(level);
        fileHandler.setFormatter(new SimpleFormatter());
        log.setLevel(level);
        log.setUseParentHandlers(false);
        log.addHandler(fileHandler);
        String string2 = System.getenv().get("JCE_DEBUG_OUTPUT_MODE");
        if (string2 != null && !"".equals(string2)) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.FINER);
            log.addHandler(consoleHandler);
        }
    }

    public static void init(CryptoServerProviderBuilder cryptoServerProviderBuilder) throws SecurityException, IOException {
        if (!initialized) {
            filename = cryptoServerProviderBuilder.getLogFile();
            level = cryptoServerProviderBuilder.getLogLevel();
            size = cryptoServerProviderBuilder.getLogSize();
            if (filename != null && level > 0 && level < 5) {
                Log.init(filename, LogLevel.values()[level], size);
            }
            initialized = true;
        }
    }

    public static void init(CryptoServerJCEConfig cryptoServerJCEConfig) throws SecurityException, IOException {
        if (!initialized) {
            filename = cryptoServerJCEConfig.getString("LogFile", null);
            level = cryptoServerJCEConfig.getInt("LogLevel", 2);
            size = cryptoServerJCEConfig.getInt("LogSize", 10000000);
            if (filename != null && level > 0 && level < 5) {
                Log.init(filename, LogLevel.values()[level], size);
            }
            initialized = true;
        }
    }

    public static void log(LogLevel logLevel, String string) {
        int n = Log.determineLogLevel(logLevel);
        if (n > 0 && n <= level) {
            Level level = Log.getLogLevel(LogLevel.values()[n]);
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
            log.log(level, "[CryptoServerJCE] [" + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "] " + string);
        }
    }

    public static Level getLogLevel(LogLevel logLevel) {
        switch (logLevel) {
            case None: {
                return Level.OFF;
            }
            case Error: {
                return Level.SEVERE;
            }
            case Warning: {
                return Level.WARNING;
            }
            case Info: {
                return Level.INFO;
            }
            case Trace: {
                return Level.FINE;
            }
        }
        return Level.WARNING;
    }

    private static int determineLogLevel(LogLevel logLevel) {
        switch (logLevel) {
            case Error: {
                return 1;
            }
            case Warning: {
                return 2;
            }
            case Info: {
                return 3;
            }
            case Trace: {
                return 4;
            }
        }
        return 0;
    }

    static {
        log = Logger.getLogger(name);
        initialized = false;
    }
}

