/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerJCE.CryptoServerKeySpec;
import CryptoServerJCE.CryptoServerSecretKey;
import CryptoServerJCE.Log;
import CryptoServerJCE.LogLevel;
import com.utimaco.javacpp.ucapi.UcapiExportPolicy;
import com.utimaco.javacpp.ucapi.UcapiKeyHandle;
import com.utimaco.jce.hsm.HSM;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoServerSecretKeyFactory
extends SecretKeyFactorySpi {
    private final HSM hsm;
    private final int algo;

    CryptoServerSecretKeyFactory(HSM hSM, String string, int n) throws NoSuchAlgorithmException {
        Log.log(LogLevel.Trace, "enter....");
        this.hsm = hSM;
        this.algo = n;
        switch (n) {
            case 20: 
            case 21: {
                break;
            }
            default: {
                throw new NoSuchAlgorithmException();
            }
        }
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        Log.log(LogLevel.Trace, "enter....");
        try {
            KeySpec keySpec2 = keySpec;
            UcapiExportPolicy ucapiExportPolicy = this.hsm.getExportPolicy();
            if (keySpec != null && keySpec instanceof CryptoServerKeySpec) {
                CryptoServerKeySpec cryptoServerKeySpec = (CryptoServerKeySpec)keySpec;
                keySpec2 = cryptoServerKeySpec.getKeySpec();
                if (cryptoServerKeySpec.isConfigured) {
                    ucapiExportPolicy = this.hsm.createExportPolicy(cryptoServerKeySpec.allow_wrapped_export, cryptoServerKeySpec.allow_plain_export);
                }
            }
            switch (this.algo) {
                case 20: {
                    byte[] byArray;
                    Object object;
                    int n = 0;
                    if (keySpec2 instanceof SecretKeySpec) {
                        object = (SecretKeySpec)keySpec2;
                        n = ((SecretKeySpec)object).getEncoded().length;
                        byArray = ((SecretKeySpec)object).getEncoded();
                    } else if (keySpec2 instanceof DESKeySpec) {
                        object = (DESKeySpec)keySpec2;
                        n = ((DESKeySpec)object).getKey().length;
                        byArray = ((DESKeySpec)object).getKey();
                    } else if (keySpec2 instanceof DESedeKeySpec) {
                        object = (DESedeKeySpec)keySpec2;
                        n = ((DESedeKeySpec)object).getKey().length;
                        byArray = ((DESedeKeySpec)object).getKey();
                    } else {
                        throw new InvalidKeySpecException("Invalid key class");
                    }
                    try {
                        object = this.hsm.importSecretKey(this.algo, n, true, ucapiExportPolicy, byArray);
                        return new CryptoServerSecretKey(this.hsm, "DES", (UcapiKeyHandle)object);
                    }
                    catch (Exception exception) {
                        InvalidKeyException invalidKeyException = new InvalidKeyException(exception.toString());
                        invalidKeyException.initCause(exception);
                        throw invalidKeyException;
                    }
                }
                case 21: {
                    if (keySpec2 instanceof SecretKeySpec) {
                        SecretKeySpec secretKeySpec = (SecretKeySpec)keySpec2;
                        int n = secretKeySpec.getEncoded().length;
                        byte[] byArray = secretKeySpec.getEncoded();
                        try {
                            UcapiKeyHandle ucapiKeyHandle = this.hsm.importSecretKey(this.algo, n, true, ucapiExportPolicy, byArray);
                            return new CryptoServerSecretKey(this.hsm, "AES", ucapiKeyHandle);
                        }
                        catch (Exception exception) {
                            InvalidKeyException invalidKeyException = new InvalidKeyException(exception.toString());
                            invalidKeyException.initCause(exception);
                            throw invalidKeyException;
                        }
                    }
                    throw new InvalidKeySpecException("Invalid key class");
                }
            }
            throw new InvalidKeySpecException();
        }
        catch (Exception exception) {
            Log.log(LogLevel.Error, exception.getMessage());
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException(exception.toString());
            invalidKeySpecException.initCause(exception);
            throw invalidKeySpecException;
        }
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        Log.log(LogLevel.Trace, "enter....");
        throw new InvalidKeyException();
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        Log.log(LogLevel.Trace, "enter....");
        if (!(secretKey instanceof CryptoServerSecretKey)) {
            throw new InvalidKeySpecException("Invalid key object");
        }
        try {
            CryptoServerSecretKey cryptoServerSecretKey = (CryptoServerSecretKey)secretKey;
            byte[] byArray = this.hsm.exportSecretKey(cryptoServerSecretKey.getKeyHandle());
            if (clazz.getName().equals("javax.crypto.spec.SecretKeySpec")) {
                return new SecretKeySpec(byArray, cryptoServerSecretKey.getAlgorithm());
            }
            if (clazz.getName().equals("javax.crypto.spec.DESKeySpec")) {
                return new DESKeySpec(byArray);
            }
            if (clazz.getName().equals("javax.crypto.spec.DESedeKeySpec")) {
                switch (byArray.length) {
                    case 16: {
                        byte[] byArray2 = new byte[24];
                        System.arraycopy(byArray, 0, byArray2, 0, 16);
                        System.arraycopy(byArray, 0, byArray2, 16, 8);
                        return new DESedeKeySpec(byArray2);
                    }
                    case 24: {
                        return new DESedeKeySpec(byArray);
                    }
                }
            }
        }
        catch (Exception exception) {
            Log.log(LogLevel.Error, exception.getMessage());
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException(exception.toString());
            invalidKeySpecException.initCause(exception);
            throw invalidKeySpecException;
        }
        throw new InvalidKeySpecException();
    }
}

