/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerAPI.CryptoServerException;
import CryptoServerJCE.CryptoServerCipher;
import CryptoServerJCE.CryptoServerECAlgorithmParametersSpi;
import CryptoServerJCE.CryptoServerJCEConfig;
import CryptoServerJCE.CryptoServerJCEException;
import CryptoServerJCE.CryptoServerKeyAgreement;
import CryptoServerJCE.CryptoServerKeyFactory;
import CryptoServerJCE.CryptoServerKeyGenerator;
import CryptoServerJCE.CryptoServerKeyPairGenerator;
import CryptoServerJCE.CryptoServerKeyStore;
import CryptoServerJCE.CryptoServerMac;
import CryptoServerJCE.CryptoServerMessageDigest;
import CryptoServerJCE.CryptoServerProviderBuilder;
import CryptoServerJCE.CryptoServerSecretKeyFactory;
import CryptoServerJCE.CryptoServerSecureRandom;
import CryptoServerJCE.CryptoServerSignature;
import CryptoServerJCE.DumyCertificate;
import CryptoServerJCE.Log;
import CryptoServerJCE.LogLevel;
import CryptoServerJCE.ToolBox;
import CryptoServerJCE.Version;
import com.utimaco.javacpp.global.UcapiWrapperGlobal;
import com.utimaco.javacpp.ucapi.UcapiExportPolicy;
import com.utimaco.jce.hsm.HSM;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.Arrays;
import java.util.List;

public final class CryptoServerProvider
extends Provider {
    private static final long serialVersionUID = 1L;
    private static final String PROVIDERNAME = "CryptoServer";
    private static final String PROVIDERDATE = "2024/10/10";
    private static final String PROVIDERINFO = "JCA/JCE provider for Utimaco SecurityServer 6.0.0.0 (2024/10/10)";
    private static final double PROVIDERVERSION = Version.getVersionDouble();
    private HSM hsm;
    protected static final int ALGO_NONE = 0;
    public static final int ALGO_RSA = 1;
    public static final int ALGO_DSA = 2;
    public static final int ALGO_EC = 3;
    public static final int ALGO_ECDSA = 4;
    public static final int ALGO_EC_EDWARDS = 5;
    protected static final int ALGO_SHA1 = 10;
    protected static final int ALGO_SHA224 = 11;
    protected static final int ALGO_SHA256 = 12;
    protected static final int ALGO_SHA384 = 13;
    protected static final int ALGO_SHA512 = 14;
    protected static final int ALGO_MD5 = 15;
    protected static final int ALGO_SHA3_224 = 16;
    protected static final int ALGO_SHA3_256 = 17;
    protected static final int ALGO_SHA3_384 = 18;
    protected static final int ALGO_SHA3_512 = 19;
    public static final int ALGO_DES = 20;
    public static final int ALGO_AES = 21;
    protected static final int ALGO_BSI_TR03111 = 34;
    protected static final int ALGO_ECDH = 35;
    protected static final int ALGO_ECDHC = 36;
    protected static final int ALGO_DH = 37;
    protected static final String DEFAULT_EC_CURVE = "NIST-P256";
    protected static final String ED25519 = "Ed25519";
    protected static final String ED448 = "Ed448";
    protected static final String ED_DSA = "EdDSA";
    protected static final String RSA = "RSA";
    protected static final String DSA = "DSA";
    protected static final String EC = "EC";
    protected static String STRING_PROVIDER_HASH_RNG = "CryptoServer";
    protected static Provider PROVIDER_HASH_RNG = null;
    protected static boolean USE_HSM_FOR_HASHING = false;
    public static final int E_JCE = 47492;
    public static final int E_JCE_MISSING_KEYSTOREPATH = -1182531582;
    public static final int E_JCE_PARAM = -1182728192;
    public static final int E_JCE_NO_PROVIDER = -1182531581;
    public static final int E_JCE_USER_NAME = -1182531580;
    public static final int E_JCE_WRONG_EXPORTPOLICY = -1182531579;
    public static final String E_MECH_NOT_INITIALIZED = "The mechanism is not initialized. Please, invoke the initialization before.";

    private void initProvider() {
        UcapiExportPolicy ucapiExportPolicy = ToolBox.setDefaultExportPolicy(null);
        this.hsm.setExportPolicy(ucapiExportPolicy);
        this.registerServices();
    }

    public void setProvider(Provider provider) throws CryptoServerJCEException {
        if (provider != null) {
            PROVIDER_HASH_RNG = provider;
            STRING_PROVIDER_HASH_RNG = provider.getName();
        }
    }

    private void logProviderInfo() {
        Log.log(LogLevel.Info, "PROVIDERNAME: CryptoServer");
        Log.log(LogLevel.Info, "PROVIDERINFO: JCA/JCE provider for Utimaco SecurityServer 6.0.0.0 (2024/10/10)");
        Log.log(LogLevel.Info, "PROVIDERDATE: 2024/10/10");
        Log.log(LogLevel.Info, "PROVIDERVERSION: " + PROVIDERVERSION);
    }

    public CryptoServerProvider() throws IOException, NumberFormatException, Exception {
        super(PROVIDERNAME, PROVIDERVERSION, PROVIDERINFO);
        String string = System.getenv("CRYPTOSERVER_JCE_CONFIG");
        if (string == null) {
            string = System.getProperty("user.home") + "/CryptoServer.cfg";
        }
        this.processConfig(new FileInputStream(string));
        this.logProviderInfo();
        this.initProvider();
        PROVIDER_HASH_RNG = !PROVIDERNAME.equals(STRING_PROVIDER_HASH_RNG) && Security.getProvider(STRING_PROVIDER_HASH_RNG) != null ? Security.getProvider(STRING_PROVIDER_HASH_RNG) : this;
    }

    protected CryptoServerProvider(CryptoServerProviderBuilder cryptoServerProviderBuilder) throws IOException, NumberFormatException, Exception {
        super(PROVIDERNAME, PROVIDERVERSION, PROVIDERINFO);
        this.hsm = cryptoServerProviderBuilder.createHSM();
        STRING_PROVIDER_HASH_RNG = cryptoServerProviderBuilder.getHashProvider();
        this.logProviderInfo();
        this.initProvider();
        Log.init(cryptoServerProviderBuilder);
        PROVIDER_HASH_RNG = !PROVIDERNAME.equals(STRING_PROVIDER_HASH_RNG) && Security.getProvider(STRING_PROVIDER_HASH_RNG) != null ? Security.getProvider(STRING_PROVIDER_HASH_RNG) : this;
    }

    public CryptoServerProvider(String string, int n) throws IOException, NumberFormatException, CryptoServerJCEException {
        super(PROVIDERNAME, PROVIDERVERSION, PROVIDERINFO);
        HSM.HSMBuilder hSMBuilder = new HSM.HSMBuilder(string).timeout(n);
        this.hsm = hSMBuilder.build();
        this.initProvider();
        PROVIDER_HASH_RNG = this;
    }

    public CryptoServerProvider(String[] stringArray, int n) throws IOException, NumberFormatException, CryptoServerJCEException {
        super(PROVIDERNAME, PROVIDERVERSION, PROVIDERINFO);
        HSM.HSMBuilder hSMBuilder = new HSM.HSMBuilder(stringArray).timeout(n);
        this.hsm = hSMBuilder.build();
        this.initProvider();
        PROVIDER_HASH_RNG = this;
    }

    public CryptoServerProvider(InputStream inputStream) throws IOException, NumberFormatException {
        super(PROVIDERNAME, PROVIDERVERSION, PROVIDERINFO);
        this.processConfig(inputStream);
        this.logProviderInfo();
        this.initProvider();
        PROVIDER_HASH_RNG = !PROVIDERNAME.equals(STRING_PROVIDER_HASH_RNG) && Security.getProvider(STRING_PROVIDER_HASH_RNG) != null ? Security.getProvider(STRING_PROVIDER_HASH_RNG) : this;
    }

    public CryptoServerProvider(String string) throws IOException, NumberFormatException {
        super(PROVIDERNAME, PROVIDERVERSION, PROVIDERINFO);
        this.processConfig(new FileInputStream(string));
        this.logProviderInfo();
        this.initProvider();
        PROVIDER_HASH_RNG = !PROVIDERNAME.equals(STRING_PROVIDER_HASH_RNG) && Security.getProvider(STRING_PROVIDER_HASH_RNG) != null ? Security.getProvider(STRING_PROVIDER_HASH_RNG) : this;
    }

    private void processConfig(InputStream inputStream) throws IOException, NumberFormatException {
        CryptoServerJCEConfig cryptoServerJCEConfig = new CryptoServerJCEConfig(inputStream);
        Log.init(cryptoServerJCEConfig);
        String[] stringArray = cryptoServerJCEConfig.getStringValues("Device", null);
        STRING_PROVIDER_HASH_RNG = cryptoServerJCEConfig.getString("HashProvider", PROVIDERNAME);
        if ("HSM".equals(STRING_PROVIDER_HASH_RNG)) {
            USE_HSM_FOR_HASHING = true;
        }
        HSM.HSMBuilder hSMBuilder = new HSM.HSMBuilder(stringArray).timeout(cryptoServerJCEConfig.getInt("Timeout", 0)).connectionTimeout(cryptoServerJCEConfig.getInt("ConnectionTimeout", 0)).externalStorage(cryptoServerJCEConfig.getBoolean("StoreKeysExternal", false)).noNativeGC(cryptoServerJCEConfig.getBoolean("NoNativeGC", false)).keyStorePath(cryptoServerJCEConfig.getString("KeyStorePath", null)).keyStoreType(cryptoServerJCEConfig.getString("KeyStoreType", "Legacy")).user(cryptoServerJCEConfig.getString("DefaultUser", "JCE")).keyGroup(cryptoServerJCEConfig.getString("KeyGroup", "")).endSessionOnShutDown(cryptoServerJCEConfig.getBoolean("EndSessionOnShutdown", false)).keepSessionAlive(cryptoServerJCEConfig.getBoolean("KeepSessionAlive", false));
        this.hsm = hSMBuilder.build();
    }

    @Override
    public Object setProperty(String string, String string2) {
        try {
            if (string.equals("EndSessionOnShutdown")) {
                this.hsm.setEndSessionOnShutdown(Boolean.parseBoolean(string2));
            } else if (string.equals("DefaultUser")) {
                this.setDefaultUserName(string2);
            } else if (string.equals("KeyGroup")) {
                if (string2 == null) {
                    string2 = "";
                }
                this.hsm.setKeyGroup(string2);
            } else {
                if (string.equals("KeySpecifier")) {
                    throw new Exception("Warning: KeySpecifier is not supported");
                }
                if (string.equals("Export")) {
                    UcapiExportPolicy ucapiExportPolicy = new UcapiExportPolicy();
                    ucapiExportPolicy.allow_wrapped_export(false);
                    ucapiExportPolicy.allow_plain_export(false);
                    ucapiExportPolicy.allow_backup(true);
                    switch (string2) {
                        case "0": {
                            ucapiExportPolicy.allow_wrapped_export(false);
                            break;
                        }
                        case "1": {
                            ucapiExportPolicy.allow_wrapped_export(true);
                            break;
                        }
                        case "2": 
                        case "3": {
                            throw new CryptoServerJCEException(-1182531579, "Invalid combination as allow_plain_export in denied");
                        }
                        case "65536": {
                            ucapiExportPolicy.allow_backup(false);
                            break;
                        }
                        default: {
                            throw new CryptoServerJCEException(-1182531579, "Invalid value for exportPolicy was given");
                        }
                    }
                    this.hsm.setExportPolicy(ucapiExportPolicy);
                } else if (string.equals("Usage")) {
                    this.hsm.handleKeyUsage(string2);
                } else if (string.equals("Timeout")) {
                    this.hsm.setTimeout(Integer.parseInt(string2));
                }
            }
        }
        catch (IOException iOException) {
            Log.log(LogLevel.Error, iOException.getMessage());
            iOException.printStackTrace();
        }
        catch (CryptoServerJCEException cryptoServerJCEException) {
            Log.log(LogLevel.Error, cryptoServerJCEException.getMessage());
            cryptoServerJCEException.printStackTrace();
        }
        catch (Exception exception) {
            Log.log(LogLevel.Warning, exception.getMessage());
            exception.printStackTrace();
        }
        return super.setProperty(string, string2);
    }

    public void loginPassword(String string, byte[] byArray) throws CryptoServerException, IOException {
        this.loginPassword(string, new String(byArray));
    }

    public void loginPassword(String string, String string2) throws CryptoServerException, IOException {
        try {
            this.hsm.login(string, string2);
        }
        catch (Exception exception) {
            Log.log(LogLevel.Error, exception.getMessage());
            String string3 = ToolBox.getCodeException(exception);
            if (ToolBox.CXIErrorCodes.ERROR_UNKNOWN_USER.equals(string3) || ToolBox.CXIErrorCodes.ERROR_INVALID_PASSWORD.equals(string3)) {
                long l = Long.parseLong(string3.toLowerCase(), 16);
                CryptoServerException cryptoServerException = new CryptoServerException((int)l, exception.toString());
                throw cryptoServerException;
            }
            throw exception;
        }
    }

    public void loginSign(String string, String string2, String string3) {
        this.hsm.loginSign(string, string2, string3);
    }

    public void logoff() {
        if (this.hsm != null) {
            this.hsm.logoff();
        }
    }

    public void close() {
        this.logoff();
        if (this.hsm != null) {
            this.hsm.close();
        }
    }

    public void setDefaultUserName(String string) throws IOException, CryptoServerException {
        if (string.length() == 0) {
            throw new CryptoServerException(-1182531580, "No default user name was given");
        }
        this.hsm.setUser(string);
    }

    public DumyCertificate getDumyCertificate() {
        return new DumyCertificate();
    }

    public DumyCertificate createSelfSignedDumyCertificate(String string, PublicKey publicKey, PrivateKey privateKey) throws Exception {
        return new DumyCertificate(this.getHsm(), string, publicKey, privateKey);
    }

    public DumyCertificate[] getDumyCertificateChain() {
        DumyCertificate[] dumyCertificateArray = new DumyCertificate[]{new DumyCertificate()};
        return dumyCertificateArray;
    }

    protected void finalize() {
        try {
            if (this.hsm != null) {
                this.hsm.logoff();
                this.hsm.close();
            }
        }
        catch (Exception exception) {
            Log.log(LogLevel.Error, exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void registerServices() {
        this.putService(new CryptoServerSignatureService(this, "SHA1withRSA", 1, 10));
        this.putService(new CryptoServerSignatureService(this, "SHA224withRSA", 1, 11));
        this.putService(new CryptoServerSignatureService(this, "SHA256withRSA", 1, 12));
        this.putService(new CryptoServerSignatureService(this, "SHA384withRSA", 1, 13));
        this.putService(new CryptoServerSignatureService(this, "SHA512withRSA", 1, 14));
        this.putService(new CryptoServerSignatureService(this, "SHA3-224withRSA", 1, 16));
        this.putService(new CryptoServerSignatureService(this, "SHA3-256withRSA", 1, 17));
        this.putService(new CryptoServerSignatureService(this, "SHA3-384withRSA", 1, 18));
        this.putService(new CryptoServerSignatureService(this, "SHA3-512withRSA", 1, 19));
        this.putService(new CryptoServerSignatureService(this, "MD5withRSA", 1, 15));
        this.putService(new CryptoServerSignatureService(this, "NONEwithRSA", 1, 0));
        this.putService(new CryptoServerSignatureService(this, "RSASSA-PSS", 1, 0));
        this.putService(new CryptoServerSignatureService(this, "SHA1withRSASSA-PSS", 1, 10));
        this.putService(new CryptoServerSignatureService(this, "SHA224withRSASSA-PSS", 1, 11));
        this.putService(new CryptoServerSignatureService(this, "SHA256withRSASSA-PSS", 1, 12));
        this.putService(new CryptoServerSignatureService(this, "SHA384withRSASSA-PSS", 1, 13));
        this.putService(new CryptoServerSignatureService(this, "SHA512withRSASSA-PSS", 1, 14));
        this.putService(new CryptoServerSignatureService(this, "SHA1withECDSA", 4, 10));
        this.putService(new CryptoServerSignatureService(this, "SHA224withECDSA", 4, 11));
        this.putService(new CryptoServerSignatureService(this, "SHA256withECDSA", 4, 12));
        this.putService(new CryptoServerSignatureService(this, "SHA384withECDSA", 4, 13));
        this.putService(new CryptoServerSignatureService(this, "SHA512withECDSA", 4, 14));
        this.putService(new CryptoServerSignatureService(this, "SHA3-224withECDSA", 4, 16));
        this.putService(new CryptoServerSignatureService(this, "SHA3-256withECDSA", 4, 17));
        this.putService(new CryptoServerSignatureService(this, "SHA3-384withECDSA", 4, 18));
        this.putService(new CryptoServerSignatureService(this, "SHA3-512withECDSA", 4, 19));
        this.putService(new CryptoServerSignatureService(this, "MD5withECDSA", 4, 15));
        this.putService(new CryptoServerSignatureService(this, "NONEwithECDSA", 4, 0));
        this.putService(new CryptoServerSignatureService(this, "NONEwithDSA", 2, 0));
        this.putService(new CryptoServerSignatureService(this, "SHA1withDSA", 2, 10));
        this.putService(new CryptoServerSignatureService(this, "SHA224withDSA", 2, 11));
        this.putService(new CryptoServerSignatureService(this, "SHA256withDSA", 2, 12));
        this.putService(new CryptoServerSignatureService(this, "SHA384withDSA", 2, 13));
        this.putService(new CryptoServerSignatureService(this, "SHA512withDSA", 2, 14));
        this.putService(new CryptoServerSignatureService(this, "SHA3-224withDSA", 2, 16));
        this.putService(new CryptoServerSignatureService(this, "SHA3-256withDSA", 2, 17));
        this.putService(new CryptoServerSignatureService(this, "SHA3-384withDSA", 2, 18));
        this.putService(new CryptoServerSignatureService(this, "SHA3-512withDSA", 2, 19));
        this.putService(new CryptoServerSignatureService(this, "NONEwithDSAinP1363Format", 2, 0));
        this.putService(new CryptoServerSignatureService(this, "SHA1withDSAinP1363Format", 2, 10));
        this.putService(new CryptoServerSignatureService(this, "SHA224withDSAinP1363Format", 2, 11));
        this.putService(new CryptoServerSignatureService(this, "SHA256withDSAinP1363Format", 2, 12));
        this.putService(new CryptoServerSignatureService(this, "NONEwithECDSAinP1363Format", 4, 0));
        this.putService(new CryptoServerSignatureService(this, "SHA1withECDSAinP1363Format", 4, 10));
        this.putService(new CryptoServerSignatureService(this, "SHA224withECDSAinP1363Format", 4, 11));
        this.putService(new CryptoServerSignatureService(this, "SHA256withECDSAinP1363Format", 4, 12));
        this.putService(new CryptoServerSignatureService(this, "SHA384withECDSAinP1363Format", 4, 13));
        this.putService(new CryptoServerSignatureService(this, "SHA512withECDSAinP1363Format", 4, 14));
        this.putService(new CryptoServerSignatureService(this, ED_DSA, 5, 0));
        this.putService(new CryptoServerSignatureService(this, ED25519, 5, 0));
        this.putService(new CryptoServerSignatureService(this, ED448, 5, 0));
        this.putService(new CryptoServerKeyPairGeneratorService(this, RSA, 1));
        this.putService(new CryptoServerKeyPairGeneratorService(this, EC, 3));
        this.putService(new CryptoServerKeyPairGeneratorService(this, DSA, 2));
        this.putService(new CryptoServerKeyPairGeneratorService(this, ED_DSA, 5));
        this.putService(new CryptoServerKeyPairGeneratorService(this, ED25519, 5));
        this.putService(new CryptoServerKeyPairGeneratorService(this, ED448, 5));
        this.putService(new CryptoServerKeyAgreementService(this, "ECDH", 35, 0, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECDHC", 36, 0, false));
        this.put("Alg.Alias.KeyAgreement.ECCDH", "ECDHC");
        this.putService(new CryptoServerKeyAgreementService(this, "ECDHwithSHA1KDF", 35, 10, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECDHwithSHA224KDF", 35, 11, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECDHwithSHA256KDF", 35, 12, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECDHwithSHA384KDF", 35, 13, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECDHwithSHA512KDF", 35, 14, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA1KDF", 36, 10, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA224KDF", 36, 11, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA256KDF", 36, 12, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA384KDF", 36, 13, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA512KDF", 36, 14, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA1CKDF", 36, 10, true));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA256CKDF", 36, 12, true));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA384CKDF", 36, 13, true));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA512CKDF", 36, 14, true));
        this.putService(new CryptoServerKeyAgreementService(this, "ECKABSITR03111S", 34, 0, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECKABSITR03111Z", 34, 0, true));
        this.putService(new CryptoServerKeyAgreementService(this, "ECKAEGwithSHA1KDF", 35, 10, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECKAEGwithSHA224KDF", 35, 11, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECKAEGwithSHA256KDF", 35, 12, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECKAEGwithSHA384KDF", 35, 13, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECKAEGwithSHA512KDF", 35, 14, false));
        this.putService(new CryptoServerKeyFactoryService(this, RSA, 1));
        this.putService(new CryptoServerKeyFactoryService(this, EC, 3));
        this.putService(new CryptoServerKeyFactoryService(this, DSA, 2));
        this.putService(new CryptoServerSecretKeyFactoryService(this, "AES", 21));
        this.putService(new CryptoServerSecretKeyFactoryService(this, "DES", 20));
        this.putService(new CryptoServerSecretKeyFactoryService(this, "DESede", 20));
        this.putService(new CryptoServerKeyStoreService(this));
        this.putService(new CryptoServerSecureRandomService(this, "SHA1PRNG", UcapiWrapperGlobal.RNDMode.PSEUDO));
        this.putService(new CryptoServerSecureRandomService(this, PROVIDERNAME, UcapiWrapperGlobal.RNDMode.REAL));
        this.putService(new CryptoServerKeyGeneratorService(this, "DES", 20));
        this.putService(new CryptoServerKeyGeneratorService(this, "DESede", 20));
        this.putService(new CryptoServerKeyGeneratorService(this, "AES", 21));
        this.putService(new CryptoServerCipherService(this, "DES", 20));
        this.putService(new CryptoServerCipherService(this, "DESede", 20));
        this.putService(new CryptoServerCipherService(this, "AES", 21));
        this.putService(new CryptoServerCipherService(this, RSA, 1));
        this.putService(new CryptoServerMacService(this, "DES", 20));
        this.putService(new CryptoServerMacService(this, "DESwithPKCS5Padding", 20));
        this.putService(new CryptoServerMacService(this, "AES", 21));
        this.putService(new CryptoServerMacService(this, "AESwithPKCS5Padding", 21));
        this.putService(new CryptoServerMacService(this, "HmacMD5", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA1", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA224", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA256", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA384", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA512", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA3-224", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA3-256", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA3-384", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA3-512", 0));
        this.putService(new CryptoServerMacService(this, "HmacRMD160", 0));
        this.putService(new CryptoServerMessageDigestService(this, "MD5", Arrays.asList("MD-5")));
        this.putService(new CryptoServerMessageDigestService(this, "SHA-1", Arrays.asList("SHA1", "SHA")));
        this.putService(new CryptoServerMessageDigestService(this, "SHA-224", Arrays.asList("SHA224")));
        this.putService(new CryptoServerMessageDigestService(this, "SHA-256", Arrays.asList("SHA256")));
        this.putService(new CryptoServerMessageDigestService(this, "SHA-384", Arrays.asList("SHA384")));
        this.putService(new CryptoServerMessageDigestService(this, "SHA-512", Arrays.asList("SHA512")));
        this.putService(new CryptoServerMessageDigestService(this, "SHA3-224"));
        this.putService(new CryptoServerMessageDigestService(this, "SHA3-256"));
        this.putService(new CryptoServerMessageDigestService(this, "SHA3-384"));
        this.putService(new CryptoServerMessageDigestService(this, "SHA3-512"));
        this.putService(new CryptoServerMessageDigestService(this, "RMD-160"));
        this.putService(new CryptoServerECAlgorithmParamatersService(this, EC));
        this.putService(new CryptoServerECAlgorithmParamatersService(this, "ECDH"));
    }

    public CryptoServerProvider getCryptoServer() {
        return this;
    }

    public String getDevice() {
        if (this.hsm != null && this.getDevices() != null) {
            return this.getDevices().length > 0 ? this.getDevices()[0] : null;
        }
        return null;
    }

    protected HSM getHsm() {
        return this.hsm;
    }

    public void changePassword(String string, String string2) {
        this.hsm.changeUserPassword(string, string2);
    }

    public int getAuthState() {
        return this.hsm.getSession().get_auth_state().mask();
    }

    public int getTimeout() {
        return this.hsm.getTimeout();
    }

    public String[] getDevices() {
        return this.hsm.getDevices();
    }

    private static class CryptoServerSecretKeyFactoryService
    extends Provider.Service {
        private int keyAlgo;

        CryptoServerSecretKeyFactoryService(Provider provider, String string, int n) {
            super(provider, "SecretKeyFactory", string, "CryptoServerSecretKeyFactory", null, null);
            this.keyAlgo = n;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            CryptoServerProvider cryptoServerProvider = (CryptoServerProvider)this.getProvider();
            return new CryptoServerSecretKeyFactory(cryptoServerProvider.getHsm(), this.getAlgorithm(), this.keyAlgo);
        }
    }

    private static class CryptoServerKeyFactoryService
    extends Provider.Service {
        private int keyAlgo;

        CryptoServerKeyFactoryService(Provider provider, String string, int n) {
            super(provider, "KeyFactory", string, "CryptoServerKeyFactory", null, null);
            this.keyAlgo = n;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            return new CryptoServerKeyFactory(((CryptoServerProvider)this.getProvider()).getHsm(), this.getAlgorithm(), this.keyAlgo);
        }
    }

    private static class CryptoServerSecureRandomService
    extends Provider.Service {
        private UcapiWrapperGlobal.RNDMode algo;

        CryptoServerSecureRandomService(Provider provider, String string, UcapiWrapperGlobal.RNDMode rNDMode) {
            super(provider, "SecureRandom", string, "CryptoServerSecureRandom", null, null);
            this.algo = rNDMode;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            CryptoServerProvider cryptoServerProvider = (CryptoServerProvider)this.getProvider();
            return new CryptoServerSecureRandom(cryptoServerProvider.getHsm(), this.getAlgorithm(), this.algo);
        }
    }

    private static class CryptoServerKeyStoreService
    extends Provider.Service {
        CryptoServerKeyStoreService(Provider provider) {
            super(provider, "KeyStore", CryptoServerProvider.PROVIDERNAME, "CryptoServerKeyStore", null, null);
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            CryptoServerProvider cryptoServerProvider = (CryptoServerProvider)this.getProvider();
            return new CryptoServerKeyStore(cryptoServerProvider.getHsm());
        }
    }

    private static class CryptoServerMessageDigestService
    extends Provider.Service {
        CryptoServerMessageDigestService(Provider provider, String string) {
            super(provider, "MessageDigest", string, "CryptoServerMessageDigest", null, null);
        }

        CryptoServerMessageDigestService(Provider provider, String string, List<String> list) {
            super(provider, "MessageDigest", string, "CryptoServerMessageDigest", list, null);
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            CryptoServerProvider cryptoServerProvider = (CryptoServerProvider)this.getProvider();
            return new CryptoServerMessageDigest(cryptoServerProvider.getHsm(), this.getAlgorithm());
        }
    }

    private static class CryptoServerMacService
    extends Provider.Service {
        private int keyAlgo;

        CryptoServerMacService(Provider provider, String string, int n) {
            super(provider, "Mac", string, "CryptoServerMac", null, null);
            this.keyAlgo = n;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            CryptoServerProvider cryptoServerProvider = (CryptoServerProvider)this.getProvider();
            return new CryptoServerMac(cryptoServerProvider.getHsm(), this.getAlgorithm(), this.keyAlgo);
        }
    }

    private static class CryptoServerKeyAgreementService
    extends Provider.Service {
        private int keyAgreementAlgo;
        private int hashAlgo;
        private boolean extraFlag;

        CryptoServerKeyAgreementService(Provider provider, String string, int n, int n2, boolean bl) {
            super(provider, "KeyAgreement", string, "CryptoServerKeyAgreement", null, null);
            this.keyAgreementAlgo = n;
            this.hashAlgo = n2;
            this.extraFlag = bl;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            CryptoServerProvider cryptoServerProvider = (CryptoServerProvider)this.getProvider();
            return new CryptoServerKeyAgreement(cryptoServerProvider.getHsm(), this.getAlgorithm(), this.keyAgreementAlgo, this.hashAlgo, this.extraFlag);
        }
    }

    private static class CryptoServerKeyGeneratorService
    extends Provider.Service {
        private int keyAlgo;

        CryptoServerKeyGeneratorService(Provider provider, String string, int n) {
            super(provider, "KeyGenerator", string, "CryptoServerKeyGenerator", null, null);
            this.keyAlgo = n;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            CryptoServerProvider cryptoServerProvider = (CryptoServerProvider)this.getProvider();
            return new CryptoServerKeyGenerator(cryptoServerProvider.getHsm(), this.getAlgorithm(), this.keyAlgo);
        }
    }

    private static class CryptoServerCipherService
    extends Provider.Service {
        private int keyAlgo;

        CryptoServerCipherService(Provider provider, String string, int n) {
            super(provider, "Cipher", string, "CryptoServerCipher", null, null);
            this.keyAlgo = n;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            CryptoServerProvider cryptoServerProvider = (CryptoServerProvider)this.getProvider();
            return new CryptoServerCipher(cryptoServerProvider.getHsm(), this.getAlgorithm(), this.keyAlgo);
        }
    }

    private static class CryptoServerKeyPairGeneratorService
    extends Provider.Service {
        private int sigAlgo;

        CryptoServerKeyPairGeneratorService(Provider provider, String string, int n) {
            super(provider, "KeyPairGenerator", string, "CryptoServerKeyPairGenerator", null, null);
            this.sigAlgo = n;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            CryptoServerProvider cryptoServerProvider = (CryptoServerProvider)this.getProvider();
            return new CryptoServerKeyPairGenerator(cryptoServerProvider.getHsm(), this.getAlgorithm(), this.sigAlgo);
        }
    }

    private static class CryptoServerECAlgorithmParamatersService
    extends Provider.Service {
        CryptoServerECAlgorithmParamatersService(Provider provider, String string) {
            super(provider, "AlgorithmParameters", string, "CryptoServerAlgorithmParametersSpi", null, null);
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            return new CryptoServerECAlgorithmParametersSpi();
        }
    }

    private static class CryptoServerSignatureService
    extends Provider.Service {
        private int sigAlgo;
        private int hashAlgo;

        CryptoServerSignatureService(Provider provider, String string, int n, int n2) {
            super(provider, "Signature", string, "CryptoServerSignature", null, null);
            this.sigAlgo = n;
            this.hashAlgo = n2;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            CryptoServerProvider cryptoServerProvider = (CryptoServerProvider)this.getProvider();
            return new CryptoServerSignature(cryptoServerProvider.getHsm(), this.getAlgorithm(), this.sigAlgo, this.hashAlgo);
        }
    }

    public static enum FipsUsage {
        USAGE_SIGN_VERIFY,
        USAGE_OTHER;

    }
}

