/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerJCE.ByteFifo;
import CryptoServerJCE.CryptoServerSecretKey;
import CryptoServerJCE.Log;
import CryptoServerJCE.LogLevel;
import CryptoServerJCE.ToolBox;
import com.utimaco.javacpp.global.UcapiWrapperGlobal;
import com.utimaco.javacpp.ucapi.UcapiKeyHandle;
import com.utimaco.javacpp.ucapi.UcapiSignInfo;
import com.utimaco.javacpp.ucapi.UcapiSignState;
import com.utimaco.javacpp.ucapi.UcapiVectorU8;
import com.utimaco.jce.hsm.HSM;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoServerMac
extends MacSpi {
    public static final int MECH_CHAIN_CBC = 0x100000;
    public static final int MECH_MODE_HMAC = 0x1000000;
    public static final int MECH_HASH_ALGO_SHA1 = 16;
    public static final int MECH_HASH_ALGO_RMD160 = 32;
    public static final int MECH_HASH_ALGO_SHA224 = 48;
    public static final int MECH_HASH_ALGO_SHA256 = 64;
    public static final int MECH_HASH_ALGO_MD5 = 80;
    public static final int MECH_HASH_ALGO_SHA384 = 96;
    public static final int MECH_HASH_ALGO_SHA512 = 112;
    public static final int MECH_HASH_ALGO_SHA3_224 = 128;
    public static final int MECH_HASH_ALGO_SHA3_256 = 144;
    public static final int MECH_HASH_ALGO_SHA3_384 = 160;
    public static final int MECH_HASH_ALGO_SHA3_512 = 176;
    private final HSM hsm;
    private final String algorithm;
    private int algo;
    private int blockSize;
    private int mech;
    private UcapiWrapperGlobal.HashAlgo hash;
    private int padding;
    private byte[] iv_init;
    private ByteFifo buff;
    private boolean err;
    private final int PAD_NONE = 0;
    private final int PAD_PKCS5 = 1;
    private UcapiKeyHandle key;
    private UcapiSignState sign_state;
    private UcapiSignInfo sign_info;

    CryptoServerMac(HSM hSM, String string, int n) throws NoSuchAlgorithmException {
        Log.log(LogLevel.Trace, "enter....");
        this.hsm = hSM;
        this.algorithm = string;
        this.algo = n;
        this.err = false;
        this.padding = 0;
        this.mech = 0;
        this.hash = UcapiWrapperGlobal.HashAlgo.NONE;
        if (string.equals("DES") || string.equals("AES")) {
            this.padding = 0;
            this.mech = 0x100000;
        } else if (string.equals("DESwithPKCS5Padding") || string.equals("AESwithPKCS5Padding")) {
            this.padding = 1;
            this.mech = 0x100000;
        } else if (string.startsWith("Hmac")) {
            this.mech = 0x1000000;
            this.hash = CryptoServerMac.selectHashAlgoCXI(string);
        } else {
            throw new NoSuchAlgorithmException();
        }
    }

    @Override
    protected int engineGetMacLength() {
        Log.log(LogLevel.Trace, "enter....");
        return this.blockSize;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object;
        Log.log(LogLevel.Trace, "enter....");
        this.buff = new ByteFifo();
        this.iv_init = null;
        this.err = false;
        switch (this.algo) {
            case 20: {
                if (!key.getAlgorithm().startsWith("DES")) {
                    throw new InvalidKeyException();
                }
                this.blockSize = 8;
                break;
            }
            case 21: {
                if (!key.getAlgorithm().startsWith("AES")) {
                    throw new InvalidKeyException();
                }
                this.blockSize = 16;
                break;
            }
            case 0: {
                if (key.getAlgorithm().startsWith("DES")) {
                    this.algo = 20;
                    this.blockSize = 8;
                    break;
                }
                if (!key.getAlgorithm().startsWith("AES")) break;
                this.algo = 21;
                this.blockSize = 16;
                break;
            }
            default: {
                throw new InvalidKeyException();
            }
        }
        if (key instanceof CryptoServerSecretKey) {
            object = (CryptoServerSecretKey)key;
            this.key = ((CryptoServerSecretKey)object).keyHandle;
        } else if (key instanceof SecretKeySpec) {
            object = (SecretKeySpec)key;
            byte[] byArray = ((SecretKeySpec)object).getEncoded();
            try {
                this.key = this.hsm.importSecretKey(this.algo, byArray.length, true, this.hsm.getExportPolicy(), byArray);
            }
            catch (Exception exception) {
                InvalidKeyException invalidKeyException = new InvalidKeyException(exception.toString());
                invalidKeyException.initCause(exception);
                throw invalidKeyException;
            }
        } else {
            throw new InvalidKeyException("Invalid key class: " + key.toString());
        }
        if (this.algorithm.startsWith("Hmac") && algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("HMAC does not use parameters");
        }
        if (algorithmParameterSpec != null) {
            if (algorithmParameterSpec instanceof IvParameterSpec) {
                object = (IvParameterSpec)algorithmParameterSpec;
                this.iv_init = ((IvParameterSpec)object).getIV();
                if (this.iv_init.length != this.blockSize) {
                    throw new InvalidAlgorithmParameterException("Invalid IV length");
                }
            } else {
                throw new InvalidAlgorithmParameterException("Invalid parameter class: " + algorithmParameterSpec.toString());
            }
        }
        this.sign_info = new UcapiSignInfo();
        if (this.algorithm.startsWith("Hmac")) {
            this.sign_info.hash_mode(UcapiWrapperGlobal.HashMode.HMAC);
            this.sign_info.hash_algo(this.hash);
        } else {
            if (this.padding == 0) {
                this.sign_info.padding().set_none();
            } else {
                this.sign_info.padding().set_pkcs5();
            }
            if (this.iv_init == null) {
                this.sign_info.chaining().set_cbc();
            } else {
                this.sign_info.chaining().set_cbc(this.iv_init, (long)this.iv_init.length);
            }
        }
        this.sign_state = new UcapiSignState(this.sign_info);
        UcapiWrapperGlobal.sign_init(this.hsm.isEphemeralStored(this.key) ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.sign_state, this.key);
    }

    @Override
    protected void engineReset() {
        Log.log(LogLevel.Trace, "enter....");
        this.buff = new ByteFifo();
        if (this.sign_info != null) {
            this.sign_info.close();
            this.sign_info = null;
        }
        if (this.sign_state != null) {
            this.sign_state.close();
            this.sign_state = null;
        }
        this.err = false;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        Log.log(LogLevel.Trace, "enter....");
        if (this.err) {
            return;
        }
        if (n2 != 0) {
            this.buff.put(byArray, n, n2);
        }
        if ((n5 = (n4 = this.buff.getSize()) - (n3 = n4 % this.blockSize)) < 1000) {
            return;
        }
        if (!this.algorithm.startsWith("Hmac") && n3 == 0) {
            n3 = this.blockSize;
            n5 = n4 - this.blockSize;
        }
        byte[] byArray2 = this.buff.get(n5);
        try {
            UcapiWrapperGlobal.sign_update(this.hsm.getSession(), this.hsm.isEphemeralStored(this.key) ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.sign_state, byArray2, (long)byArray2.length);
        }
        catch (Exception exception) {
            Log.log(LogLevel.Error, exception.getMessage());
            this.err = true;
            exception.printStackTrace();
        }
    }

    @Override
    protected void engineUpdate(byte by) {
        Log.log(LogLevel.Trace, "enter....");
        if (this.err) {
            return;
        }
        this.buff.expand(this.blockSize);
        this.buff.fill(by, 1);
        if (this.buff.getSize() > 1000) {
            this.engineUpdate(null, 0, 0);
        }
    }

    @Override
    protected byte[] engineDoFinal() {
        byte[] byArray;
        Log.log(LogLevel.Trace, "enter....");
        if (this.err) {
            return null;
        }
        int n = this.buff.getSize();
        if (n == 0 && !this.algorithm.startsWith("Hmac") && this.padding == 0) {
            return null;
        }
        if (!this.algorithm.startsWith("Hmac")) {
            switch (this.padding) {
                case 0: {
                    if (n % this.blockSize == 0) break;
                    return null;
                }
                case 1: {
                    if (n % this.blockSize == 0) break;
                    int n2 = this.blockSize - n % this.blockSize;
                    this.buff.expand(n2);
                    this.buff.fill((byte)n2, n2);
                    n += n2;
                }
            }
        }
        byte[] byArray2 = this.buff.get(n);
        try {
            UcapiVectorU8 ucapiVectorU8 = UcapiWrapperGlobal.sign_final(this.hsm.getSession(), this.hsm.isEphemeralStored(this.key) ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.sign_state, byArray2, (long)byArray2.length);
            byArray = ToolBox.ucapiVecU8ToByteArray(ucapiVectorU8);
        }
        catch (Exception exception) {
            Log.log(LogLevel.Error, exception.getMessage());
            this.err = true;
            exception.printStackTrace();
            return null;
        }
        return byArray;
    }

    private static UcapiWrapperGlobal.HashAlgo selectHashAlgoCXI(String string) throws NoSuchAlgorithmException {
        switch (string) {
            case "HmacMD5": {
                return UcapiWrapperGlobal.HashAlgo.MD5;
            }
            case "HmacRMD160": {
                return UcapiWrapperGlobal.HashAlgo.RMD160;
            }
            case "HmacSHA1": {
                return UcapiWrapperGlobal.HashAlgo.SHA1;
            }
            case "HmacSHA224": {
                return UcapiWrapperGlobal.HashAlgo.SHA224;
            }
            case "HmacSHA3-224": {
                return UcapiWrapperGlobal.HashAlgo.SHA3_224;
            }
            case "HmacSHA256": {
                return UcapiWrapperGlobal.HashAlgo.SHA256;
            }
            case "HmacSHA3-256": {
                return UcapiWrapperGlobal.HashAlgo.SHA3_256;
            }
            case "HmacSHA384": {
                return UcapiWrapperGlobal.HashAlgo.SHA384;
            }
            case "HmacSHA3-384": {
                return UcapiWrapperGlobal.HashAlgo.SHA3_384;
            }
            case "HmacSHA512": {
                return UcapiWrapperGlobal.HashAlgo.SHA512;
            }
            case "HmacSHA3-512": {
                return UcapiWrapperGlobal.HashAlgo.SHA3_512;
            }
        }
        throw new NoSuchAlgorithmException();
    }
}

