/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerCXI.CryptoServerCXI;
import CryptoServerJCE.CryptoServerDSAKeyGenParameterSpec;
import CryptoServerJCE.CryptoServerDSAPrivateKey;
import CryptoServerJCE.CryptoServerECKeyGenParameterSpec;
import CryptoServerJCE.CryptoServerECPrivateKey;
import CryptoServerJCE.CryptoServerJCEException;
import CryptoServerJCE.CryptoServerPrivateKey;
import CryptoServerJCE.CryptoServerPublicKey;
import CryptoServerJCE.CryptoServerRSAKeyGenParameterSpec;
import CryptoServerJCE.CryptoServerRSAPrivateKey;
import CryptoServerJCE.Log;
import CryptoServerJCE.LogLevel;
import CryptoServerJCE.ToolBox;
import com.utimaco.javacpp.global.UcapiWrapperGlobal;
import com.utimaco.javacpp.ucapi.UcapiExportPolicy;
import com.utimaco.javacpp.ucapi.UcapiKeyPair;
import com.utimaco.javacpp.ucapi.UcapiKeyTemplate;
import com.utimaco.javacpp.ucapi.UcapiVectorU8;
import com.utimaco.jce.hsm.HSM;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import org.bytedeco.javacpp.Pointer;

public class CryptoServerKeyPairGenerator
extends KeyPairGeneratorSpi {
    private final HSM hsm;
    private final int algo;
    private final String algorithm;
    private String curveName;
    private int keysize = -1;
    private AlgorithmParameterSpec param = null;

    CryptoServerKeyPairGenerator(HSM hSM, String string, int n) throws NoSuchAlgorithmException {
        Log.log(LogLevel.Trace, "enter....");
        this.hsm = hSM;
        this.algo = n;
        this.algorithm = string;
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 5: {
                if ("Ed25519".equalsIgnoreCase(string) || "Ed448".equalsIgnoreCase(string) || "EdDSA".equalsIgnoreCase(string)) break;
                throw new NoSuchAlgorithmException("Unsupported Edwards curvename " + string);
            }
            default: {
                throw new NoSuchAlgorithmException();
            }
        }
    }

    private PairTemplates createPairTemplates() {
        Object object;
        UcapiKeyTemplate ucapiKeyTemplate = new UcapiKeyTemplate();
        UcapiKeyTemplate ucapiKeyTemplate2 = new UcapiKeyTemplate();
        switch (this.algo) {
            case 1: {
                ucapiKeyTemplate.set_algorithm(UcapiWrapperGlobal.Algorithm.RSA);
                ucapiKeyTemplate.set_size(1024);
                ucapiKeyTemplate2.set_algorithm(UcapiWrapperGlobal.Algorithm.RSA);
                ucapiKeyTemplate2.set_size(1024);
                break;
            }
            case 2: {
                ucapiKeyTemplate.set_algorithm(UcapiWrapperGlobal.Algorithm.DSA);
                break;
            }
            case 3: {
                ucapiKeyTemplate.set_algorithm(UcapiWrapperGlobal.Algorithm.ECDSA);
                ucapiKeyTemplate2.set_algorithm(UcapiWrapperGlobal.Algorithm.ECDSA);
                this.curveName = new String("NIST-P256");
                ucapiKeyTemplate.set_ec_curve_name(this.curveName);
                ucapiKeyTemplate2.set_ec_curve_name(this.curveName);
                break;
            }
            case 5: {
                ucapiKeyTemplate.set_algorithm(UcapiWrapperGlobal.Algorithm.EC_Edwards);
                ucapiKeyTemplate2.set_algorithm(UcapiWrapperGlobal.Algorithm.EC_Edwards);
                try {
                    this.curveName = new String(this.algorithm);
                    if ("EdDSA".equals(this.algorithm)) break;
                    object = ToolBox.getEdwardsCurveName(this.algorithm);
                    ucapiKeyTemplate.set_ec_curve_name((String)object);
                    ucapiKeyTemplate2.set_ec_curve_name((String)object);
                    break;
                }
                catch (Exception exception) {
                    Log.log(LogLevel.Error, exception.getMessage());
                }
            }
        }
        ucapiKeyTemplate.set_export_policy(this.hsm.getExportPolicy());
        ucapiKeyTemplate.set_usage(this.hsm.getKeyUsage());
        ucapiKeyTemplate2.set_extractable(true);
        ucapiKeyTemplate2.set_usage(this.hsm.getKeyUsage());
        object = new PairTemplates();
        ((PairTemplates)object).publicTemplate = ucapiKeyTemplate2;
        ((PairTemplates)object).privateTemplate = ucapiKeyTemplate;
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private PairTemplates initTemplatesByKeySize(PairTemplates var1_1) {
        switch (this.algo) {
            case 1: {
                if (this.keysize < 512 || this.keysize > 8192) {
                    throw new InvalidParameterException();
                }
                PairTemplates.access$200(var1_1).set_size(this.keysize);
                PairTemplates.access$100(var1_1).set_size(this.keysize);
                break;
            }
            case 2: {
                if (this.keysize < 512 || this.keysize > 8192) {
                    throw new InvalidParameterException();
                }
                var2_2 = this.hsm.generateDSAParams(this.keysize, 160);
                var3_3 = null;
                var4_4 = var2_2.get_dsa_prime_q().value();
                var5_7 = null;
                try {
                    var6_8 = var2_2.get_dsa_prime_p().value();
                    var7_11 = null;
                    try {
                        var8_12 = var2_2.get_dsa_generator().value();
                        var9_15 = null;
                        try {
                            PairTemplates.access$200(var1_1).set_size(this.keysize);
                            PairTemplates.access$200(var1_1).set_algorithm(UcapiWrapperGlobal.Algorithm.DSA);
                            PairTemplates.access$200(var1_1).set_dsa_prime_p(var6_8);
                            PairTemplates.access$200(var1_1).set_dsa_prime_q(var4_4);
                            PairTemplates.access$200(var1_1).set_dsa_generator(var8_12);
                            PairTemplates.access$100(var1_1).set_algorithm(UcapiWrapperGlobal.Algorithm.DSA);
                            PairTemplates.access$100(var1_1).set_extractable(true);
                            PairTemplates.access$100(var1_1).set_size(this.keysize);
                            PairTemplates.access$100(var1_1).set_dsa_prime_p(var6_8);
                            PairTemplates.access$100(var1_1).set_dsa_prime_q(var4_4);
                            PairTemplates.access$100(var1_1).set_dsa_generator(var8_12);
                        }
                        catch (Throwable var10_17) {
                            var9_15 = var10_17;
                            throw var10_17;
                        }
                        finally {
                            if (var8_12 != null) {
                                if (var9_15 != null) {
                                    try {
                                        var8_12.close();
                                    }
                                    catch (Throwable var10_16) {
                                        var9_15.addSuppressed(var10_16);
                                    }
                                } else {
                                    var8_12.close();
                                }
                            }
                        }
                    }
                    catch (Throwable var8_14) {
                        var7_11 = var8_14;
                        throw var8_14;
                    }
                    finally {
                        if (var6_8 != null) {
                            if (var7_11 != null) {
                                try {
                                    var6_8.close();
                                }
                                catch (Throwable var8_13) {
                                    var7_11.addSuppressed(var8_13);
                                }
                            } else {
                                var6_8.close();
                            }
                        }
                    }
                }
                catch (Throwable var6_10) {
                    var5_7 = var6_10;
                    throw var6_10;
                }
                finally {
                    if (var4_4 != null) {
                        if (var5_7 != null) {
                            try {
                                var4_4.close();
                            }
                            catch (Throwable var6_9) {
                                var5_7.addSuppressed(var6_9);
                            }
                        } else {
                            var4_4.close();
                        }
                    }
                }
                if (var2_2 == null) break;
                if (var3_3 == null) ** GOTO lbl85
                try {
                    var2_2.close();
                }
                catch (Throwable var4_5) {
                    var3_3.addSuppressed(var4_5);
                }
                break;
lbl85:
                // 1 sources

                var2_2.close();
                break;
                catch (Throwable var4_6) {
                    try {
                        var3_3 = var4_6;
                        throw var4_6;
                    }
                    catch (Throwable var17_24) {
                        if (var2_2 != null) {
                            if (var3_3 != null) {
                                try {
                                    var2_2.close();
                                }
                                catch (Throwable var18_25) {
                                    var3_3.addSuppressed(var18_25);
                                }
                            } else {
                                var2_2.close();
                            }
                        }
                        throw var17_24;
                    }
                }
            }
            case 37: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new InvalidParameterException();
            }
        }
        return var1_1;
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) throws InvalidParameterException {
        Log.log(LogLevel.Trace, "enter....");
        switch (this.algo) {
            case 1: {
                if (n < 512 || n > 8192) {
                    throw new InvalidParameterException();
                }
                this.keysize = n;
                break;
            }
            case 2: {
                if (n < 512 || n > 8192) {
                    throw new InvalidParameterException();
                }
                this.keysize = n;
                break;
            }
            case 37: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new InvalidParameterException();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private PairTemplates initTemplatesByParameterSpec(PairTemplates var1_1) {
        switch (this.algo) {
            case 1: {
                if (!(this.param instanceof RSAKeyGenParameterSpec)) {
                    throw new InvalidParameterException();
                }
                var2_2 = (RSAKeyGenParameterSpec)this.param;
                var3_3 = var2_2.getKeysize();
                if (var3_3 < 512 || var3_3 > 8192) {
                    throw new InvalidParameterException();
                }
                PairTemplates.access$200(var1_1).set_size(var3_3);
                PairTemplates.access$100(var1_1).set_size(var3_3);
                var4_5 = var2_2.getPublicExponent();
                if (var4_5 != null) {
                    var5_6 = new UcapiVectorU8(var4_5.toByteArray());
                    var6_9 = null;
                    try {
                        PairTemplates.access$200(var1_1).set_rsa_exponent(var5_6);
                        PairTemplates.access$100(var1_1).set_rsa_exponent(var5_6);
                    }
                    catch (Throwable var7_17) {
                        var6_9 = var7_17;
                        throw var7_17;
                    }
                    finally {
                        if (var5_6 != null) {
                            if (var6_9 != null) {
                                try {
                                    var5_6.close();
                                }
                                catch (Throwable var7_16) {
                                    var6_9.addSuppressed(var7_16);
                                }
                            } else {
                                var5_6.close();
                            }
                        }
                    }
                }
                if (this.param instanceof CryptoServerRSAKeyGenParameterSpec) break;
                break;
            }
            case 2: {
                if (!(this.param instanceof DSAParameterSpec)) ** GOTO lbl108
                var5_7 = (DSAParameterSpec)this.param;
                var6_10 = var5_7.getP().toByteArray();
                var7_18 = var5_7.getQ().toByteArray();
                var8_27 = var5_7.getG().toByteArray();
                var9_34 = new UcapiVectorU8(var6_10);
                var10_41 = null;
                var11_48 = new UcapiVectorU8(var7_18);
                var12_55 = null;
                try {
                    var13_60 = new UcapiVectorU8(var8_27);
                    var14_67 = null;
                    try {
                        PairTemplates.access$200(var1_1).set_dsa_prime_p(var9_34);
                        PairTemplates.access$200(var1_1).set_dsa_prime_q(var11_48);
                        PairTemplates.access$200(var1_1).set_dsa_prime_p(var13_60);
                        PairTemplates.access$200(var1_1).set_size(var5_7.getP().bitLength());
                    }
                    catch (Throwable var15_73) {
                        var14_67 = var15_73;
                        throw var15_73;
                    }
                    finally {
                        if (var13_60 != null) {
                            if (var14_67 != null) {
                                try {
                                    var13_60.close();
                                }
                                catch (Throwable var15_72) {
                                    var14_67.addSuppressed(var15_72);
                                }
                            } else {
                                var13_60.close();
                            }
                        }
                    }
                }
                catch (Throwable var13_62) {
                    var12_55 = var13_62;
                    throw var13_62;
                }
                finally {
                    if (var11_48 != null) {
                        if (var12_55 != null) {
                            try {
                                var11_48.close();
                            }
                            catch (Throwable var13_61) {
                                var12_55.addSuppressed(var13_61);
                            }
                        } else {
                            var11_48.close();
                        }
                    }
                }
                if (var9_34 == null) break;
                if (var10_41 == null) ** GOTO lbl91
                try {
                    var9_34.close();
                }
                catch (Throwable var11_49) {
                    var10_41.addSuppressed(var11_49);
                }
                break;
lbl91:
                // 1 sources

                var9_34.close();
                break;
                catch (Throwable var11_50) {
                    try {
                        var10_41 = var11_50;
                        throw var11_50;
                    }
                    catch (Throwable var20_83) {
                        if (var9_34 != null) {
                            if (var10_41 != null) {
                                try {
                                    var9_34.close();
                                }
                                catch (Throwable var21_84) {
                                    var10_41.addSuppressed(var21_84);
                                }
                            } else {
                                var9_34.close();
                            }
                        }
                        throw var20_83;
                    }
                }
lbl108:
                // 1 sources

                if (!(this.param instanceof CryptoServerDSAKeyGenParameterSpec)) {
                    throw new InvalidParameterException();
                }
                var5_8 = (CryptoServerDSAKeyGenParameterSpec)this.param;
                if (var5_8.dsaParameter == null) ** GOTO lbl183
                var6_11 = var5_8.dsaParameter;
                var7_19 = var6_11.getP().toByteArray();
                var8_28 = var6_11.getQ().toByteArray();
                var9_35 = var6_11.getG().toByteArray();
                var10_42 = new UcapiVectorU8(var7_19);
                var11_51 = null;
                var12_56 = new UcapiVectorU8(var8_28);
                var13_63 = null;
                try {
                    var14_68 = new UcapiVectorU8(var9_35);
                    var15_74 = null;
                    try {
                        PairTemplates.access$200(var1_1).set_dsa_prime_p(var10_42);
                        PairTemplates.access$200(var1_1).set_dsa_prime_q(var12_56);
                        PairTemplates.access$200(var1_1).set_dsa_prime_p(var14_68);
                        PairTemplates.access$200(var1_1).set_size(var6_11.getP().bitLength());
                    }
                    catch (Throwable var16_79) {
                        var15_74 = var16_79;
                        throw var16_79;
                    }
                    finally {
                        if (var14_68 != null) {
                            if (var15_74 != null) {
                                try {
                                    var14_68.close();
                                }
                                catch (Throwable var16_78) {
                                    var15_74.addSuppressed(var16_78);
                                }
                            } else {
                                var14_68.close();
                            }
                        }
                    }
                }
                catch (Throwable var14_70) {
                    var13_63 = var14_70;
                    throw var14_70;
                }
                finally {
                    if (var12_56 != null) {
                        if (var13_63 != null) {
                            try {
                                var12_56.close();
                            }
                            catch (Throwable var14_69) {
                                var13_63.addSuppressed(var14_69);
                            }
                        } else {
                            var12_56.close();
                        }
                    }
                }
                if (var10_42 == null) break;
                if (var11_51 == null) ** GOTO lbl166
                try {
                    var10_42.close();
                }
                catch (Throwable var12_57) {
                    var11_51.addSuppressed(var12_57);
                }
                break;
lbl166:
                // 1 sources

                var10_42.close();
                break;
                catch (Throwable var12_58) {
                    try {
                        var11_51 = var12_58;
                        throw var12_58;
                    }
                    catch (Throwable var26_89) {
                        if (var10_42 != null) {
                            if (var11_51 != null) {
                                try {
                                    var10_42.close();
                                }
                                catch (Throwable var27_90) {
                                    var11_51.addSuppressed(var27_90);
                                }
                            } else {
                                var10_42.close();
                            }
                        }
                        throw var26_89;
                    }
                }
lbl183:
                // 1 sources

                var3_4 = var5_8.keysize;
                if (var3_4 == 0) {
                    var3_4 = 1024;
                }
                if ((var6_12 = var5_8.qsize) == 0) {
                    var6_12 = 160;
                }
                if (var3_4 < 512 || var3_4 > 8192) {
                    throw new InvalidParameterException();
                }
                try {
                    var7_20 = this.hsm.generateDSAParams(var3_4, var6_12);
                    var8_29 = null;
                    var9_36 = var7_20.get_dsa_prime_p().value();
                    var10_43 = null;
                    try {
                        var11_52 = var7_20.get_dsa_prime_q().value();
                        var12_59 = null;
                        try {
                            var13_64 = var7_20.get_dsa_generator().value();
                            var14_71 = null;
                            try {
                                PairTemplates.access$200(var1_1).set_dsa_prime_p(var9_36);
                                PairTemplates.access$200(var1_1).set_dsa_prime_q(var11_52);
                                PairTemplates.access$200(var1_1).set_dsa_generator(var13_64);
                                PairTemplates.access$200(var1_1).set_size(var3_4);
                                PairTemplates.access$200(var1_1).set_algorithm(UcapiWrapperGlobal.Algorithm.DSA);
                                PairTemplates.access$100(var1_1).set_algorithm(UcapiWrapperGlobal.Algorithm.DSA);
                                PairTemplates.access$100(var1_1).set_extractable(true);
                                PairTemplates.access$100(var1_1).set_size(var3_4);
                                PairTemplates.access$100(var1_1).set_dsa_prime_p(var9_36);
                                PairTemplates.access$100(var1_1).set_dsa_prime_q(var11_52);
                                PairTemplates.access$100(var1_1).set_dsa_generator(var13_64);
                            }
                            catch (Throwable var15_76) {
                                var14_71 = var15_76;
                                throw var15_76;
                            }
                            finally {
                                if (var13_64 != null) {
                                    if (var14_71 != null) {
                                        try {
                                            var13_64.close();
                                        }
                                        catch (Throwable var15_75) {
                                            var14_71.addSuppressed(var15_75);
                                        }
                                    } else {
                                        var13_64.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable var13_66) {
                            var12_59 = var13_66;
                            throw var13_66;
                        }
                        finally {
                            if (var11_52 != null) {
                                if (var12_59 != null) {
                                    try {
                                        var11_52.close();
                                    }
                                    catch (Throwable var13_65) {
                                        var12_59.addSuppressed(var13_65);
                                    }
                                } else {
                                    var11_52.close();
                                }
                            }
                        }
                    }
                    catch (Throwable var11_54) {
                        var10_43 = var11_54;
                        throw var11_54;
                    }
                    finally {
                        if (var9_36 != null) {
                            if (var10_43 != null) {
                                try {
                                    var9_36.close();
                                }
                                catch (Throwable var11_53) {
                                    var10_43.addSuppressed(var11_53);
                                }
                            } else {
                                var9_36.close();
                            }
                        }
                    }
                    if (var7_20 == null) break;
                    if (var8_29 == null) ** GOTO lbl265
                    try {
                        var7_20.close();
                    }
                    catch (Throwable var9_37) {
                        var8_29.addSuppressed(var9_37);
                    }
                    break;
lbl265:
                    // 1 sources

                    var7_20.close();
                    ** break;
                    catch (Throwable var9_38) {
                        try {
                            var8_29 = var9_38;
                            throw var9_38;
                        }
                        catch (Throwable var34_97) {
                            if (var7_20 != null) {
                                if (var8_29 != null) {
                                    try {
                                        var7_20.close();
                                    }
                                    catch (Throwable var35_98) {
                                        var8_29.addSuppressed(var35_98);
                                    }
                                } else {
                                    var7_20.close();
                                }
                            }
                            throw var34_97;
lbl282:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (Exception var7_21) {
                    var8_30 = new InvalidParameterException(var7_21.toString());
                    var8_30.initCause(var7_21);
                    throw var8_30;
                }
            }
            case 3: 
            case 5: {
                try {
                    if (!(this.param instanceof CryptoServerECKeyGenParameterSpec)) ** GOTO lbl330
                    var6_13 = (CryptoServerECKeyGenParameterSpec)this.param;
                    if (var6_13.name != null) {
                        var7_22 = null;
                        var7_22 = this.algo == 5 ? ToolBox.getEdwardsCurveName(var6_13.name) : new String(var6_13.name);
                        this.curveName = new String(var6_13.name);
                        PairTemplates.access$200(var1_1).set_ec_curve_name((String)var7_22);
                        PairTemplates.access$100(var1_1).set_ec_curve_name((String)var7_22);
                    }
                    if (var6_13.ecParameter == null) break;
                    var7_22 = new CryptoServerCXI.ECParameter(var6_13.ecParameter);
                    var8_31 = new UcapiVectorU8(var7_22.getEncoded());
                    var9_39 = null;
                    PairTemplates.access$200(var1_1).set_ec_curve_oid(var8_31);
                    PairTemplates.access$100(var1_1).set_ec_curve_oid(var8_31);
                    if (var8_31 == null) break;
                    if (var9_39 == null) ** GOTO lbl313
                    try {
                        var8_31.close();
                    }
                    catch (Throwable var10_44) {
                        var9_39.addSuppressed(var10_44);
                    }
                    break;
lbl313:
                    // 1 sources

                    var8_31.close();
                    break;
                    catch (Throwable var10_45) {
                        try {
                            var9_39 = var10_45;
                            throw var10_45;
                        }
                        catch (Throwable var36_99) {
                            if (var8_31 != null) {
                                if (var9_39 != null) {
                                    try {
                                        var8_31.close();
                                    }
                                    catch (Throwable var37_100) {
                                        var9_39.addSuppressed(var37_100);
                                    }
                                } else {
                                    var8_31.close();
                                }
                            }
                            throw var36_99;
                        }
                    }
lbl330:
                    // 1 sources

                    if (this.param instanceof ECGenParameterSpec && (var6_14 = (ECGenParameterSpec)this.param).getName() != null) {
                        var7_23 = null;
                        var7_23 = this.algo == 5 ? ToolBox.getEdwardsCurveName(var6_14.getName()) : new String(var6_14.getName());
                        this.curveName = new String(var6_14.getName());
                        PairTemplates.access$200(var1_1).set_ec_curve_name(var7_23);
                        PairTemplates.access$100(var1_1).set_ec_curve_name(var7_23);
                        break;
                    }
                    if (!(this.param instanceof ECParameterSpec)) ** GOTO lbl375
                    var6_14 = (ECParameterSpec)this.param;
                    var7_24 = new CryptoServerCXI.ECParameter((ECParameterSpec)var6_14);
                    var8_32 = new UcapiVectorU8(var7_24.getEncoded());
                    var9_40 = null;
                    PairTemplates.access$200(var1_1).set_ec_curve_oid(var8_32);
                    PairTemplates.access$100(var1_1).set_ec_curve_oid(var8_32);
                    if (var8_32 == null) break;
                    if (var9_40 == null) ** GOTO lbl353
                    try {
                        var8_32.close();
                    }
                    catch (Throwable var10_46) {
                        var9_40.addSuppressed(var10_46);
                    }
                    break;
lbl353:
                    // 1 sources

                    var8_32.close();
                    break;
                    catch (Throwable var10_47) {
                        try {
                            var9_40 = var10_47;
                            throw var10_47;
                        }
                        catch (Throwable var38_101) {
                            if (var8_32 != null) {
                                if (var9_40 != null) {
                                    try {
                                        var8_32.close();
                                    }
                                    catch (Throwable var39_102) {
                                        var9_40.addSuppressed(var39_102);
                                    }
                                } else {
                                    var8_32.close();
                                }
                            }
                            throw var38_101;
                        }
                    }
                }
                catch (Exception var6_15) {
                    var7_25 = new InvalidParameterException(var6_15.toString());
                    var7_25.initCause(var6_15);
                    throw var7_25;
                }
lbl375:
                // 1 sources

                throw new InvalidParameterException();
            }
        }
        return var1_1;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidParameterException {
        Log.log(LogLevel.Trace, "enter....");
        switch (this.algo) {
            case 1: {
                if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
                    throw new InvalidParameterException();
                }
                this.param = algorithmParameterSpec;
                break;
            }
            case 2: {
                if (!(algorithmParameterSpec instanceof DSAParameterSpec) && !(algorithmParameterSpec instanceof CryptoServerDSAKeyGenParameterSpec)) {
                    throw new InvalidParameterException();
                }
                if (algorithmParameterSpec instanceof CryptoServerDSAKeyGenParameterSpec) {
                    CryptoServerDSAKeyGenParameterSpec cryptoServerDSAKeyGenParameterSpec = (CryptoServerDSAKeyGenParameterSpec)algorithmParameterSpec;
                    if (cryptoServerDSAKeyGenParameterSpec.dsaParameter == null) {
                        this.keysize = cryptoServerDSAKeyGenParameterSpec.keysize;
                        if (this.keysize == 0) {
                            this.keysize = 1024;
                        }
                        if (this.keysize < 512 || this.keysize > 8192) {
                            throw new InvalidParameterException();
                        }
                    }
                }
                this.param = algorithmParameterSpec;
                break;
            }
            case 3: 
            case 5: {
                if (!(algorithmParameterSpec instanceof CryptoServerECKeyGenParameterSpec || algorithmParameterSpec instanceof ECGenParameterSpec || algorithmParameterSpec instanceof ECParameterSpec)) {
                    throw new InvalidParameterException();
                }
                this.param = algorithmParameterSpec;
                break;
            }
            default: {
                throw new InvalidParameterException();
            }
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        CryptoServerPublicKey cryptoServerPublicKey;
        CryptoServerPrivateKey cryptoServerPrivateKey;
        Log.log(LogLevel.Trace, "enter....");
        String string = null;
        switch (this.algo) {
            case 1: {
                string = "RSA";
                break;
            }
            case 2: {
                string = "DSA";
                break;
            }
            case 3: {
                string = "EC";
                break;
            }
            case 5: {
                string = this.curveName;
            }
        }
        PairTemplates pairTemplates = null;
        Pointer pointer = null;
        try {
            Object object;
            pairTemplates = this.createPairTemplates();
            if (this.param != null) {
                pairTemplates = this.initTemplatesByParameterSpec(pairTemplates);
                if (this.param instanceof CryptoServerRSAKeyGenParameterSpec) {
                    object = (CryptoServerRSAKeyGenParameterSpec)this.param;
                    if (((CryptoServerRSAKeyGenParameterSpec)object).isConfigured) {
                        pointer = this.hsm.createExportPolicy(((CryptoServerRSAKeyGenParameterSpec)object).allow_wrapped_export, ((CryptoServerRSAKeyGenParameterSpec)object).allow_plain_export);
                        pairTemplates.privateTemplate.set_export_policy((UcapiExportPolicy)pointer);
                    }
                } else if (this.param instanceof CryptoServerDSAKeyGenParameterSpec) {
                    object = (CryptoServerDSAKeyGenParameterSpec)this.param;
                    if (((CryptoServerDSAKeyGenParameterSpec)object).isConfigured) {
                        pointer = this.hsm.createExportPolicy(((CryptoServerDSAKeyGenParameterSpec)object).allow_wrapped_export, ((CryptoServerDSAKeyGenParameterSpec)object).allow_plain_export);
                        pairTemplates.privateTemplate.set_export_policy((UcapiExportPolicy)pointer);
                    }
                } else if (this.param instanceof CryptoServerECKeyGenParameterSpec) {
                    object = (CryptoServerECKeyGenParameterSpec)this.param;
                    if (((CryptoServerECKeyGenParameterSpec)object).isConfigured) {
                        pointer = this.hsm.createExportPolicy(((CryptoServerECKeyGenParameterSpec)object).allow_wrapped_export, ((CryptoServerECKeyGenParameterSpec)object).allow_plain_export);
                        pairTemplates.privateTemplate.set_export_policy((UcapiExportPolicy)pointer);
                    }
                }
            } else if (this.keysize != -1) {
                pairTemplates = this.initTemplatesByKeySize(pairTemplates);
            }
            if (this.hsm.getKeyGroup() != null) {
                pairTemplates.privateTemplate.set_group(this.hsm.getKeyGroup());
                pairTemplates.publicTemplate.set_group(this.hsm.getKeyGroup());
            }
            object = ToolBox.generateFormatCurrentDate();
            pairTemplates.privateTemplate.set_date_generated((String)object);
            pairTemplates.publicTemplate.set_date_generated((String)object);
            UcapiKeyPair ucapiKeyPair = this.hsm.generateKeyPair(pairTemplates.publicTemplate, pairTemplates.privateTemplate);
            cryptoServerPrivateKey = 1 == this.algo ? new CryptoServerRSAPrivateKey(this.hsm, ucapiKeyPair.private_key()) : (2 == this.algo ? new CryptoServerDSAPrivateKey(this.hsm, ucapiKeyPair.private_key()) : (3 == this.algo ? new CryptoServerECPrivateKey(this.hsm, ucapiKeyPair.private_key()) : new CryptoServerPrivateKey(this.hsm, string, ucapiKeyPair.private_key())));
            cryptoServerPublicKey = new CryptoServerPublicKey(this.hsm, string, ucapiKeyPair.public_key());
        }
        catch (CryptoServerJCEException cryptoServerJCEException) {
            Log.log(LogLevel.Error, cryptoServerJCEException.getMessage());
            cryptoServerJCEException.printStackTrace();
            throw new RuntimeException(cryptoServerJCEException);
        }
        finally {
            if (pointer != null) {
                pointer.close();
            }
            if (pairTemplates != null) {
                pairTemplates.privateTemplate.close();
                pairTemplates.publicTemplate.close();
            }
        }
        return new KeyPair(cryptoServerPublicKey, cryptoServerPrivateKey);
    }

    private class PairTemplates {
        private UcapiKeyTemplate privateTemplate;
        private UcapiKeyTemplate publicTemplate;

        private PairTemplates() {
        }
    }
}

