/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import CryptoServerJCE.AsnBuffer;
import CryptoServerJCE.CertBuilder;
import CryptoServerJCE.CryptoServerECKeyGenParameterSpec;
import CryptoServerJCE.CryptoServerECKeySizeParameterSpec;
import CryptoServerJCE.ToolBox;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;

public class CryptoServerECAlgorithmParametersSpi
extends AlgorithmParametersSpi {
    private String curveName = null;
    private static final String ECURVE_DIR = "/ecurves/";

    protected boolean isASN1FormatString(String string) {
        return string == null || string.equals("ASN.1");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec == null) {
            throw new InvalidParameterSpecException("paramSpec must not be null");
        }
        if (algorithmParameterSpec instanceof CryptoServerECKeyGenParameterSpec) {
            this.curveName = ((CryptoServerECKeyGenParameterSpec)algorithmParameterSpec).name == null ? this.getCurveName(((CryptoServerECKeyGenParameterSpec)algorithmParameterSpec).ecParameter) : ((CryptoServerECKeyGenParameterSpec)algorithmParameterSpec).name;
        } else if (algorithmParameterSpec instanceof ECParameterSpec) {
            this.curveName = this.getCurveName((ECParameterSpec)algorithmParameterSpec);
        } else if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            this.curveName = ((ECGenParameterSpec)algorithmParameterSpec).getName();
        } else if (algorithmParameterSpec instanceof CryptoServerECKeyGenParameterSpec) {
            int n = ((CryptoServerECKeySizeParameterSpec)algorithmParameterSpec).getKeySize();
            this.curveName = this.getCurveName(n);
        } else {
            throw new InvalidParameterSpecException("AlgorithmParameterSpec class not recognized: " + algorithmParameterSpec.getClass().getName());
        }
        if (this.curveName == null) {
            throw new InvalidParameterSpecException("Not a supported curve: " + algorithmParameterSpec);
        }
    }

    private String getCurveName(ECParameterSpec eCParameterSpec) throws InvalidParameterSpecException {
        for (String string : new HashSet<String>(ToolBox.curveNameAliases.values())) {
            try {
                CryptoServerCXI.ECParameter eCParameter = new CryptoServerCXI.ECParameter(ToolBox.getEncodedByCurveName(string));
                ECParameterSpec eCParameterSpec2 = eCParameter.getSpec();
                if (!eCParameterSpec2.getOrder().equals(eCParameterSpec.getOrder()) || !eCParameterSpec2.getCurve().equals(eCParameterSpec.getCurve()) || !eCParameterSpec2.getGenerator().equals(eCParameterSpec.getGenerator()) || eCParameterSpec2.getCofactor() != eCParameterSpec.getCofactor()) continue;
                return string;
            }
            catch (CryptoServerException | IOException exception) {
                exception.printStackTrace();
            }
        }
        throw new InvalidParameterSpecException("Unsupported parameters in AlgorithmParameterSpec");
    }

    private String getCurveName(int n) {
        return ToolBox.getCurveName(n);
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        this.engineInit(byArray, "ASN.1");
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (this.isASN1FormatString(string)) {
            AsnBuffer asnBuffer = new AsnBuffer(byArray);
            try {
                byte[] byArray2 = asnBuffer.getOID();
                for (CertBuilder.ECCurve eCCurve : CertBuilder.curves) {
                    if (!Arrays.equals(byArray2, eCCurve.oid)) continue;
                    this.curveName = eCCurve.name;
                    return;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        throw new IOException("Only named ECParameters supported");
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz.isAssignableFrom(CryptoServerECKeyGenParameterSpec.class) || clazz == AlgorithmParameterSpec.class) {
            return new CryptoServerECKeyGenParameterSpec(this.curveName);
        }
        if (clazz.isAssignableFrom(ECParameterSpec.class)) {
            try {
                CryptoServerCXI.ECParameter eCParameter = new CryptoServerCXI.ECParameter(ToolBox.getEncodedByCurveName(ToolBox.curveNameAliases.getOrDefault(this.curveName, this.curveName)));
                return eCParameter.getSpec();
            }
            catch (Exception exception) {}
        } else {
            if (clazz.isAssignableFrom(ECGenParameterSpec.class)) {
                return new ECGenParameterSpec(this.curveName);
            }
            if (clazz.isAssignableFrom(CryptoServerECKeySizeParameterSpec.class)) {
                try {
                    CryptoServerCXI.ECParameter eCParameter = new CryptoServerCXI.ECParameter(ToolBox.getEncodedByCurveName(this.curveName));
                    return new CryptoServerECKeySizeParameterSpec(eCParameter.getSpec().getCurve().getField().getFieldSize());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        throw new InvalidParameterSpecException("EC AlgorithmParameters cannot convert to " + clazz.getName());
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        return this.engineGetEncoded("ASN.1");
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        if (this.isASN1FormatString(string)) {
            byte[] byArray = null;
            for (CertBuilder.ECCurve eCCurve : CertBuilder.curves) {
                if (!eCCurve.name.equals(ToolBox.curveNameAliases.getOrDefault(this.curveName, this.curveName))) continue;
                byArray = eCCurve.oid;
                break;
            }
            if (byArray == null) {
                throw new IOException("Unsupported EC parameter: " + this.curveName);
            }
            try {
                AsnBuffer asnBuffer = new AsnBuffer();
                asnBuffer.addItem(6, byArray);
                return asnBuffer.getData();
            }
            catch (ParseException parseException) {
                throw new IOException(parseException);
            }
        }
        throw new IOException("Unknown parameters format in AlgorithmParameters object: " + string);
    }

    @Override
    protected String engineToString() {
        if (this.curveName == null) {
            return "Not initialized";
        }
        return this.curveName;
    }
}

