/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerJCE.ByteFifo;
import CryptoServerJCE.CryptoServerCCMParameterSpec;
import CryptoServerJCE.CryptoServerGCMParameterSpec;
import CryptoServerJCE.CryptoServerPrivateKey;
import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.CryptoServerProviderJCEException;
import CryptoServerJCE.CryptoServerPublicKey;
import CryptoServerJCE.CryptoServerSecretKey;
import CryptoServerJCE.CryptoServerUnwrapAlgorithmParameterSpec;
import CryptoServerJCE.Log;
import CryptoServerJCE.LogLevel;
import CryptoServerJCE.ToolBox;
import com.utimaco.javacpp.global.UcapiWrapperGlobal;
import com.utimaco.javacpp.ucapi.UcapiAEAData;
import com.utimaco.javacpp.ucapi.UcapiChaining;
import com.utimaco.javacpp.ucapi.UcapiCryptInfo;
import com.utimaco.javacpp.ucapi.UcapiCryptState;
import com.utimaco.javacpp.ucapi.UcapiKeyHandle;
import com.utimaco.javacpp.ucapi.UcapiPadding;
import com.utimaco.javacpp.ucapi.UcapiVectorU8;
import com.utimaco.jce.hsm.HSM;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;

public class CryptoServerCipher
extends CipherSpi {
    public static final int MECH_MODE_ENCRYPT = 0x2000000;
    public static final int MECH_MODE_DECRYPT = 0x3000000;
    public static final int MECH_CHAIN_ECB = 0;
    public static final int MECH_CHAIN_CBC = 0x100000;
    public static final int MECH_CHAIN_GCM = 0x600000;
    public static final int MECH_CHAIN_OFB = 0x700000;
    public static final int MECH_CHAIN_CCM = 0x800000;
    public static final int MECH_PAD_NONE = 0;
    public static final int MECH_PAD_PKCS5 = 4096;
    public static final int MECH_PAD_PKCS1 = 16384;
    public static final int MECH_PAD_OAEP = 20480;
    private final HSM hsm;
    private final int algo;
    private int mech_chain;
    private int mech_pad;
    private boolean isISO10126PAD;
    private final int blockSize;
    private boolean isFirstUpdate;
    private byte[] iv_init;
    private byte[] aad;
    private int tagLen;
    private int dataLen;
    private int hashLen;
    private UcapiKeyHandle key;
    private int mode;
    private ByteFifo buff;
    private SecureRandom rng;
    private UcapiCryptState cryptoState;
    private OAEPParameterSpec currentParamOAEP;
    private CryptoServerUnwrapAlgorithmParameterSpec unwrapAlgParam;
    private UcapiCryptInfo cryptRsaInfo;

    CryptoServerCipher(HSM hSM, String string, int n) throws NoSuchAlgorithmException {
        Log.log(LogLevel.Trace, "enter....");
        this.hsm = hSM;
        this.algo = n;
        this.isFirstUpdate = true;
        this.mech_chain = 0;
        this.mech_pad = 0;
        this.isISO10126PAD = false;
        switch (n) {
            case 20: {
                this.blockSize = 8;
                break;
            }
            case 21: {
                this.blockSize = 16;
                break;
            }
            case 1: {
                this.blockSize = 0;
                break;
            }
            default: {
                throw new NoSuchAlgorithmException();
            }
        }
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        Log.log(LogLevel.Trace, "enter....");
        byte[] byArray2 = null;
        int n3 = 0;
        int n4 = 0;
        if (this.key == null) {
            throw new CryptoServerProviderJCEException("The mechanism is not initialized. Please, invoke the initialization before.");
        }
        if (n2 > 0) {
            this.buff.put(byArray, n, n2);
        }
        n3 = this.buff.getSize();
        switch (this.algo) {
            case 20: 
            case 21: {
                n4 = n3 % this.blockSize;
                if (n4 == 0) break;
                n4 = this.blockSize - n4;
            }
        }
        if (n3 == 0 && this.mech_chain != 0x600000 && this.mech_chain != 0x800000 && this.mech_pad == 0 && !this.isISO10126PAD) {
            return this.cryptFinal(new byte[0]);
        }
        if (this.mode == 0x3000000 && this.mech_chain != 0x600000 && this.mech_chain != 0x800000 && this.mech_chain != 0x700000 && n4 != 0) {
            throw new IllegalBlockSizeException();
        }
        if (this.mode == 0x2000000 && this.isISO10126PAD) {
            if (n4 == 0) {
                n4 = this.blockSize;
            }
            this.buff.expand(n4);
            if (n4 > 1) {
                try {
                    byte[] byArray3 = new byte[n4 - 1];
                    if (this.rng == null) {
                        this.rng = SecureRandom.getInstance("SHA1PRNG", CryptoServerProvider.PROVIDER_HASH_RNG);
                    }
                    this.rng.nextBytes(byArray3);
                    this.buff.put(byArray3);
                }
                catch (Exception exception) {
                    BadPaddingException badPaddingException = new BadPaddingException("No SecureRandom" + exception.toString());
                    badPaddingException.initCause(exception);
                    throw badPaddingException;
                }
            }
            this.buff.fill((byte)n4, 1);
            n3 = this.buff.getSize();
        }
        byte[] byArray4 = this.buff.get(n3);
        byArray2 = this.cryptFinal(byArray4);
        if (this.mode == 0x3000000 && this.isISO10126PAD) {
            byte by = byArray2[byArray2.length - 1];
            if (by <= 0 || by > this.blockSize) {
                throw new BadPaddingException();
            }
            byArray4 = new byte[byArray2.length - by];
            System.arraycopy(byArray2, 0, byArray4, 0, byArray4.length);
            byArray2 = byArray4;
        }
        return byArray2;
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        Log.log(LogLevel.Trace, "enter....");
        byte[] byArray3 = this.engineDoFinal(byArray, n, n2);
        if (byArray3 == null) {
            return 0;
        }
        if (byArray3.length > byArray2.length - n3) {
            throw new ShortBufferException();
        }
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    @Override
    protected int engineGetBlockSize() {
        Log.log(LogLevel.Trace, "enter....");
        return this.blockSize;
    }

    @Override
    protected byte[] engineGetIV() {
        Log.log(LogLevel.Trace, "enter....");
        return this.iv_init;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        Log.log(LogLevel.Trace, "enter....");
        int n2 = 0;
        if (this.key == null) {
            throw new CryptoServerProviderJCEException("The mechanism is not initialized. Please, invoke the initialization before.");
        }
        switch (this.algo) {
            case 20: 
            case 21: {
                n2 = n + this.buff.getSize();
                if (this.mode != 0x2000000) break;
                if (this.mech_chain == 0x800000 || this.mech_chain == 0x600000) {
                    n2 += this.tagLen;
                    break;
                }
                if (this.mech_pad == 0 && !this.isISO10126PAD) break;
                n2 += this.blockSize - n2 % this.blockSize;
                break;
            }
            case 1: {
                int n3 = this.hsm.getKeySize(this.key) / 8;
                n2 = this.mech_pad == 16384 ? (this.mode == 0x3000000 ? n3 - 11 : n3) : (this.mech_pad == 20480 ? (this.mode == 0x3000000 ? n3 - this.hashLen * 2 - 2 : n3) : (this.mode == 0x3000000 ? (n3 * 8 + 7) / 8 - 1 : (n3 * 8 + 7) / 8));
            }
        }
        return n2;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        Log.log(LogLevel.Trace, "enter....");
        return null;
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        Log.log(LogLevel.Trace, "enter....");
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            Log.log(LogLevel.Error, invalidAlgorithmParameterException.getMessage());
            invalidAlgorithmParameterException.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void engineInit(int var1_1, Key var2_2, AlgorithmParameterSpec var3_3, SecureRandom var4_4) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Log.log(LogLevel.Trace, "enter....");
        this.buff = new ByteFifo();
        this.isFirstUpdate = true;
        this.iv_init = null;
        this.rng = var4_4;
        switch (var1_1) {
            case 1: 
            case 3: {
                this.mode = 0x2000000;
                break;
            }
            case 2: 
            case 4: {
                this.mode = 0x3000000;
                break;
            }
            default: {
                throw new InvalidKeyException("Invalid opmode: " + var1_1);
            }
        }
        var5_5 = var3_3;
        if (var3_3 != null && var3_3 instanceof CryptoServerUnwrapAlgorithmParameterSpec) {
            var5_5 = ((CryptoServerUnwrapAlgorithmParameterSpec)var3_3).getAlgParamSpec();
            this.unwrapAlgParam = (CryptoServerUnwrapAlgorithmParameterSpec)var3_3;
        }
        switch (this.algo) {
            case 20: 
            case 21: {
                if (!var2_2.getAlgorithm().startsWith("DES") && !var2_2.getAlgorithm().equals("AES")) {
                    throw new InvalidKeyException("Invalid key algorithm: " + var2_2.getAlgorithm());
                }
                if (var2_2 instanceof CryptoServerSecretKey) {
                    var6_6 = (CryptoServerSecretKey)var2_2;
                    this.key = var6_6.keyHandle;
                } else if (var2_2 instanceof SecretKeySpec) {
                    var6_6 = (SecretKeySpec)var2_2;
                    var7_8 = var6_6.getEncoded();
                    try {
                        this.key = this.hsm.importSecretKey(this.algo, ((byte[])var7_8).length, true, this.hsm.getExportPolicy(), (byte[])var7_8);
                    }
                    catch (Exception var8_10) {
                        var9_17 = new InvalidKeyException(var8_10.toString());
                        var9_17.initCause(var8_10);
                        throw var9_17;
                    }
                } else {
                    throw new InvalidKeyException("Invalid key class: " + var2_2.toString());
                }
                if (var5_5 != null) {
                    if (var5_5 instanceof IvParameterSpec) {
                        var6_6 = (IvParameterSpec)var5_5;
                        this.iv_init = var6_6.getIV();
                        if (this.iv_init.length != this.blockSize) {
                            throw new InvalidAlgorithmParameterException("Invalid IV length");
                        }
                    } else if (var5_5 instanceof GCMParameterSpec) {
                        var6_6 = (GCMParameterSpec)var5_5;
                        this.iv_init = var6_6.getIV();
                        this.tagLen = var6_6.getTLen() / 8;
                    } else if (var5_5 instanceof CryptoServerGCMParameterSpec) {
                        var6_6 = (CryptoServerGCMParameterSpec)var5_5;
                        this.iv_init = var6_6.getIV();
                        this.aad = var6_6.getAad();
                        this.tagLen = var6_6.getTLen() / 8;
                    } else if (var5_5 instanceof CryptoServerCCMParameterSpec) {
                        var6_6 = (CryptoServerCCMParameterSpec)var5_5;
                        this.iv_init = var6_6.getNonce();
                        this.aad = var6_6.getAad();
                        this.tagLen = var6_6.getMacLen();
                        this.dataLen = var6_6.getDataLen();
                    } else {
                        throw new InvalidAlgorithmParameterException("Invalid mechanism parameter: " + var5_5.toString());
                    }
                }
                var6_6 = new UcapiCryptInfo();
                var7_8 = null;
                var8_11 = new UcapiChaining();
                var9_18 = null;
                try {
                    var10_20 = new UcapiPadding();
                    var11_25 = null;
                    try {
                        if (this.mech_chain == 0) {
                            var8_11.set_ecb();
                        } else if (this.mech_chain == 0x700000) {
                            var12_26 = new BytePointer(this.iv_init);
                            var13_29 = null;
                            try {
                                var8_11.set_ofb(var12_26, (long)this.iv_init.length);
                            }
                            catch (Throwable var14_32) {
                                var13_29 = var14_32;
                                throw var14_32;
                            }
                            finally {
                                if (var12_26 != null) {
                                    if (var13_29 != null) {
                                        try {
                                            var12_26.close();
                                        }
                                        catch (Throwable var14_31) {
                                            var13_29.addSuppressed(var14_31);
                                        }
                                    } else {
                                        var12_26.close();
                                    }
                                }
                            }
                        } else if (this.mech_chain == 0x100000) {
                            if (this.iv_init == null) {
                                var8_11.set_cbc();
                            } else {
                                var12_26 = new BytePointer(this.iv_init);
                                var13_30 = null;
                                try {
                                    var8_11.set_cbc(var12_26, (long)this.iv_init.length);
                                }
                                catch (Throwable var14_34) {
                                    var13_30 = var14_34;
                                    throw var14_34;
                                }
                                finally {
                                    if (var12_26 != null) {
                                        if (var13_30 != null) {
                                            try {
                                                var12_26.close();
                                            }
                                            catch (Throwable var14_33) {
                                                var13_30.addSuppressed(var14_33);
                                            }
                                        } else {
                                            var12_26.close();
                                        }
                                    }
                                }
                            }
                        } else if (this.mech_chain == 0x600000) {
                            this.setParametersGCM(var8_11, null);
                        } else if (this.mech_chain == 0x800000) {
                            this.setParametersCCM(var8_11, null);
                        } else {
                            throw new InvalidAlgorithmParameterException();
                        }
                        if (this.mech_pad == 0) {
                            var10_20.set_none();
                            var6_6.padding(var10_20);
                        } else if (this.mech_pad == 4096) {
                            var10_20.set_pkcs5();
                            var6_6.padding(var10_20);
                        } else if (this.mech_chain != 0x600000 && this.mech_chain != 0x800000) {
                            throw new InvalidAlgorithmParameterException();
                        }
                        var6_6.chaining(var8_11);
                        this.cryptoState = new UcapiCryptState((UcapiCryptInfo)var6_6);
                        if (this.mode == 0x3000000) {
                            UcapiWrapperGlobal.decrypt_init(this.hsm.isEphemeralStored(this.key) != false ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.cryptoState, this.key);
                        } else {
                            UcapiWrapperGlobal.encrypt_init(this.hsm.isEphemeralStored(this.key) != false ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.cryptoState, this.key);
                        }
                    }
                    catch (Throwable var12_28) {
                        var11_25 = var12_28;
                        throw var12_28;
                    }
                    finally {
                        if (var10_20 != null) {
                            if (var11_25 != null) {
                                try {
                                    var10_20.close();
                                }
                                catch (Throwable var12_27) {
                                    var11_25.addSuppressed(var12_27);
                                }
                            } else {
                                var10_20.close();
                            }
                        }
                    }
                }
                catch (Throwable var10_22) {
                    var9_18 = var10_22;
                    throw var10_22;
                }
                finally {
                    if (var8_11 != null) {
                        if (var9_18 != null) {
                            try {
                                var8_11.close();
                            }
                            catch (Throwable var10_21) {
                                var9_18.addSuppressed(var10_21);
                            }
                        } else {
                            var8_11.close();
                        }
                    }
                }
                if (var6_6 == null) break;
                if (var7_8 == null) ** GOTO lbl183
                try {
                    var6_6.close();
                }
                catch (Throwable var8_12) {
                    var7_8.addSuppressed(var8_12);
                }
                break;
lbl183:
                // 1 sources

                var6_6.close();
                break;
                catch (Throwable var8_13) {
                    try {
                        var7_8 = var8_13;
                        throw var8_13;
                    }
                    catch (Throwable var23_43) {
                        if (var6_6 != null) {
                            if (var7_8 != null) {
                                try {
                                    var6_6.close();
                                }
                                catch (Throwable var24_44) {
                                    var7_8.addSuppressed(var24_44);
                                }
                            } else {
                                var6_6.close();
                            }
                        }
                        throw var23_43;
                    }
                }
            }
            case 1: {
                if (var2_2 instanceof CryptoServerPrivateKey) {
                    var6_7 = (CryptoServerPrivateKey)var2_2;
                    this.key = var6_7.keyHandle;
                } else if (var2_2 instanceof CryptoServerPublicKey) {
                    var6_7 = (CryptoServerPublicKey)var2_2;
                    this.key = var6_7.keyHandle;
                } else {
                    throw new InvalidKeyException("Invalid key class: " + var2_2.toString());
                }
                var6_7 = new UcapiPadding();
                var7_9 = null;
                this.cryptRsaInfo = new UcapiCryptInfo();
                if (var5_5 == null) ** GOTO lbl221
                if (!(var5_5 instanceof OAEPParameterSpec)) ** GOTO lbl220
                var8_14 = (OAEPParameterSpec)var5_5;
                this.setParamsOAEP((UcapiPadding)var6_7, (OAEPParameterSpec)var8_14);
                this.currentParamOAEP = var8_14;
                ** GOTO lbl249
lbl220:
                // 1 sources

                throw new InvalidAlgorithmParameterException("Invalid AlgorithmParameterSpec: " + var5_5.toString());
lbl221:
                // 1 sources

                if (this.mech_pad != 20480) ** GOTO lbl224
                this.setParamsOAEP((UcapiPadding)var6_7, OAEPParameterSpec.DEFAULT);
                ** GOTO lbl249
lbl224:
                // 1 sources

                var8_14 = new UcapiChaining();
                var9_19 = null;
                try {
                    var8_14.set_ecb();
                    this.cryptRsaInfo.chaining((UcapiChaining)var8_14);
                }
                catch (Throwable var10_24) {
                    var9_19 = var10_24;
                    throw var10_24;
                }
                finally {
                    if (var8_14 != null) {
                        if (var9_19 != null) {
                            try {
                                var8_14.close();
                            }
                            catch (Throwable var10_23) {
                                var9_19.addSuppressed(var10_23);
                            }
                        } else {
                            var8_14.close();
                        }
                    }
                }
                if (this.mech_pad == 16384) {
                    var6_7.set_pkcs1();
                } else {
                    var6_7.set_none();
                }
lbl249:
                // 4 sources

                this.cryptRsaInfo.padding((UcapiPadding)var6_7);
                if (var6_7 == null) break;
                if (var7_9 == null) ** GOTO lbl259
                try {
                    var6_7.close();
                }
                catch (Throwable var8_15) {
                    var7_9.addSuppressed(var8_15);
                }
                break;
lbl259:
                // 1 sources

                var6_7.close();
                break;
                catch (Throwable var8_16) {
                    try {
                        var7_9 = var8_16;
                        throw var8_16;
                    }
                    catch (Throwable var27_47) {
                        if (var6_7 != null) {
                            if (var7_9 != null) {
                                try {
                                    var6_7.close();
                                }
                                catch (Throwable var28_48) {
                                    var7_9.addSuppressed(var28_48);
                                }
                            } else {
                                var6_7.close();
                            }
                        }
                        throw var27_47;
                    }
                }
            }
            default: {
                throw new InvalidKeyException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParametersGCM(UcapiChaining ucapiChaining, byte[] byArray) {
        int n = 0;
        int n2 = 0;
        BytePointer bytePointer = null;
        BytePointer bytePointer2 = null;
        if (this.aad != null) {
            n = this.aad.length;
            bytePointer = new BytePointer(this.aad);
        }
        if (byArray != null) {
            n2 = byArray.length;
            bytePointer2 = new BytePointer(byArray);
        }
        int n3 = this.tagLen * 8;
        try (BytePointer bytePointer3 = new BytePointer(this.iv_init);){
            ucapiChaining.set_gcm((byte)n3, bytePointer3, (long)this.iv_init.length, this.aad != null ? bytePointer : null, (long)n, bytePointer2, (long)n2);
        }
        finally {
            if (bytePointer != null) {
                bytePointer.close();
            }
            if (bytePointer2 != null) {
                bytePointer2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParametersCCM(UcapiChaining ucapiChaining, byte[] byArray) {
        int n = 0;
        Pointer pointer = null;
        int n2 = 0;
        BytePointer bytePointer = null;
        if (byArray != null) {
            n2 = byArray.length;
            bytePointer = new BytePointer(byArray);
        }
        if (this.aad != null) {
            n = this.aad.length;
            pointer = new BytePointer(this.aad);
        }
        try (BytePointer bytePointer2 = new BytePointer(this.iv_init);){
            ucapiChaining.set_ccm(this.dataLen, (byte)this.tagLen, bytePointer2, (long)this.iv_init.length, (BytePointer)(this.aad != null ? pointer : null), (long)n, bytePointer, (long)n2);
        }
        finally {
            if (pointer != null) {
                pointer.close();
            }
            if (bytePointer != null) {
                bytePointer.close();
            }
        }
    }

    private void setCurrentPadding(UcapiPadding ucapiPadding) {
        if (this.mech_pad == UcapiWrapperGlobal.PaddingMode.PKCS5.value) {
            ucapiPadding.set_pkcs5();
        } else if (this.mech_pad == UcapiWrapperGlobal.PaddingMode.ISO7816.value) {
            ucapiPadding.set_iso7816();
        } else if (this.mech_pad == UcapiWrapperGlobal.PaddingMode.KWP.value) {
            ucapiPadding.set_kwp();
        } else if (this.mech_pad == UcapiWrapperGlobal.PaddingMode.NONE.value) {
            ucapiPadding.set_none();
        } else if (this.mech_pad == UcapiWrapperGlobal.PaddingMode.PKCS1.value) {
            ucapiPadding.set_pkcs1();
        } else if (this.mech_pad == UcapiWrapperGlobal.PaddingMode.X9_31.value) {
            ucapiPadding.set_x9_31();
        } else if (this.mech_pad == UcapiWrapperGlobal.PaddingMode.ZERO.value) {
            ucapiPadding.set_zero();
        } else if (this.mech_pad == UcapiWrapperGlobal.PaddingMode.RANDOM.value) {
            ucapiPadding.set_random();
        } else if (this.mech_pad == UcapiWrapperGlobal.PaddingMode.OAEP.value) {
            try {
                if (this.currentParamOAEP != null) {
                    this.setParamsOAEP(ucapiPadding, this.currentParamOAEP);
                } else {
                    this.setParamsOAEP(ucapiPadding, OAEPParameterSpec.DEFAULT);
                }
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                invalidAlgorithmParameterException.printStackTrace();
            }
        }
    }

    private void setCurrentChaining(UcapiChaining ucapiChaining, byte[] byArray) {
        switch (this.mech_chain) {
            case 0x100000: {
                if (this.iv_init == null) break;
                ucapiChaining.set_cbc(this.iv_init, (long)this.iv_init.length);
                break;
            }
            case 0x700000: {
                if (this.iv_init == null) break;
                ucapiChaining.set_ofb(this.iv_init, (long)this.iv_init.length);
                break;
            }
            case 0x600000: {
                this.setParametersGCM(ucapiChaining, byArray);
                break;
            }
            case 0x800000: {
                this.setParametersCCM(ucapiChaining, byArray);
            }
        }
    }

    private byte[] addVerificationTagToEncrypted(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = Arrays.copyOf(byArray2, byArray2.length + this.tagLen);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, this.tagLen);
        return byArray3;
    }

    private byte[] getVerificationTagFromEncrypted(byte[] byArray) {
        byte[] byArray2 = new byte[this.tagLen];
        System.arraycopy(byArray, byArray.length - this.tagLen, byArray2, 0, this.tagLen);
        return byArray2;
    }

    private void setParamsOAEP(UcapiPadding ucapiPadding, OAEPParameterSpec oAEPParameterSpec) throws InvalidAlgorithmParameterException {
        UcapiWrapperGlobal.HashAlgo hashAlgo = this.selectHashAlgo(oAEPParameterSpec.getDigestAlgorithm());
        AlgorithmParameterSpec algorithmParameterSpec = oAEPParameterSpec.getMGFParameters();
        if (!oAEPParameterSpec.getMGFAlgorithm().equals("MGF1") || !(algorithmParameterSpec instanceof MGF1ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Invalid MGF algorithm");
        }
        MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)algorithmParameterSpec;
        UcapiWrapperGlobal.HashAlgo hashAlgo2 = this.selectHashAlgo(mGF1ParameterSpec.getDigestAlgorithm());
        PSource pSource = oAEPParameterSpec.getPSource();
        byte[] byArray = ((PSource.PSpecified)pSource).getValue();
        String string = new String(byArray);
        ucapiPadding.set_oaep(hashAlgo, hashAlgo2, string);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters != null) {
            throw new InvalidAlgorithmParameterException();
        }
        this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        Log.log(LogLevel.Trace, "enter....");
        switch (this.algo) {
            case 20: 
            case 21: {
                if (string.equalsIgnoreCase("ECB")) {
                    this.mech_chain = 0;
                    return;
                }
                if (string.equalsIgnoreCase("CBC")) {
                    this.mech_chain = 0x100000;
                    return;
                }
                if (string.equalsIgnoreCase("GCM")) {
                    this.mech_chain = 0x600000;
                    return;
                }
                if (string.equalsIgnoreCase("CCM")) {
                    this.mech_chain = 0x800000;
                    return;
                }
                if (!string.equalsIgnoreCase("OFB") && !string.equalsIgnoreCase("OFB128")) break;
                this.mech_chain = 0x700000;
                return;
            }
            case 1: {
                if (!string.equals("ECB") && !string.equalsIgnoreCase("None")) break;
                this.mech_chain = 0;
                return;
            }
        }
        throw new NoSuchAlgorithmException();
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        Log.log(LogLevel.Trace, "enter....");
        if (string.equalsIgnoreCase("NoPadding")) {
            this.mech_pad = 0;
            return;
        }
        switch (this.algo) {
            case 20: 
            case 21: {
                if (string.equalsIgnoreCase("PKCS5Padding")) {
                    this.mech_pad = 4096;
                    return;
                }
                if (!string.equalsIgnoreCase("ISO10126Padding")) break;
                this.isISO10126PAD = true;
                this.mech_pad = 0;
                return;
            }
            case 1: {
                if (string.equalsIgnoreCase("PKCS1Padding")) {
                    this.mech_pad = 16384;
                    return;
                }
                if (!string.equalsIgnoreCase("OAEPPadding")) break;
                this.mech_pad = 20480;
                return;
            }
        }
        if (this.mech_chain != 0x600000 && this.mech_chain != 0x800000) {
            throw new NoSuchPaddingException();
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        Log.log(LogLevel.Trace, "enter....");
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (this.key == null) {
            throw new CryptoServerProviderJCEException("The mechanism is not initialized. Please, invoke the initialization before.");
        }
        if (n2 == 0) {
            return null;
        }
        this.buff.put(byArray, n, n2);
        int n3 = this.buff.getSize();
        switch (this.algo) {
            case 20: 
            case 21: {
                int n4 = n3 % this.blockSize;
                int n5 = n3 - n4;
                if (n5 > 0 && this.mode == 0x3000000 && (this.mech_chain == 0x800000 || this.mech_chain == 0x600000 || (this.mech_pad != 0 || this.isISO10126PAD) && n4 == 0)) {
                    n4 += this.blockSize;
                    n5 -= this.blockSize;
                }
                if (n5 == 0) {
                    return null;
                }
                byArray2 = this.buff.get(n5);
                byArray3 = this.cryptUpdate(byArray2);
            }
        }
        this.isFirstUpdate = false;
        return byArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] cryptUpdate(byte[] byArray) {
        byte[] byArray2 = null;
        try (Pointer pointer = null;){
            pointer = this.algo == 1 ? (this.mode == 0x2000000 ? UcapiWrapperGlobal.encrypt(this.hsm.getSession(), this.hsm.isEphemeralStored(this.key) ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.cryptRsaInfo, this.key, byArray, (long)byArray.length) : UcapiWrapperGlobal.decrypt(this.hsm.getSession(), this.hsm.isEphemeralStored(this.key) ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.cryptRsaInfo, this.key, byArray, (long)byArray.length)) : (this.mode == 0x2000000 ? UcapiWrapperGlobal.encrypt_update(this.hsm.getSession(), this.hsm.isEphemeralStored(this.key) ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.cryptoState, byArray, (long)byArray.length) : UcapiWrapperGlobal.decrypt_update(this.hsm.getSession(), this.hsm.isEphemeralStored(this.key) ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.cryptoState, byArray, (long)byArray.length));
            byArray2 = ToolBox.ucapiVecU8ToByteArray((UcapiVectorU8)pointer);
        }
        return byArray2;
    }

    private byte[] cryptFinal(byte[] byArray) throws BadPaddingException, IllegalBlockSizeException {
        Object object;
        Pointer pointer;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        Pointer pointer2 = null;
        if (this.mode == 0x3000000 && (this.mech_chain == 0x600000 || this.mech_chain == 0x800000)) {
            byArray3 = this.getVerificationTagFromEncrypted(byArray);
            byArray4 = new byte[byArray.length - this.tagLen];
            System.arraycopy(byArray, 0, byArray4, 0, byArray.length - this.tagLen);
            pointer = new UcapiVectorU8(byArray3);
            object = null;
            try {
                this.cryptoState.set_verification_tag((UcapiVectorU8)pointer);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (pointer != null) {
                    if (object != null) {
                        try {
                            pointer.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        pointer.close();
                    }
                }
            }
        } else {
            byArray4 = byArray;
        }
        pointer = null;
        try {
            if (this.algo == 1) {
                pointer = this.mode == 0x2000000 ? UcapiWrapperGlobal.encrypt(this.hsm.getSession(), this.hsm.isEphemeralStored(this.key) ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.cryptRsaInfo, this.key, byArray4, (long)byArray4.length) : UcapiWrapperGlobal.decrypt(this.hsm.getSession(), this.hsm.isEphemeralStored(this.key) ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.cryptRsaInfo, this.key, byArray4, (long)byArray4.length);
            } else if (this.mode == 0x2000000) {
                pointer2 = new UcapiAEAData();
                pointer = UcapiWrapperGlobal.encrypt_final(this.hsm.getSession(), this.hsm.isEphemeralStored(this.key) ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.cryptoState, byArray4, (long)byArray4.length, (UcapiAEAData)pointer2);
            } else {
                pointer = UcapiWrapperGlobal.decrypt_final(this.hsm.getSession(), this.hsm.isEphemeralStored(this.key) ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.cryptoState, byArray4, (long)byArray4.length);
            }
            byArray2 = ToolBox.ucapiVecU8ToByteArray((UcapiVectorU8)pointer);
            if (this.mode == 0x2000000 && (this.mech_chain == 0x600000 || this.mech_chain == 0x800000)) {
                object = ToolBox.ucapiVecU8ToByteArray(((UcapiAEAData)pointer2).verification_tag());
                byArray2 = this.addVerificationTagToEncrypted((byte[])object, byArray2);
            }
        }
        catch (Exception exception) {
            Log.log(LogLevel.Error, exception.getMessage());
            String string = ToolBox.getCodeException(exception);
            if (ToolBox.CXIErrorCodes.ERROR_CXI_CRYPT_ILLEGAL_BLOCK_SIZE.equals(string)) {
                IllegalBlockSizeException illegalBlockSizeException = new IllegalBlockSizeException(exception.toString());
                illegalBlockSizeException.initCause(exception);
                throw illegalBlockSizeException;
            }
            if (ToolBox.CXIErrorCodes.ERROR_CXI_CRYPT_BAD_PADDING.equals(string)) {
                BadPaddingException badPaddingException = new BadPaddingException(exception.toString());
                badPaddingException.initCause(exception);
                throw badPaddingException;
            }
            if (ToolBox.CXIErrorCodes.ERROR_CXI_CRYPT_AEAD_BAD_TAG.equals(string)) {
                AEADBadTagException aEADBadTagException = new AEADBadTagException("GCM tag mismatch");
                aEADBadTagException.initCause(exception);
                throw aEADBadTagException;
            }
            throw exception;
        }
        finally {
            if (pointer != null) {
                pointer.close();
            }
            if (pointer2 != null) {
                pointer2.close();
            }
            this.iv_init = null;
            this.aad = null;
            if (this.cryptoState != null) {
                this.cryptoState.close();
                this.cryptoState = null;
            }
            this.key = null;
            this.buff = null;
            this.buff = new ByteFifo();
            this.rng = null;
            this.unwrapAlgParam = null;
            this.currentParamOAEP = null;
            if (this.cryptRsaInfo != null) {
                this.cryptRsaInfo.close();
                this.cryptRsaInfo = null;
            }
        }
        return byArray2;
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        Log.log(LogLevel.Trace, "enter....");
        byte[] byArray3 = this.engineUpdate(byArray, n, n2);
        if (byArray3 == null) {
            return 0;
        }
        if (byArray3.length > byArray2.length - n3) {
            throw new ShortBufferException();
        }
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    protected void engineUpdateAAD(byte[] byArray) {
        Log.log(LogLevel.Trace, "enter....");
        if (this.mech_chain == 0x600000 || this.mech_chain == 0x800000) {
            this.aad = byArray;
            if (this.cryptoState == null) {
                throw new CryptoServerProviderJCEException("The mechanism is not initialized. Please, invoke the initialization before.");
            }
            if (!this.isFirstUpdate) {
                throw new CryptoServerProviderJCEException("Update AAD after first update is not allowed");
            }
            try (UcapiCryptInfo ucapiCryptInfo = new UcapiCryptInfo();
                 UcapiChaining ucapiChaining = new UcapiChaining();){
                if (this.mech_chain == 0x600000) {
                    this.setParametersGCM(ucapiChaining, null);
                } else {
                    this.setParametersCCM(ucapiChaining, null);
                }
                ucapiCryptInfo.chaining(ucapiChaining);
                this.cryptoState.close();
                this.cryptoState = new UcapiCryptState(ucapiCryptInfo);
                if (this.mode == 0x3000000) {
                    UcapiWrapperGlobal.decrypt_init(this.hsm.isEphemeralStored(this.key) ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.cryptoState, this.key);
                }
                UcapiWrapperGlobal.encrypt_init(this.hsm.isEphemeralStored(this.key) ? this.hsm.getKeyStorage() : this.hsm.getKeyStorageExternalPermanent(), this.cryptoState, this.key);
            }
        } else {
            throw new CryptoServerProviderJCEException("Cipher mechanism does not accept AAD");
        }
    }

    @Override
    protected void engineUpdateAAD(byte[] byArray, int n, int n2) {
        Log.log(LogLevel.Trace, "enter....");
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.engineUpdateAAD(byArray2);
    }

    protected void updateAAD(ByteBuffer byteBuffer) {
        Log.log(LogLevel.Trace, "enter....");
        this.engineUpdateAAD(byteBuffer != null ? byteBuffer.array() : null);
    }

    private UcapiWrapperGlobal.HashAlgo selectHashAlgo(String string) throws InvalidAlgorithmParameterException {
        switch (string) {
            case "MD5": {
                this.hashLen = 16;
                return UcapiWrapperGlobal.HashAlgo.MD5;
            }
            case "RMD-160": {
                this.hashLen = 20;
                return UcapiWrapperGlobal.HashAlgo.RMD160;
            }
            case "SHA-1": {
                this.hashLen = 20;
                return UcapiWrapperGlobal.HashAlgo.SHA1;
            }
            case "SHA-224": {
                this.hashLen = 28;
                return UcapiWrapperGlobal.HashAlgo.SHA224;
            }
            case "SHA3-224": {
                this.hashLen = 28;
                return UcapiWrapperGlobal.HashAlgo.SHA3_224;
            }
            case "SHA-256": {
                this.hashLen = 32;
                return UcapiWrapperGlobal.HashAlgo.SHA256;
            }
            case "SHA3-256": {
                this.hashLen = 32;
                return UcapiWrapperGlobal.HashAlgo.SHA3_256;
            }
            case "SHA-384": {
                this.hashLen = 48;
                return UcapiWrapperGlobal.HashAlgo.SHA384;
            }
            case "SHA3-384": {
                this.hashLen = 48;
                return UcapiWrapperGlobal.HashAlgo.SHA3_384;
            }
            case "SHA-512": {
                this.hashLen = 64;
                return UcapiWrapperGlobal.HashAlgo.SHA512;
            }
            case "SHA3-512": {
                this.hashLen = 64;
                return UcapiWrapperGlobal.HashAlgo.SHA3_512;
            }
        }
        throw new InvalidAlgorithmParameterException("Unsupported algorithm " + string);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected byte[] engineWrap(Key var1_1) throws IllegalBlockSizeException, InvalidKeyException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    protected Key engineUnwrap(byte[] var1_1, String var2_2, int var3_3) throws InvalidKeyException, NoSuchAlgorithmException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 104[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

