/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerCXI;

import CryptoServerAPI.CryptoServerException;
import CryptoServerAPI.CryptoServerUtil;
import CryptoServerCXI.AsnBuffer;
import CryptoServerCXI.Autoversion;
import CryptoServerCXI.Item;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class CryptoServerCXI {
    public static final String CXI_DATE = "2018/02/13";
    public static final String CXI_NAME = "CXI Interface for Utimaco CryptoServer";
    public static final double CXI_VERSION = Autoversion.getVersionDouble();
    public static final int KEY_ALGO_RAW = 0;
    public static final int KEY_ALGO_DES = 1;
    public static final int KEY_ALGO_AES = 2;
    public static final int KEY_ALGO_RSA = 3;
    public static final int KEY_ALGO_ECDSA = 4;
    public static final int KEY_ALGO_DSA = 5;
    public static final int KEY_ALGO_ECDH = 6;
    public static final int KEY_ALGO_DH = 7;
    public static final int KEY_ALGO_DH_PKCS = 8;
    public static final int KEY_ALGO_X509 = 9;
    public static final int KEY_ALGO_X509_ATT = 10;
    public static final byte[] TAG_MO = new byte[]{77, 79};
    public static final byte[] TAG_PE = new byte[]{80, 69};
    public static final byte[] TAG_KC = new byte[]{75, 67};
    public static final byte[] TAG_BH = new byte[]{66, 72};
    protected static final byte[] TAG_BB = new byte[]{66, 66};
    public static final byte[] TAG_KB = new byte[]{75, 66};
    public static final byte[] TAG_PL = new byte[]{80, 76};
    public static final byte[] TAG_K = new byte[]{75, 32};
    public static final byte[] TAG_MP = new byte[]{77, 80};
    public static final byte[] TAG_PK = new byte[]{80, 75};
    public static final int E_JCXI = 47489;
    public static final int E_JCXI_PARAM = -1182728192;
    public static final int E_JCXI_BAD_NAME = -1182728191;
    public static final int E_JCXI_NAME_REQ = -1182728190;
    public static final int E_JCXI_CHARSET = -1182728189;
    public static final int E_JCXI_BAD_KTOK = -1182728188;
    public static final int E_JCXI_BAD_ANSW = -1182728187;
    public static final int E_JCXI_KEY_ATTR = -1182728186;
    public static final int E_JCXI_BAD_ALGO = -1182728185;
    public static final int E_JCXI_USER_NAME = -1182728184;
    public static final int E_JCXI_NO_DEVICE = -1182728183;
    public static final int E_JCXI_NO_KEY_COMP = -1182728182;
    public static final int E_JCXI_NO_KEY = -1182728181;
    public static final int E_JCXI_CSA_VERSION = -1182728180;
    public static final int E_JCXI_NO_EC_PARAM = -1182728179;
    public static final int E_JCXI_NO_IV_OUT = -1182728178;
    public static final int E_JCXI_FW_VER = -1182728177;
    public static final int E_JCXI_ASN1_DECODE = -1182728176;
    public static final int E_JCXI_AES_DECRYPT = -1182728175;
    public static final int E_JCXI_ITEM_NOT_FOUND = -1182728174;
    public static final int E_JCXI_ECC_PARAM = -1182728160;
    public static final int E_JCXI_CONFIG = -1182728144;
    public static final int E_JCXI_DATA_LENGTH = -1182728128;
    public static final int E_JCXI_MECHS_LENGTH = -1182728112;
    public static final int E_CXI_FIPS_USAGE_NOT_SET = -1335361264;
    private static final String CHARSET_NAME = "UTF-8";

    public static class ByteArray {
        private byte[] buf;

        public ByteArray() {
            this.buf = null;
        }

        public ByteArray(byte[] byArray) {
            this.setBytes(byArray);
        }

        public void setBytes(byte[] byArray) {
            this.buf = (byte[])byArray.clone();
        }

        public byte[] getBytes() {
            if (this.buf == null) {
                return new byte[0];
            }
            return this.buf;
        }

        public int length() {
            return this.buf == null ? 0 : this.buf.length;
        }

        public void setInt(int n) {
            if (this.buf == null || this.buf.length != 4) {
                this.buf = new byte[4];
            }
            CryptoServerUtil.store_int4(n, this.buf, 0);
        }

        public int getInt() {
            if (this.buf == null || this.buf.length != 4) {
                return 0;
            }
            return CryptoServerUtil.load_int4(this.buf, 0);
        }

        public void append(byte[] byArray) {
            if (this.buf == null) {
                this.buf = (byte[])byArray.clone();
            } else {
                int n = this.buf.length;
                this.buf = Arrays.copyOf(this.buf, n + byArray.length);
                System.arraycopy(byArray, 0, this.buf, n, byArray.length);
            }
        }

        public void append(ByteArray byteArray) {
            this.append(byteArray.getBytes());
        }

        public void appendInt2(int n) {
            byte[] byArray = new byte[2];
            CryptoServerUtil.store_int2(n, byArray, 0);
            this.append(byArray);
        }

        public void appendInt4(int n) {
            byte[] byArray = new byte[4];
            CryptoServerUtil.store_int4(n, byArray, 0);
            this.append(byArray);
        }

        public void clear() {
            this.buf = null;
        }
    }

    public static class ECParameter {
        private BigInteger p;
        private int m;
        private BigInteger rp;
        private BigInteger a;
        private BigInteger b;
        private BigInteger gx;
        private BigInteger gy;
        private BigInteger n;
        private int h;
        private final byte[] prime_field = new byte[]{42, -122, 72, -50, 61, 1, 1};
        private final byte[] char2_field = new byte[]{42, -122, 72, -50, 61, 1, 2};
        private final byte[] normal_basis = new byte[]{42, -122, 72, -50, 61, 1, 2, 3, 1};
        private final byte[] trinom_basis = new byte[]{42, -122, 72, -50, 61, 1, 2, 3, 2};
        private final byte[] pentan_basis = new byte[]{42, -122, 72, -50, 61, 1, 2, 3, 3};
        static Map<String, byte[]> ecParamPool;
        private static final String ECURVE_DIR = "/ecurves/";

        public ECParameter(ECParameterSpec eCParameterSpec) throws CryptoServerException {
            this.h = eCParameterSpec.getCofactor();
            this.n = eCParameterSpec.getOrder();
            this.gx = eCParameterSpec.getGenerator().getAffineX();
            this.gy = eCParameterSpec.getGenerator().getAffineY();
            this.a = eCParameterSpec.getCurve().getA();
            this.b = eCParameterSpec.getCurve().getB();
            ECField eCField = eCParameterSpec.getCurve().getField();
            if (eCField instanceof ECFieldFp) {
                ECFieldFp eCFieldFp = (ECFieldFp)eCField;
                this.p = eCFieldFp.getP();
                this.rp = null;
                return;
            }
            if (eCField instanceof ECFieldF2m) {
                ECFieldF2m eCFieldF2m = (ECFieldF2m)eCField;
                this.rp = eCFieldF2m.getReductionPolynomial();
                this.m = eCFieldF2m.getM();
                this.p = null;
                if (this.rp != null) {
                    return;
                }
            }
            throw new CryptoServerException(-1182728160);
        }

        public ECParameter(byte[] byArray) throws CryptoServerException {
            Object[] objectArray;
            int n;
            AsnBuffer asnBuffer = new AsnBuffer(byArray);
            asnBuffer = asnBuffer.getSEQ();
            if (asnBuffer.getINT(2).compareTo(BigInteger.ONE) != 0) {
                throw new CryptoServerException(-1182728160);
            }
            AsnBuffer asnBuffer2 = asnBuffer.getSEQ();
            byte[] byArray2 = asnBuffer2.getOID();
            if (Arrays.equals(byArray2, this.prime_field)) {
                this.p = asnBuffer2.getINT(2);
                this.rp = null;
            } else if (Arrays.equals(byArray2, this.char2_field)) {
                ECFieldF2m eCFieldF2m;
                this.p = null;
                asnBuffer2 = asnBuffer2.getSEQ();
                this.m = asnBuffer2.getINT(2).intValue();
                byArray2 = asnBuffer2.getOID();
                n = byArray2[byArray2.length - 1];
                switch (n) {
                    case 1: {
                        eCFieldF2m = new ECFieldF2m(this.m);
                        break;
                    }
                    case 2: {
                        objectArray = new int[]{asnBuffer2.getINT(2).intValue()};
                        eCFieldF2m = new ECFieldF2m(this.m, (int[])objectArray);
                        break;
                    }
                    case 3: {
                        asnBuffer2 = asnBuffer2.getSEQ();
                        objectArray = new int[3];
                        objectArray[2] = asnBuffer2.getINT(2).intValue();
                        objectArray[1] = asnBuffer2.getINT(2).intValue();
                        objectArray[0] = asnBuffer2.getINT(2).intValue();
                        eCFieldF2m = new ECFieldF2m(this.m, (int[])objectArray);
                        break;
                    }
                    default: {
                        throw new CryptoServerException(-1182728160);
                    }
                }
                this.rp = eCFieldF2m.getReductionPolynomial();
                if (this.rp == null) {
                    throw new CryptoServerException(-1182728160);
                }
            } else {
                throw new CryptoServerException(-1182728160);
            }
            asnBuffer2 = asnBuffer.getSEQ();
            this.a = asnBuffer2.getINT(4);
            this.b = asnBuffer2.getINT(4);
            byte[] byArray3 = asnBuffer.getOCT();
            if (byArray3[0] != 4) {
                throw new CryptoServerException(-1182728160);
            }
            n = byArray3.length - 1;
            if ((n & 1) != 0) {
                throw new CryptoServerException(-1182728160);
            }
            objectArray = new byte[n /= 2];
            System.arraycopy(byArray3, 1, objectArray, 0, n);
            this.gx = new BigInteger(1, (byte[])objectArray);
            System.arraycopy(byArray3, 1 + n, objectArray, 0, n);
            this.gy = new BigInteger(1, (byte[])objectArray);
            this.n = asnBuffer.getINT(2);
            this.h = asnBuffer.getINT(2).intValue();
        }

        public ECParameterSpec getSpec() {
            EllipticCurve ellipticCurve;
            ECField eCField = this.p == null ? new ECFieldF2m(this.m, this.rp) : new ECFieldFp(this.p);
            try {
                ellipticCurve = new EllipticCurve(eCField, this.a, this.b);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.a.signum() == 0 || this.b.signum() == 0) {
                    System.out.println("Sorry, this seems to be a known JAVA bug! Try to update your JAVA version.");
                }
                throw illegalArgumentException;
            }
            ECPoint eCPoint = new ECPoint(this.gx, this.gy);
            return new ECParameterSpec(ellipticCurve, eCPoint, this.n, this.h);
        }

        public byte[] getEncoded() throws CryptoServerException {
            byte[] byArray;
            Object object;
            Object object2;
            byte[] byArray2 = new byte[]{1};
            AsnBuffer asnBuffer = new AsnBuffer();
            asnBuffer.addItem(2, byArray2);
            AsnBuffer asnBuffer2 = new AsnBuffer();
            if (this.p != null) {
                asnBuffer2.addItem(6, this.prime_field);
                asnBuffer2.addINT(2, this.p);
            } else {
                asnBuffer2.addItem(6, this.char2_field);
                object2 = new ECFieldF2m(this.m, this.rp);
                AsnBuffer asnBuffer3 = new AsnBuffer();
                asnBuffer3.addINT(2, BigInteger.valueOf(this.m));
                object = ((ECFieldF2m)object2).getMidTermsOfReductionPolynomial();
                if (object == null) {
                    asnBuffer3.addItem(6, this.normal_basis);
                } else if (((int[])object).length == 1) {
                    asnBuffer3.addItem(6, this.trinom_basis);
                    asnBuffer3.addINT(2, BigInteger.valueOf(object[0]));
                } else if (((int[])object).length == 3) {
                    asnBuffer3.addItem(6, this.pentan_basis);
                    AsnBuffer asnBuffer4 = new AsnBuffer();
                    asnBuffer4.addINT(2, BigInteger.valueOf(object[2]));
                    asnBuffer4.addINT(2, BigInteger.valueOf(object[1]));
                    asnBuffer4.addINT(2, BigInteger.valueOf(object[0]));
                    asnBuffer3.addSEQ(asnBuffer4);
                } else {
                    throw new CryptoServerException(-1182728160);
                }
                asnBuffer2.addSEQ(asnBuffer3);
            }
            asnBuffer.addSEQ(asnBuffer2);
            object2 = new AsnBuffer();
            ((AsnBuffer)object2).addINT(4, this.a);
            ((AsnBuffer)object2).addINT(4, this.b);
            asnBuffer.addSEQ((AsnBuffer)object2);
            byte[] byArray3 = this.gx.toByteArray();
            while (byArray3.length > 1 && byArray3[0] == 0) {
                byArray = new byte[byArray3.length - 1];
                System.arraycopy(byArray3, 1, byArray, 0, byArray.length);
                byArray3 = byArray;
            }
            byte[] byArray4 = this.gy.toByteArray();
            while (byArray4.length > 1 && byArray4[0] == 0) {
                byArray = new byte[byArray4.length - 1];
                System.arraycopy(byArray4, 1, byArray, 0, byArray.length);
                byArray4 = byArray;
            }
            int n = byArray3.length;
            if (n < byArray4.length) {
                n = byArray4.length;
            }
            byArray = new byte[2 * n + 1];
            Arrays.fill(byArray, (byte)0);
            System.arraycopy(byArray3, 0, byArray, 1 + n - byArray3.length, byArray3.length);
            System.arraycopy(byArray4, 0, byArray, 1 + 2 * n - byArray4.length, byArray4.length);
            byArray[0] = 4;
            asnBuffer.addItem(4, byArray);
            asnBuffer.addINT(2, this.n);
            asnBuffer.addINT(2, BigInteger.valueOf(this.h));
            object = new AsnBuffer();
            ((AsnBuffer)object).addSEQ(asnBuffer);
            return ((AsnBuffer)object).getData();
        }

        public static byte[] getEncoded(Object object, String string) throws IOException {
            InputStream inputStream;
            byte[] byArray;
            if (ecParamPool == null) {
                ecParamPool = new HashMap<String, byte[]>();
            }
            if ((byArray = ecParamPool.get(string)) == null && (inputStream = object.getClass().getResourceAsStream(ECURVE_DIR + string)) != null) {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[512];
                while ((n = inputStream.read(byArray2)) > 0) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                inputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
                ecParamPool.put(string, byArray);
            }
            return byArray;
        }
    }

    public static class ECPublicKey {
        ECPoint w;
        ECParameterSpec params;

        public ECPublicKey(ECPublicKeySpec eCPublicKeySpec) {
            this.w = eCPublicKeySpec.getW();
            this.params = eCPublicKeySpec.getParams();
        }

        public ECParameterSpec getParams() {
            return this.params;
        }

        public ECPoint getW() {
            return this.w;
        }

        public byte[] getEncoded() throws CryptoServerException {
            byte[] byArray = this.w.getAffineX().toByteArray();
            byte[] byArray2 = this.w.getAffineY().toByteArray();
            int n = byArray[0] == 0 ? 1 : 0;
            int n2 = byArray2[0] == 0 ? 1 : 0;
            int n3 = byArray.length - n;
            int n4 = byArray2.length - n2;
            int n5 = this.params.getCurve().getField().getFieldSize();
            int n6 = (n5 + 7) / 8;
            if (n3 > n6 || n4 > n6) {
                throw new CryptoServerException(-1182728160);
            }
            byte[] byArray3 = new byte[1 + 2 * n6];
            Arrays.fill(byArray3, (byte)0);
            System.arraycopy(byArray, n, byArray3, 1 + n6 - n3, n3);
            System.arraycopy(byArray2, n2, byArray3, byArray3.length - n4, n4);
            byArray3[0] = 4;
            return byArray3;
        }
    }

    public static class KeyAttAndComp {
        public KeyAttributes keyAttributes;
        public KeyComponents keyComponents;

        public KeyAttAndComp() {
        }

        public KeyAttAndComp(byte[] byArray, byte[] byArray2) throws CryptoServerException {
            this.keyAttributes = new KeyAttributes(byArray);
            this.keyComponents = new KeyComponents(byArray2);
        }
    }

    public static class KeyComponents {
        public static final byte[] TYPE_P = new byte[]{80, 32};
        public static final byte[] TYPE_Q = new byte[]{81, 32};
        public static final byte[] TYPE_DP = new byte[]{68, 80};
        public static final byte[] TYPE_DQ = new byte[]{68, 81};
        public static final byte[] TYPE_U = new byte[]{85, 32};
        public static final byte[] TYPE_SEXP = new byte[]{83, 69};
        public static final byte[] TYPE_PEXP = new byte[]{80, 69};
        public static final byte[] TYPE_MOD = new byte[]{77, 79};
        public static final byte[] TYPE_SK = new byte[]{83, 75};
        public static final byte[] TYPE_PK = new byte[]{80, 75};
        private byte[] kc;

        public KeyComponents() {
        }

        public KeyComponents(byte[] byArray) {
            this.kc = byArray;
        }

        public void add(byte[] byArray, byte[] byArray2) {
            this.kc = Item.mkItemList(null, this.kc, byArray, byArray2);
        }

        public void add(byte[] byArray, BigInteger bigInteger) {
            byte[] byArray2 = bigInteger.toByteArray();
            while (byArray2.length > 1 && byArray2[0] == 0) {
                byte[] byArray3 = new byte[byArray2.length - 1];
                System.arraycopy(byArray2, 1, byArray3, 0, byArray3.length);
                byArray2 = byArray3;
            }
            this.kc = Item.mkItemList(null, this.kc, byArray, byArray2);
        }

        public byte[] getList() {
            return this.kc;
        }

        public byte[] getItem(byte[] byArray) throws CryptoServerException {
            try {
                return Item.getItem(byArray, this.kc, 0);
            }
            catch (CryptoServerException cryptoServerException) {
                throw new CryptoServerException(-1182728182);
            }
        }
    }

    public static class KeyAttributes {
        public static final int PROP_KEY_GROUP = 1;
        public static final int PROP_KEY_NAME = 2;
        public static final int PROP_KEY_ALGO = 3;
        public static final int PROP_KEY_SIZE = 4;
        public static final int PROP_KEY_EXPORT = 5;
        public static final int PROP_KEY_USAGE = 6;
        public static final int PROP_KEY_MECHS = 7;
        public static final int PROP_KEY_SPEC = 8;
        public static final int PROP_KEY_LABEL = 9;
        public static final int PROP_KEY_BLEN = 10;
        public static final int PROP_KEY_UNAME = 11;
        public static final int PROP_KEY_TYPE = 12;
        public static final int PROP_KEY_DATE_GEN = 13;
        public static final int PROP_KEY_CERT = 14;
        public static final int PROP_KEY_DATE_EXP = 15;
        public static final int PROP_KEY_RSA_MOD = 20;
        public static final int PROP_KEY_RSA_EXP = 21;
        public static final int PROP_KEY_DSA_P = 25;
        public static final int PROP_KEY_DSA_Q = 26;
        public static final int PROP_KEY_DSA_G = 27;
        public static final int PROP_KEY_DSA_PUBKEY = 28;
        public static final int PROP_KEY_EC_CURVE = 30;
        public static final int PROP_KEY_EC_PUBKEY = 31;
        public static final int PROP_CFG_ALLOW_GROUPS = 90;
        public static final int PROP_CFG_CHECK_VALIDITY_PERIOD = 91;
        public static final int PROP_CFG_AUTH_PLAIN = 92;
        public static final int PROP_CFG_WRAP_POLICY = 93;
        public static final int PROP_CFG_AUTH_KEYM = 94;
        public static final int PROP_CFG_AUTH_USER = 95;
        public static final int PROP_CFG_SECURE_DERIVATION = 96;
        public static final int PROP_CFG_SECURE_IMPORT = 97;
        public static final int PROP_CFG_SECURE_RSA_COMPONENTS = 98;
        public static final int PROP_CFG_P11R2_BACKWARDS_COMPATIBLE = 99;
        public static final int PROP_CFG_ENFORCE_BLINDING = 100;
        public static final int PROP_CFG_SECURE_GROUP_BACKUP = 101;
        public static final int PROP_CFG_GROUP_BACKUP_PASS_HASH = 102;
        public static final int PROP_FIPS_KEY_USAGE_PADDING = 109;
        public static final int PROP_KEY_MAX = 110;
        private byte[][] attr;

        public KeyAttributes() {
            this.attr = new byte[128][];
        }

        public KeyAttributes(byte[] byArray, int n) throws CryptoServerException {
            int n2;
            if (byArray.length - n < 6 || byArray[n++] != 80 || byArray[n++] != 76 || (n2 = CryptoServerUtil.load_int4(byArray, n)) > byArray.length - n - 4) {
                throw new CryptoServerException(-1182728186);
            }
            n += 4;
            this.attr = new byte[126][];
            while (n2 > 0) {
                if (n2 < 4) {
                    throw new CryptoServerException(-1182728186);
                }
                int n3 = CryptoServerUtil.load_int2(byArray, n);
                int n4 = CryptoServerUtil.load_int2(byArray, n += 2);
                n += 2;
                if (n2 < 4 + n4) {
                    throw new CryptoServerException(-1182728186, "invalid length: " + Integer.toString(n4));
                }
                if (n3 < 110) {
                    if (n4 == 0) {
                        this.attr[n3] = null;
                    } else {
                        this.attr[n3] = new byte[n4];
                        System.arraycopy(byArray, n, this.attr[n3], 0, n4);
                    }
                }
                n += n4;
                n2 -= 4 + n4;
            }
        }

        public KeyAttributes(byte[] byArray) throws CryptoServerException {
            this(byArray, 0);
        }

        public KeyAttributes clone() {
            KeyAttributes keyAttributes = new KeyAttributes();
            for (int i = 0; i < 110; ++i) {
                if (this.attr[i] == null) continue;
                keyAttributes.attr[i] = (byte[])this.attr[i].clone();
            }
            return keyAttributes;
        }

        public byte[] toByteArray() throws CryptoServerException {
            int n;
            int n2 = 0;
            int n3 = 0;
            for (n = 1; n < 110; ++n) {
                if (this.attr[n] == null) continue;
                n2 += 4 + this.attr[n].length;
            }
            byte[] byArray = new byte[n2];
            for (n = 1; n < 110; ++n) {
                if (this.attr[n] == null) continue;
                byArray[n3] = 0;
                byArray[n3 + 1] = (byte)n;
                CryptoServerUtil.store_int2(this.attr[n].length, byArray, n3 + 2);
                System.arraycopy(this.attr[n], 0, byArray, n3 += 4, this.attr[n].length);
                n3 += this.attr[n].length;
            }
            return byArray;
        }

        public int length() {
            return this.attr.length;
        }

        public byte[] get(int n) {
            return this.attr[n];
        }

        public void setInt(int n, int n2) {
            this.attr[n] = new byte[4];
            CryptoServerUtil.store_int4(n2, this.attr[n], 0);
        }

        public int getInt(int n, int n2) {
            if (this.attr[n] == null || this.attr[n].length != 4) {
                return n2;
            }
            return CryptoServerUtil.load_int4(this.attr[n], 0);
        }

        public void setBool(int n, boolean bl) {
            this.attr[n] = new byte[1];
            this.attr[n][0] = !bl ? (byte)0 : 1;
        }

        public boolean getBool(int n, boolean bl) {
            if (this.attr[n] == null || this.attr[n].length != 1) {
                return bl;
            }
            return this.attr[n][0] != 0;
        }

        public void setString(int n, String string) throws CryptoServerException {
            try {
                this.attr[n] = (byte[])(string == null ? null : (string.startsWith("{U}") ? string.substring(3).concat("\u0000").getBytes("UTF-16LE") : (string.startsWith("{Z}") ? string.substring(3).concat("\u0000").getBytes(CryptoServerCXI.CHARSET_NAME) : string.getBytes(CryptoServerCXI.CHARSET_NAME))));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CryptoServerException(-1182728189);
            }
        }

        public String getString(int n, String string) throws CryptoServerException {
            try {
                if (this.attr[n] == null) {
                    return string;
                }
                if (this.attr[n].length == 0) {
                    return "";
                }
                byte[] byArray = this.attr[n];
                if (byArray.length <= 2 || byArray[byArray.length - 1] != 0) {
                    return new String(byArray, CryptoServerCXI.CHARSET_NAME);
                }
                if (byArray[byArray.length - 2] != 0) {
                    String string2 = "{Z}" + new String(byArray, CryptoServerCXI.CHARSET_NAME);
                    return string2.substring(0, string2.length() - 1);
                }
                String string3 = "{U}" + new String(byArray, "UTF-16LE");
                return string3.substring(0, string3.length() - 1);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CryptoServerException(-1182728189);
            }
        }

        private void setBI(int n, BigInteger bigInteger) {
            int n2;
            if (bigInteger.signum() == 0) {
                this.attr[n] = null;
                return;
            }
            byte[] byArray = bigInteger.toByteArray();
            for (n2 = 0; n2 < byArray.length && byArray[n2] == 0; ++n2) {
            }
            if (n2 > 0) {
                this.attr[n] = new byte[byArray.length - n2];
                System.arraycopy(byArray, n2, this.attr[n], 0, byArray.length - n2);
            } else {
                this.attr[n] = byArray;
            }
        }

        public void setAlgo(int n) {
            this.setInt(3, n);
        }

        public int getAlgo() {
            return this.getInt(3, 0);
        }

        public void setType(int n) {
            this.setInt(12, n);
        }

        public int getType() {
            return this.getInt(12, 0);
        }

        public void setSize(int n) {
            this.setInt(4, n);
        }

        public int getSize() {
            return this.getInt(4, 0);
        }

        public void setExport(int n) {
            this.setInt(5, n);
        }

        public int getExport() {
            return this.getInt(5, 0);
        }

        public void setUsage(int n) {
            this.setInt(6, n);
        }

        public int getUsage() {
            return this.getInt(6, 0);
        }

        public void setLabel(String string) throws CryptoServerException {
            this.setString(9, string);
        }

        public String getLabel() throws CryptoServerException {
            return this.getString(9, null);
        }

        public void setExponent(byte[] byArray) {
            this.attr[21] = byArray;
        }

        public void setExponent(BigInteger bigInteger) {
            this.setBI(21, bigInteger);
        }

        public byte[] getExponent() {
            return this.attr[21];
        }

        public void setModulus(byte[] byArray) {
            this.attr[20] = byArray;
        }

        public void setModulus(BigInteger bigInteger) {
            this.setBI(20, bigInteger);
        }

        public byte[] getModulus() {
            return this.attr[20];
        }

        public void setParamP(byte[] byArray) {
            this.attr[25] = byArray;
        }

        public void setParamP(BigInteger bigInteger) {
            this.setBI(25, bigInteger);
        }

        public byte[] getParamP() {
            return this.attr[25];
        }

        public void setParamQ(byte[] byArray) {
            this.attr[26] = byArray;
        }

        public void setParamQ(BigInteger bigInteger) {
            this.setBI(26, bigInteger);
        }

        public byte[] getParamQ() {
            return this.attr[26];
        }

        public void setParamG(byte[] byArray) {
            this.attr[27] = byArray;
        }

        public void setParamG(BigInteger bigInteger) {
            this.setBI(27, bigInteger);
        }

        public byte[] getParamG() {
            return this.attr[27];
        }

        public void setDSAPub(byte[] byArray) {
            this.attr[28] = byArray;
        }

        public void setDSAPub(BigInteger bigInteger) {
            this.setBI(28, bigInteger);
        }

        public byte[] getDSAPub() {
            return this.attr[28];
        }

        public void setCurve(String string) throws CryptoServerException {
            this.setString(30, string);
        }

        public void setCurve(byte[] byArray) {
            this.attr[30] = byArray;
        }

        public void setCurve(ECParameterSpec eCParameterSpec) throws CryptoServerException {
            ECParameter eCParameter = new ECParameter(eCParameterSpec);
            this.attr[30] = eCParameter.getEncoded();
        }

        public byte[] getCurve() {
            return this.attr[30];
        }

        public byte[] getCurveEncoded() throws IOException, CryptoServerException {
            byte[] byArray = this.attr[30];
            if (byArray[0] == 48) {
                return byArray;
            }
            try {
                byArray = ECParameter.getEncoded(this, new String(byArray, CryptoServerCXI.CHARSET_NAME));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CryptoServerException(-1182728189);
            }
            if (byArray == null) {
                throw new CryptoServerException(-1182728179);
            }
            return byArray;
        }

        public void setECPub(byte[] byArray) {
            this.attr[31] = byArray;
        }

        public void setECPub(BigInteger bigInteger) {
            this.setBI(31, bigInteger);
        }

        public byte[] getECPub() {
            return this.attr[31];
        }

        public void setName(String string) throws CryptoServerException {
            if (string != null && string.length() == 0) {
                throw new CryptoServerException(-1182728191);
            }
            this.setString(2, string);
        }

        public String getName() throws CryptoServerException {
            return this.getString(2, null);
        }

        public void setGroup(String string) throws CryptoServerException {
            this.setString(1, string);
        }

        public String getGroup() throws CryptoServerException {
            return this.getString(1, null);
        }

        public void setSpecifier(int n) {
            if (n < 0) {
                return;
            }
            this.setInt(8, n);
        }

        public int getSpecifier() {
            if (this.attr[8] == null) {
                return -1;
            }
            return CryptoServerUtil.load_int4(this.attr[8], 0);
        }

        private void setDate(Date date, int n) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            gregorianCalendar.setTime(date);
            byte[] byArray = new byte[13];
            byArray[1] = (byte)(gregorianCalendar.get(1) % 100);
            byArray[3] = (byte)(gregorianCalendar.get(2) + 1);
            byArray[5] = (byte)gregorianCalendar.get(5);
            byArray[7] = (byte)gregorianCalendar.get(11);
            byArray[9] = (byte)gregorianCalendar.get(12);
            byArray[11] = (byte)gregorianCalendar.get(13);
            byArray[12] = 90;
            for (int i = 0; i < 12; i += 2) {
                byArray[i] = (byte)(byArray[i + 1] / 10 + 48);
                byArray[i + 1] = (byte)(byArray[i + 1] % 10 + 48);
            }
            this.attr[n] = byArray;
        }

        public void setGenerationDate(Date date) {
            this.setDate(date, 13);
        }

        public void setGenerationDate(byte[] byArray) {
            this.attr[13] = byArray;
        }

        public void setExpirationDate(Date date) {
            this.setDate(date, 15);
        }

        public void setExpirationDate(byte[] byArray) {
            this.attr[15] = byArray;
        }

        private Date getDate(int n) {
            byte[] byArray = this.attr[n];
            int[] nArray = new int[7];
            if (byArray == null || byArray.length != 13 && byArray.length != 15 || byArray[byArray.length - 1] != 90) {
                return null;
            }
            nArray[0] = 20;
            int n2 = 6;
            for (int i = byArray.length - 3; i >= 0; i -= 2) {
                if (byArray[i] < 48 || byArray[i] > 57 || byArray[i + 1] < 48 || byArray[i + 1] > 57) {
                    return null;
                }
                nArray[n2--] = byArray[i] % 16 * 10 + byArray[i + 1] % 16;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            gregorianCalendar.set(nArray[0] * 100 + nArray[1], nArray[2] - 1, nArray[3], nArray[4], nArray[5], nArray[6]);
            return gregorianCalendar.getTime();
        }

        public Date getGenerationDate() {
            return this.getDate(13);
        }

        public Date getExpirationDate() {
            return this.getDate(15);
        }

        public void setCertificate(byte[] byArray) {
            this.attr[14] = byArray;
        }

        public byte[] getCertificate() {
            return this.attr[14];
        }

        public void setMechs(int[] nArray) throws CryptoServerException, UnsupportedEncodingException {
            if (nArray == null) {
                return;
            }
            if (nArray.length > 255) {
                throw new CryptoServerException(-1182728112);
            }
            int n = 2 + nArray.length * 4;
            byte[] byArray = new byte[n];
            byArray[0] = 67;
            byArray[1] = (byte)nArray.length;
            for (int i = 0; i < nArray.length; ++i) {
                CryptoServerUtil.store_int4(nArray[i], byArray, 2 + i * 4);
            }
            this.attr[7] = byArray;
        }

        public byte[] getMechs() {
            return this.attr[7];
        }

        public void setFIPSUsage(int n) {
            this.setInt(109, n);
        }

        public int getFIPSUsage() {
            return this.getInt(109, 0);
        }
    }

    public static class Key {
        byte[] value;
        boolean handle;

        public Key(byte[] byArray) throws CryptoServerException {
            if (byArray.length < 8 || byArray[0] != 75 || byArray[1] != 32) {
                throw new CryptoServerException(-1182728188);
            }
            if (byArray[6] == 75 && byArray[7] == 72) {
                this.handle = true;
            } else if ((byArray[6] == 66 || byArray[6] == 75) && byArray[7] == 66) {
                this.handle = false;
            } else {
                throw new CryptoServerException(-1182728188);
            }
            this.value = byArray;
        }

        public boolean isHandle() {
            return this.handle;
        }

        public byte[] getEncoded() {
            return this.value;
        }

        public KeyAttributes getAttributes() throws CryptoServerException {
            byte[] byArray;
            if (this.handle) {
                throw new CryptoServerException(-1182728188);
            }
            byte[] byArray2 = Item.getItem(TAG_K, this.value, 0);
            try {
                byArray = Item.getItem(TAG_BB, byArray2, 0);
            }
            catch (CryptoServerException cryptoServerException) {
                if (cryptoServerException.ErrorCode == -1182728174) {
                    byArray = Item.getItem(TAG_KB, byArray2, 0);
                }
                throw cryptoServerException;
            }
            int n = Item.findItem(TAG_PL, byArray, 0);
            int n2 = CryptoServerUtil.load_int4(byArray, n + 2);
            byte[] byArray3 = new byte[6 + n2];
            System.arraycopy(byArray, n, byArray3, 0, 6 + n2);
            return new KeyAttributes(byArray3);
        }
    }
}

