/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerAPI.CryptoServerException;
import CryptoServerAPI.CryptoServerUtil;
import CryptoServerCXI.CryptoServerCXI;
import CryptoServerJCE.CryptoServerPrivateKey;
import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.CryptoServerPublicKey;
import CryptoServerJCE.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public class CryptoServerSignature
extends SignatureSpi {
    private final CryptoServerProvider provider;
    private final String keyAlgo;
    private int hashAlgo;
    private CryptoServerPrivateKey skey;
    private CryptoServerPublicKey pkey;
    private int mode;
    private ByteArrayOutputStream buffer;
    private MessageDigest md;
    private int mech_pad;
    private int mech_format;
    private int mech_hash;
    private byte[] mech_param;
    private final int MODE_SIGN = 1;
    private final int MODE_VERIFY = 2;

    CryptoServerSignature(Provider provider, String string, int n, int n2) throws NoSuchAlgorithmException {
        Log.log("T: enter...");
        this.provider = (CryptoServerProvider)provider;
        this.hashAlgo = n2;
        this.mech_pad = 0;
        this.mech_format = 0;
        this.mech_hash = 0;
        this.mech_param = null;
        switch (n) {
            case 1: {
                this.keyAlgo = "RSA";
                this.mech_pad = 16384;
                this.mech_format = 0;
                break;
            }
            case 2: {
                this.keyAlgo = "DSA";
                this.mech_pad = 0;
                this.mech_format = 1024;
                break;
            }
            case 4: {
                this.keyAlgo = "EC";
                this.mech_pad = 0;
                this.mech_format = 1024;
                break;
            }
            default: {
                throw new NoSuchAlgorithmException();
            }
        }
        if (string.indexOf("RSASSA-PSS") == -1) {
            if (n2 == 0) {
                this.buffer = new ByteArrayOutputStream();
                this.mech_hash = 0;
                this.mech_pad = 0;
                return;
            }
            String string2 = CryptoServerSignature.getHashName(n2);
            this.mech_hash = CryptoServerSignature.selectHashAlgoCXI(string2);
            this.setHashMechanism(string2);
        } else {
            this.initDefaultValuesPSS();
        }
    }

    private void initDefaultValuesPSS() throws NoSuchAlgorithmException {
        switch (this.hashAlgo) {
            case 0: 
            case 10: {
                try {
                    this.engineSetParameter(PSSParameterSpec.DEFAULT);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    Log.log("E: " + invalidAlgorithmParameterException.getMessage());
                }
                break;
            }
            case 11: {
                try {
                    this.engineSetParameter(new PSSParameterSpec("SHA-224", "MGF1", MGF1ParameterSpec.SHA224, 28, 1));
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    Log.log("E: " + invalidAlgorithmParameterException.getMessage());
                }
                break;
            }
            case 12: {
                try {
                    this.engineSetParameter(new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1));
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    Log.log("E: " + invalidAlgorithmParameterException.getMessage());
                }
                break;
            }
            case 13: {
                try {
                    this.engineSetParameter(new PSSParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, 48, 1));
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    Log.log("E: " + invalidAlgorithmParameterException.getMessage());
                }
                break;
            }
            case 14: {
                try {
                    this.engineSetParameter(new PSSParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, 64, 1));
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    Log.log("E: " + invalidAlgorithmParameterException.getMessage());
                }
                break;
            }
            default: {
                throw new NoSuchAlgorithmException();
            }
        }
    }

    private void setHashMechanism(String string) throws NoSuchAlgorithmException {
        try {
            switch (this.hashAlgo) {
                case 11: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    this.md = MessageDigest.getInstance(string, this.provider);
                    break;
                }
                default: {
                    this.md = MessageDigest.getInstance(string, CryptoServerProvider.PROVIDER_HASH);
                    break;
                }
            }
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            throw new NoSuchAlgorithmException("Algorithm " + string + " of Provider " + CryptoServerProvider.PROVIDER_HASH + " not found");
        }
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        Log.log("T: enter...");
        if (!(privateKey instanceof CryptoServerPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.skey = (CryptoServerPrivateKey)privateKey;
        if (this.skey.provider != this.provider || !this.keyAlgo.equals(this.skey.getAlgorithm())) {
            throw new InvalidKeyException();
        }
        this.mode = 1;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        Log.log("T: enter...");
        if (!(publicKey instanceof CryptoServerPublicKey)) {
            throw new InvalidKeyException();
        }
        this.pkey = (CryptoServerPublicKey)publicKey;
        if (this.pkey.provider != this.provider || !this.keyAlgo.equals(this.pkey.getAlgorithm())) {
            throw new InvalidKeyException();
        }
        this.mode = 2;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        Log.log("T: enter...");
        if (this.hashAlgo == 0) {
            this.buffer.write(byArray, n, n2);
        } else {
            this.md.update(byArray, n, n2);
        }
    }

    @Override
    protected void engineUpdate(byte by) {
        Log.log("T: enter...");
        if (this.hashAlgo == 0) {
            this.buffer.write(by);
        } else {
            this.md.update(by);
        }
    }

    protected byte[] signSetFipsProp(int n, byte[] byArray, CryptoServerCXI.ByteArray byteArray) throws IOException, CryptoServerException {
        try {
            return this.provider.cs.sign(n, this.skey.key, this.mech_pad | this.mech_format | this.mech_hash, this.mech_param, byArray, byteArray);
        }
        catch (CryptoServerException cryptoServerException) {
            if (cryptoServerException.ErrorCode == -1335361264) {
                this.skey = (CryptoServerPrivateKey)this.provider.setFipsUsage(this.skey, CryptoServerProvider.FipsUsage.USAGE_SIGN_VERIFY, this.mech_pad);
                return this.provider.cs.sign(n, this.skey.key, this.mech_pad | this.mech_format | this.mech_hash, this.mech_param, byArray, byteArray);
            }
            throw cryptoServerException;
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray;
        Log.log("T: enter...");
        if (this.mode != 1) {
            throw new SignatureException();
        }
        if (this.hashAlgo == 0) {
            byArray = this.buffer.toByteArray();
            this.buffer.reset();
        } else {
            byArray = this.md.digest();
            this.md.reset();
        }
        try {
            return this.signSetFipsProp(0, byArray, null);
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            SignatureException signatureException = new SignatureException(exception.toString());
            signatureException.initCause(exception);
            throw signatureException;
        }
    }

    @Override
    protected int engineSign(byte[] byArray, int n, int n2) throws SignatureException {
        Log.log("T: enter...");
        byte[] byArray2 = this.engineSign();
        if (byArray2.length > n2) {
            throw new SignatureException("Buffer too small");
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    protected boolean verifySetFipsProp(int n, byte[] byArray, byte[] byArray2, CryptoServerCXI.ByteArray byteArray) throws IOException, CryptoServerException {
        try {
            return this.provider.cs.verify(n, this.pkey.key, this.mech_pad | this.mech_format | this.mech_hash, this.mech_param, byArray, byArray2, byteArray);
        }
        catch (CryptoServerException cryptoServerException) {
            if (cryptoServerException.ErrorCode == -1335361264) {
                this.pkey = (CryptoServerPublicKey)this.provider.setFipsUsage(this.pkey, CryptoServerProvider.FipsUsage.USAGE_SIGN_VERIFY, this.mech_pad);
                return this.provider.cs.verify(n, this.pkey.key, this.mech_pad | this.mech_format | this.mech_hash, this.mech_param, byArray, byArray2, byteArray);
            }
            throw cryptoServerException;
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2;
        Log.log("T: enter...");
        if (this.mode != 2) {
            throw new SignatureException();
        }
        if (this.hashAlgo == 0) {
            byArray2 = this.buffer.toByteArray();
            this.buffer.reset();
        } else {
            byArray2 = this.md.digest();
            this.md.reset();
        }
        try {
            return this.verifySetFipsProp(0, byArray2, byArray, null);
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            SignatureException signatureException = new SignatureException(exception.toString());
            signatureException.initCause(exception);
            throw signatureException;
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
        Log.log("T: enter...");
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return this.engineVerify(byArray2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        Log.log("T: enter...");
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof PSSParameterSpec)) throw new InvalidAlgorithmParameterException("invalid AlgorithmParameterSpec");
            PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
            String string = pSSParameterSpec.getDigestAlgorithm();
            int n = 0;
            try {
                this.mech_hash = CryptoServerSignature.selectHashAlgoCXI(string);
                this.hashAlgo = CryptoServerSignature.selectHashAlgo(string);
                this.setHashMechanism(string);
            }
            catch (Exception exception) {
                Log.log("E: " + exception.getMessage());
                throw new InvalidAlgorithmParameterException("unsupported digest algorithm: " + string);
            }
            AlgorithmParameterSpec algorithmParameterSpec2 = pSSParameterSpec.getMGFParameters();
            if (!pSSParameterSpec.getMGFAlgorithm().equals("MGF1") || !(algorithmParameterSpec2 instanceof MGF1ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("invalid MGF algorithm");
            }
            if (pSSParameterSpec.getTrailerField() != 1) {
                throw new InvalidAlgorithmParameterException("invalid trailer field value [has to be == 1]");
            }
            MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)algorithmParameterSpec2;
            String string2 = mGF1ParameterSpec.getDigestAlgorithm();
            try {
                n = CryptoServerSignature.selectHashAlgoCXI(string2);
            }
            catch (Exception exception) {
                Log.log("E: " + exception.getMessage());
                throw new InvalidAlgorithmParameterException("unsupported mgf1 digest algorithm: " + string2);
            }
            this.mech_pad = 24576;
            this.mech_param = new byte[12];
            CryptoServerUtil.store_int4(this.mech_hash, this.mech_param, 0);
            CryptoServerUtil.store_int4(n, this.mech_param, 4);
            CryptoServerUtil.store_int4(pSSParameterSpec.getSaltLength(), this.mech_param, 8);
            return;
        }
        this.mech_param = null;
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) {
        Log.log("T: enter...");
        return null;
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) {
        Log.log("T: enter...");
    }

    private static String getHashName(int n) throws NoSuchAlgorithmException {
        switch (n) {
            case 10: {
                return "SHA-1";
            }
            case 11: {
                return "SHA-224";
            }
            case 12: {
                return "SHA-256";
            }
            case 13: {
                return "SHA-384";
            }
            case 14: {
                return "SHA-512";
            }
            case 16: {
                return "SHA3-224";
            }
            case 17: {
                return "SHA3-256";
            }
            case 18: {
                return "SHA3-384";
            }
            case 19: {
                return "SHA3-512";
            }
            case 15: {
                return "MD5";
            }
        }
        throw new NoSuchAlgorithmException();
    }

    private static int selectHashAlgoCXI(String string) throws NoSuchAlgorithmException {
        switch (string) {
            case "MD5": {
                return 80;
            }
            case "RMD-160": {
                return 32;
            }
            case "SHA-1": {
                return 16;
            }
            case "SHA-224": {
                return 48;
            }
            case "SHA3-224": {
                return 128;
            }
            case "SHA-256": {
                return 64;
            }
            case "SHA3-256": {
                return 144;
            }
            case "SHA-384": {
                return 96;
            }
            case "SHA3-384": {
                return 160;
            }
            case "SHA-512": {
                return 112;
            }
            case "SHA3-512": {
                return 176;
            }
        }
        throw new NoSuchAlgorithmException();
    }

    private static int selectHashAlgo(String string) throws NoSuchAlgorithmException {
        switch (string) {
            case "MD5": {
                return 15;
            }
            case "SHA-1": {
                return 10;
            }
            case "SHA-224": {
                return 11;
            }
            case "SHA3-224": {
                return 16;
            }
            case "SHA-256": {
                return 12;
            }
            case "SHA3-256": {
                return 17;
            }
            case "SHA-384": {
                return 13;
            }
            case "SHA3-384": {
                return 18;
            }
            case "SHA-512": {
                return 14;
            }
            case "SHA3-512": {
                return 19;
            }
        }
        throw new NoSuchAlgorithmException();
    }
}

