/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerAPI.CryptoServerCluster;
import CryptoServerAPI.CryptoServerConfig;
import CryptoServerAPI.CryptoServerException;
import CryptoServerAPI.CryptoServerLog;
import CryptoServerCXI.CryptoServerCXI;
import CryptoServerJCE.CryptoServerCipher;
import CryptoServerJCE.CryptoServerECAlgorithmParametersSpi;
import CryptoServerJCE.CryptoServerKey;
import CryptoServerJCE.CryptoServerKeyAgreement;
import CryptoServerJCE.CryptoServerKeyFactory;
import CryptoServerJCE.CryptoServerKeyGenerator;
import CryptoServerJCE.CryptoServerKeyPairGenerator;
import CryptoServerJCE.CryptoServerKeyStore;
import CryptoServerJCE.CryptoServerMac;
import CryptoServerJCE.CryptoServerMessageDigest;
import CryptoServerJCE.CryptoServerSecretKeyFactory;
import CryptoServerJCE.CryptoServerSecureRandom;
import CryptoServerJCE.CryptoServerSignature;
import CryptoServerJCE.DumyCertificate;
import CryptoServerJCE.Log;
import CryptoServerJCE.Version;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;

public final class CryptoServerProvider
extends Provider {
    private static final long serialVersionUID = 1L;
    private static final String PROVIDERNAME = "CryptoServer";
    private static final String PROVIDERDATE = "2021/18/10";
    private static final String PROVIDERINFO = "JCA/JCE provider for Utimaco CryptoServer (2021/18/10)";
    private static final double PROVIDERVERSION = Version.getVersionDouble();
    protected CryptoServerCXI cs;
    private EventHandler eventHandler;
    protected String defaultUser = "JCE";
    protected String keyGroup = "";
    protected int keySpecifier = -1;
    protected boolean keysExternal = false;
    protected String keyStorePath = "";
    protected int export = 0;
    protected int usage = -1;
    protected static final int ALGO_NONE = 0;
    protected static final int ALGO_RSA = 1;
    protected static final int ALGO_DSA = 2;
    protected static final int ALGO_EC = 3;
    protected static final int ALGO_ECDSA = 4;
    protected static final int ALGO_SHA1 = 10;
    protected static final int ALGO_SHA224 = 11;
    protected static final int ALGO_SHA256 = 12;
    protected static final int ALGO_SHA384 = 13;
    protected static final int ALGO_SHA512 = 14;
    protected static final int ALGO_MD5 = 15;
    protected static final int ALGO_SHA3_224 = 16;
    protected static final int ALGO_SHA3_256 = 17;
    protected static final int ALGO_SHA3_384 = 18;
    protected static final int ALGO_SHA3_512 = 19;
    protected static final int ALGO_DES = 20;
    protected static final int ALGO_AES = 21;
    protected static final int ALGO_BSI_TR03111 = 34;
    protected static final int ALGO_ECDH = 35;
    protected static final int ALGO_ECDHC = 36;
    protected static final int ALGO_DH = 37;
    protected static final String DEFAULT_EC_CURVE = "NIST-P256";
    protected static String PROVIDER_HASH = "SUN";
    protected static String PROVIDER_RNG = "SUN";
    public static final int E_JCE = 47492;
    public static final int E_JCE_MISSING_KEYSTOREPATH = -1182531582;

    private void initProvider() throws CryptoServerException {
        try {
            if (Security.getProvider("SunJCE") != null) {
                PROVIDER_RNG = "SUN";
                PROVIDER_HASH = "SUN";
                return;
            }
            if (Security.getProvider("IBMJCE") != null) {
                PROVIDER_RNG = "IBMJCE";
                PROVIDER_HASH = "IBMJCE";
                return;
            }
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            exception.printStackTrace();
        }
        throw new CryptoServerException(-1182793718, "No appropriate JCE provider (SunJCE/IBMJCE) found");
    }

    private void logProviderInfo() throws CryptoServerException {
        Log.log("I: PROVIDERNAME: CryptoServer");
        Log.log("I: PROVIDERINFO: JCA/JCE provider for Utimaco CryptoServer (2021/18/10)");
        Log.log("I: PROVIDERDATE: 2021/18/10");
        Log.log("I: PROVIDERVERSION: " + PROVIDERVERSION);
    }

    public CryptoServerProvider() throws IOException, NumberFormatException, CryptoServerException {
        super(PROVIDERNAME, PROVIDERVERSION, PROVIDERINFO);
        this.initProvider();
        String string = System.getenv("CRYPTOSERVER_JCE_CONFIG");
        if (string == null) {
            string = System.getProperty("user.home") + "/CryptoServer.cfg";
        }
        this.processConfig(new FileInputStream(string));
        this.logProviderInfo();
        this.registerServices();
    }

    public CryptoServerProvider(String string, int n) throws IOException, NumberFormatException, CryptoServerException {
        super(PROVIDERNAME, PROVIDERVERSION, PROVIDERINFO);
        this.initProvider();
        this.cs = new CryptoServerCXI(string, n);
        this.cs.setEndSessionOnShutdown(true);
        this.registerServices();
    }

    public CryptoServerProvider(String[] stringArray, int n) throws IOException, NumberFormatException, CryptoServerException {
        super(PROVIDERNAME, PROVIDERVERSION, PROVIDERINFO);
        this.initProvider();
        this.cs = new CryptoServerCXI(stringArray, n);
        this.cs.setEndSessionOnShutdown(true);
        this.eventHandler = new EventHandler(CryptoServerCXI.CxiLog);
        this.cs.setEventHandler(this.eventHandler);
        this.registerServices();
    }

    public CryptoServerProvider(InputStream inputStream) throws IOException, NumberFormatException, CryptoServerException {
        super(PROVIDERNAME, PROVIDERVERSION, PROVIDERINFO);
        this.initProvider();
        this.processConfig(inputStream);
        this.logProviderInfo();
        this.registerServices();
    }

    public CryptoServerProvider(String string) throws IOException, NumberFormatException, CryptoServerException {
        super(PROVIDERNAME, PROVIDERVERSION, PROVIDERINFO);
        this.initProvider();
        this.processConfig(new FileInputStream(string));
        this.logProviderInfo();
        this.registerServices();
    }

    private void processConfig(InputStream inputStream) throws IOException, NumberFormatException, CryptoServerException {
        CryptoServerConfig cryptoServerConfig = new CryptoServerConfig(inputStream);
        Log.init(cryptoServerConfig);
        this.cs = new CryptoServerCXI(cryptoServerConfig);
        this.cs.setEventHandler(new EventHandler(CryptoServerCXI.CxiLog));
        this.defaultUser = cryptoServerConfig.getString("DefaultUser", "JCE");
        this.keyGroup = cryptoServerConfig.getString("KeyGroup", "");
        this.keySpecifier = cryptoServerConfig.getInt("KeySpecifier", -1);
        this.keysExternal = cryptoServerConfig.getBoolean("StoreKeysExternal", false);
        this.keyStorePath = cryptoServerConfig.getString("KeyStorePath", "");
        if (this.keysExternal && "".equals(this.keyStorePath)) {
            throw new CryptoServerException(-1182531582, "Property 'KeyStorePath' is not set in configfile.");
        }
    }

    @Override
    public Object setProperty(String string, String string2) {
        try {
            if (string.equals("Timeout")) {
                this.cs.setTimeout(Integer.parseInt(string2));
            } else if (string.equals("EndSessionOnShutdown")) {
                this.cs.setEndSessionOnShutdown(Integer.parseInt(string2) != 0);
            } else if (string.equals("KeepSessionAlive")) {
                boolean bl = Integer.parseInt(string2) != 0;
                this.cs.setKeepSessionAlive(bl);
            } else if (string.equals("DefaultUser")) {
                this.setDefaultUserName(string2);
            } else if (string.equals("KeyGroup")) {
                if (string2 == null) {
                    string2 = "";
                }
                this.keyGroup = string2;
            } else if (string.equals("KeySpecifier")) {
                if (string2 == null) {
                    string2 = "-1";
                }
                this.keySpecifier = Integer.parseInt(string2);
            } else if (string.equals("Export")) {
                this.export = string2.equals("2") ? 1 : Integer.parseInt(string2);
            } else if (string.equals("Usage")) {
                this.usage = Integer.parseInt(string2);
            }
        }
        catch (IOException iOException) {
            Log.log("E: " + iOException.getMessage());
            iOException.printStackTrace();
        }
        catch (CryptoServerException cryptoServerException) {
            Log.log("E: " + cryptoServerException.getMessage());
            cryptoServerException.printStackTrace();
        }
        return super.setProperty(string, string2);
    }

    public CryptoServerCXI getCryptoServer() {
        return this.cs;
    }

    public void loginPassword(String string, byte[] byArray) throws IOException, CryptoServerException {
        this.cs.logonPassword(string, byArray);
    }

    public void loginPassword(String string, String string2) throws IOException, CryptoServerException {
        this.cs.logonPassword(string, string2);
    }

    public void changePassword(String string, String string2) throws IOException, CryptoServerException, UnsupportedEncodingException {
        byte[] byArray;
        byte[] byArray2 = this.defaultUser.getBytes("ISO-8859-15");
        if (byArray2.length <= 8) {
            byArray = new byte[8];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        } else {
            byte[] byArray3 = new byte[1 + byArray2.length];
            byArray3[0] = 0;
            System.arraycopy(byArray2, 0, byArray3, 1, byArray2.length);
            byArray = this.cs.exec(131, 15, byArray3);
        }
        byte[] byArray4 = string2.getBytes("ISO-8859-15");
        byte[] byArray5 = new byte[byArray.length + byArray4.length];
        System.arraycopy(byArray, 0, byArray5, 0, byArray.length);
        System.arraycopy(byArray4, 0, byArray5, byArray.length, byArray4.length);
        this.cs.exec(131, 6, byArray5);
    }

    public void loginSign(String string, String string2, String string3) throws IOException, CryptoServerException {
        this.cs.logonSign(string, string2, string3);
    }

    public void logoff() throws IOException, CryptoServerException {
        this.cs.logoff();
    }

    public void setDefaultUserName(String string) throws IOException, CryptoServerException {
        if (string.length() == 0) {
            throw new CryptoServerException(-1182728184);
        }
        this.defaultUser = string;
    }

    public DumyCertificate getDumyCertificate() {
        return new DumyCertificate();
    }

    public DumyCertificate getDumyCertificate(PublicKey publicKey) {
        return new DumyCertificate(publicKey);
    }

    public DumyCertificate[] getDumyCertificateChain() {
        DumyCertificate[] dumyCertificateArray = new DumyCertificate[]{new DumyCertificate()};
        return dumyCertificateArray;
    }

    protected void finalize() {
        try {
            if (this.cs != null) {
                this.cs.logoff();
                this.cs.close();
            }
        }
        catch (Exception exception) {
            Log.log("T: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    protected CryptoServerKey setFipsUsage(CryptoServerKey cryptoServerKey, FipsUsage fipsUsage, int n) throws IOException, CryptoServerException {
        CryptoServerKeyStore cryptoServerKeyStore = new CryptoServerKeyStore(this);
        CryptoServerCXI.KeyAttributes keyAttributes = this.cs.getKeyAttributes(cryptoServerKey.key, false);
        if (!cryptoServerKeyStore.engineContainsAlias(keyAttributes.getName())) {
            IOException iOException = new IOException("Non Persistent Key given.");
            throw iOException;
        }
        int n2 = 0;
        int n3 = n;
        if (fipsUsage == FipsUsage.USAGE_SIGN_VERIFY) {
            switch (n3) {
                case 16384: {
                    n2 = 1;
                    break;
                }
                case 24576: {
                    n2 = 2;
                    break;
                }
                case 28672: {
                    n2 = 3;
                    break;
                }
                default: {
                    n2 = -1;
                }
            }
        }
        keyAttributes = new CryptoServerCXI.KeyAttributes();
        keyAttributes.setInt(109, n2);
        CryptoServerKey cryptoServerKey2 = new CryptoServerKey(this, cryptoServerKey.algorithm, this.cs.setKeyAttributes(cryptoServerKey.key, keyAttributes));
        keyAttributes = this.cs.getKeyAttributes(cryptoServerKey2.key, false);
        try {
            cryptoServerKeyStore.engineSetKeyEntry(keyAttributes.getName(), cryptoServerKey2, null, null);
            return (CryptoServerKey)cryptoServerKeyStore.engineGetKey(keyAttributes.getName(), null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            IOException iOException = new IOException(noSuchAlgorithmException.toString());
            iOException.initCause(noSuchAlgorithmException);
            throw iOException;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            IOException iOException = new IOException(unrecoverableKeyException.toString());
            iOException.initCause(unrecoverableKeyException);
            throw iOException;
        }
        catch (KeyStoreException keyStoreException) {
            IOException iOException = new IOException(keyStoreException.toString());
            iOException.initCause(keyStoreException);
            throw iOException;
        }
    }

    private void registerServices() {
        this.putService(new CryptoServerSignatureService(this, "SHA1withRSA", 1, 10));
        this.putService(new CryptoServerSignatureService(this, "SHA224withRSA", 1, 11));
        this.putService(new CryptoServerSignatureService(this, "SHA256withRSA", 1, 12));
        this.putService(new CryptoServerSignatureService(this, "SHA384withRSA", 1, 13));
        this.putService(new CryptoServerSignatureService(this, "SHA512withRSA", 1, 14));
        this.putService(new CryptoServerSignatureService(this, "SHA3-224withRSA", 1, 16));
        this.putService(new CryptoServerSignatureService(this, "SHA3-256withRSA", 1, 17));
        this.putService(new CryptoServerSignatureService(this, "SHA3-384withRSA", 1, 18));
        this.putService(new CryptoServerSignatureService(this, "SHA3-512withRSA", 1, 19));
        this.putService(new CryptoServerSignatureService(this, "MD5withRSA", 1, 15));
        this.putService(new CryptoServerSignatureService(this, "SHA1withECDSA", 4, 10));
        this.putService(new CryptoServerSignatureService(this, "SHA224withECDSA", 4, 11));
        this.putService(new CryptoServerSignatureService(this, "SHA256withECDSA", 4, 12));
        this.putService(new CryptoServerSignatureService(this, "SHA384withECDSA", 4, 13));
        this.putService(new CryptoServerSignatureService(this, "SHA512withECDSA", 4, 14));
        this.putService(new CryptoServerSignatureService(this, "SHA3-224withECDSA", 4, 16));
        this.putService(new CryptoServerSignatureService(this, "SHA3-256withECDSA", 4, 17));
        this.putService(new CryptoServerSignatureService(this, "SHA3-384withECDSA", 4, 18));
        this.putService(new CryptoServerSignatureService(this, "SHA3-512withECDSA", 4, 19));
        this.putService(new CryptoServerSignatureService(this, "MD5withECDSA", 4, 15));
        this.putService(new CryptoServerSignatureService(this, "NONEwithECDSA", 4, 0));
        this.putService(new CryptoServerSignatureService(this, "SHA1withDSA", 2, 10));
        this.putService(new CryptoServerSignatureService(this, "NONEwithDSA", 2, 0));
        this.putService(new CryptoServerSignatureService(this, "RSASSA-PSS", 1, 0));
        this.putService(new CryptoServerSignatureService(this, "SHA1withRSASSA-PSS", 1, 10));
        this.putService(new CryptoServerSignatureService(this, "SHA224withRSASSA-PSS", 1, 11));
        this.putService(new CryptoServerSignatureService(this, "SHA256withRSASSA-PSS", 1, 12));
        this.putService(new CryptoServerSignatureService(this, "SHA384withRSASSA-PSS", 1, 13));
        this.putService(new CryptoServerSignatureService(this, "SHA512withRSASSA-PSS", 1, 14));
        this.putService(new CryptoServerKeyPairGeneratorService(this, "RSA", 1));
        this.putService(new CryptoServerKeyPairGeneratorService(this, "EC", 3));
        this.putService(new CryptoServerKeyPairGeneratorService(this, "DSA", 2));
        this.putService(new CryptoServerKeyAgreementService(this, "ECDH", 35, 0, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECDHC", 36, 0, false));
        this.put("Alg.Alias.KeyAgreement.ECCDH", "ECDHC");
        this.putService(new CryptoServerKeyAgreementService(this, "ECDHwithSHA1KDF", 35, 10, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECDHwithSHA224KDF", 35, 11, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECDHwithSHA256KDF", 35, 12, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECDHwithSHA384KDF", 35, 13, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECDHwithSHA512KDF", 35, 14, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA1KDF", 36, 10, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA224KDF", 36, 11, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA256KDF", 36, 12, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA384KDF", 36, 13, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA512KDF", 36, 14, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA1CKDF", 36, 10, true));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA256CKDF", 36, 12, true));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA384CKDF", 36, 13, true));
        this.putService(new CryptoServerKeyAgreementService(this, "ECCDHWITHSHA512CKDF", 36, 14, true));
        this.putService(new CryptoServerKeyAgreementService(this, "ECKABSITR03111S", 34, 0, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECKABSITR03111Z", 34, 0, true));
        this.putService(new CryptoServerKeyAgreementService(this, "ECKAEGwithSHA1KDF", 35, 10, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECKAEGwithSHA224KDF", 35, 11, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECKAEGwithSHA256KDF", 35, 12, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECKAEGwithSHA384KDF", 35, 13, false));
        this.putService(new CryptoServerKeyAgreementService(this, "ECKAEGwithSHA512KDF", 35, 14, false));
        this.putService(new CryptoServerKeyFactoryService(this, "RSA", 1));
        this.putService(new CryptoServerKeyFactoryService(this, "DSA", 2));
        this.putService(new CryptoServerKeyFactoryService(this, "EC", 3));
        this.putService(new CryptoServerSecretKeyFactoryService(this, "AES", 21));
        this.putService(new CryptoServerSecretKeyFactoryService(this, "DES", 20));
        this.putService(new CryptoServerSecretKeyFactoryService(this, "DESede", 20));
        this.putService(new CryptoServerKeyStoreService(this));
        this.putService(new CryptoServerSecureRandomService(this, "SHA1PRNG", 1));
        this.putService(new CryptoServerSecureRandomService(this, PROVIDERNAME, 0));
        this.putService(new CryptoServerKeyGeneratorService(this, "DES", 20));
        this.putService(new CryptoServerKeyGeneratorService(this, "DESede", 20));
        this.putService(new CryptoServerKeyGeneratorService(this, "AES", 21));
        this.putService(new CryptoServerCipherService(this, "DES", 20));
        this.putService(new CryptoServerCipherService(this, "DESede", 20));
        this.putService(new CryptoServerCipherService(this, "AES", 21));
        this.putService(new CryptoServerCipherService(this, "RSA", 1));
        this.putService(new CryptoServerMacService(this, "DES", 20));
        this.putService(new CryptoServerMacService(this, "DESwithPKCS5Padding", 20));
        this.putService(new CryptoServerMacService(this, "AES", 21));
        this.putService(new CryptoServerMacService(this, "AESwithPKCS5Padding", 21));
        this.putService(new CryptoServerMacService(this, "HmacMD5", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA1", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA224", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA256", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA384", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA512", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA3-224", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA3-256", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA3-384", 0));
        this.putService(new CryptoServerMacService(this, "HmacSHA3-512", 0));
        this.putService(new CryptoServerMacService(this, "HmacRMD160", 0));
        this.putService(new CryptoServerMessageDigestService(this, "MD5"));
        this.putService(new CryptoServerMessageDigestService(this, "SHA-1"));
        this.putService(new CryptoServerMessageDigestService(this, "SHA-224"));
        this.putService(new CryptoServerMessageDigestService(this, "SHA-256"));
        this.putService(new CryptoServerMessageDigestService(this, "SHA-384"));
        this.putService(new CryptoServerMessageDigestService(this, "SHA-512"));
        this.putService(new CryptoServerMessageDigestService(this, "SHA3-224"));
        this.putService(new CryptoServerMessageDigestService(this, "SHA3-256"));
        this.putService(new CryptoServerMessageDigestService(this, "SHA3-384"));
        this.putService(new CryptoServerMessageDigestService(this, "SHA3-512"));
        this.putService(new CryptoServerMessageDigestService(this, "RMD-160"));
        this.putService(new CryptoServerECAlgorithmParamatersService(this, "EC"));
        this.putService(new CryptoServerECAlgorithmParamatersService(this, "ECDH"));
    }

    private static class CryptoServerSecretKeyFactoryService
    extends Provider.Service {
        private int keyAlgo;

        CryptoServerSecretKeyFactoryService(Provider provider, String string, int n) {
            super(provider, "SecretKeyFactory", string, "CryptoServerSecretKeyFactory", null, null);
            this.keyAlgo = n;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            return new CryptoServerSecretKeyFactory(this.getProvider(), this.getAlgorithm(), this.keyAlgo);
        }
    }

    private static class CryptoServerKeyFactoryService
    extends Provider.Service {
        private int keyAlgo;

        CryptoServerKeyFactoryService(Provider provider, String string, int n) {
            super(provider, "KeyFactory", string, "CryptoServerKeyFactory", null, null);
            this.keyAlgo = n;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            return new CryptoServerKeyFactory(this.getProvider(), this.getAlgorithm(), this.keyAlgo);
        }
    }

    private static class CryptoServerSecureRandomService
    extends Provider.Service {
        private int algo;

        CryptoServerSecureRandomService(Provider provider, String string, int n) {
            super(provider, "SecureRandom", string, "CryptoServerSecureRandom", null, null);
            this.algo = n;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            return new CryptoServerSecureRandom(this.getProvider(), this.getAlgorithm(), this.algo);
        }
    }

    private static class CryptoServerKeyStoreService
    extends Provider.Service {
        CryptoServerKeyStoreService(Provider provider) {
            super(provider, "KeyStore", CryptoServerProvider.PROVIDERNAME, "CryptoServerKeyStore", null, null);
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            return new CryptoServerKeyStore(this.getProvider());
        }
    }

    private static class CryptoServerMessageDigestService
    extends Provider.Service {
        CryptoServerMessageDigestService(Provider provider, String string) {
            super(provider, "MessageDigest", string, "CryptoServerMessageDigest", null, null);
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            return new CryptoServerMessageDigest(this.getProvider(), this.getAlgorithm());
        }
    }

    private static class CryptoServerMacService
    extends Provider.Service {
        private int keyAlgo;

        CryptoServerMacService(Provider provider, String string, int n) {
            super(provider, "Mac", string, "CryptoServerMac", null, null);
            this.keyAlgo = n;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            return new CryptoServerMac(this.getProvider(), this.getAlgorithm(), this.keyAlgo);
        }
    }

    private static class CryptoServerCipherService
    extends Provider.Service {
        private int keyAlgo;

        CryptoServerCipherService(Provider provider, String string, int n) {
            super(provider, "Cipher", string, "CryptoServerCipher", null, null);
            this.keyAlgo = n;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            return new CryptoServerCipher(this.getProvider(), this.getAlgorithm(), this.keyAlgo);
        }
    }

    private static class CryptoServerKeyAgreementService
    extends Provider.Service {
        private int keyAgreementAlgo;
        private int hashAlgo;
        private boolean extraFlag;

        CryptoServerKeyAgreementService(Provider provider, String string, int n, int n2, boolean bl) {
            super(provider, "KeyAgreement", string, "CryptoServerKeyAgreement", null, null);
            this.keyAgreementAlgo = n;
            this.hashAlgo = n2;
            this.extraFlag = bl;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            return new CryptoServerKeyAgreement(this.getProvider(), this.getAlgorithm(), this.keyAgreementAlgo, this.hashAlgo, this.extraFlag);
        }
    }

    private static class CryptoServerKeyGeneratorService
    extends Provider.Service {
        private int keyAlgo;

        CryptoServerKeyGeneratorService(Provider provider, String string, int n) {
            super(provider, "KeyGenerator", string, "CryptoServerKeyGenerator", null, null);
            this.keyAlgo = n;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            return new CryptoServerKeyGenerator(this.getProvider(), this.getAlgorithm(), this.keyAlgo);
        }
    }

    private static class CryptoServerKeyPairGeneratorService
    extends Provider.Service {
        private int sigAlgo;

        CryptoServerKeyPairGeneratorService(Provider provider, String string, int n) {
            super(provider, "KeyPairGenerator", string, "CryptoServerKeyPairGenerator", null, null);
            this.sigAlgo = n;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            return new CryptoServerKeyPairGenerator(this.getProvider(), this.getAlgorithm(), this.sigAlgo);
        }
    }

    private static class CryptoServerECAlgorithmParamatersService
    extends Provider.Service {
        CryptoServerECAlgorithmParamatersService(Provider provider, String string) {
            super(provider, "AlgorithmParameters", string, "CryptoServerAlgorithmParametersSpi", null, null);
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            return new CryptoServerECAlgorithmParametersSpi();
        }
    }

    private static class CryptoServerSignatureService
    extends Provider.Service {
        private int sigAlgo;
        private int hashAlgo;

        CryptoServerSignatureService(Provider provider, String string, int n, int n2) {
            super(provider, "Signature", string, "CryptoServerSignature", null, null);
            this.sigAlgo = n;
            this.hashAlgo = n2;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            return new CryptoServerSignature(this.getProvider(), this.getAlgorithm(), this.sigAlgo, this.hashAlgo);
        }
    }

    private class EventHandler
    implements CryptoServerCluster.EventHandler {
        CryptoServerLog log = null;

        public EventHandler(CryptoServerLog cryptoServerLog) {
            this.log = cryptoServerLog;
        }

        @Override
        public void stateChanged(String string, int n) {
            String[] stringArray = new String[]{"CLOSED", "OPEN", "ACTIVE", "???"};
            String string2 = "I: state of " + string + " changed to: " + stringArray[n & 3];
            if (this.log != null) {
                this.log.print("stateChanged", string2, new Object[0]);
            } else {
                System.out.println(string2);
            }
        }

        @Override
        public void errorOccurred(String string, int n, String string2, String string3) {
            String string4 = "E: error occurred on " + string + " at " + string2 + "\ncode: 0x" + Integer.toHexString(n) + "\nmessage: " + string3;
            if (this.log != null) {
                this.log.print("errorOccurred", string4, new Object[0]);
            } else {
                System.out.println(string4);
            }
        }
    }

    public static enum FipsUsage {
        USAGE_SIGN_VERIFY,
        USAGE_OTHER;

    }
}

