/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerCXI.CryptoServerCXI;
import CryptoServerJCE.CryptoServerDSAKeyGenParameterSpec;
import CryptoServerJCE.CryptoServerECKeyGenParameterSpec;
import CryptoServerJCE.CryptoServerPrivateKey;
import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.CryptoServerPublicKey;
import CryptoServerJCE.CryptoServerRSAKeyGenParameterSpec;
import CryptoServerJCE.Log;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Date;

public class CryptoServerKeyPairGenerator
extends KeyPairGeneratorSpi {
    private final CryptoServerProvider provider;
    private final int algo;
    private CryptoServerCXI.KeyAttributes attr;

    CryptoServerKeyPairGenerator(Provider provider, String string, int n) throws NoSuchAlgorithmException {
        Log.log("T: enter...");
        this.provider = (CryptoServerProvider)provider;
        this.algo = n;
        this.attr = new CryptoServerCXI.KeyAttributes();
        switch (n) {
            case 1: {
                this.attr.setAlgo(3);
                this.attr.setSize(1024);
                break;
            }
            case 2: {
                this.attr.setAlgo(5);
                break;
            }
            case 3: {
                this.attr.setAlgo(4);
                try {
                    this.attr.setCurve("NIST-P256");
                    break;
                }
                catch (Exception exception) {
                    NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(exception.toString());
                    noSuchAlgorithmException.initCause(exception);
                    throw noSuchAlgorithmException;
                }
            }
            default: {
                throw new NoSuchAlgorithmException();
            }
        }
        this.attr.setExport(this.provider.export);
        this.attr.setUsage(this.provider.usage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initialize(int n, SecureRandom secureRandom) throws InvalidParameterException {
        Log.log("T: enter...");
        switch (this.algo) {
            case 1: {
                if (n < 512 || n > 8192) {
                    throw new InvalidParameterException();
                }
                this.attr.setSize(n);
                this.attr.setExponent((byte[])null);
                return;
            }
            case 2: {
                if (n < 512 || n > 8192) {
                    throw new InvalidParameterException();
                }
                try {
                    this.attr = this.provider.cs.generateDSADomainParam(n, 160, 0);
                    this.attr.setSize(n);
                    this.attr.setAlgo(5);
                    return;
                }
                catch (Exception exception) {
                    InvalidParameterException invalidParameterException = new InvalidParameterException(exception.toString());
                    invalidParameterException.initCause(exception);
                    throw invalidParameterException;
                }
            }
            case 3: {
                try {
                    switch (n) {
                        case 160: {
                            this.attr.setCurve("secp160k1");
                            return;
                        }
                        case 192: {
                            this.attr.setCurve("NIST-P192");
                            return;
                        }
                        case 224: {
                            this.attr.setCurve("NIST-P224");
                            return;
                        }
                        case 256: {
                            this.attr.setCurve("NIST-P256");
                            return;
                        }
                        case 320: {
                            this.attr.setCurve("brainpoolP320r1");
                            return;
                        }
                        case 384: {
                            this.attr.setCurve("NIST-P384");
                            return;
                        }
                        case 512: {
                            this.attr.setCurve("brainpoolP512r1");
                            return;
                        }
                        case 521: {
                            this.attr.setCurve("NIST-P521");
                            return;
                        }
                    }
                    throw new InvalidParameterException();
                }
                catch (Exception exception) {
                    Log.log("E: " + exception.getMessage());
                    InvalidParameterException invalidParameterException = new InvalidParameterException(exception.toString());
                    invalidParameterException.initCause(exception);
                    throw invalidParameterException;
                }
            }
            default: {
                throw new InvalidParameterException();
            }
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidParameterException {
        Log.log("T: enter...");
        switch (this.algo) {
            case 1: {
                if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
                    throw new InvalidParameterException();
                }
                RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
                int n = rSAKeyGenParameterSpec.getKeysize();
                if (n < 512 || n > 8192) {
                    throw new InvalidParameterException();
                }
                this.attr.setSize(n);
                BigInteger bigInteger = rSAKeyGenParameterSpec.getPublicExponent();
                if (bigInteger == null) {
                    this.attr.setExponent((byte[])null);
                } else {
                    this.attr.setExponent(bigInteger);
                }
                if (!(algorithmParameterSpec instanceof CryptoServerRSAKeyGenParameterSpec)) break;
                CryptoServerRSAKeyGenParameterSpec cryptoServerRSAKeyGenParameterSpec = (CryptoServerRSAKeyGenParameterSpec)algorithmParameterSpec;
                if (cryptoServerRSAKeyGenParameterSpec.exportFlag < 0) break;
                this.attr.setExport(cryptoServerRSAKeyGenParameterSpec.exportFlag);
                break;
            }
            case 2: {
                if (algorithmParameterSpec instanceof DSAParameterSpec) {
                    DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
                    this.attr.setParamP(dSAParameterSpec.getP());
                    this.attr.setParamQ(dSAParameterSpec.getQ());
                    this.attr.setParamG(dSAParameterSpec.getG());
                    this.attr.setSize(dSAParameterSpec.getP().bitLength());
                    break;
                }
                if (!(algorithmParameterSpec instanceof CryptoServerDSAKeyGenParameterSpec)) {
                    throw new InvalidParameterException();
                }
                CryptoServerDSAKeyGenParameterSpec cryptoServerDSAKeyGenParameterSpec = (CryptoServerDSAKeyGenParameterSpec)algorithmParameterSpec;
                if (cryptoServerDSAKeyGenParameterSpec.dsaParameter != null) {
                    DSAParameterSpec dSAParameterSpec = cryptoServerDSAKeyGenParameterSpec.dsaParameter;
                    this.attr.setParamP(dSAParameterSpec.getP());
                    this.attr.setParamQ(dSAParameterSpec.getQ());
                    this.attr.setParamG(dSAParameterSpec.getG());
                    this.attr.setSize(dSAParameterSpec.getP().bitLength());
                } else {
                    int n;
                    int n2 = cryptoServerDSAKeyGenParameterSpec.keysize;
                    if (n2 == 0) {
                        n2 = 1024;
                    }
                    if ((n = cryptoServerDSAKeyGenParameterSpec.qsize) == 0) {
                        n = 160;
                    }
                    if (n2 < 512 || n2 > 8192) {
                        throw new InvalidParameterException();
                    }
                    try {
                        this.attr = this.provider.cs.generateDSADomainParam(n2, n, 0);
                        this.attr.setSize(n2);
                        this.attr.setAlgo(5);
                    }
                    catch (Exception exception) {
                        InvalidParameterException invalidParameterException = new InvalidParameterException(exception.toString());
                        invalidParameterException.initCause(exception);
                        throw invalidParameterException;
                    }
                }
                if (cryptoServerDSAKeyGenParameterSpec.exportFlag < 0) break;
                this.attr.setExport(cryptoServerDSAKeyGenParameterSpec.exportFlag);
                break;
            }
            case 3: {
                try {
                    if (algorithmParameterSpec instanceof CryptoServerECKeyGenParameterSpec) {
                        CryptoServerECKeyGenParameterSpec cryptoServerECKeyGenParameterSpec = (CryptoServerECKeyGenParameterSpec)algorithmParameterSpec;
                        if (cryptoServerECKeyGenParameterSpec.name != null) {
                            this.attr.setCurve(cryptoServerECKeyGenParameterSpec.name);
                        }
                        if (cryptoServerECKeyGenParameterSpec.ecParameter != null) {
                            this.attr.setCurve(cryptoServerECKeyGenParameterSpec.ecParameter);
                        }
                        if (cryptoServerECKeyGenParameterSpec.exportFlag < 0) break;
                        this.attr.setExport(cryptoServerECKeyGenParameterSpec.exportFlag);
                        break;
                    }
                    if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                        ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)algorithmParameterSpec;
                        this.attr.setCurve(eCGenParameterSpec.getName());
                        break;
                    }
                    if (algorithmParameterSpec instanceof ECParameterSpec) {
                        ECParameterSpec eCParameterSpec = (ECParameterSpec)algorithmParameterSpec;
                        CryptoServerCXI.ECParameter eCParameter = new CryptoServerCXI.ECParameter(eCParameterSpec);
                        this.attr.setCurve(eCParameter.getEncoded());
                        break;
                    }
                }
                catch (Exception exception) {
                    InvalidParameterException invalidParameterException = new InvalidParameterException(exception.toString());
                    invalidParameterException.initCause(exception);
                    throw invalidParameterException;
                }
                throw new InvalidParameterException();
            }
            default: {
                throw new InvalidParameterException();
            }
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        CryptoServerPublicKey cryptoServerPublicKey;
        CryptoServerPrivateKey cryptoServerPrivateKey;
        Log.log("T: enter...");
        String string = null;
        switch (this.algo) {
            case 1: {
                string = "RSA";
                break;
            }
            case 2: {
                string = "DSA";
                break;
            }
            case 3: {
                string = "EC";
            }
        }
        try {
            if (this.provider.keyGroup.length() != 0) {
                this.attr.setGroup(this.provider.keyGroup);
            }
            this.attr.setGenerationDate(new Date());
            CryptoServerCXI.Key key = this.provider.cs.generateKey(2, this.attr);
            cryptoServerPrivateKey = new CryptoServerPrivateKey(this.provider, string, key);
            CryptoServerCXI.KeyAttributes keyAttributes = this.provider.cs.getKeyAttributes(key, true);
            CryptoServerCXI.Key key2 = this.provider.cs.importClearKey(3, 65536, keyAttributes, null);
            cryptoServerPublicKey = new CryptoServerPublicKey(this.provider, string, key2);
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
        return new KeyPair(cryptoServerPublicKey, cryptoServerPrivateKey);
    }
}

