/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerCXI.CryptoServerCXI;
import CryptoServerJCE.CryptoServerKeyGenParameterSpec;
import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.CryptoServerSecretKey;
import CryptoServerJCE.Log;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public class CryptoServerKeyGenerator
extends KeyGeneratorSpi {
    private final CryptoServerProvider provider;
    private final String algorithm;
    private final int algo;
    private CryptoServerCXI.KeyAttributes attr;

    CryptoServerKeyGenerator(Provider provider, String string, int n) throws NoSuchAlgorithmException {
        Log.log("T: enter...");
        this.provider = (CryptoServerProvider)provider;
        this.algorithm = string;
        this.algo = n;
        this.attr = new CryptoServerCXI.KeyAttributes();
        switch (n) {
            case 20: {
                this.attr.setAlgo(1);
                if (string.equals("DES")) {
                    this.attr.setSize(56);
                    break;
                }
                this.attr.setSize(112);
                break;
            }
            case 21: {
                this.attr.setAlgo(2);
                this.attr.setSize(256);
                break;
            }
            default: {
                throw new NoSuchAlgorithmException();
            }
        }
        this.attr.setExport(this.provider.export);
        this.attr.setUsage(this.provider.usage);
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) throws InvalidParameterException {
        Log.log("T: enter...");
        switch (this.algo) {
            case 20: {
                if (n != 56 && n != 112 && n != 168) {
                    throw new InvalidParameterException();
                }
                this.attr.setSize(n);
                break;
            }
            case 21: {
                if (n != 128 && n != 192 && n != 256) {
                    throw new InvalidParameterException();
                }
                this.attr.setSize(n);
                break;
            }
            default: {
                throw new InvalidParameterException();
            }
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidParameterException {
        Log.log("T: enter...");
        if (!(algorithmParameterSpec instanceof CryptoServerKeyGenParameterSpec)) {
            throw new InvalidParameterException();
        }
        CryptoServerKeyGenParameterSpec cryptoServerKeyGenParameterSpec = (CryptoServerKeyGenParameterSpec)algorithmParameterSpec;
        this.engineInit(cryptoServerKeyGenParameterSpec.keySize, null);
        if (cryptoServerKeyGenParameterSpec.exportFlag >= 0) {
            this.attr.setExport(cryptoServerKeyGenParameterSpec.exportFlag);
        }
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        Log.log("T: enter...");
    }

    @Override
    protected SecretKey engineGenerateKey() {
        CryptoServerCXI.Key key;
        Log.log("T: enter...");
        try {
            if (this.provider.keyGroup.length() != 0) {
                this.attr.setGroup(this.provider.keyGroup);
            }
            this.attr.setGenerationDate(new Date());
            key = this.provider.cs.generateKey(2, this.attr);
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
        return new CryptoServerSecretKey(this.provider, this.algorithm, key);
    }
}

