/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerAPI.CryptoServerException;
import CryptoServerAPI.CryptoServerUtil;
import CryptoServerCXI.CryptoServerCXI;
import CryptoServerJCE.CryptoServerKeyFactory;
import CryptoServerJCE.CryptoServerPrivateKey;
import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.CryptoServerPublicKey;
import CryptoServerJCE.CryptoServerSecretKey;
import CryptoServerJCE.CryptoServerSharedInfoParameterSpec;
import CryptoServerJCE.Log;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import sun.security.util.ECUtil;

public class CryptoServerKeyAgreement
extends KeyAgreementSpi {
    private final CryptoServerProvider provider;
    private final String keyAlgo;
    private final int agreementAlgo;
    private CryptoServerPrivateKey skey;
    private byte[] publicValue;
    private byte[] sharedData = null;
    private int secretLen;
    private int mech;
    private boolean tr03111FormatX = false;
    private static final String OID_AES = "2.16.840.1.101.3.4.1";

    public CryptoServerKeyAgreement(Provider provider, String string, int n, int n2, boolean bl) throws NoSuchAlgorithmException {
        Log.log("T: enter...");
        this.provider = (CryptoServerProvider)provider;
        this.agreementAlgo = n;
        switch (n) {
            case 35: {
                this.keyAlgo = "EC";
                this.mech = 0x50000000;
                this.mech |= this.getHashMechanism(n2);
                if (!bl) break;
                this.mech |= 0x200;
                break;
            }
            case 36: {
                this.keyAlgo = "EC";
                this.mech = 0x60000000;
                this.mech |= this.getHashMechanism(n2);
                if (!bl) break;
                this.mech |= 0x200;
                break;
            }
            case 34: {
                this.keyAlgo = "EC";
                this.tr03111FormatX = bl;
                break;
            }
            default: {
                throw new NoSuchAlgorithmException();
            }
        }
    }

    private int getHashMechanism(int n) {
        switch (n) {
            case 10: {
                return 16;
            }
            case 11: {
                return 48;
            }
            case 12: {
                return 64;
            }
            case 13: {
                return 96;
            }
            case 14: {
                return 112;
            }
            case 16: {
                return 128;
            }
            case 17: {
                return 144;
            }
            case 18: {
                return 160;
            }
            case 19: {
                return 176;
            }
            case 15: {
                return 80;
            }
        }
        return 0;
    }

    @Override
    public void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            byte[] byArray;
            ECParameterSpec eCParameterSpec;
            if (!(key instanceof CryptoServerPrivateKey)) {
                throw new InvalidKeyException();
            }
            if (((CryptoServerPrivateKey)key).provider != this.provider || !this.keyAlgo.equals(key.getAlgorithm())) {
                throw new InvalidKeyException();
            }
            this.skey = (CryptoServerPrivateKey)key;
            if ((this.mech & 0xF0000000) == 0x60000000 && (eCParameterSpec = new CryptoServerCXI.ECParameter(byArray = this.provider.getCryptoServer().getKeyAttributes(this.skey.key, true).getCurveEncoded()).getSpec()).getCurve().getField() instanceof ECFieldF2m) {
                throw new InvalidKeyException("Binary field curves not supported");
            }
            this.secretLen = this.skey.key.getAttributes().getSize() + 7 >> 3 << 3;
            this.publicValue = null;
        }
        catch (CryptoServerException | IOException exception) {
            throw new InvalidKeyException(exception);
        }
    }

    @Override
    public void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Log.log("T: enter...");
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof CryptoServerSharedInfoParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unsupported parameter type");
            }
            if ((this.mech & 0xF0) == 0) {
                throw new InvalidAlgorithmParameterException("Algorithm does not support parameters");
            }
        }
        this.sharedData = ((CryptoServerSharedInfoParameterSpec)algorithmParameterSpec).getData();
        this.engineInit(key, secureRandom);
    }

    @Override
    public Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        block11: {
            if (this.skey == null) {
                throw new IllegalStateException("Not initialized");
            }
            if (this.publicValue != null) {
                throw new IllegalStateException("Phase already executed");
            }
            if (!bl) {
                throw new IllegalStateException("Only key agreement between 2 parties allowed");
            }
            if (!(key instanceof PublicKey)) {
                throw new InvalidKeyException("Key must be a PublicKey");
            }
            if (this.keyAlgo.equalsIgnoreCase("EC")) {
                try {
                    byte[] byArray = this.provider.getCryptoServer().getKeyAttributes(this.skey.key, true).getCurveEncoded();
                    if (key instanceof ECPublicKey && (key.getAlgorithm().equalsIgnoreCase("EC") || key.getAlgorithm().equalsIgnoreCase("ECDH"))) {
                        ECParameterSpec eCParameterSpec = new CryptoServerCXI.ECParameter(byArray).getSpec();
                        ECParameterSpec eCParameterSpec2 = ((ECPublicKey)key).getParams();
                        if (!(eCParameterSpec.getCurve().equals(eCParameterSpec2.getCurve()) && eCParameterSpec.getGenerator().equals(eCParameterSpec2.getGenerator()) && eCParameterSpec.getOrder().equals(eCParameterSpec2.getOrder()) && eCParameterSpec.getCofactor() == eCParameterSpec2.getCofactor())) {
                            throw new InvalidKeyException("PublicKey EC parameters must match PrivateKey EC parameters");
                        }
                        ECPoint eCPoint = ((ECPublicKey)key).getW();
                        this.publicValue = ECUtil.encodePoint(eCPoint, eCParameterSpec2.getCurve());
                        break block11;
                    }
                    if (key instanceof CryptoServerPublicKey && key.getAlgorithm().equalsIgnoreCase("EC")) {
                        CryptoServerCXI.KeyAttributes keyAttributes = this.provider.getCryptoServer().getKeyAttributes(((CryptoServerPublicKey)key).key, true);
                        if (Arrays.equals(keyAttributes.getCurveEncoded(), byArray)) {
                            throw new InvalidKeyException("PublicKey EC parameters must match PrivateKey EC parameters");
                        }
                        this.publicValue = keyAttributes.getECPub();
                        break block11;
                    }
                    throw new InvalidKeyException("Key must be a PublicKey with algorithm " + this.keyAlgo);
                }
                catch (CryptoServerException | IOException exception) {
                    Log.log("E: " + exception.getMessage());
                    exception.printStackTrace();
                    throw new InvalidKeyException(exception);
                }
            }
        }
        return null;
    }

    @Override
    public byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.agreementAlgo == 34) {
            if (this.skey == null || this.publicValue == null) {
                throw new IllegalStateException("Not initialized correctly");
            }
            try {
                byte[] byArray = this.skey.key.getAttributes().getCurveEncoded();
                ECParameterSpec eCParameterSpec = new CryptoServerCXI.ECParameter(byArray).getSpec();
                CryptoServerKeyFactory cryptoServerKeyFactory = new CryptoServerKeyFactory(this.provider, null, 3);
                ECPoint eCPoint = ECUtil.decodePoint(this.publicValue, eCParameterSpec.getCurve());
                ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
                PublicKey publicKey = cryptoServerKeyFactory.engineGeneratePublic(eCPublicKeySpec);
                byte[] byArray2 = this.provider.cs.agreeSecret(0, this.skey.key, ((CryptoServerPublicKey)publicKey).key, 0, null);
                if (byArray2[0] == 68 && byArray2[1] == 65) {
                    int n = CryptoServerUtil.load_int4(byArray2, 2);
                    if (this.tr03111FormatX) {
                        return CryptoServerUtil.copyOf(byArray2, 7, n / 2);
                    }
                    return CryptoServerUtil.copyOf(byArray2, 6, n);
                }
                throw new IllegalStateException();
            }
            catch (CryptoServerException | IOException | NoSuchAlgorithmException | InvalidKeySpecException exception) {
                Log.log("E: " + exception.getMessage());
                exception.printStackTrace();
                throw new IllegalStateException(exception);
            }
        }
        try {
            CryptoServerSecretKey cryptoServerSecretKey = (CryptoServerSecretKey)this.engineGenerateSecret("Generic");
            CryptoServerCXI.KeyAttAndComp keyAttAndComp = this.provider.cs.exportClearKey(cryptoServerSecretKey.key, 8);
            return keyAttAndComp.keyComponents.getList();
        }
        catch (CryptoServerException | IOException | InvalidKeyException | NoSuchAlgorithmException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @Override
    public int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        if (n + this.secretLen > byArray.length) {
            throw new ShortBufferException("Need " + this.secretLen + " bytes, only " + (byArray.length - n) + " available");
        }
        byte[] byArray2 = this.engineGenerateSecret();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    @Override
    public SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (string == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        if (this.skey == null || this.publicValue == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        if (this.agreementAlgo == 34) {
            throw new NoSuchAlgorithmException("Key agreement service does not have a KDF");
        }
        try {
            Object object;
            CryptoServerCXI.KeyAttributes keyAttributes = new CryptoServerCXI.KeyAttributes();
            int n = 0;
            if (string.equalsIgnoreCase("DES")) {
                n = 56;
                keyAttributes.setAlgo(1);
                keyAttributes.setExport(this.provider.export);
            } else if (string.equalsIgnoreCase("DESede")) {
                n = 168;
                keyAttributes.setAlgo(1);
                keyAttributes.setExport(this.provider.export);
            } else if (string.equalsIgnoreCase("AES") || string.equals(OID_AES)) {
                n = 256;
                keyAttributes.setAlgo(2);
                keyAttributes.setExport(this.provider.export);
            } else if (string.startsWith(OID_AES)) {
                object = string.split("\\.");
                if (((String[])object).length != 9) {
                    throw new NoSuchAlgorithmException("Unknown algorithm " + string);
                }
                try {
                    int n2 = Integer.parseInt(object[8]);
                    n = n2 < 20 ? 128 : (n2 < 40 ? 192 : 256);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NoSuchAlgorithmException("Unknown algorithm " + string);
                }
                keyAttributes.setAlgo(2);
                keyAttributes.setExport(this.provider.export);
            } else if (string.equalsIgnoreCase("Generic")) {
                n = this.secretLen;
                keyAttributes.setAlgo(0);
                keyAttributes.setExport(2);
            } else {
                throw new NoSuchAlgorithmException("Unknown algorithm " + string);
            }
            if (n > this.secretLen && (this.mech & 0xF0) == 0) {
                throw new InvalidKeyException("Could only generate secret keys with length <=" + this.secretLen);
            }
            keyAttributes.setSize(n);
            keyAttributes.setUsage(this.provider.usage);
            keyAttributes.setType(8);
            object = new CryptoServerCXI.ByteArray();
            if (this.sharedData == null) {
                ((CryptoServerCXI.ByteArray)object).appendInt2(0);
            } else {
                ((CryptoServerCXI.ByteArray)object).appendInt2(this.sharedData.length);
                ((CryptoServerCXI.ByteArray)object).append(this.sharedData);
            }
            ((CryptoServerCXI.ByteArray)object).appendInt2(this.publicValue.length);
            ((CryptoServerCXI.ByteArray)object).append(this.publicValue);
            CryptoServerCXI.Key key = this.provider.cs.deriveKey(2, this.skey.key, keyAttributes, this.mech, ((CryptoServerCXI.ByteArray)object).getBytes());
            return new CryptoServerSecretKey(this.provider, string, key);
        }
        catch (CryptoServerException | IOException exception) {
            Log.log("E: " + exception.getMessage());
            exception.printStackTrace();
            throw new InvalidKeyException(exception);
        }
    }
}

