/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import CryptoServerJCE.AsnBuffer;
import CryptoServerJCE.Log;
import CryptoServerJCE.ToolBox;
import java.text.ParseException;

public class CertBuilder {
    private static final byte[] OID_RSA_ENCRYPTION = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 1};
    private static final byte[] OID_EC_PUBLICKEY = new byte[]{42, -122, 72, -50, 61, 2, 1};
    private static final byte[] OID_DSA = new byte[]{42, -122, 72, -50, 56, 4, 1};
    static final ECCurve[] curves = new ECCurve[]{new ECCurve("secp112r1", new byte[]{43, -127, 4, 0, 6}), new ECCurve("secp112r2", new byte[]{43, -127, 4, 0, 7}), new ECCurve("secp128r1", new byte[]{43, -127, 4, 0, 28}), new ECCurve("secp128r2", new byte[]{43, -127, 4, 0, 29}), new ECCurve("secp160k1", new byte[]{43, -127, 4, 0, 9}), new ECCurve("secp160r1", new byte[]{43, -127, 4, 0, 8}), new ECCurve("secp160r2", new byte[]{43, -127, 4, 0, 30}), new ECCurve("secp192k1", new byte[]{43, -127, 4, 0, 31}), new ECCurve("secp192r1", new byte[]{42, -122, 72, -50, 61, 3, 1, 1}), new ECCurve("secp224k1", new byte[]{43, -127, 4, 0, 32}), new ECCurve("secp224r1", new byte[]{43, -127, 4, 0, 33}), new ECCurve("secp256k1", new byte[]{43, -127, 4, 0, 10}), new ECCurve("secp256r1", new byte[]{42, -122, 72, -50, 61, 3, 1, 7}), new ECCurve("secp384r1", new byte[]{43, -127, 4, 0, 34}), new ECCurve("secp521r1", new byte[]{43, -127, 4, 0, 35}), new ECCurve("NIST-P192", new byte[]{42, -122, 72, -50, 61, 3, 1, 1}), new ECCurve("NIST-P224", new byte[]{43, -127, 4, 0, 33}), new ECCurve("NIST-P256", new byte[]{42, -122, 72, -50, 61, 3, 1, 7}), new ECCurve("NIST-P384", new byte[]{43, -127, 4, 0, 34}), new ECCurve("NIST-P521", new byte[]{43, -127, 4, 0, 35}), new ECCurve("sect113r1", new byte[]{43, -127, 4, 0, 4}), new ECCurve("sect113r2", new byte[]{43, -127, 4, 0, 5}), new ECCurve("sect131r1", new byte[]{43, -127, 4, 0, 22}), new ECCurve("sect131r2", new byte[]{43, -127, 4, 0, 23}), new ECCurve("sect163k1", new byte[]{43, -127, 4, 0, 1}), new ECCurve("sect163r1", new byte[]{43, -127, 4, 0, 2}), new ECCurve("sect163r2", new byte[]{43, -127, 4, 0, 15}), new ECCurve("sect193r1", new byte[]{43, -127, 4, 0, 24}), new ECCurve("sect193r2", new byte[]{43, -127, 4, 0, 25}), new ECCurve("sect233k1", new byte[]{43, -127, 4, 0, 26}), new ECCurve("sect233r1", new byte[]{43, -127, 4, 0, 27}), new ECCurve("sect239k1", new byte[]{43, -127, 4, 0, 3}), new ECCurve("sect283k1", new byte[]{43, -127, 4, 0, 16}), new ECCurve("sect283r1", new byte[]{43, -127, 4, 0, 17}), new ECCurve("sect409k1", new byte[]{43, -127, 4, 0, 36}), new ECCurve("sect409r1", new byte[]{43, -127, 4, 0, 37}), new ECCurve("sect571k1", new byte[]{43, -127, 4, 0, 38}), new ECCurve("sect571r1", new byte[]{43, -127, 4, 0, 39}), new ECCurve("NIST-K163", new byte[]{43, -127, 4, 0, 1}), new ECCurve("NIST-B163", new byte[]{43, -127, 4, 0, 15}), new ECCurve("NIST-K233", new byte[]{43, -127, 4, 0, 26}), new ECCurve("NIST-B233", new byte[]{43, -127, 4, 0, 27}), new ECCurve("NIST-K283", new byte[]{43, -127, 4, 0, 16}), new ECCurve("NIST-B283", new byte[]{43, -127, 4, 0, 17}), new ECCurve("NIST-K409", new byte[]{43, -127, 4, 0, 36}), new ECCurve("NIST-B409", new byte[]{43, -127, 4, 0, 37}), new ECCurve("NIST-K571", new byte[]{43, -127, 4, 0, 38}), new ECCurve("NIST-B571", new byte[]{43, -127, 4, 0, 39}), new ECCurve("brainpoolP160r1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 1}), new ECCurve("brainpoolP160t1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 2}), new ECCurve("brainpoolP192r1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 3}), new ECCurve("brainpoolP192t1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 4}), new ECCurve("brainpoolP224r1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 5}), new ECCurve("brainpoolP224t1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 6}), new ECCurve("brainpoolP256r1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 7}), new ECCurve("brainpoolP256t1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 8}), new ECCurve("brainpoolP320r1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 9}), new ECCurve("brainpoolP320t1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 10}), new ECCurve("brainpoolP384r1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 11}), new ECCurve("brainpoolP384t1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 12}), new ECCurve("brainpoolP512r1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 13}), new ECCurve("brainpoolP512t1", new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 14})};

    static byte[] buildPublicKeyInfoX509(CryptoServerCXI.KeyAttributes keyAttributes) throws ParseException, CryptoServerException {
        Object object;
        AsnBuffer asnBuffer = new AsnBuffer();
        switch (keyAttributes.getAlgo()) {
            case 3: {
                object = new AsnBuffer();
                ((AsnBuffer)object).addItem(6, OID_RSA_ENCRYPTION);
                ((AsnBuffer)object).addItem(5, new byte[0]);
                asnBuffer.addSEQ((AsnBuffer)object);
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                object = new AsnBuffer();
                ((AsnBuffer)object).addItem(6, OID_DSA);
                byte[] byArray = keyAttributes.getParamP();
                byte[] byArray2 = keyAttributes.getParamQ();
                byte[] byArray3 = keyAttributes.getParamG();
                if (byArray == null || byArray3 == null) {
                    throw new CryptoServerException(-1182728192, "missing DSA domain parameter");
                }
                AsnBuffer asnBuffer2 = new AsnBuffer();
                if ((byArray[0] & 0x80) != 0) {
                    byArray = ToolBox.concat(new byte[]{0}, byArray);
                }
                asnBuffer2.addItem(2, byArray);
                if (byArray2 != null) {
                    if ((byArray2[0] & 0x80) != 0) {
                        byArray2 = ToolBox.concat(new byte[]{0}, byArray2);
                    }
                    asnBuffer2.addItem(2, byArray2);
                }
                if ((byArray3[0] & 0x80) != 0) {
                    byArray3 = ToolBox.concat(new byte[]{0}, byArray3);
                }
                asnBuffer2.addItem(2, byArray3);
                ((AsnBuffer)object).addSEQ(asnBuffer2);
                asnBuffer.addSEQ((AsnBuffer)object);
                break;
            }
            case 4: 
            case 6: {
                Object object2;
                object = keyAttributes.getCurve();
                Object object3 = null;
                if (object == null) {
                    throw new CryptoServerException(-1182728192, "missing EC parameter");
                }
                if (object[0] == 48) {
                    throw new CryptoServerException(-1182728192, "unsupported EC parameter format: ASN1");
                }
                if (object[0] == 6) {
                    object3 = object;
                } else {
                    object2 = new String((byte[])object).trim();
                    for (ECCurve eCCurve : curves) {
                        if (!eCCurve.name.equals(object2)) continue;
                        object3 = eCCurve.oid;
                        break;
                    }
                    if (object3 == null) {
                        throw new CryptoServerException(-1182728192, "unsupported EC parameter: " + (String)object2);
                    }
                }
                object2 = new AsnBuffer();
                ((AsnBuffer)object2).addItem(6, OID_EC_PUBLICKEY);
                ((AsnBuffer)object2).addItem(6, (byte[])object3);
                asnBuffer.addSEQ((AsnBuffer)object2);
                break;
            }
            default: {
                throw new CryptoServerException(-1182728185, "invalid key algorithm: " + keyAttributes.getAlgo());
            }
        }
        asnBuffer.addItem(3, CertBuilder.encodePublicKey(keyAttributes));
        object = new AsnBuffer();
        ((AsnBuffer)object).addSEQ(asnBuffer);
        return ((AsnBuffer)object).getData();
    }

    private static byte[] encodePublicKey(CryptoServerCXI.KeyAttributes keyAttributes) throws ParseException, CryptoServerException {
        switch (keyAttributes.getAlgo()) {
            case 3: {
                byte[] byArray = keyAttributes.getModulus();
                byte[] byArray2 = keyAttributes.getExponent();
                if (byArray == null || byArray2 == null) {
                    throw new CryptoServerException(-1182728192, "missing RSA public key components");
                }
                AsnBuffer asnBuffer = new AsnBuffer();
                asnBuffer.addItem(2, ToolBox.concat(new byte[]{0}, byArray));
                if ((byArray2[0] & 0x80) != 0) {
                    byArray2 = ToolBox.concat(new byte[]{0}, byArray2);
                }
                asnBuffer.addItem(2, byArray2);
                AsnBuffer asnBuffer2 = new AsnBuffer();
                asnBuffer2.addSEQ(asnBuffer);
                return ToolBox.concat(new byte[]{0}, asnBuffer2.getData());
            }
            case 5: 
            case 7: 
            case 8: {
                byte[] byArray = keyAttributes.getDSAPub();
                if (byArray == null) {
                    throw new CryptoServerException(-1182728192, "missing DSA public key");
                }
                AsnBuffer asnBuffer = new AsnBuffer();
                if ((byArray[0] & 0x80) != 0) {
                    byArray = ToolBox.concat(new byte[]{0}, byArray);
                }
                asnBuffer.addItem(2, byArray);
                return ToolBox.concat(new byte[]{0}, asnBuffer.getData());
            }
            case 4: 
            case 6: {
                byte[] byArray = keyAttributes.getECPub();
                if (byArray == null) {
                    throw new CryptoServerException(-1182728192, "missing EC public key");
                }
                return ToolBox.concat(new byte[]{0}, byArray);
            }
        }
        Log.log("E: invalid algorithm");
        return null;
    }

    static class ECCurve {
        public String name;
        public byte[] oid;

        public ECCurve(String string, byte[] byArray) {
            this.name = string;
            this.oid = byArray;
        }
    }
}

