/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerAPI.CryptoServerUtil;
import java.text.ParseException;

public class AsnBuffer {
    public static final int TAG_EOC = 160;
    public static final int TAG_BOOLEAN = 1;
    public static final int TAG_INTEGER = 2;
    public static final int TAG_BIT_STRING = 3;
    public static final int TAG_OCTET_STRING = 4;
    public static final int TAG_NULL = 5;
    public static final int TAG_OBJECT_ID = 6;
    public static final int TAG_ENUMERATED = 10;
    public static final int TAG_UTF8STRING = 12;
    public static final int TAG_PRINTABLE_STRING = 19;
    public static final int TAG_TELETEXT_STRING = 20;
    public static final int TAG_IA5STRING = 22;
    public static final int TAG_UTCTIME = 23;
    public static final int TAG_GENERALIZEDTIME = 24;
    public static final int TAG_SEQUENCE = 48;
    public static final int TAG_SET = 49;
    byte[] data;

    public AsnBuffer(byte[] byArray) {
        this.data = byArray;
    }

    public AsnBuffer() {
        this.data = new byte[0];
    }

    public byte[] getItem() throws ParseException {
        if (this.data.length == 0) {
            return null;
        }
        if (this.data.length < 2) {
            throw new ParseException("Invalid ASN1 format", 0);
        }
        int n = this.data[1];
        int n2 = 2;
        if (n < 0) {
            if (this.data.length < (n2 += (n &= 0x7F))) {
                throw new ParseException("Invalid ASN1 format", n2);
            }
            switch (n) {
                case 1: {
                    n = this.data[2] & 0xFF;
                    break;
                }
                case 2: {
                    n = (this.data[2] & 0xFF) << 8 | this.data[3] & 0xFF;
                    break;
                }
                case 3: {
                    n = (this.data[2] & 0xFF) << 16 | (this.data[3] & 0xFF) << 8 | this.data[4] & 0xFF;
                    break;
                }
                default: {
                    throw new ParseException("Invalid ASN1 format", n);
                }
            }
        }
        if (this.data.length < n + n2) {
            throw new ParseException("Invalid ASN1 format", n + n2);
        }
        byte[] byArray = new byte[n];
        if (n > 0) {
            System.arraycopy(this.data, n2, byArray, 0, n);
        }
        n2 += n;
        n = this.data.length - n2;
        byte[] byArray2 = new byte[n];
        if (n > 0) {
            System.arraycopy(this.data, n2, byArray2, 0, n);
        }
        this.data = byArray2;
        return byArray;
    }

    public AsnBuffer getSEQ() throws ParseException {
        if (this.data.length == 0 || this.data[0] != 48) {
            throw new ParseException("Invalid ASN1 format", 0);
        }
        return new AsnBuffer(this.getItem());
    }

    public AsnBuffer getSET() throws ParseException {
        if (this.data.length == 0 || this.data[0] != 49) {
            throw new ParseException("Invalid ASN1 format", 0);
        }
        return new AsnBuffer(this.getItem());
    }

    public byte[] getINT(int n) throws ParseException {
        if (this.data.length == 0 || this.data[0] != (byte)n) {
            throw new ParseException("Invalid ASN1 format", 0);
        }
        return this.getItem();
    }

    public byte[] getOCT() throws ParseException {
        if (this.data.length == 0 || this.data[0] != 4) {
            throw new ParseException("Invalid ASN1 format", 0);
        }
        return this.getItem();
    }

    public byte[] getOID() throws ParseException {
        if (this.data.length == 0 || this.data[0] != 6) {
            throw new ParseException("Invalid ASN1 format", 0);
        }
        return this.getItem();
    }

    public void addItem(int n, byte[] byArray, byte[] byArray2) throws ParseException {
        int n2;
        int n3;
        byte[] byArray3 = new byte[5];
        int n4 = byArray2.length;
        if (byArray != null) {
            n4 += byArray.length;
        }
        CryptoServerUtil.store_int4(n4, byArray3, 1);
        for (n3 = 1; n3 < 5 && byArray3[n3] == 0; ++n3) {
        }
        if (n3 == 5 || n3 == 4 && byArray3[4] > 0) {
            n2 = 1;
            n3 = 4;
        } else {
            n2 = 6 - n3;
            byArray3[--n3] = (byte)(n2 - 129);
        }
        byArray3[--n3] = (byte)n;
        int n5 = this.data.length + ++n2 + n4;
        byte[] byArray4 = new byte[n5];
        System.arraycopy(byArray3, n3, byArray4, this.data.length, n2);
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray4, n2 + this.data.length, byArray.length);
            n2 += byArray.length;
        }
        System.arraycopy(byArray2, 0, byArray4, n2 + this.data.length, byArray2.length);
        System.arraycopy(this.data, 0, byArray4, 0, this.data.length);
        this.data = byArray4;
    }

    public void addItem(int n, byte[] byArray) throws ParseException {
        this.addItem(n, null, byArray);
    }

    public void addINT(int n, byte[] byArray) throws ParseException {
        byte[] byArray2;
        byte[] byArray3 = byArray;
        if (n != 2) {
            while (byArray3.length > 1 && byArray3[0] == 0) {
                byArray2 = new byte[byArray3.length - 1];
                System.arraycopy(byArray3, 1, byArray2, 0, byArray2.length);
                byArray3 = byArray2;
            }
            byArray2 = null;
        } else {
            byArray2 = null;
            if (byArray3[0] < 0) {
                byArray2 = new byte[]{0};
            }
        }
        this.addItem(n, byArray2, byArray3);
    }

    public void addSEQ(AsnBuffer asnBuffer) throws ParseException {
        this.addItem(48, null, asnBuffer.data);
    }

    public void addSET(AsnBuffer asnBuffer) throws ParseException {
        this.addItem(49, null, asnBuffer.data);
    }

    public byte[] getData() {
        return this.data;
    }
}

