/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerAPI;

import CryptoServerAPI.CryptoServer;
import CryptoServerAPI.CryptoServerCSX;
import CryptoServerAPI.CryptoServerConfig;
import CryptoServerAPI.CryptoServerException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class CryptoServerCluster
extends CryptoServer {
    public static final int DEVICE_STATE_CLOSED = 0;
    public static final int DEVICE_STATE_OPEN = 1;
    public static final int DEVICE_STATE_ACTIVE = 2;
    private int clusterHandle = -1;
    private DeviceState clusterState = DeviceState.Closed;
    private int fallbackInterval = 0;
    private EventHandler eventHandler = null;
    private boolean keepSessionAlive = false;
    private int readTimeout = 30000;

    public CryptoServerCluster() throws IOException, CryptoServerException {
    }

    public CryptoServerCluster(String[] stringArray, int n) throws IOException, CryptoServerException {
        this.open(stringArray, n);
    }

    public CryptoServerCluster(CryptoServerConfig cryptoServerConfig) throws IOException, CryptoServerException {
        this(cryptoServerConfig.getStringValues("Device", null), cryptoServerConfig.getInt("ConnectionTimeout", 0));
        this.setTimeout(cryptoServerConfig.getInt("Timeout", 0));
        this.setEndSessionOnShutdown(cryptoServerConfig.getBoolean("EndSessionOnShutdown", false));
        this.keepSessionAlive = cryptoServerConfig.getBoolean("KeepSessionAlive", false);
        this.fallbackInterval = cryptoServerConfig.getInt("FallbackInterval", 0);
    }

    public CryptoServerCluster(String string, int n) throws IOException, CryptoServerException {
        this(new String[]{string}, n);
    }

    public CryptoServerCluster(String string) throws IOException, CryptoServerException {
        this(new String[]{string}, 30000);
    }

    public synchronized void open(String[] stringArray, int n) throws CryptoServerException {
        if (this.clusterState == DeviceState.Closed) {
            this.clusterHandle = CryptoServerCSX.cs_cluster_open(stringArray, n, this.readTimeout, this.fallbackInterval);
            this.clusterState = DeviceState.Open;
            if (this.eventHandler != null) {
                CryptoServerCSX.cs_cluster_set_event_handler(this.clusterHandle, this.eventHandler);
            }
        }
    }

    public synchronized void close() {
        if (this.clusterState != DeviceState.Closed) {
            CryptoServerCSX.cs_cluster_close(this.clusterHandle);
            this.clusterHandle = -1;
            this.clusterState = DeviceState.Closed;
        }
    }

    public byte[] exec(int n, int n2, byte[] byArray, Error[] errorArray) throws IOException, CryptoServerException {
        return CryptoServerCSX.cs_cluster_exec(this.clusterHandle, n, n2, errorArray, byArray);
    }

    public byte[] exec(int n, int n2, byte[] byArray) throws IOException, CryptoServerException {
        return this.exec(n, n2, byArray, null);
    }

    public String getDevice() {
        return CryptoServerCSX.cs_cluster_get_current_device(this.clusterHandle);
    }

    public int getTimeout() {
        return this.readTimeout;
    }

    public synchronized void setTimeout(int n) throws IOException, CryptoServerException {
        this.readTimeout = n;
        if (this.clusterState == DeviceState.Open) {
            CryptoServerCSX.cs_cluster_set_timeout(this.clusterHandle, n);
        }
    }

    public synchronized void setFallbackInterval(int n) throws CryptoServerException {
        this.fallbackInterval = n;
        if (this.clusterState == DeviceState.Open) {
            CryptoServerCSX.cs_cluster_set_fallback_interval(this.clusterHandle, n);
        }
    }

    public synchronized void setKeepSessionAlive(boolean bl) throws CryptoServerException {
        this.keepSessionAlive = bl;
        if (this.clusterState == DeviceState.Active && bl) {
            CryptoServerCSX.cs_cluster_keep_session_alive(this.clusterHandle);
        }
    }

    public synchronized void setEventHandler(EventHandler eventHandler) throws CryptoServerException {
        this.eventHandler = eventHandler;
        if (eventHandler != null && this.clusterState == DeviceState.Open) {
            CryptoServerCSX.cs_cluster_set_event_handler(this.clusterHandle, eventHandler);
        }
    }

    public synchronized void logon(String string, String string2, byte[] byArray) throws IOException, CryptoServerException {
        CryptoServerCSX.cs_cluster_logon(this.clusterHandle, string, string2, byArray);
        this.clusterState = DeviceState.Active;
        if (this.keepSessionAlive) {
            CryptoServerCSX.cs_cluster_keep_session_alive(this.clusterHandle);
        }
    }

    public synchronized void logoff() throws IOException, CryptoServerException {
        if (this.clusterState == DeviceState.Active) {
            CryptoServerCSX.cs_cluster_logoff(this.clusterHandle);
            this.clusterState = DeviceState.Open;
        }
    }

    public int getAuthState() throws IOException, CryptoServerException {
        return CryptoServerCSX.cs_cluster_get_auth_state(this.clusterHandle);
    }

    public void setFallbackInterval(long l) throws CryptoServerException {
        this.setFallbackInterval((int)l);
    }

    public void logonPassword(String string, byte[] byArray) throws IOException, CryptoServerException {
        this.logon(string, null, byArray);
    }

    public void logonPassword(String string, String string2) throws IOException, CryptoServerException {
        try {
            this.logon(string, null, string2.getBytes("ISO-8859-15"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CryptoServerException(-1182793709);
        }
    }

    public void logonSign(String string, String string2, String string3) throws IOException, CryptoServerException {
        try {
            this.logon(string, string2, string3 != null ? string3.getBytes("ISO-8859-15") : null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CryptoServerException(-1182793709);
        }
    }

    public void keepSessionAlive() throws CryptoServerException {
        this.setKeepSessionAlive(true);
    }

    public void logonSC(String string, String string2) throws IOException, CryptoServerException {
        throw new CryptoServerException(-1182793704, "Smartcard authentication not supported on cluster");
    }

    public static class Error {
        public int mask;
        public int code;

        public Error(int n, int n2) {
            this.mask = n;
            this.code = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeviceState {
        Closed(0),
        Open(1),
        Active(2);

        private int state;

        private DeviceState(int n2) {
            this.state = n2;
        }

        public int intValue() {
            return this.state;
        }

        public static DeviceState valueOf(int n) {
            return DeviceState.values()[n];
        }
    }

    public static interface EventHandler {
        public void stateChanged(String var1, int var2);

        public void errorOccurred(String var1, int var2, String var3, String var4);
    }
}

