/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerAPI;

import CryptoServerAPI.CryptoServerCSX;
import CryptoServerAPI.CryptoServerConfig;
import CryptoServerAPI.CryptoServerException;
import CryptoServerAPI.CryptoServerUtil;
import CryptoServerAPI.Version;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class CryptoServer {
    private static final String JCSA_NAME = "Java CSXAPI for Utimaco CryptoServer";
    private static final double JCSA_VERSION = Version.getVersionDouble();
    protected static final int DEFAULT_CONNECT_TIMEOUT = 3000;
    protected static final int DEFAULT_READ_TIMEOUT = 30000;
    private static final int KEEP_ALIVE_INTERVAL_ENABLE = 300;
    private static final int KEEP_ALIVE_INTERVAL_DISABLE = 0;
    protected CryptoServerCSX csx;
    private int connHandle = -1;
    private CryptoServerCSX.SessionContext sessContext = null;
    private String device;
    private int timeout = 30000;
    private ConnectionState connState = ConnectionState.CLOSED;
    private boolean trace = false;
    private PrintStream traceOut;
    private boolean endSessionOnShutdown = false;
    private ShutdownThread shutdownThread;
    private boolean keepSessionAlive = false;
    public static final int E_JCSA = 47488;
    public static final int E_JCSA_TERM = -1182793727;
    public static final int E_JCSA_BLK_LEN = -1182793726;
    public static final int E_JCSA_BAD_ANSW = -1182793725;
    public static final int E_JCSA_BAD_TAG = -1182793724;
    public static final int E_JCSA_AUTH_MAX = -1182793723;
    public static final int E_JCSA_PWD_LEN = -1182793722;
    public static final int E_JCSA_TRANS_NAME = -1182793721;
    public static final int E_JCSA_JCE_ALGO = -1182793720;
    public static final int E_JCSA_GET_CH = -1182793719;
    public static final int E_JCSA_JCE_PROV = -1182793718;
    public static final int E_JCSA_JCE_KEY = -1182793717;
    public static final int E_JCSA_JCE_EXC = -1182793716;
    public static final int E_JCSA_SM_FAIL = -1182793715;
    public static final int E_JCSA_SM_MODE = -1182793714;
    public static final int E_JCSA_SK_DEC = -1182793713;
    public static final int E_JCSA_JNI_ERR = -1182793712;
    public static final int E_JCSA_BAD_PARA = -1182793711;
    public static final int E_JCSA_NO_AUTH = -1182793710;
    public static final int E_JCSA_CHARSET = -1182793709;
    public static final int E_JCSA_DATALEN = -1182793708;
    public static final int E_JCSA_KEY_DECRYPT = -1182793707;
    public static final int E_JCSA_IO = -1182793706;
    public static final int E_JCSA_NO_DEV = -1182793705;
    public static final int E_JCSA_AUTH_MECH = -1182793704;
    public static final int E_JCSA_CLUSTER = 194510850;
    public static final int E_JCSA_CLUSTER_OPEN = -1182793695;
    public static final int E_JCSA_CLUSTER_LOGON = -1182793694;
    public static final int E_JCSA_CLUSTER_EXEC = -1182793693;
    protected static final String CHARSET = "ISO-8859-15";

    protected CryptoServer() throws IOException, CryptoServerException {
        this.csx = new CryptoServerCSX();
    }

    public static String getName() {
        return JCSA_NAME;
    }

    public static double getVersion() {
        return JCSA_VERSION;
    }

    public CryptoServer(String string, int n) throws IOException, NumberFormatException, CryptoServerException {
        this();
        this.open(string, n);
        this.setTimeout(30000);
    }

    public CryptoServer(String string) throws IOException, NumberFormatException, CryptoServerException {
        this();
        this.open(string, 3000);
        this.setTimeout(30000);
    }

    public CryptoServer(CryptoServerConfig cryptoServerConfig) throws IOException, NumberFormatException, CryptoServerException {
        this();
        this.open(cryptoServerConfig.getStringValues("Device", null)[0], cryptoServerConfig.getInt("ConnectionTimeout", 3000));
        this.setTimeout(cryptoServerConfig.getInt("Timeout", 30000));
        this.endSessionOnShutdown = cryptoServerConfig.getBoolean("EndSessionOnShutdown", false);
        this.keepSessionAlive = cryptoServerConfig.getBoolean("KeepSessionAlive", false);
    }

    public synchronized void open(String string, int n) throws CryptoServerException {
        if (this.connState == ConnectionState.CLOSED) {
            this.connHandle = CryptoServerCSX.cs_open_connection(string, n, this.timeout);
            this.device = string;
            this.connState = ConnectionState.OPEN;
        }
    }

    public void open(String string) throws CryptoServerException {
        this.open(string, 3000);
    }

    public synchronized void close() {
        if (this.connState != ConnectionState.CLOSED) {
            switch (this.connState) {
                case AUTHED: {
                    this.endAuthentication();
                    break;
                }
                case SESSION: {
                    this.endSession();
                }
            }
            CryptoServerCSX.cs_close_connection(this.connHandle);
            this.device = "";
            this.connHandle = -1;
            this.connState = ConnectionState.CLOSED;
        }
    }

    public String getDevice() {
        return this.device;
    }

    public synchronized void setTimeout(int n) throws IOException, CryptoServerException {
        if (this.connState != ConnectionState.CLOSED) {
            CryptoServerCSX.cs_set_timeout(this.connHandle, n);
        }
        this.timeout = n;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTrace(PrintStream printStream, boolean bl) {
        this.traceOut = printStream;
        this.trace = bl;
    }

    public byte[] exec(int n, int n2, byte[] byArray) throws IOException, CryptoServerException {
        if (this.trace) {
            CryptoServerUtil.xtrace(this.traceOut, "cmd", byArray);
        }
        byte[] byArray2 = CryptoServerCSX.cs_exec_command(this.connHandle, this.sessContext, n, n2, byArray);
        if (this.trace) {
            CryptoServerUtil.xtrace(this.traceOut, "answ", byArray2);
        }
        return byArray2;
    }

    private synchronized void prepareAuthentication(String string, byte[] byArray, String string2) throws CryptoServerException {
        if (this.sessContext == null) {
            this.sessContext = new CryptoServerCSX.SessionContext(this.csx);
        }
        CryptoServerCSX.cs_prepare_auth(this.connHandle, string, string2, byArray, this.sessContext);
        if (this.connState != ConnectionState.SESSION) {
            this.connState = ConnectionState.AUTHED;
        }
    }

    private synchronized void openSession() throws CryptoServerException {
        if (this.sessContext == null) {
            this.sessContext = new CryptoServerCSX.SessionContext(this.csx);
        }
        CryptoServerCSX.cs_get_sessionkey_ex(this.connHandle, this.sessContext);
        this.connState = ConnectionState.SESSION;
        if (this.keepSessionAlive) {
            CryptoServerCSX.cs_keep_session_alive_ex(this.connHandle, this.sessContext, 300);
        }
        if (this.endSessionOnShutdown) {
            this.shutdownThread = new ShutdownThread(this);
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        }
    }

    public void logonPassword(String string, byte[] byArray) throws IOException, CryptoServerException {
        this.prepareAuthentication(string, byArray, null);
        this.openSession();
    }

    public void logonPassword(String string, String string2) throws IOException, CryptoServerException {
        this.logonPassword(string, string2.getBytes(CHARSET));
    }

    public void logonSign(String string, String string2, String string3) throws IOException, CryptoServerException {
        this.prepareAuthentication(string, string3 != null ? string3.getBytes(CHARSET) : null, string2);
        this.openSession();
    }

    public void logoff() throws IOException, CryptoServerException {
        this.endSession();
    }

    public int getAuthState() throws IOException, CryptoServerException {
        return CryptoServerCSX.cs_get_auth_state(this.connHandle, this.sessContext);
    }

    public void prepareAuthenticationHMAC(String string, byte[] byArray) throws CryptoServerException {
        this.prepareAuthentication(string, byArray, null);
    }

    public void prepareAuthenticationHMAC(String string, String string2) throws CryptoServerException, UnsupportedEncodingException {
        this.prepareAuthentication(string, string2.getBytes(CHARSET), null);
    }

    public void prepareAuthenticationRSASign(String string, String string2, String string3) throws IOException, CryptoServerException {
        this.prepareAuthentication(string, string3 != null ? string3.getBytes(CHARSET) : null, string2);
    }

    public void prepareAuthenticationRSASC(String string, String string2) throws IOException, CryptoServerException {
        this.prepareAuthentication(string, string2.getBytes(CHARSET), null);
    }

    public synchronized void endAuthentication() {
        if (this.connState == ConnectionState.AUTHED) {
            CryptoServerCSX.cs_end_authentication(this.sessContext);
            this.sessContext = null;
            this.connState = ConnectionState.OPEN;
        }
    }

    public void getSessionKeyDH() throws IOException, CryptoServerException {
        this.openSession();
    }

    public synchronized void setKeepSessionAlive(boolean bl) throws CryptoServerException {
        this.keepSessionAlive = bl;
        if (this.connState == ConnectionState.SESSION) {
            CryptoServerCSX.cs_keep_session_alive_ex(this.connHandle, this.sessContext, bl ? 300 : 0);
        }
    }

    public void setEndSessionOnShutdown(boolean bl) {
        this.endSessionOnShutdown = bl;
    }

    public synchronized void endSession() {
        if (this.connState == ConnectionState.SESSION) {
            CryptoServerCSX.cs_end_session(this.connHandle, this.sessContext);
            this.sessContext = null;
            this.connState = ConnectionState.OPEN;
        }
        try {
            if (this.shutdownThread != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
                this.shutdownThread = null;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void logonSC(String string, String string2) throws IOException, CryptoServerException {
        this.logonSign(string, null, string2);
    }

    public void getSessionKeyDH(int n) throws IOException, CryptoServerException {
        this.openSession();
    }

    public void keepSessionAlive() throws CryptoServerException {
        this.setKeepSessionAlive(true);
    }

    public void setTrace(PrintStream printStream) {
        this.setTrace(printStream, true);
    }

    public void setTrace(boolean bl) {
        this.setTrace(System.out, bl);
    }

    private static class ShutdownThread
    extends Thread {
        private CryptoServer cs;

        ShutdownThread(CryptoServer cryptoServer) {
            this.cs = cryptoServer;
        }

        public void run() {
            try {
                this.cs.setTimeout(1000);
                this.cs.endSession();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConnectionState {
        CLOSED,
        OPEN,
        AUTHED,
        SESSION;

    }
}

