/*
 * Decompiled with CFR 0.152.
 */
package defaults;

import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.CryptoServerProviderBuilder;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECPublicKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class sign_EC {
    public static void main(String[] stringArray) throws Exception {
        System.out.println("\n--- Utimaco CryptoServer JCE - sign_EC ---\n");
        String[] stringArray2 = new String[]{"brainpoolP160r1", "brainpoolP256r1", "brainpoolP320r1", "brainpoolP384r1", "brainpoolP512r1", "brainpoolP160t1", "brainpoolP256t1", "brainpoolP320t1", "brainpoolP384t1", "brainpoolP512t1", "sect113r1", "sect233r1", "sect283r1", "sect409r1", "sect571r1", "sect163r2", "sect163k1", "sect233k1", "sect283k1", "sect409k1", "sect571k1", "secp112r1", "secp128r1", "secp160r1", "secp112r2", "secp128r2", "secp160r2", "secp160k1", "secp192k1", "secp224k1", "secp256k1"};
        String[] stringArray3 = new String[]{"SHA1withECDSA", "SHA224withECDSA", "SHA256withECDSA", "SHA384withECDSA", "SHA512withECDSA", "SHA3-224withECDSA", "SHA3-256withECDSA", "SHA3-384withECDSA", "SHA3-512withECDSA", "NONEwithECDSA"};
        CryptoServerProvider cryptoServerProvider = null;
        try {
            CryptoServerProviderBuilder cryptoServerProviderBuilder = new CryptoServerProviderBuilder();
            cryptoServerProvider = cryptoServerProviderBuilder.build();
            cryptoServerProvider.loginPassword("JCE", "12345678");
            Security.addProvider((Provider)new BouncyCastleProvider());
            Security.addProvider((Provider)cryptoServerProvider);
            Provider[] providerArray = new Provider[]{cryptoServerProvider, Security.getProvider("BC")};
            for (int i = 0; i <= 2; ++i) {
                System.out.println("\nSign on  : " + providerArray[i & 1].getName());
                System.out.println("Verify on: " + providerArray[i >> 1 & 1].getName());
                Provider provider = providerArray[i & 1];
                Provider provider2 = providerArray[i >> 1 & 1];
                for (String string : stringArray2) {
                    System.out.println("curve: " + string);
                    KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", providerArray[i & 1]);
                    keyPairGenerator.initialize(new ECGenParameterSpec(string));
                    KeyPair keyPair = keyPairGenerator.generateKeyPair();
                    PrivateKey privateKey = keyPair.getPrivate();
                    KeyFactory keyFactory = KeyFactory.getInstance("EC", providerArray[i & 1]);
                    ECPublicKeySpec eCPublicKeySpec = keyFactory.getKeySpec(keyPair.getPublic(), ECPublicKeySpec.class);
                    keyFactory = KeyFactory.getInstance("EC", providerArray[i >> 1 & 1]);
                    PublicKey publicKey = keyFactory.generatePublic(eCPublicKeySpec);
                    for (String string2 : stringArray3) {
                        System.out.println("  algo: " + string2);
                        Signature signature = Signature.getInstance(string2, provider);
                        Signature signature2 = Signature.getInstance(string2, provider2);
                        for (int j = 1; j < 3; j += 3) {
                            byte[] byArray = string2.indexOf("NONE") < 0 ? sign_EC.getRandom(j) : sign_EC.getRandom(10);
                            for (int k = 1; k < 22; k += 2) {
                                byte[] byArray2 = string2.indexOf("NONE") < 0 ? sign_EC.getRandom(k) : sign_EC.getRandom(10);
                                byte[] byArray3 = sign_EC.cat(byArray, byArray2);
                                signature.initSign(privateKey);
                                signature.update(byArray);
                                signature.update(byArray2);
                                byte[] byArray4 = signature.sign();
                                signature2.initVerify(publicKey);
                                signature2.update(byArray3);
                                if (signature2.verify(byArray4)) continue;
                                throw new Exception("Signature Verification failed");
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (cryptoServerProvider != null) {
                cryptoServerProvider.close();
            }
        }
        System.out.println("Done");
    }

    private static byte[] getRandom(int n) {
        try {
            byte[] byArray = new byte[n];
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            if (n > 0) {
                do {
                    secureRandom.nextBytes(byArray);
                } while (byArray[0] == 0);
            }
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static byte[] cat(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2;
        }
        if (byArray2 == null) {
            return byArray;
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }
}

