/*
 * Decompiled with CFR 0.152.
 */
package defaults;

import CryptoServerAPI.CryptoServerUtil;
import CryptoServerJCE.CryptoServerKeyGenParameterSpec;
import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.CryptoServerRSAKeyGenParameterSpec;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class key_Wrap_RSA {
    public static void main(String[] stringArray) throws Exception {
        System.out.println("\n--- Utimaco CryptoServer JCE: key_Wrap_RSA ---\n");
        byte[] byArray = "Hello World".getBytes();
        CryptoServerProvider cryptoServerProvider = null;
        try {
            cryptoServerProvider = stringArray.length > 0 ? new CryptoServerProvider(stringArray[0]) : new CryptoServerProvider(key_Wrap_RSA.class.getResourceAsStream("/CryptoServer.cfg"));
            cryptoServerProvider.loginPassword("JCE", "12345678");
            KeyStore keyStore = KeyStore.getInstance("CryptoServer", (Provider)cryptoServerProvider);
            keyStore.load(null, null);
            CryptoServerRSAKeyGenParameterSpec cryptoServerRSAKeyGenParameterSpec = new CryptoServerRSAKeyGenParameterSpec(1024, new BigInteger("010001", 16));
            cryptoServerRSAKeyGenParameterSpec.setExportable(true);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", (Provider)cryptoServerProvider);
            keyPairGenerator.initialize((AlgorithmParameterSpec)cryptoServerRSAKeyGenParameterSpec, null);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            System.out.println("generate AES key...");
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", (Provider)cryptoServerProvider);
            CryptoServerKeyGenParameterSpec cryptoServerKeyGenParameterSpec = new CryptoServerKeyGenParameterSpec(256);
            cryptoServerKeyGenParameterSpec.setPlainExportable(true);
            keyGenerator.init((AlgorithmParameterSpec)cryptoServerKeyGenParameterSpec, null);
            SecretKey secretKey = keyGenerator.generateKey();
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding", (Provider)cryptoServerProvider);
            cipher.init(1, secretKey);
            byte[] byArray2 = cipher.doFinal(byArray);
            System.out.println("export (wrap) AES key (encrypted with RSA key)...");
            Cipher cipher2 = Cipher.getInstance("RSA/None/PKCS1Padding", (Provider)cryptoServerProvider);
            cipher2.init(3, keyPair.getPublic());
            byte[] byArray3 = cipher2.wrap(secretKey);
            CryptoServerUtil.xtrace((String)"key blob", (byte[])byArray3);
            System.out.println("import (unwrap) encrypted AES key...");
            cipher2.init(4, keyPair.getPrivate());
            secretKey = (SecretKey)cipher2.unwrap(byArray3, "AES", 3);
            cipher.init(2, secretKey);
            byte[] byArray4 = cipher.doFinal(byArray2);
            CryptoServerUtil.xtrace((String)"decrypted test data", (byte[])byArray4);
            if (!Arrays.equals(byArray4, byArray)) {
                throw new Exception("En-/Decryption failed");
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (cryptoServerProvider != null) {
                cryptoServerProvider.close();
            }
        }
        System.out.println("Done");
    }
}

