/*
 * Decompiled with CFR 0.152.
 */
package defaults;

import CryptoServerAPI.CryptoServerUtil;
import CryptoServerJCE.CryptoServerECKeyGenParameterSpec;
import CryptoServerJCE.CryptoServerKeyGenParameterSpec;
import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.CryptoServerRSAKeyGenParameterSpec;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class key_Wrap_AES {
    public static void main(String[] stringArray) throws Exception {
        System.out.println("\n--- Utimaco CryptoServer JCE: key_Wrap_AES ---\n");
        byte[] byArray = "Hello World".getBytes();
        CryptoServerProvider cryptoServerProvider = null;
        try {
            cryptoServerProvider = stringArray.length > 0 ? new CryptoServerProvider(stringArray[0]) : new CryptoServerProvider(key_Wrap_AES.class.getResourceAsStream("/CryptoServer.cfg"));
            cryptoServerProvider.loginPassword("JCE", "12345678");
            KeyStore keyStore = KeyStore.getInstance("CryptoServer", (Provider)cryptoServerProvider);
            keyStore.load(null, null);
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", (Provider)cryptoServerProvider);
            keyGenerator.init((AlgorithmParameterSpec)new CryptoServerKeyGenParameterSpec(256), null);
            SecretKey secretKey = keyGenerator.generateKey();
            keyStore.setKeyEntry("AES_imp_1", secretKey, null, null);
            secretKey = (SecretKey)keyStore.getKey("AES_imp_1", null);
            System.out.println("\ngenerate DES key...");
            CryptoServerKeyGenParameterSpec cryptoServerKeyGenParameterSpec = new CryptoServerKeyGenParameterSpec(168);
            cryptoServerKeyGenParameterSpec.setExportable(true);
            KeyGenerator keyGenerator2 = KeyGenerator.getInstance("DES", (Provider)cryptoServerProvider);
            keyGenerator2.init((AlgorithmParameterSpec)cryptoServerKeyGenParameterSpec, null);
            SecretKey secretKey2 = keyGenerator2.generateKey();
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding", (Provider)cryptoServerProvider);
            cipher.init(1, secretKey2);
            byte[] byArray2 = cipher.doFinal(byArray);
            System.out.println("export (wrap) DES key (encrypted with AES key)...");
            Cipher cipher2 = Cipher.getInstance("AES/ECB/PKCS5Padding", (Provider)cryptoServerProvider);
            cipher2.init(3, secretKey);
            byte[] byArray3 = cipher2.wrap(secretKey2);
            CryptoServerUtil.xtrace((String)("key blob" + byArray3.length), (byte[])byArray3);
            System.out.println("import (unwrap) encrypted DES key...");
            cipher2.init(4, secretKey);
            secretKey2 = (SecretKey)cipher2.unwrap(byArray3, "DES", 3);
            cipher.init(2, secretKey2);
            byte[] byArray4 = cipher.doFinal(byArray2);
            CryptoServerUtil.xtrace((String)"decrypted test data", (byte[])byArray4);
            if (!Arrays.equals(byArray4, byArray)) {
                throw new Exception("En-/Decryption failed");
            }
            System.out.println("\ngenerate DES key...");
            cryptoServerProvider.setProperty("Export", "1");
            keyGenerator2.init(168, null);
            secretKey2 = keyGenerator2.generateKey();
            System.out.println("export (wrap) DES key (encrypted with AES key)...");
            cipher2 = Cipher.getInstance("AES/ECB/PKCS5Padding", (Provider)cryptoServerProvider);
            cipher2.init(3, secretKey);
            byArray3 = cipher2.wrap(secretKey2);
            CryptoServerUtil.xtrace((String)"key blob", (byte[])byArray3);
            cipher2.init(4, secretKey);
            secretKey2 = (SecretKey)cipher2.unwrap(byArray3, "DES", 3);
            cipher.init(1, secretKey2);
            byArray2 = cipher.doFinal(byArray);
            cipher.init(2, secretKey2);
            byArray4 = cipher.doFinal(byArray2);
            CryptoServerUtil.xtrace((String)"decrypted test data", (byte[])byArray4);
            if (!Arrays.equals(byArray4, byArray)) {
                throw new Exception("En-/Decryption failed");
            }
            cryptoServerProvider.setProperty("Export", "0");
            System.out.println("\ngenerate RSA key...");
            CryptoServerRSAKeyGenParameterSpec cryptoServerRSAKeyGenParameterSpec = new CryptoServerRSAKeyGenParameterSpec(1024, new BigInteger("010001", 16));
            cryptoServerRSAKeyGenParameterSpec.setExportable(true);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", (Provider)cryptoServerProvider);
            keyPairGenerator.initialize((AlgorithmParameterSpec)cryptoServerRSAKeyGenParameterSpec, null);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            Signature signature = Signature.getInstance("SHA1withRSA", (Provider)cryptoServerProvider);
            Signature signature2 = Signature.getInstance("SHA1withRSA", (Provider)cryptoServerProvider);
            System.out.println("export (wrap) RSA key (encrypted with AES key)...");
            cipher2 = Cipher.getInstance("AES/ECB/PKCS5Padding", (Provider)cryptoServerProvider);
            cipher2.init(3, secretKey);
            byArray3 = cipher2.wrap(keyPair.getPrivate());
            CryptoServerUtil.xtrace((String)"key blob", (byte[])byArray3);
            System.out.println("import (unwrap) encrypted RSA key...");
            cipher2.init(4, secretKey);
            PrivateKey privateKey = (PrivateKey)cipher2.unwrap(byArray3, "RSA", 2);
            System.out.println("sign test data...");
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray5 = signature.sign();
            System.out.println("verify signature...");
            signature2.initVerify(keyPair.getPublic());
            signature2.update(byArray);
            if (!signature2.verify(byArray5)) {
                throw new Exception("Signature verification failed");
            }
            System.out.println("\ngenerate RSA key...");
            cryptoServerProvider.setProperty("Export", "1");
            keyPairGenerator.initialize(1024, null);
            keyPair = keyPairGenerator.generateKeyPair();
            System.out.println("export (wrap) RSA key (encrypted with AES key)...");
            cipher2 = Cipher.getInstance("AES/ECB/PKCS5Padding", (Provider)cryptoServerProvider);
            cipher2.init(3, secretKey);
            byArray3 = cipher2.wrap(keyPair.getPrivate());
            CryptoServerUtil.xtrace((String)"key blob", (byte[])byArray3);
            cipher2.init(4, secretKey);
            privateKey = (PrivateKey)cipher2.unwrap(byArray3, "RSA", 2);
            System.out.println("sign test data...");
            signature.initSign(privateKey);
            signature.update(byArray);
            byArray5 = signature.sign();
            System.out.println("verify signature...");
            signature2.initVerify(keyPair.getPublic());
            signature2.update(byArray);
            if (!signature2.verify(byArray5)) {
                throw new Exception("Signature verification failed");
            }
            cryptoServerProvider.setProperty("Export", "0");
            System.out.println("\ngenerate EC key...");
            CryptoServerECKeyGenParameterSpec cryptoServerECKeyGenParameterSpec = new CryptoServerECKeyGenParameterSpec("NIST-P384");
            cryptoServerECKeyGenParameterSpec.setExportable(true);
            keyPairGenerator = KeyPairGenerator.getInstance("EC", (Provider)cryptoServerProvider);
            keyPairGenerator.initialize((AlgorithmParameterSpec)cryptoServerECKeyGenParameterSpec, null);
            keyPair = keyPairGenerator.generateKeyPair();
            System.out.println("export (wrap) EC key (encrypted with AES key)...");
            cipher2 = Cipher.getInstance("AES/ECB/PKCS5Padding", (Provider)cryptoServerProvider);
            cipher2.init(3, secretKey);
            byArray3 = cipher2.wrap(keyPair.getPrivate());
            CryptoServerUtil.xtrace((String)"key blob", (byte[])byArray3);
            System.out.println("import (unwrap) encrypted EC key...");
            cipher2.init(4, secretKey);
            privateKey = (PrivateKey)cipher2.unwrap(byArray3, "EC", 2);
            System.out.println("sign test data...");
            signature = Signature.getInstance("SHA512withECDSA", (Provider)cryptoServerProvider);
            signature.initSign(privateKey);
            signature.update(byArray);
            byArray5 = signature.sign();
            System.out.println("verify signature...");
            signature2 = Signature.getInstance("SHA512withECDSA", (Provider)cryptoServerProvider);
            signature2.initVerify(keyPair.getPublic());
            signature2.update(byArray);
            if (!signature2.verify(byArray5)) {
                throw new Exception("Signature verification failed");
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (cryptoServerProvider != null) {
                cryptoServerProvider.close();
            }
        }
        System.out.println("Done");
    }
}

