/*
 * Decompiled with CFR 0.152.
 */
package defaults;

import CryptoServerJCE.CryptoServerProvider;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Enumeration;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;

public class key_Import {
    public static void main(String[] stringArray) throws Exception {
        System.out.println("\n--- Utimaco CryptoServer JCE: key_Import ---\n");
        CryptoServerProvider cryptoServerProvider = null;
        try {
            cryptoServerProvider = stringArray.length > 0 ? new CryptoServerProvider(stringArray[0]) : new CryptoServerProvider(key_Import.class.getResourceAsStream("/CryptoServer.cfg"));
            cryptoServerProvider.loginPassword("JCE", "12345678");
            KeyStore keyStore = KeyStore.getInstance("CryptoServer", (Provider)cryptoServerProvider);
            keyStore.load(null, null);
            System.out.println("import AES key...");
            keyStore.setKeyEntry("AES_imp_1", AESTestKey.getKey((Provider)cryptoServerProvider), null, null);
            SecretKey secretKey = (SecretKey)keyStore.getKey("AES_imp_1", null);
            System.out.println("import DES key...");
            keyStore.setKeyEntry("DES_imp_1", DESTestKey.getKey((Provider)cryptoServerProvider), null, null);
            SecretKey secretKey2 = (SecretKey)keyStore.getKey("DES_imp_1", null);
            System.out.println("import private RSA key...");
            keyStore.setKeyEntry("RSA_prv_imp_1", RSATestKey.getPrivateKey((Provider)cryptoServerProvider), null, (Certificate[])cryptoServerProvider.getDumyCertificateChain());
            System.out.println("import private RSA key (CRT)...");
            keyStore.setKeyEntry("RSA_prv_imp_2", RSATestKey.getPrivateCRTKey((Provider)cryptoServerProvider), null, (Certificate[])cryptoServerProvider.getDumyCertificateChain());
            PrivateKey privateKey = (PrivateKey)keyStore.getKey("RSA_prv_imp_1", null);
            System.out.println("import public RSA key...");
            keyStore.setKeyEntry("RSA_pub_imp_1", RSATestKey.getPublicKey((Provider)cryptoServerProvider), null, null);
            PublicKey publicKey = (PublicKey)keyStore.getKey("RSA_pub_imp_1", null);
            System.out.println("import private EC key...");
            keyStore.setKeyEntry("EC_prv_imp_1", ECTestKey.getPrivateKey((Provider)cryptoServerProvider), null, (Certificate[])cryptoServerProvider.getDumyCertificateChain());
            PrivateKey privateKey2 = (PrivateKey)keyStore.getKey("EC_prv_imp_1", null);
            System.out.println("import public EC key...");
            keyStore.setKeyEntry("EC_pub_imp_1", ECTestKey.getPublicKey((Provider)cryptoServerProvider), null, (Certificate[])cryptoServerProvider.getDumyCertificateChain());
            PublicKey publicKey2 = (PublicKey)keyStore.getKey("EC_pub_imp_1", null);
            Enumeration<String> enumeration = keyStore.aliases();
            System.out.println("\nKeys:\n");
            System.out.println("Type Name             Creation");
            System.out.println("----------------------------------------");
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (keyStore.isKeyEntry(string)) {
                    System.out.print("Key  ");
                }
                if (keyStore.isCertificateEntry(string)) {
                    System.out.print("Cert ");
                }
                System.out.println(String.format("%-16s %s", string, keyStore.getCreationDate(string)));
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (cryptoServerProvider != null) {
                cryptoServerProvider.close();
            }
        }
        System.out.println("Done");
    }

    private static class ECTestKey {
        static final String primeP = "D35E472036BC4FB7E13C785ED201E065F98FCFA6F6F40DEF4F92B9EC7893EC28FCD412B1F1B32E27";
        static final String paramA = "D35E472036BC4FB7E13C785ED201E065F98FCFA6F6F40DEF4F92B9EC7893EC28FCD412B1F1B32E24";
        static final String paramB = "A7F561E038EB1ED560B3D147DB782013064C19F27ED27C6780AAF77FB8A547CEB5B4FEF422340353";
        static final String genX = "925BE9FB01AFC6FB4D3E7D4990010F813408AB106C4F09CB7EE07868CC136FFF3357F624A21BED52";
        static final String genY = "63BA3A7A27483EBF6671DBEF7ABB30EBEE084E58A0B077AD42A5A0989D1EE71B1B9BC0455FB0D2C3";
        static final String order = "D35E472036BC4FB7E13C785ED201E065F98FCFA5B68F12A32D482EC7EE8658E98691555B44C59311";
        static final int cof = 1;
        static final String pubkeyx = "4C687852F26D6CA492D533AFF820007B781E52F06A8518EEA8CAC917D5D86BC4735DAEED9509D473";
        static final String pubkeyy = "554E1D95FE14B1FA842E8DD2CD5B435D47860C73FF7993A82868935E26432A1ED74FC1933011DCE3";
        static final String prvkey = "3F5B81C9C925B5A776C517BFF8105FC7715784AC58AEADCDFAD975825A02A1A603C0FD1C61B32698";

        private ECTestKey() {
        }

        public static ECParameterSpec getParams() throws NoSuchAlgorithmException, InvalidKeySpecException {
            ECParameterSpec eCParameterSpec = new ECParameterSpec(new EllipticCurve(new ECFieldFp(new BigInteger(primeP, 16)), new BigInteger(paramA, 16), new BigInteger(paramB, 16)), new ECPoint(new BigInteger(genX, 16), new BigInteger(genY, 16)), new BigInteger(order, 16), 1);
            return eCParameterSpec;
        }

        public static Key getPrivateKey(Provider provider) throws NoSuchAlgorithmException, InvalidKeySpecException {
            ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(new BigInteger(prvkey, 16), ECTestKey.getParams());
            KeyFactory keyFactory = KeyFactory.getInstance("EC", provider);
            return keyFactory.generatePrivate(eCPrivateKeySpec);
        }

        public static Key getPublicKey(Provider provider) throws NoSuchAlgorithmException, InvalidKeySpecException {
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(new ECPoint(new BigInteger(pubkeyx, 16), new BigInteger(pubkeyy, 16)), ECTestKey.getParams());
            KeyFactory keyFactory = KeyFactory.getInstance("EC", provider);
            return keyFactory.generatePublic(eCPublicKeySpec);
        }
    }

    private static class RSATestKey {
        static final String modulus = "B7F3893AAB150BAFECC1931097893C38751AD728DD56DEB8F1A41097755B5E0664FF32FD902B04EDCFD5E2EF8330FDF07C15F9C2229E53F71446EEDBC82BEA3D1679B2BBC07B269D0832D098B3478189CB1FD9F770ED5231EE9AA05BEBE2D0F13F4813F919EB8B3B14AEEE0EE22EDEB152CB5B5798712CDE28273B7E5AB232EB";
        static final String pExponent = "010001";
        static final String sExponent = "0C69C84467C01B524B5942B9D76800E2D47033BDC3B5F580A879C84ED8320AB5C6C1FBE8657EA9ADFC9CF3DBF2CFEF0AF7ECA9B6828C89A0FE42CD2292AEF7F6FB0B8BC61EAE635CE3ACAADACBB0609666266D28B2760483F169C05E672C5C88D2B5B0F66C6474AA7E75A3D526EFBD865D4CD8457DD8F9D31C4B095827C6B3AD";
        static final String primeP = "D19916EC3E718F393467AD608813306B58F763EF6F1A8FE1251AAAE720D1A6F0E552F95DE53C0FECDFFE0ED9E541FC00F83393C9E1B26789D3A779ACA9A5C905";
        static final String primeQ = "E0ACED5548DFF0A24147FEDE87B22505DC11FBC4F080C3E17A11BA588AE2A40AFCFDF352F9031F8F344E909C2ECCD912E2BA6B864C2DE6CFB4F50E03C17F0F2F";
        static final String coeff = "9EC636117E558F3A1C9E03E54A1FADD9F0A6728F34C5842B6F557D58C92BCB243FDB62AA9751B5AA24B4B5129B253ED97D3A69818C7AD2AA6483C2473C1E52F7";
        static final String pExpP = "9D165DC5C5AF1AA6C70E05355A06F7BD1CBA9D5DB0297A3845B4CCEDD8FD085F77A04E60FF139AE3EFA4DBC0974072FCCF08E8F4DF80F474A9FAD50881454D79";
        static final String pExpQ = "7332D781EA1AC0A4413AAC08E7A4C4ECEB38E151CA4B0BA499D56B29A914AA2DE42845D1DE51E6A5A39940F683DC8ED4EB21D0AE0C7360AC5149710525FA830B";

        private RSATestKey() {
        }

        public static Key getPrivateCRTKey(Provider provider) throws NoSuchAlgorithmException, InvalidKeySpecException {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", provider);
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(new BigInteger(modulus, 16), new BigInteger(pExponent, 16), new BigInteger(sExponent, 16), new BigInteger(primeP, 16), new BigInteger(primeQ, 16), new BigInteger(pExpP, 16), new BigInteger(pExpQ, 16), new BigInteger(coeff, 16));
            return keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
        }

        public static Key getPrivateKey(Provider provider) throws NoSuchAlgorithmException, InvalidKeySpecException {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", provider);
            RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(new BigInteger(modulus, 16), new BigInteger(sExponent, 16));
            return keyFactory.generatePrivate(rSAPrivateKeySpec);
        }

        public static Key getPublicKey(Provider provider) throws NoSuchAlgorithmException, InvalidKeySpecException {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", provider);
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger(modulus, 16), new BigInteger(pExponent, 16));
            return keyFactory.generatePublic(rSAPublicKeySpec);
        }
    }

    private static class DESTestKey {
        static final byte[] desKeyBytes = new byte[]{17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 19};

        private DESTestKey() {
        }

        public static Key getKey(Provider provider) throws NoSuchAlgorithmException, InvalidKeySpecException {
            SecretKeySpec secretKeySpec = new SecretKeySpec(desKeyBytes, "DES");
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES", provider);
            return secretKeyFactory.generateSecret(secretKeySpec);
        }
    }

    private static class AESTestKey {
        static final byte[] aesKeyBytes = new byte[]{-73, -13, -119, 58, -85, 21, 11, -81, -20, -63, -109, 16, -105, -119, 60, 56, 117, 26, -41, 40, -35, 86, -34, -72, -15, -92, 16, -105, 117, 91, 94, 6};

        private AESTestKey() {
        }

        public static Key getKey(Provider provider) throws NoSuchAlgorithmException, InvalidKeySpecException {
            SecretKeySpec secretKeySpec = new SecretKeySpec(aesKeyBytes, "AES");
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("AES", provider);
            return secretKeyFactory.generateSecret(secretKeySpec);
        }
    }
}

