/*
 * Decompiled with CFR 0.152.
 */
package defaults;

import CryptoServerJCE.CryptoServerProvider;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.Cipher;

public class bench_RSA {
    public static void main(String[] stringArray) throws Exception {
        System.out.println("\n--- Utimaco CryptoServer JCE - bench_RSA ---\n");
        byte[] byArray = "+++ data to be signed +++".getBytes();
        int[] nArray = new int[]{1024, 2048, 4096};
        int n = 1000;
        String string = "RSA Bench";
        CryptoServerProvider cryptoServerProvider = null;
        try {
            cryptoServerProvider = stringArray.length > 0 ? new CryptoServerProvider(stringArray[0]) : new CryptoServerProvider(bench_RSA.class.getResourceAsStream("/CryptoServer.cfg"));
            cryptoServerProvider.loginPassword("JCE", "12345678");
            KeyStore keyStore = KeyStore.getInstance("CryptoServer", (Provider)cryptoServerProvider);
            keyStore.load(null, null);
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                System.out.println("\nKey size: " + n2);
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", (Provider)cryptoServerProvider);
                keyPairGenerator.initialize(n2, null);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                PrivateKey privateKey = keyPair.getPrivate();
                PublicKey publicKey = keyPair.getPublic();
                keyStore.setKeyEntry(string, privateKey, null, (Certificate[])cryptoServerProvider.getDumyCertificateChain());
                privateKey = (PrivateKey)keyStore.getKey(string, null);
                Cipher cipher = Cipher.getInstance("RSA/None/NoPadding", (Provider)cryptoServerProvider);
                cipher.init(1, publicKey);
                byte[] byArray2 = cipher.doFinal(byArray);
                byte[] byArray3 = null;
                Date date = new Date();
                for (int j = 0; j < n; ++j) {
                    cipher.init(2, privateKey);
                    byArray3 = cipher.doFinal(byArray2);
                }
                Date date2 = new Date();
                if (!Arrays.equals(byArray3, byArray)) {
                    throw new Exception("data compare failed");
                }
                long l = date2.getTime() - date.getTime();
                System.out.println("  Duration: " + l + " ms");
                long l2 = (long)(n * 1000) / l;
                System.out.println("  Speed: " + l2 + " op/second");
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (cryptoServerProvider != null) {
                cryptoServerProvider.close();
            }
        }
        System.out.println("Done");
    }
}

