/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerAPI;

import CryptoServerAPI.CryptoServerUtil;
import java.io.IOException;
import java.util.Properties;

public class CryptoServerException
extends Exception {
    public int ErrorCode;
    public byte[] ErrorAnswer;
    private static Properties errorTable;

    public CryptoServerException(int n, String string) {
        super(CryptoServerException.getErrorMessage(n, string));
        this.ErrorCode = n;
    }

    public CryptoServerException(int n) {
        super(CryptoServerException.getErrorMessage(n, null));
        this.ErrorCode = n;
    }

    protected CryptoServerException(int n, byte[] byArray) {
        super(CryptoServerException.getErrorMessage(n, null));
        this.ErrorCode = n;
        this.ErrorAnswer = byArray;
    }

    public static void addErrorTable(String string) throws IOException {
        CryptoServerUtil cryptoServerUtil = new CryptoServerUtil();
        Properties properties = new Properties(errorTable);
        cryptoServerUtil.getErrorList(properties, string);
        errorTable = properties;
    }

    public static String getErrorMessage(int n, String string) {
        int n2;
        String string2 = CryptoServerUtil.toHexString(n, 8, '0').toUpperCase();
        int n3 = 8;
        String string3 = string != null ? string + "\nCryptoServer Error " + string2 : "CryptoServer Error " + string2;
        char[] cArray = string2.toCharArray();
        char[] cArray2 = new char[8];
        cArray2[0] = cArray[0];
        cArray2[1] = cArray[1];
        cArray2[2] = cArray[2];
        for (n2 = 3; n2 < 8; ++n2) {
            cArray2[n2] = 120;
        }
        for (n2 = 3; n2 < 8; ++n2) {
            cArray2[n2] = cArray[n2];
            string2 = errorTable.getProperty(new String(cArray2));
            if (string2 == null) continue;
            string3 = string3.concat("\n\t" + string2);
            n3 = n2;
        }
        if (n3 < 7) {
            string3 = string3.concat("\n\terrno = " + (n & 0xFFFFFFF >>> n3 * 4));
        }
        return string3;
    }

    static {
        CryptoServerUtil cryptoServerUtil = new CryptoServerUtil();
        errorTable = new Properties();
        try {
            cryptoServerUtil.getErrorList(errorTable, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

