/*
 * Decompiled with CFR 0.152.
 */
package fips140se;

import CryptoServerJCE.CryptoServerProvider;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.security.spec.RSAPublicKeySpec;

public class sign_RSA_FIPS140SE {
    public static void main(String[] stringArray) throws Exception {
        System.out.println("\n--- Utimaco CryptoServer JCE - sign_RSA ---\n");
        int[] nArray = new int[]{1024, 1234, 1537, 2048};
        Algorithm[] algorithmArray = new Algorithm[]{new Algorithm("SHA1withRSA", null), new Algorithm("SHA256withRSA", null), new Algorithm("SHA384withRSA", null), new Algorithm("SHA512withRSA", null), new Algorithm("SHA1withRSA", PSSParameterSpec.DEFAULT), new Algorithm("SHA1withRSA", new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA1, 32, 1)), new Algorithm("SHA256withRSA", new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA1, 32, 1)), new Algorithm("SHA256withRSA", new PSSParameterSpec("SHA-1", "MGF1", MGF1ParameterSpec.SHA256, 0, 1)), new Algorithm("SHA384withRSA", new PSSParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA1, 48, 1)), new Algorithm("SHA512withRSA", new PSSParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA1, 20, 1))};
        CryptoServerProvider cryptoServerProvider = null;
        try {
            cryptoServerProvider = new CryptoServerProvider(stringArray.length > 0 ? stringArray[0] : "CryptoServer.cfg");
            System.out.println("Device  : " + cryptoServerProvider.getCryptoServer().getDevice());
            cryptoServerProvider.loginPassword("JCE", "12345678");
            for (int i = 0; i < 2; ++i) {
                for (Algorithm algorithm : algorithmArray) {
                    String string = algorithm.algo;
                    System.out.println("algo: " + string);
                    CryptoServerProvider cryptoServerProvider2 = cryptoServerProvider;
                    CryptoServerProvider cryptoServerProvider3 = cryptoServerProvider;
                    System.out.println("  Sign on  : " + cryptoServerProvider2.getName());
                    System.out.println("  Verify on: " + cryptoServerProvider3.getName());
                    for (int n : nArray) {
                        System.out.println("    size: " + n);
                        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", cryptoServerProvider2);
                        keyPairGenerator.initialize(n);
                        KeyPair keyPair = keyPairGenerator.generateKeyPair();
                        PrivateKey privateKey = keyPair.getPrivate();
                        KeyFactory keyFactory = KeyFactory.getInstance("RSA", cryptoServerProvider2);
                        RSAPublicKeySpec rSAPublicKeySpec = keyFactory.getKeySpec(keyPair.getPublic(), RSAPublicKeySpec.class);
                        keyFactory = KeyFactory.getInstance("RSA", cryptoServerProvider3);
                        PublicKey publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
                        Signature signature = Signature.getInstance(string, cryptoServerProvider2);
                        Signature signature2 = Signature.getInstance(string, cryptoServerProvider3);
                        for (int j = 1; j < 33; j += 3) {
                            byte[] byArray = sign_RSA_FIPS140SE.getRandom(j);
                            for (int k = 1; k < 22; k += 2) {
                                byte[] byArray2 = sign_RSA_FIPS140SE.getRandom(k);
                                signature.initSign(privateKey);
                                if (algorithm.param != null) {
                                    signature.setParameter(algorithm.param);
                                }
                                signature.update(byArray);
                                signature.update(byArray2);
                                byte[] byArray3 = signature.sign();
                                byte[] byArray4 = sign_RSA_FIPS140SE.cat(byArray, byArray2);
                                signature2.initVerify(publicKey);
                                if (algorithm.param != null) {
                                    signature2.setParameter(algorithm.param);
                                }
                                signature2.update(byArray4);
                                if (signature2.verify(byArray3)) continue;
                                throw new Exception("Signature Verification failed");
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (cryptoServerProvider != null) {
                cryptoServerProvider.logoff();
            }
        }
        System.out.println("Done");
    }

    private static byte[] getRandom(int n) {
        try {
            byte[] byArray = new byte[n];
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            do {
                secureRandom.nextBytes(byArray);
            } while (byArray[0] == 0);
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static byte[] cat(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2;
        }
        if (byArray2 == null) {
            return byArray;
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    private static class Algorithm {
        String algo;
        AlgorithmParameterSpec param;

        public Algorithm(String string, AlgorithmParameterSpec algorithmParameterSpec) {
            this.algo = string;
            this.param = algorithmParameterSpec;
        }
    }
}

