/*
 * Decompiled with CFR 0.152.
 */
package defaults;

import CryptoServerJCE.CryptoServerProvider;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.security.spec.RSAPublicKeySpec;

public class sign_RSA {
    public static void main(String[] stringArray) throws Exception {
        System.out.println("\n--- Utimaco CryptoServer JCE - sign_RSA ---\n");
        int[] nArray = new int[]{1024, 2048, 3072};
        Algorithm[] algorithmArray = new Algorithm[]{new Algorithm("SHA1withRSA", null), new Algorithm("SHA224withRSA", null), new Algorithm("SHA256withRSA", null), new Algorithm("SHA384withRSA", null), new Algorithm("SHA512withRSA", null), new Algorithm("SHA3-224withRSA", null), new Algorithm("SHA3-256withRSA", null), new Algorithm("SHA3-384withRSA", null), new Algorithm("SHA3-512withRSA", null), new Algorithm("MD5withRSA", null), new Algorithm("SHA1withRSA", PSSParameterSpec.DEFAULT), new Algorithm("SHA1withRSA", new PSSParameterSpec("SHA-1", "MGF1", MGF1ParameterSpec.SHA256, 32, 1)), new Algorithm("SHA224withRSA", new PSSParameterSpec("SHA-224", "MGF1", MGF1ParameterSpec.SHA1, 32, 1)), new Algorithm("SHA256withRSA", new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 0, 1)), new Algorithm("SHA384withRSA", new PSSParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA224, 48, 1)), new Algorithm("SHA512withRSA", new PSSParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, 20, 1)), new Algorithm("SHA3-224withRSA", new PSSParameterSpec("SHA3-224", "MGF1", MGF1ParameterSpec.SHA1, 32, 1)), new Algorithm("SHA3-256withRSA", new PSSParameterSpec("SHA3-256", "MGF1", MGF1ParameterSpec.SHA384, 0, 1)), new Algorithm("SHA3-384withRSA", new PSSParameterSpec("SHA3-384", "MGF1", MGF1ParameterSpec.SHA256, 48, 1)), new Algorithm("SHA3-512withRSA", new PSSParameterSpec("SHA3-512", "MGF1", MGF1ParameterSpec.SHA512, 20, 1))};
        CryptoServerProvider cryptoServerProvider = null;
        try {
            cryptoServerProvider = new CryptoServerProvider(stringArray.length > 0 ? stringArray[0] : "CryptoServer.cfg");
            System.out.println("Device : " + cryptoServerProvider.getCryptoServer().getDevice());
            cryptoServerProvider.loginPassword("JCE", "12345678");
            Provider[] providerArray = new Provider[]{cryptoServerProvider, Security.getProvider("SunRsaSign")};
            for (int i = 0; i <= 2; ++i) {
                System.out.println("\nSign on  : " + providerArray[i & 1].getName());
                System.out.println("Verify on: " + providerArray[i >> 1 & 1].getName());
                for (int n : nArray) {
                    System.out.println("  size: " + n);
                    KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", providerArray[i & 1]);
                    keyPairGenerator.initialize(n);
                    KeyPair keyPair = keyPairGenerator.generateKeyPair();
                    PrivateKey privateKey = keyPair.getPrivate();
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA", providerArray[i & 1]);
                    RSAPublicKeySpec rSAPublicKeySpec = keyFactory.getKeySpec(keyPair.getPublic(), RSAPublicKeySpec.class);
                    keyFactory = KeyFactory.getInstance("RSA", providerArray[i >> 1 & 1]);
                    PublicKey publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
                    for (Algorithm algorithm : algorithmArray) {
                        String string = algorithm.algo;
                        if (i > 0 && string.startsWith("SHA3-")) continue;
                        System.out.println("    algo: " + string + (algorithm.param != null ? ",PSS" : ""));
                        Signature signature = Signature.getInstance((i & 1) != 0 && algorithm.param != null ? "RSASSA-PSS" : string, providerArray[i & 1]);
                        Signature signature2 = Signature.getInstance((i >> 1 & 1) != 0 && algorithm.param != null ? "RSASSA-PSS" : string, providerArray[i >> 1 & 1]);
                        for (int j = 1; j < 33; j += 3) {
                            byte[] byArray = sign_RSA.getRandom(j);
                            for (int k = 1; k < 22; k += 2) {
                                byte[] byArray2 = sign_RSA.getRandom(k);
                                signature.initSign(privateKey);
                                if (algorithm.param != null) {
                                    signature.setParameter(algorithm.param);
                                }
                                signature.update(byArray);
                                signature.update(byArray2);
                                byte[] byArray3 = signature.sign();
                                byte[] byArray4 = sign_RSA.cat(byArray, byArray2);
                                signature2.initVerify(publicKey);
                                if (algorithm.param != null) {
                                    signature2.setParameter(algorithm.param);
                                }
                                signature2.update(byArray4);
                                if (signature2.verify(byArray3)) continue;
                                throw new Exception("Signature Verification failed");
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (cryptoServerProvider != null) {
                cryptoServerProvider.logoff();
            }
        }
        System.out.println("Done");
    }

    private static byte[] getRandom(int n) {
        try {
            byte[] byArray = new byte[n];
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            do {
                secureRandom.nextBytes(byArray);
            } while (byArray[0] == 0);
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static byte[] cat(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2;
        }
        if (byArray2 == null) {
            return byArray;
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    private static class Algorithm {
        String algo;
        AlgorithmParameterSpec param;

        public Algorithm(String string, AlgorithmParameterSpec algorithmParameterSpec) {
            this.algo = string;
            this.param = algorithmParameterSpec;
        }
    }
}

