/*
 * Decompiled with CFR 0.152.
 */
package defaults;

import CryptoServerJCE.CryptoServerKeyGenParameterSpec;
import CryptoServerJCE.CryptoServerProvider;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class prov_Login {
    public static SecretKey generateKey(Provider provider) throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", provider);
        CryptoServerKeyGenParameterSpec cryptoServerKeyGenParameterSpec = new CryptoServerKeyGenParameterSpec();
        cryptoServerKeyGenParameterSpec.setKeySize(256);
        keyGenerator.init(cryptoServerKeyGenParameterSpec, null);
        return keyGenerator.generateKey();
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("\n--- Utimaco CryptoServer JCE: prov_Login ---\n");
        String string = null;
        Provider provider = null;
        if (stringArray.length > 1) {
            string = stringArray[1];
        }
        Provider[] providerArray = Security.getProviders();
        System.out.println("List of all Providers:");
        for (int i = 0; i < providerArray.length; ++i) {
            System.out.println("  " + providerArray[i].getName());
        }
        try {
            if (string == null) {
                provider = new CryptoServerProvider(stringArray.length > 0 ? stringArray[0] : "CryptoServer.cfg");
                System.out.println("Device  : " + ((CryptoServerProvider)provider).getCryptoServer().getDevice());
                System.out.println("\nLogin to CryptoServer...");
                switch (1) {
                    case 1: {
                        ((CryptoServerProvider)provider).loginPassword("JCE", "12345678");
                        break;
                    }
                    case 2: {
                        ((CryptoServerProvider)provider).loginSign("JCE_RSA", "rsa.key", null);
                        break;
                    }
                    case 3: {
                        ((CryptoServerProvider)provider).loginSign("JCE_RSA", "rsa_enc.key", "utimaco");
                    }
                }
                System.out.println("OK");
                System.out.println("\nGenerate key...");
                SecretKey secretKey = prov_Login.generateKey(provider);
                System.out.println("OK");
                System.out.println("\nStore key in key store...");
                KeyStore keyStore = KeyStore.getInstance("CryptoServer", provider);
                keyStore.load(null, null);
                keyStore.setKeyEntry("TEST_KEY", secretKey, null, null);
                System.out.println("OK");
            } else {
                provider = Security.getProvider(string);
                if (provider == null) {
                    throw new Exception("Invalid provider: " + string);
                }
                if (provider.getName().equals("CryptoServer")) {
                    System.out.println("\nAccessing key store...");
                    KeyStore keyStore = KeyStore.getInstance("CryptoServer", provider);
                    keyStore.load(null, "12345678".toCharArray());
                }
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (provider != null && provider instanceof CryptoServerProvider) {
                ((CryptoServerProvider)provider).logoff();
            }
        }
        System.out.println("Done");
    }
}

