/*
 * Decompiled with CFR 0.152.
 */
package defaults;

import CryptoServerAPI.CryptoServerUtil;
import CryptoServerJCE.CryptoServerKeyGenParameterSpec;
import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.CryptoServerRSAKeyGenParameterSpec;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class key_Wrap_RSA {
    public static void main(String[] stringArray) throws Exception {
        System.out.println("\n--- Utimaco CryptoServer JCE: key_Wrap_RSA ---\n");
        byte[] byArray = "Hello World".getBytes();
        CryptoServerProvider cryptoServerProvider = null;
        try {
            cryptoServerProvider = new CryptoServerProvider(stringArray.length > 0 ? stringArray[0] : "CryptoServer.cfg");
            System.out.println("Device  : " + cryptoServerProvider.getCryptoServer().getDevice());
            cryptoServerProvider.loginPassword("JCE", "12345678");
            KeyStore keyStore = KeyStore.getInstance("CryptoServer", cryptoServerProvider);
            keyStore.load(null, null);
            CryptoServerRSAKeyGenParameterSpec cryptoServerRSAKeyGenParameterSpec = new CryptoServerRSAKeyGenParameterSpec(1024, new BigInteger("010001", 16));
            cryptoServerRSAKeyGenParameterSpec.setExportable(true);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", cryptoServerProvider);
            keyPairGenerator.initialize(cryptoServerRSAKeyGenParameterSpec, null);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            System.out.println("generate AES key...");
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", cryptoServerProvider);
            CryptoServerKeyGenParameterSpec cryptoServerKeyGenParameterSpec = new CryptoServerKeyGenParameterSpec(256);
            cryptoServerKeyGenParameterSpec.setPlainExportable(true);
            keyGenerator.init(cryptoServerKeyGenParameterSpec, null);
            SecretKey secretKey = keyGenerator.generateKey();
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding", cryptoServerProvider);
            cipher.init(1, secretKey);
            byte[] byArray2 = cipher.doFinal(byArray);
            System.out.println("export (wrap) AES key (encrypted with RSA key)...");
            Cipher cipher2 = Cipher.getInstance("RSA/None/PKCS1Padding", cryptoServerProvider);
            cipher2.init(3, keyPair.getPublic());
            byte[] byArray3 = cipher2.wrap(secretKey);
            CryptoServerUtil.xtrace("key blob", byArray3);
            System.out.println("import (unwrap) encrypted AES key...");
            cipher2.init(4, keyPair.getPrivate());
            secretKey = (SecretKey)cipher2.unwrap(byArray3, "AES", 3);
            cipher.init(2, secretKey);
            byte[] byArray4 = cipher.doFinal(byArray2);
            CryptoServerUtil.xtrace("decrypted test data", byArray4);
            if (!Arrays.equals(byArray4, byArray)) {
                throw new Exception("En-/Decryption failed");
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (cryptoServerProvider != null) {
                cryptoServerProvider.logoff();
            }
        }
        System.out.println("Done");
    }

    private static class RSATestKey {
        static final String modulus = "B7F3893AAB150BAFECC1931097893C38751AD728DD56DEB8F1A41097755B5E0664FF32FD902B04EDCFD5E2EF8330FDF07C15F9C2229E53F71446EEDBC82BEA3D1679B2BBC07B269D0832D098B3478189CB1FD9F770ED5231EE9AA05BEBE2D0F13F4813F919EB8B3B14AEEE0EE22EDEB152CB5B5798712CDE28273B7E5AB232EB";
        static final String pExponent = "010001";
        static final String sExponent = "0C69C84467C01B524B5942B9D76800E2D47033BDC3B5F580A879C84ED8320AB5C6C1FBE8657EA9ADFC9CF3DBF2CFEF0AF7ECA9B6828C89A0FE42CD2292AEF7F6FB0B8BC61EAE635CE3ACAADACBB0609666266D28B2760483F169C05E672C5C88D2B5B0F66C6474AA7E75A3D526EFBD865D4CD8457DD8F9D31C4B095827C6B3AD";
        static final String primeP = "D19916EC3E718F393467AD608813306B58F763EF6F1A8FE1251AAAE720D1A6F0E552F95DE53C0FECDFFE0ED9E541FC00F83393C9E1B26789D3A779ACA9A5C905";
        static final String primeQ = "E0ACED5548DFF0A24147FEDE87B22505DC11FBC4F080C3E17A11BA588AE2A40AFCFDF352F9031F8F344E909C2ECCD912E2BA6B864C2DE6CFB4F50E03C17F0F2F";
        static final String coeff = "9EC636117E558F3A1C9E03E54A1FADD9F0A6728F34C5842B6F557D58C92BCB243FDB62AA9751B5AA24B4B5129B253ED97D3A69818C7AD2AA6483C2473C1E52F7";
        static final String pExpP = "9D165DC5C5AF1AA6C70E05355A06F7BD1CBA9D5DB0297A3845B4CCEDD8FD085F77A04E60FF139AE3EFA4DBC0974072FCCF08E8F4DF80F474A9FAD50881454D79";
        static final String pExpQ = "7332D781EA1AC0A4413AAC08E7A4C4ECEB38E151CA4B0BA499D56B29A914AA2DE42845D1DE51E6A5A39940F683DC8ED4EB21D0AE0C7360AC5149710525FA830B";

        private RSATestKey() {
        }

        public static Key getPrivateCRTKey(Provider provider) throws NoSuchAlgorithmException, InvalidKeySpecException {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", provider);
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(new BigInteger(modulus, 16), new BigInteger(pExponent, 16), new BigInteger(sExponent, 16), new BigInteger(primeP, 16), new BigInteger(primeQ, 16), new BigInteger(pExpP, 16), new BigInteger(pExpQ, 16), new BigInteger(coeff, 16));
            return keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
        }

        public static Key getPrivateKey(Provider provider) throws NoSuchAlgorithmException, InvalidKeySpecException {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", provider);
            RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(new BigInteger(modulus, 16), new BigInteger(sExponent, 16));
            return keyFactory.generatePrivate(rSAPrivateKeySpec);
        }

        public static Key getPublicKey(Provider provider) throws NoSuchAlgorithmException, InvalidKeySpecException {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", provider);
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger(modulus, 16), new BigInteger(pExponent, 16));
            return keyFactory.generatePublic(rSAPublicKeySpec);
        }
    }
}

