/*
 * Decompiled with CFR 0.152.
 */
package defaults;

import CryptoServerAPI.CryptoServerUtil;
import CryptoServerJCE.CryptoServerECKeyGenParameterSpec;
import CryptoServerJCE.CryptoServerKeyGenParameterSpec;
import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.CryptoServerRSAKeyGenParameterSpec;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class key_Wrap_AES {
    public static void main(String[] stringArray) throws Exception {
        System.out.println("\n--- Utimaco CryptoServer JCE: key_Wrap_AES ---\n");
        byte[] byArray = "Hello World".getBytes();
        CryptoServerProvider cryptoServerProvider = null;
        try {
            cryptoServerProvider = new CryptoServerProvider(stringArray.length > 0 ? stringArray[0] : "CryptoServer.cfg");
            System.out.println("Device  : " + cryptoServerProvider.getCryptoServer().getDevice());
            cryptoServerProvider.loginPassword("JCE", "12345678");
            KeyStore keyStore = KeyStore.getInstance("CryptoServer", cryptoServerProvider);
            keyStore.load(null, null);
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", cryptoServerProvider);
            keyGenerator.init(new CryptoServerKeyGenParameterSpec(256), null);
            SecretKey secretKey = keyGenerator.generateKey();
            keyStore.setKeyEntry("AES_imp_1", secretKey, null, null);
            secretKey = (SecretKey)keyStore.getKey("AES_imp_1", null);
            System.out.println("\ngenerate DES key...");
            CryptoServerKeyGenParameterSpec cryptoServerKeyGenParameterSpec = new CryptoServerKeyGenParameterSpec(168);
            cryptoServerKeyGenParameterSpec.setPlainExportable(true);
            KeyGenerator keyGenerator2 = KeyGenerator.getInstance("DES", cryptoServerProvider);
            keyGenerator2.init(cryptoServerKeyGenParameterSpec, null);
            SecretKey secretKey2 = keyGenerator2.generateKey();
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding", cryptoServerProvider);
            cipher.init(1, secretKey2);
            byte[] byArray2 = cipher.doFinal(byArray);
            System.out.println("export (wrap) DES key (encrypted with AES key)...");
            Cipher cipher2 = Cipher.getInstance("AES/ECB/PKCS5Padding", cryptoServerProvider);
            cipher2.init(3, secretKey);
            byte[] byArray3 = cipher2.wrap(secretKey2);
            CryptoServerUtil.xtrace("key blob", byArray3);
            System.out.println("import (unwrap) encrypted DES key...");
            cipher2.init(4, secretKey);
            secretKey2 = (SecretKey)cipher2.unwrap(byArray3, "DES", 3);
            cipher.init(2, secretKey2);
            byte[] byArray4 = cipher.doFinal(byArray2);
            CryptoServerUtil.xtrace("decrypted test data", byArray4);
            if (!Arrays.equals(byArray4, byArray)) {
                throw new Exception("En-/Decryption failed");
            }
            System.out.println("\ngenerate DES key...");
            cryptoServerProvider.setProperty("Export", "1");
            keyGenerator2.init(168, null);
            secretKey2 = keyGenerator2.generateKey();
            System.out.println("export (wrap) DES key (encrypted with AES key)...");
            cipher2 = Cipher.getInstance("AES/ECB/PKCS5Padding", cryptoServerProvider);
            cipher2.init(3, secretKey);
            byArray3 = cipher2.wrap(secretKey2);
            CryptoServerUtil.xtrace("key blob", byArray3);
            cipher2.init(4, secretKey);
            secretKey2 = (SecretKey)cipher2.unwrap(byArray3, "DES", 3);
            cipher.init(1, secretKey2);
            byArray2 = cipher.doFinal(byArray);
            cipher.init(2, secretKey2);
            byArray4 = cipher.doFinal(byArray2);
            CryptoServerUtil.xtrace("decrypted test data", byArray4);
            if (!Arrays.equals(byArray4, byArray)) {
                throw new Exception("En-/Decryption failed");
            }
            cryptoServerProvider.setProperty("Export", "0");
            System.out.println("\ngenerate RSA key...");
            CryptoServerRSAKeyGenParameterSpec cryptoServerRSAKeyGenParameterSpec = new CryptoServerRSAKeyGenParameterSpec(1024, new BigInteger("010001", 16));
            cryptoServerRSAKeyGenParameterSpec.setExportable(true);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", cryptoServerProvider);
            keyPairGenerator.initialize(cryptoServerRSAKeyGenParameterSpec, null);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            Signature signature = Signature.getInstance("SHA1withRSA", cryptoServerProvider);
            Signature signature2 = Signature.getInstance("SHA1withRSA", cryptoServerProvider);
            System.out.println("export (wrap) RSA key (encrypted with AES key)...");
            cipher2 = Cipher.getInstance("AES/ECB/PKCS5Padding", cryptoServerProvider);
            cipher2.init(3, secretKey);
            byArray3 = cipher2.wrap(keyPair.getPrivate());
            CryptoServerUtil.xtrace("key blob", byArray3);
            System.out.println("import (unwrap) encrypted RSA key...");
            cipher2.init(4, secretKey);
            PrivateKey privateKey = (PrivateKey)cipher2.unwrap(byArray3, "RSA", 2);
            System.out.println("sign test data...");
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray5 = signature.sign();
            System.out.println("verify signature...");
            signature2.initVerify(keyPair.getPublic());
            signature2.update(byArray);
            if (!signature2.verify(byArray5)) {
                throw new Exception("Signature verification failed");
            }
            System.out.println("\ngenerate RSA key...");
            cryptoServerProvider.setProperty("Export", "1");
            keyPairGenerator.initialize(1024, null);
            keyPair = keyPairGenerator.generateKeyPair();
            System.out.println("export (wrap) RSA key (encrypted with AES key)...");
            cipher2 = Cipher.getInstance("AES/ECB/PKCS5Padding", cryptoServerProvider);
            cipher2.init(3, secretKey);
            byArray3 = cipher2.wrap(keyPair.getPrivate());
            CryptoServerUtil.xtrace("key blob", byArray3);
            cipher2.init(4, secretKey);
            privateKey = (PrivateKey)cipher2.unwrap(byArray3, "RSA", 2);
            System.out.println("sign test data...");
            signature.initSign(privateKey);
            signature.update(byArray);
            byArray5 = signature.sign();
            System.out.println("verify signature...");
            signature2.initVerify(keyPair.getPublic());
            signature2.update(byArray);
            if (!signature2.verify(byArray5)) {
                throw new Exception("Signature verification failed");
            }
            cryptoServerProvider.setProperty("Export", "0");
            System.out.println("\ngenerate EC key...");
            CryptoServerECKeyGenParameterSpec cryptoServerECKeyGenParameterSpec = new CryptoServerECKeyGenParameterSpec("NIST-P384");
            cryptoServerECKeyGenParameterSpec.setExportable(true);
            keyPairGenerator = KeyPairGenerator.getInstance("EC", cryptoServerProvider);
            keyPairGenerator.initialize(cryptoServerECKeyGenParameterSpec, null);
            keyPair = keyPairGenerator.generateKeyPair();
            System.out.println("export (wrap) EC key (encrypted with AES key)...");
            cipher2 = Cipher.getInstance("AES/ECB/PKCS5Padding", cryptoServerProvider);
            cipher2.init(3, secretKey);
            byArray3 = cipher2.wrap(keyPair.getPrivate());
            CryptoServerUtil.xtrace("key blob", byArray3);
            System.out.println("import (unwrap) encrypted EC key...");
            cipher2.init(4, secretKey);
            privateKey = (PrivateKey)cipher2.unwrap(byArray3, "EC", 2);
            System.out.println("sign test data...");
            signature = Signature.getInstance("SHA512withECDSA", cryptoServerProvider);
            signature.initSign(privateKey);
            signature.update(byArray);
            byArray5 = signature.sign();
            System.out.println("verify signature...");
            signature2 = Signature.getInstance("SHA512withECDSA", cryptoServerProvider);
            signature2.initVerify(keyPair.getPublic());
            signature2.update(byArray);
            if (!signature2.verify(byArray5)) {
                throw new Exception("Signature verification failed");
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (cryptoServerProvider != null) {
                cryptoServerProvider.logoff();
            }
        }
        System.out.println("Done");
    }
}

