/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerAPI.CryptoServerConfig;
import CryptoServerAPI.CryptoServerLog;
import CryptoServerCXI.CryptoServerCXI;

public class Log {
    private static int level;

    public static void init(String string, int n, int n2) {
        level = n;
        CryptoServerCXI.CxiLog.init(string, n, n2);
    }

    public static void init(String string, CryptoServerLog.LogLevel logLevel, int n) {
        level = Log.getLogLevel(logLevel);
        CryptoServerCXI.CxiLog.init(string, logLevel, n);
    }

    public static void init(CryptoServerConfig cryptoServerConfig) {
        level = cryptoServerConfig.getInt("LogLevel", 2);
        CryptoServerCXI.CxiLog.init(cryptoServerConfig);
    }

    public static void log(String string) {
        int n = Log.determineLogLevel(string);
        if (n <= level) {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
            CryptoServerCXI.CxiLog.print(stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName(), string, new Object[0]);
        }
    }

    public static void xlog(String string, byte[] byArray) {
        int n = Log.determineLogLevel(string);
        if (n <= level) {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
            CryptoServerCXI.CxiLog.xtrace(stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName(), string, byArray);
        }
    }

    private static int determineLogLevel(String string) {
        switch (string.charAt(0)) {
            case 'E': {
                return 1;
            }
            case 'W': {
                return 2;
            }
            case 'I': {
                return 3;
            }
            case 'T': {
                return 4;
            }
        }
        return 0;
    }

    private static int getLogLevel(CryptoServerLog.LogLevel logLevel) {
        switch (logLevel) {
            case None: {
                return 0;
            }
            case Error: {
                return 1;
            }
            case Warning: {
                return 2;
            }
            case Info: {
                return 3;
            }
            case Trace: {
                return 4;
            }
        }
        return 2;
    }
}

