/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.Log;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;

public class CryptoServerMessageDigest
extends MessageDigestSpi {
    private final CryptoServerProvider provider;
    private final String algorithm;
    private int mech;
    private final int digestLen;
    private byte[] info = null;
    private boolean err;

    CryptoServerMessageDigest(Provider provider, String string) throws NoSuchAlgorithmException {
        Log.log("T: enter...");
        this.provider = (CryptoServerProvider)provider;
        this.algorithm = string;
        this.mech = 0;
        this.mech |= CryptoServerMessageDigest.selectHashAlgoCXI(string);
        this.digestLen = CryptoServerMessageDigest.setDigestLen(string);
    }

    @Override
    protected int engineGetDigestLength() {
        Log.log("T: enter...");
        return this.digestLen;
    }

    protected String getAlgorithm() {
        Log.log("T: enter...");
        return this.algorithm;
    }

    @Override
    protected byte[] engineDigest() {
        Log.log("T: enter...");
        return this.prvEngineDigest(null);
    }

    protected byte[] engineDigest(byte[] byArray) {
        Log.log("T: enter...");
        return this.prvEngineDigest(byArray);
    }

    @Override
    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        Log.log("T: enter...");
        if (this.err) {
            return 0;
        }
        byte[] byArray2 = this.prvEngineDigest(null);
        int n3 = byArray2.length;
        if (n3 > n2) {
            throw new DigestException("len not sufficent");
        }
        System.arraycopy(byArray2, 0, byArray, n, n3);
        return n3;
    }

    @Override
    protected void engineReset() {
        Log.log("T: enter...");
        this.info = null;
        this.err = false;
    }

    @Override
    protected void engineUpdate(byte by) {
        Log.log("T: enter...");
        this.prvEngineUpdate(new byte[]{by});
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        Log.log("T: enter...");
        byte[] byArray2 = new byte[n2];
        try {
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this.prvEngineUpdate(byArray2);
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            this.err = true;
            exception.printStackTrace();
        }
    }

    protected void engineUpdate(byte[] byArray) {
        Log.log("T: enter...");
        this.prvEngineUpdate(byArray);
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        Log.log("T: enter...");
        try {
            this.prvEngineUpdate(byteBuffer.array());
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            this.err = true;
            exception.printStackTrace();
        }
    }

    private void prvEngineUpdate(byte[] byArray) {
        Log.log("T: enter...");
        if (this.err) {
            return;
        }
        try {
            this.info = this.provider.cs.computeHash(32, this.mech, byArray, this.info, null);
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            this.err = true;
            exception.printStackTrace();
        }
    }

    private byte[] prvEngineDigest(byte[] byArray) {
        Log.log("T: enter...");
        if (this.err) {
            return null;
        }
        try {
            byte[] byArray2 = this.provider.cs.computeHash(0, this.mech, byArray, this.info, null);
            this.engineReset();
            return byArray2;
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            this.err = true;
            exception.printStackTrace();
            return null;
        }
    }

    private static int selectHashAlgoCXI(String string) throws NoSuchAlgorithmException {
        switch (string) {
            case "MD5": {
                return 80;
            }
            case "RMD-160": {
                return 32;
            }
            case "SHA-1": {
                return 16;
            }
            case "SHA-224": {
                return 48;
            }
            case "SHA3-224": {
                return 128;
            }
            case "SHA-256": {
                return 64;
            }
            case "SHA3-256": {
                return 144;
            }
            case "SHA-384": {
                return 96;
            }
            case "SHA3-384": {
                return 160;
            }
            case "SHA-512": {
                return 112;
            }
            case "SHA3-512": {
                return 176;
            }
        }
        throw new NoSuchAlgorithmException();
    }

    private static int setDigestLen(String string) throws NoSuchAlgorithmException {
        switch (string) {
            case "MD5": {
                return 16;
            }
            case "RMD-160": 
            case "SHA-1": {
                return 20;
            }
            case "SHA-224": 
            case "SHA3-224": {
                return 28;
            }
            case "SHA-256": 
            case "SHA3-256": {
                return 32;
            }
            case "SHA-384": 
            case "SHA3-384": {
                return 48;
            }
            case "SHA-512": 
            case "SHA3-512": {
                return 64;
            }
        }
        throw new NoSuchAlgorithmException();
    }
}

