/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import CryptoServerJCE.CryptoServerKey;
import CryptoServerJCE.CryptoServerKeyFactory;
import CryptoServerJCE.CryptoServerPrivateKey;
import CryptoServerJCE.CryptoServerProvider;
import CryptoServerJCE.CryptoServerPublicKey;
import CryptoServerJCE.CryptoServerSecretKey;
import CryptoServerJCE.DumyCertificate;
import CryptoServerJCE.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReentrantLock;

public class CryptoServerKeyStore
extends KeyStoreSpi {
    private final CryptoServerProvider provider;
    private Map<String, Item> keyCache;
    private CryptoServerCXI.KeyStore extKeyStore;

    CryptoServerKeyStore(Provider provider) {
        Log.log("T: enter...");
        this.provider = (CryptoServerProvider)provider;
        this.keyCache = new HashMap<String, Item>();
        if (this.provider.keysExternal) {
            try {
                this.extKeyStore = new CryptoServerCXI.KeyStore(this.provider.keyStorePath, 16);
            }
            catch (Exception exception) {
                Log.log("E:" + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    @Override
    public Key engineGetKey(String string, char[] cArray) throws UnrecoverableKeyException, NoSuchAlgorithmException {
        String string2;
        Item item;
        Log.log("T: enter...");
        try {
            item = this.findItem(string, true);
            if (item == null) {
                return null;
            }
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException(exception.toString());
            unrecoverableKeyException.initCause(exception);
            throw unrecoverableKeyException;
        }
        switch (item.attr.getAlgo()) {
            case 3: {
                string2 = "RSA";
                break;
            }
            case 5: {
                string2 = "DSA";
                break;
            }
            case 4: {
                string2 = "EC";
                break;
            }
            case 2: {
                string2 = "AES";
                break;
            }
            case 1: {
                string2 = "DES";
                break;
            }
            default: {
                throw new NoSuchAlgorithmException();
            }
        }
        switch (item.attr.getType()) {
            case 1: {
                return new CryptoServerPublicKey(this.provider, string2, item.key);
            }
            case 2: 
            case 3: 
            case 7: {
                return new CryptoServerPrivateKey(this.provider, string2, item.key);
            }
            case 8: {
                return new CryptoServerSecretKey(this.provider, string2, item.key);
            }
        }
        throw new UnrecoverableKeyException("unknown key type " + item.attr.getType());
    }

    @Override
    public Date engineGetCreationDate(String string) {
        Item item;
        Log.log("T: enter...");
        try {
            item = this.findItem(string, true);
            if (item == null) {
                return null;
            }
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
        return item.attr.getGenerationDate();
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        String string2;
        Item item;
        Log.log("T: enter...");
        try {
            item = this.findItem(string, true);
            if (item == null) {
                return null;
            }
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
        switch (item.attr.getAlgo()) {
            case 3: {
                string2 = "RSA";
                break;
            }
            case 5: {
                string2 = "DSA";
                break;
            }
            case 4: {
                string2 = "EC";
                break;
            }
            default: {
                return null;
            }
        }
        switch (item.attr.getType()) {
            case 1: 
            case 2: 
            case 3: {
                byte[] byArray = item.attr.getCertificate();
                if (byArray == null) {
                    CryptoServerPublicKey cryptoServerPublicKey = new CryptoServerPublicKey(this.provider, string2, item.key);
                    return new DumyCertificate(cryptoServerPublicKey);
                }
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    return certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                }
                catch (Exception exception) {
                    Log.log("E: " + exception.getMessage());
                    exception.printStackTrace();
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        String string2;
        Item item;
        Log.log("T: enter...");
        try {
            item = this.findItem(string, true);
            if (item == null) {
                return null;
            }
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
        switch (item.attr.getAlgo()) {
            case 3: {
                string2 = "RSA";
                break;
            }
            case 5: {
                string2 = "DSA";
                break;
            }
            case 4: {
                string2 = "EC";
                break;
            }
            default: {
                return null;
            }
        }
        switch (item.attr.getType()) {
            case 1: 
            case 2: 
            case 3: {
                byte[] byArray = item.attr.getCertificate();
                if (byArray == null) {
                    CryptoServerPublicKey cryptoServerPublicKey = new CryptoServerPublicKey(this.provider, string2, item.key);
                    Certificate[] certificateArray = new DumyCertificate[]{new DumyCertificate(cryptoServerPublicKey)};
                    return certificateArray;
                }
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    Certificate[] certificateArray = new X509Certificate[]{(X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray))};
                    return certificateArray;
                }
                catch (Exception exception) {
                    Log.log("E: " + exception.getMessage());
                    exception.printStackTrace();
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        Log.log("T: enter...");
        if (!(key instanceof CryptoServerKey)) {
            Log.log("E: invalid key type: " + key.toString());
            throw new KeyStoreException("invalid key type: " + key.toString());
        }
        try {
            CryptoServerKey cryptoServerKey = (CryptoServerKey)key;
            CryptoServerCXI.Key key2 = cryptoServerKey.key.isHandle() ? cryptoServerKey.provider.cs.backupKey(cryptoServerKey.key) : cryptoServerKey.key;
            CryptoServerCXI.KeyAttributes keyAttributes = new CryptoServerCXI.KeyAttributes();
            if (this.provider.keyGroup.length() != 0) {
                keyAttributes.setGroup(this.provider.keyGroup);
            }
            keyAttributes.setName(string);
            if (certificateArray != null && certificateArray.length > 0) {
                if (certificateArray instanceof X509Certificate[] || certificateArray[0].getType() == "X.509") {
                    X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
                    keyAttributes.setCertificate(x509Certificate.getEncoded());
                } else if (!(certificateArray instanceof DumyCertificate[])) {
                    throw new KeyStoreException("Invalid certificate type: " + certificateArray.toString());
                }
            }
            this.restoreKey(key2, keyAttributes);
            this.keyCache.remove(string);
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            KeyStoreException keyStoreException = new KeyStoreException(exception.toString());
            keyStoreException.initCause(exception);
            throw keyStoreException;
        }
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        Log.log("T: enter...");
        Log.log("E: Bad key");
        throw new KeyStoreException("Bad key");
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Log.log("T: enter...");
        PublicKey publicKey = certificate.getPublicKey();
        if (publicKey == null) {
            Log.log("E: Can't extract public key from certificate");
            throw new KeyStoreException("Can't extract public key from certificate");
        }
        try {
            CryptoServerKey cryptoServerKey;
            PublicKey publicKey2;
            if (publicKey instanceof RSAPublicKey) {
                publicKey2 = (RSAPublicKey)publicKey;
                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(publicKey2.getModulus(), publicKey2.getPublicExponent());
                CryptoServerKeyFactory cryptoServerKeyFactory = new CryptoServerKeyFactory(this.provider, "RSA", 1);
                cryptoServerKey = (CryptoServerKey)((Object)cryptoServerKeyFactory.engineGeneratePublic(rSAPublicKeySpec));
            } else if (publicKey instanceof DSAPublicKey) {
                publicKey2 = (DSAPublicKey)publicKey;
                DSAParams dSAParams = publicKey2.getParams();
                DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(publicKey2.getY(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
                CryptoServerKeyFactory cryptoServerKeyFactory = new CryptoServerKeyFactory(this.provider, "DSA", 2);
                cryptoServerKey = (CryptoServerKey)((Object)cryptoServerKeyFactory.engineGeneratePublic(dSAPublicKeySpec));
            } else if (publicKey instanceof ECPublicKey) {
                publicKey2 = (ECPublicKey)publicKey;
                ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(publicKey2.getW(), publicKey2.getParams());
                CryptoServerKeyFactory cryptoServerKeyFactory = new CryptoServerKeyFactory(this.provider, "EC", 3);
                cryptoServerKey = (CryptoServerKey)((Object)cryptoServerKeyFactory.engineGeneratePublic(eCPublicKeySpec));
            } else if (publicKey instanceof CryptoServerPublicKey) {
                cryptoServerKey = (CryptoServerKey)((Object)publicKey);
            } else {
                throw new KeyStoreException("Invalid public key type: " + publicKey.toString());
            }
            CryptoServerCXI.Key key = cryptoServerKey.key.isHandle() ? cryptoServerKey.provider.cs.backupKey(cryptoServerKey.key) : cryptoServerKey.key;
            publicKey2 = new CryptoServerCXI.KeyAttributes();
            if (this.provider.keyGroup.length() != 0) {
                publicKey2.setGroup(this.provider.keyGroup);
            }
            publicKey2.setName(string);
            if (certificate instanceof X509Certificate || certificate.getType() == "X.509") {
                publicKey2.setCertificate(certificate.getEncoded());
            } else if (!(certificate instanceof DumyCertificate)) {
                throw new KeyStoreException("Invalid certificate type: " + certificate.toString());
            }
            this.restoreKey(key, (CryptoServerCXI.KeyAttributes)publicKey2);
            this.keyCache.remove(string);
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            KeyStoreException keyStoreException = new KeyStoreException(exception.toString());
            keyStoreException.initCause(exception);
            throw keyStoreException;
        }
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        Log.log("T: enter...");
        try {
            Item item = this.findItem(string, false);
            if (item == null) {
                throw new KeyStoreException("Item not found: " + string);
            }
            this.keyCache.remove(string);
            this.deleteKey(item.key);
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            KeyStoreException keyStoreException = new KeyStoreException(exception.toString());
            keyStoreException.initCause(exception);
            throw keyStoreException;
        }
    }

    public Aliases engineAliases() {
        Log.log("T: enter...");
        try {
            CryptoServerCXI.KeyAttributes[] keyAttributesArray = this.listKeys(this.provider.keyGroup, null, this.provider.keySpecifier);
            return new Aliases(keyAttributesArray);
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean engineContainsAlias(String string) {
        Log.log("T: enter...");
        try {
            this.keyCache.remove(string);
            return this.findItem(string, false) != null;
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public int engineSize() {
        Log.log("T: enter...");
        try {
            int n = 0;
            CryptoServerCXI.KeyAttributes[] keyAttributesArray = this.listKeys(this.provider.keyGroup, null, this.provider.keySpecifier);
            for (int i = 0; i < keyAttributesArray.length; ++i) {
                if (keyAttributesArray[i].getName() == null) continue;
                ++n;
            }
            return n;
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            exception.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        Log.log("T: enter...");
        try {
            Item item = this.findItem(string, true);
            return item != null && item.attr.getType() != 1;
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        Log.log("T: enter...");
        try {
            Item item = this.findItem(string, true);
            return item != null && item.attr.getType() == 1;
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        Log.log("T: enter...");
        return null;
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) {
        Log.log("T: enter...");
        try {
            this.provider.changePassword(this.provider.defaultUser, new String(cArray));
        }
        catch (Exception exception) {
            Log.log("E: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException {
        Log.log("T: enter...");
        try {
            if (cArray != null) {
                this.provider.loginPassword(this.provider.defaultUser, new String(cArray));
            }
        }
        catch (CryptoServerException cryptoServerException) {
            Log.log("E: " + cryptoServerException.getMessage());
            IOException iOException = new IOException(cryptoServerException.toString());
            iOException.initCause(cryptoServerException);
            throw iOException;
        }
        this.keyCache.clear();
    }

    private Item findItem(String string, boolean bl) throws IOException, CryptoServerException, NoSuchAlgorithmException {
        Log.log("T: enter...");
        Item item = this.keyCache.get(string);
        if (item != null) {
            return item;
        }
        CryptoServerCXI.KeyAttributes keyAttributes = new CryptoServerCXI.KeyAttributes();
        keyAttributes.setGroup(this.provider.keyGroup);
        keyAttributes.setSpecifier(this.provider.keySpecifier);
        keyAttributes.setName(string);
        item = new Item();
        item.key = this.findKey(keyAttributes, bl);
        if (item.key == null) {
            return null;
        }
        if (bl) {
            item.attr = this.provider.cs.getKeyAttributes(item.key, true);
            if (!this.provider.keysExternal) {
                this.keyCache.put(string, item);
            }
        }
        return item;
    }

    private byte[] generateExtDBIndex(CryptoServerCXI.KeyAttributes keyAttributes) throws CryptoServerException, NoSuchAlgorithmException {
        Log.log("T: enter...");
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        String string = keyAttributes.getName();
        String string2 = keyAttributes.getName();
        String string3 = String.valueOf(keyAttributes.getSpecifier());
        if (string != null && string.length() > 0) {
            messageDigest.update(string.getBytes());
        }
        if (string2 != null && string2.length() > 0) {
            messageDigest.update(string2.getBytes());
        }
        if (string3 != null && string3.length() > 0) {
            messageDigest.update(string3.getBytes());
        }
        return messageDigest.digest();
    }

    private CryptoServerCXI.Key restoreKey(CryptoServerCXI.Key key, CryptoServerCXI.KeyAttributes keyAttributes) throws IOException, CryptoServerException, NoSuchAlgorithmException {
        CryptoServerCXI.Key key2;
        Log.log("T: enter...");
        if (this.provider.keysExternal) {
            key2 = this.provider.cs.restoreKey(3, key, keyAttributes);
            this.extKeyStore.insertKey(1, this.generateExtDBIndex(keyAttributes), key2);
        } else {
            key2 = this.provider.cs.restoreKey(1, key, keyAttributes);
        }
        return key2;
    }

    private void deleteKey(CryptoServerCXI.Key key) throws IOException, CryptoServerException, NoSuchAlgorithmException {
        Log.log("T: enter...");
        if (this.provider.keysExternal) {
            this.extKeyStore.deleteKey(this.generateExtDBIndex(key.getAttributes()));
        } else {
            this.provider.cs.deleteKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CryptoServerCXI.KeyAttributes[] listKeys(String string, String string2, Integer n) throws IOException, CryptoServerException {
        Log.log("T: enter...");
        CryptoServerCXI.KeyAttributes keyAttributes = new CryptoServerCXI.KeyAttributes();
        keyAttributes.setGroup(string.equals("") ? null : string);
        keyAttributes.setName(string2);
        keyAttributes.setSpecifier(n.intValue());
        if (this.provider.keysExternal) {
            int n2 = 1;
            int n3 = 0;
            int n4 = 0;
            byte[] byArray = new byte[this.extKeyStore.getIndexLength()];
            ReentrantLock reentrantLock = new ReentrantLock();
            CryptoServerCXI.KeyAttributes[] keyAttributesArray = null;
            reentrantLock.lock();
            try {
                while (this.extKeyStore.findKey(byArray, n2, keyAttributes)) {
                    ++n3;
                    n2 = 2;
                }
                keyAttributesArray = new CryptoServerCXI.KeyAttributes[n3];
                n2 = 1;
                byArray = new byte[this.extKeyStore.getIndexLength()];
                while (this.extKeyStore.findKey(byArray, n2, keyAttributes)) {
                    n2 = 2;
                    keyAttributesArray[n4++] = this.extKeyStore.getKey(byArray).getAttributes();
                }
            }
            finally {
                reentrantLock.unlock();
            }
            return keyAttributesArray;
        }
        return this.provider.cs.listKeys(keyAttributes);
    }

    private CryptoServerCXI.Key findKey(CryptoServerCXI.KeyAttributes keyAttributes, boolean bl) throws IOException, CryptoServerException, NoSuchAlgorithmException {
        Log.log("T: enter...");
        if (this.provider.keysExternal) {
            return this.extKeyStore.getKey(this.generateExtDBIndex(keyAttributes));
        }
        CryptoServerCXI.Key key = this.provider.cs.findKey(keyAttributes);
        if (key == null || !bl) {
            return key;
        }
        return this.provider.cs.backupKey(key);
    }

    private static class Item {
        protected CryptoServerCXI.Key key;
        protected CryptoServerCXI.KeyAttributes attr;

        Item() {
            Log.log("T: enter...");
        }
    }

    public static class Aliases
    implements Enumeration<String> {
        int idx;
        private CryptoServerCXI.KeyAttributes[] attr;

        public Aliases(CryptoServerCXI.KeyAttributes[] keyAttributesArray) {
            Log.log("T: enter...");
            this.attr = keyAttributesArray;
            this.idx = 0;
        }

        @Override
        public boolean hasMoreElements() {
            Log.log("T: enter...");
            return this.attr != null && this.idx < this.attr.length;
        }

        @Override
        public String nextElement() throws NoSuchElementException {
            Log.log("T: enter...");
            while (this.hasMoreElements()) {
                try {
                    String string;
                    if ((string = this.attr[this.idx++].getName()) == null) continue;
                    return string;
                }
                catch (Exception exception) {
                }
            }
            throw new NoSuchElementException();
        }
    }
}

