/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerJCE;

import CryptoServerCXI.CryptoServerCXI;
import CryptoServerJCE.AsnBuffer;
import CryptoServerJCE.CertBuilder;
import CryptoServerJCE.CryptoServerECKeyGenParameterSpec;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParametersSpi;
import java.security.InvalidParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import sun.security.util.ECKeySizeParameterSpec;

public class CryptoServerECAlgorithmParametersSpi
extends AlgorithmParametersSpi {
    private String curveName = null;
    private static final HashMap<String, String> curveNameAliases = new HashMap();
    private static final String ECURVE_DIR = "/ecurves/";

    protected boolean isASN1FormatString(String string) {
        return string == null || string.equals("ASN.1");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec == null) {
            throw new InvalidParameterSpecException("paramSpec must not be null");
        }
        if (algorithmParameterSpec instanceof CryptoServerECKeyGenParameterSpec) {
            this.curveName = ((CryptoServerECKeyGenParameterSpec)algorithmParameterSpec).name == null ? this.getCurveName(((CryptoServerECKeyGenParameterSpec)algorithmParameterSpec).ecParameter) : ((CryptoServerECKeyGenParameterSpec)algorithmParameterSpec).name;
        } else if (algorithmParameterSpec instanceof ECParameterSpec) {
            this.curveName = this.getCurveName((ECParameterSpec)algorithmParameterSpec);
        } else if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            this.curveName = ((ECGenParameterSpec)algorithmParameterSpec).getName();
        } else if (algorithmParameterSpec instanceof ECKeySizeParameterSpec) {
            int n = ((ECKeySizeParameterSpec)algorithmParameterSpec).getKeySize();
            this.curveName = this.getCurveName(n);
        } else {
            throw new InvalidParameterSpecException("AlgorithmParameterSpec class not recognized: " + algorithmParameterSpec.getClass().getName());
        }
        if (this.curveName == null) {
            throw new InvalidParameterSpecException("Not a supported curve: " + algorithmParameterSpec);
        }
    }

    private String getCurveName(ECParameterSpec eCParameterSpec) throws InvalidParameterSpecException {
        for (String string : new HashSet<String>(curveNameAliases.values())) {
            InputStream inputStream = this.getClass().getResourceAsStream(ECURVE_DIR + string);
            if (inputStream == null) continue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[512];
            try {
                int n;
                while ((n = inputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                inputStream.close();
                ECParameterSpec eCParameterSpec2 = new CryptoServerCXI.ECParameter(byteArrayOutputStream.toByteArray()).getSpec();
                if (!eCParameterSpec2.getOrder().equals(eCParameterSpec.getOrder()) || !eCParameterSpec2.getCurve().equals(eCParameterSpec.getCurve()) || !eCParameterSpec2.getGenerator().equals(eCParameterSpec.getGenerator()) || eCParameterSpec2.getCofactor() != eCParameterSpec.getCofactor()) continue;
                return string;
            }
            catch (Exception exception) {
            }
        }
        throw new InvalidParameterSpecException("Unsupported parameters in AlgorithmParameterSpec");
    }

    private String getCurveName(int n) {
        switch (n) {
            case 160: {
                return "secp160k1";
            }
            case 192: {
                return "NIST-P192";
            }
            case 224: {
                return "NIST-P224";
            }
            case 256: {
                return "NIST-P256";
            }
            case 320: {
                return "brainpoolP320r1";
            }
            case 384: {
                return "NIST-P384";
            }
            case 512: {
                return "brainpoolP512r1";
            }
            case 521: {
                return "NIST-P521";
            }
        }
        throw new InvalidParameterException();
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        this.engineInit(byArray, "ASN.1");
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (this.isASN1FormatString(string)) {
            AsnBuffer asnBuffer = new AsnBuffer(byArray);
            try {
                byte[] byArray2 = asnBuffer.getOID();
                for (CertBuilder.ECCurve eCCurve : CertBuilder.curves) {
                    if (!Arrays.equals(byArray2, eCCurve.oid)) continue;
                    this.curveName = eCCurve.name;
                    return;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        throw new IOException("Only named ECParameters supported");
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz.isAssignableFrom(CryptoServerECKeyGenParameterSpec.class) || clazz == AlgorithmParameterSpec.class) {
            return new CryptoServerECKeyGenParameterSpec(this.curveName);
        }
        if (clazz.isAssignableFrom(ECParameterSpec.class)) {
            try {
                CryptoServerCXI.ECParameter eCParameter = new CryptoServerCXI.ECParameter(CryptoServerCXI.ECParameter.getEncoded((Object)this, (String)curveNameAliases.getOrDefault(this.curveName, this.curveName)));
                return eCParameter.getSpec();
            }
            catch (Exception exception) {}
        } else {
            if (clazz.isAssignableFrom(ECGenParameterSpec.class)) {
                return new ECGenParameterSpec(this.curveName);
            }
            if (clazz.isAssignableFrom(ECKeySizeParameterSpec.class)) {
                try {
                    CryptoServerCXI.ECParameter eCParameter = new CryptoServerCXI.ECParameter(CryptoServerCXI.ECParameter.getEncoded((Object)this, (String)curveNameAliases.getOrDefault(this.curveName, this.curveName)));
                    return new ECKeySizeParameterSpec(eCParameter.getSpec().getCurve().getField().getFieldSize());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        throw new InvalidParameterSpecException("EC AlgorithmParameters cannot convert to " + clazz.getName());
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        return this.engineGetEncoded("ASN.1");
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        if (this.isASN1FormatString(string)) {
            byte[] byArray = null;
            for (CertBuilder.ECCurve eCCurve : CertBuilder.curves) {
                if (!eCCurve.name.equals(curveNameAliases.getOrDefault(this.curveName, this.curveName))) continue;
                byArray = eCCurve.oid;
                break;
            }
            if (byArray == null) {
                throw new IOException("Unsupported EC parameter: " + this.curveName);
            }
            try {
                AsnBuffer asnBuffer = new AsnBuffer();
                asnBuffer.addItem(6, byArray);
                return asnBuffer.getData();
            }
            catch (ParseException parseException) {
                throw new IOException(parseException);
            }
        }
        throw new IOException("Unknown parameters format in AlgorithmParameters object: " + string);
    }

    @Override
    protected String engineToString() {
        if (this.curveName == null) {
            return "Not initialized";
        }
        return this.curveName;
    }

    static {
        curveNameAliases.put("secp192r1", "NIST-P192");
        curveNameAliases.put("secp224r1", "NIST-P224");
        curveNameAliases.put("secp256r1", "NIST-P256");
        curveNameAliases.put("secp384r1", "NIST-P384");
        curveNameAliases.put("secp521r1", "NIST-P521");
        curveNameAliases.put("1.2.840.10045.3.1.1", "NIST-P192");
        curveNameAliases.put("1.2.840.10045.3.1.7", "NIST-P256");
        curveNameAliases.put("1.3.132.0.1", "sect163k1");
        curveNameAliases.put("1.3.132.0.4", "sect113r1");
        curveNameAliases.put("1.3.132.0.6", "secp112r1");
        curveNameAliases.put("1.3.132.0.7", "secp112r2");
        curveNameAliases.put("1.3.132.0.8", "secp160r1");
        curveNameAliases.put("1.3.132.0.9", "secp160k1");
        curveNameAliases.put("1.3.132.0.10", "secp256k1");
        curveNameAliases.put("1.3.132.0.15", "sect163r2");
        curveNameAliases.put("1.3.132.0.16", "sect283k1");
        curveNameAliases.put("1.3.132.0.17", "sect283r1");
        curveNameAliases.put("1.3.132.0.26", "sect233k1");
        curveNameAliases.put("1.3.132.0.27", "sect233r1");
        curveNameAliases.put("1.3.132.0.28", "secp128r1");
        curveNameAliases.put("1.3.132.0.29", "secp128r2");
        curveNameAliases.put("1.3.132.0.30", "secp160r2");
        curveNameAliases.put("1.3.132.0.31", "secp192k1");
        curveNameAliases.put("1.3.132.0.32", "secp224k1");
        curveNameAliases.put("1.3.132.0.33", "NIST-P224");
        curveNameAliases.put("1.3.132.0.34", "NIST-P384");
        curveNameAliases.put("1.3.132.0.35", "NIST-P521");
        curveNameAliases.put("1.3.132.0.36", "sect409k1");
        curveNameAliases.put("1.3.132.0.37", "sect409r1");
        curveNameAliases.put("1.3.132.0.38", "sect571k1");
        curveNameAliases.put("1.3.132.0.39", "sect571r1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.1", "brainpoolP160r1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.2", "brainpoolP160t1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.3", "brainpoolP192r1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.4", "brainpoolP192t1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.5", "brainpoolP224r1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.6", "brainpoolP224t1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.7", "brainpoolP256r1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.8", "brainpoolP256t1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.9", "brainpoolP320r1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.10", "brainpoolP320t1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.11", "brainpoolP384r1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.12", "brainpoolP384t1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.13", "brainpoolP512r1");
        curveNameAliases.put("1.3.36.3.3.2.8.1.1.14", "brainpoolP512t1");
    }
}

