/*
 * Decompiled with CFR 0.152.
 */
package CryptoServerAPI;

import CryptoServerAPI.CryptoServerException;
import java.io.IOException;

public class CryptoServerDatabase {
    public static final String CHARSET = "ISO-8859-15";
    private static IOException exception;
    private String filename;
    private int handle;
    private int errorCode;
    public static final int SDB_RDONLY = 0;
    public static final int SDB_RDWR = 1;
    public static final int SDB_CREAT = 2;
    public static final int SDB_LOCK = 4;
    public static final int SDB_EQUAL = 0;
    public static final int SDB_GTEQ = 1;
    public static final int SDB_GREATER = 2;
    public static final int E_JCSA_DB = 12156931;
    public static final int E_JCSA_DB_JNI_ERR = -1182792960;

    private native int nopen(byte[] var1, int var2, int var3);

    private native void nclose(int var1);

    private native int ngetidxlen(int var1);

    private native byte[] nfind(int var1, int var2, byte[] var3);

    private native void ninsert(int var1, byte[] var2, byte[] var3);

    private native void nupdate(int var1, byte[] var2, byte[] var3);

    private native void ndelete(int var1, byte[] var2);

    private native void nlock(int var1);

    private native void nunlock(int var1);

    public CryptoServerDatabase(String string, int n) throws IOException, CryptoServerException {
        if (exception != null) {
            throw exception;
        }
        this.errorCode = -1182792960;
        this.handle = this.nopen(string.getBytes(CHARSET), 2, n);
        if (this.errorCode != 0) {
            throw new CryptoServerException(this.errorCode);
        }
        this.filename = string;
    }

    public void close() {
        if (this.handle >= 0) {
            this.nclose(this.handle);
        }
        this.handle = -1;
    }

    protected void finalize() {
        this.close();
    }

    public int getIndexLength() throws CryptoServerException {
        this.errorCode = -1182792960;
        int n = this.ngetidxlen(this.handle);
        if (this.errorCode != 0) {
            throw new CryptoServerException(this.errorCode);
        }
        return n;
    }

    public byte[] find(int n, byte[] byArray) throws CryptoServerException {
        this.errorCode = -1182792960;
        byte[] byArray2 = this.nfind(this.handle, n, byArray);
        if (this.errorCode != 0) {
            throw new CryptoServerException(this.errorCode);
        }
        return byArray2;
    }

    public void insert(byte[] byArray, byte[] byArray2) throws CryptoServerException {
        this.errorCode = -1182792960;
        this.ninsert(this.handle, byArray, byArray2);
        if (this.errorCode != 0) {
            throw new CryptoServerException(this.errorCode);
        }
    }

    public void update(byte[] byArray, byte[] byArray2) throws CryptoServerException {
        this.errorCode = -1182792960;
        this.nupdate(this.handle, byArray, byArray2);
        if (this.errorCode != 0) {
            throw new CryptoServerException(this.errorCode);
        }
    }

    public void delete(byte[] byArray) throws CryptoServerException {
        this.errorCode = -1182792960;
        this.ndelete(this.handle, byArray);
        if (this.errorCode != 0) {
            throw new CryptoServerException(this.errorCode);
        }
    }

    public void lock() throws CryptoServerException {
        this.errorCode = -1182792960;
        this.nlock(this.handle);
        if (this.errorCode != 0) {
            throw new CryptoServerException(this.errorCode);
        }
    }

    public void unlock() throws CryptoServerException {
        this.errorCode = -1182792960;
        this.nunlock(this.handle);
        if (this.errorCode != 0) {
            throw new CryptoServerException(this.errorCode);
        }
    }
}

