/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view.slotMng;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import p11cat.LayoutHelper;
import p11cat.Messages;
import p11cat.StatusInfo;
import p11cat.controller.CommandAction;
import p11cat.controller.task.SetPinTask;
import p11cat.view.CommandNodePanel;
import p11cat.view.ListenerButton;
import p11cat.view.slotMng.SlotMngPanel;

class SetPinPanel
extends CommandNodePanel {
    private static final long serialVersionUID = -5930499066615542058L;
    private StatusInfo statusInfo;
    private SlotMngPanel parent;
    private JPasswordField oldPinField;
    private JPasswordField newPinField;
    private JPasswordField confirmNewPinField;
    private ListenerButton button;

    public SetPinPanel(StatusInfo statusInfo, SlotMngPanel slotMngPanel) {
        this.statusInfo = statusInfo;
        this.parent = slotMngPanel;
        this.oldPinField = new JPasswordField(20);
        this.oldPinField.setText("");
        JLabel jLabel = new JLabel(Messages.getString("P11CAT.SlotMng.SetPin.LabelOldPin"));
        jLabel.setLabelFor(this.oldPinField);
        this.newPinField = new JPasswordField(20);
        this.newPinField.setText("");
        JLabel jLabel2 = new JLabel(Messages.getString("P11CAT.SlotMng.SetPin.LabelNewPin"));
        jLabel2.setLabelFor(this.newPinField);
        this.confirmNewPinField = new JPasswordField(20);
        this.confirmNewPinField.setText("");
        JLabel jLabel3 = new JLabel(Messages.getString("P11CAT.SlotMng.SetPin.LabelConfirmNewPin"));
        jLabel3.setLabelFor(this.confirmNewPinField);
        JTextField[] jTextFieldArray = new JTextField[]{this.oldPinField, this.newPinField, this.confirmNewPinField};
        this.button = new ListenerButton(new CommandAction(Messages.getString("P11CAT.SlotMng.SetPin.ButtonText"), this), jTextFieldArray);
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        this.add(jLabel);
        this.add(this.oldPinField);
        this.add(jLabel2);
        this.add(this.newPinField);
        this.add(jLabel3);
        this.add(this.confirmNewPinField);
        this.add(this.button);
        int[][] nArrayArray = new int[][]{{0, 1}, {2, 3}, {4, 5}, {-1, 6}};
        int[] nArray = new int[]{5, 5, 5};
        int[] nArray2 = new int[]{5, 5, 5, 5, 5};
        LayoutHelper.makeSpringGrid(this, nArrayArray, nArray, nArray2);
    }

    @Override
    public void init() {
        this.oldPinField.setText("");
        this.newPinField.setText("");
        this.confirmNewPinField.setText("");
        this.button.setEnabled(false);
    }

    @Override
    public void executeCommand(ActionEvent actionEvent) {
        if (!Arrays.equals(this.newPinField.getPassword(), this.confirmNewPinField.getPassword())) {
            long l = this.statusInfo.getActiveSlotId();
            this.statusInfo.printError(Messages.getString("P11CAT.Error.SetPin.PinNotMatched"), l);
            this.newPinField.setText("");
            this.confirmNewPinField.setText("");
            return;
        }
        new SetPinTask(this.statusInfo, this.parent, new String(this.oldPinField.getPassword()), new String(this.newPinField.getPassword())).execute();
    }
}

