/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view.slotMng;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import p11cat.Constants;
import p11cat.LayoutHelper;
import p11cat.Messages;
import p11cat.StatusInfo;
import p11cat.controller.CommandAction;
import p11cat.controller.task.InitTokenTask;
import p11cat.view.CommandNodePanel;
import p11cat.view.ListenerButton;
import p11cat.view.slotMng.SlotMngPanel;

class InitTokenPanel
extends CommandNodePanel {
    private static final long serialVersionUID = -890331237246621533L;
    private StatusInfo statusInfo;
    private SlotMngPanel parent;
    private JTextField labelField;
    private JPasswordField soPinField;
    private JPasswordField confirmSOPinField;
    private JLabel confirmSOPinFieldLabel;
    private ListenerButton button;

    public InitTokenPanel(StatusInfo statusInfo, SlotMngPanel slotMngPanel) {
        this.statusInfo = statusInfo;
        this.parent = slotMngPanel;
        this.labelField = new JTextField(20);
        this.labelField.setText(Messages.getString("P11CAT.SlotMng.InitToken.DefaultLabel"));
        JLabel jLabel = new JLabel(Messages.getString("P11CAT.SlotMng.InitToken.LabelLabel"));
        jLabel.setLabelFor(this.labelField);
        this.soPinField = new JPasswordField(20);
        this.soPinField.setText("");
        JLabel jLabel2 = new JLabel(Messages.getString("P11CAT.SlotMng.InitToken.LabelPin"));
        jLabel2.setLabelFor(this.soPinField);
        this.confirmSOPinField = new JPasswordField(20);
        this.confirmSOPinField.setText("");
        this.confirmSOPinFieldLabel = new JLabel(Messages.getString("P11CAT.SlotMng.InitToken.LabelConfirmPin"));
        this.confirmSOPinFieldLabel.setLabelFor(this.confirmSOPinField);
        JTextField[] jTextFieldArray = new JTextField[]{this.soPinField, this.confirmSOPinField};
        this.button = new ListenerButton(new CommandAction(Messages.getString("P11CAT.SlotMng.InitToken.ButtonText"), this), jTextFieldArray);
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        this.add(jLabel);
        this.add(this.labelField);
        this.add(jLabel2);
        this.add(this.soPinField);
        this.add(this.confirmSOPinFieldLabel);
        this.add(this.confirmSOPinField);
        this.add(this.button);
        int[][] nArrayArray = new int[][]{{0, 1}, {2, 3}, {4, 5}, {-1, 6}};
        int[] nArray = new int[]{5, 5, 5};
        int[] nArray2 = new int[]{5, 5, 5, 5, 5};
        LayoutHelper.makeSpringGrid(this, nArrayArray, nArray, nArray2);
    }

    @Override
    public void init() {
        this.labelField.setText(Messages.getString("P11CAT.SlotMng.InitToken.DefaultLabel"));
        this.soPinField.setText("");
        this.confirmSOPinField.setText("");
        boolean bl = this.statusInfo.getTokenInitStatus().equals((Object)Constants.InitStatus.TRUE);
        this.confirmSOPinFieldLabel.setEnabled(!bl);
        this.confirmSOPinField.setEnabled(!bl);
        this.button.setEnabled(false);
    }

    @Override
    public void executeCommand(ActionEvent actionEvent) {
        if (this.statusInfo.getTokenInitStatus().equals((Object)Constants.InitStatus.TRUE)) {
            int n = JOptionPane.showConfirmDialog(this, Messages.getString("P11CAT.SlotMng.InitToken.DialogMsg"), Messages.getString("P11CAT.SlotMng.InitToken.DialogTitle"), 0);
            if (n != 0) {
                return;
            }
        } else if (!Arrays.equals(this.soPinField.getPassword(), this.confirmSOPinField.getPassword())) {
            long l = this.statusInfo.getActiveSlotId();
            this.statusInfo.printError(Messages.getString("P11CAT.Error.InitToken.PinNotMatched"), l);
            this.soPinField.setText("");
            this.confirmSOPinField.setText("");
            return;
        }
        new InitTokenTask(this.statusInfo, this.parent, this.labelField.getText(), new String(this.soPinField.getPassword())).execute();
    }
}

