/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view.renderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class LabelCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -1042420241400104584L;
    private Object[] values;
    private Icon[] icons;
    private String[] texts;
    private Color[] textColors = null;

    private boolean isNumberGreaterZero(String string) {
        try {
            if (Integer.parseInt(string) > 0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return false;
    }

    public LabelCellRenderer(Object[] objectArray, Icon[] iconArray, String[] stringArray) {
        this.values = objectArray;
        this.icons = iconArray;
        this.texts = stringArray;
    }

    public LabelCellRenderer(Object[] objectArray, Icon[] iconArray, String[] stringArray, Color[] colorArray) {
        this.values = objectArray;
        this.icons = iconArray;
        this.texts = stringArray;
        this.textColors = colorArray;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (this.isNumberGreaterZero(object.toString())) {
            jLabel.setIcon(this.icons[1]);
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!object.equals(this.values[i])) continue;
            jLabel.setIcon(this.icons[i]);
            jLabel.setText(this.texts[i]);
            if (this.textColors == null || this.textColors[i] == null) continue;
            jLabel.setForeground(this.textColors[i]);
        }
        return jLabel;
    }
}

