/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view.objMng;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import p11cat.Constants;
import p11cat.Messages;
import p11cat.StatusInfo;
import p11cat.controller.BrowseAction;
import p11cat.controller.CommandAction;
import p11cat.controller.task.ImportCertTask;
import p11cat.view.CommandNodePanel;
import p11cat.view.objMng.ObjectTablePanel;
import p11cat.view.objMng.OverwriteAttrPanel;

class ImportCertPanel
extends CommandNodePanel {
    private static final long serialVersionUID = -1527753523422324590L;
    private StatusInfo statusInfo;
    private ObjectTablePanel objectTablePanel;
    private JTextField fileField;
    private OverwriteAttrPanel certAttrPanel;
    private OverwriteAttrPanel pubKeyAttrPanel;

    private JPanel createFilePanel(StatusInfo statusInfo) {
        JPanel jPanel = new JPanel();
        this.fileField = new JTextField(40);
        this.fileField.setText("");
        JLabel jLabel = new JLabel(Messages.getString("P11CAT.ObjMng.Import.Cert.LabelFile"));
        jLabel.setLabelFor(this.fileField);
        JButton jButton = new JButton(new BrowseAction(statusInfo, this.fileField, Messages.getString("P11CAT.ObjMng.Import.Cert.BrowseTitle")));
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jLabel);
        jPanel.add(this.fileField);
        jPanel.add(jButton);
        return jPanel;
    }

    private JPanel createAttrListPanel() {
        JPanel jPanel = new JPanel();
        this.certAttrPanel = new OverwriteAttrPanel(this.statusInfo, Messages.getString("P11CAT.AttributeList.LabelCert"));
        this.certAttrPanel.setAttrArray(Constants.CREATE_CERT_ATTR_LIST);
        this.pubKeyAttrPanel = new OverwriteAttrPanel(this.statusInfo, Messages.getString("P11CAT.AttributeList.LabelPubKey"));
        this.pubKeyAttrPanel.setAttrArray(Constants.CREATE_PUB_KEY_ATTR_LIST);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("P11CAT.AttributeList.BorderTitle")));
        jPanel.add(this.certAttrPanel);
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        jPanel.add(this.pubKeyAttrPanel);
        return jPanel;
    }

    public ImportCertPanel(StatusInfo statusInfo, ObjectTablePanel objectTablePanel) {
        this.statusInfo = statusInfo;
        this.objectTablePanel = objectTablePanel;
        JButton jButton = new JButton(new CommandAction(Messages.getString("P11CAT.ObjMng.Import"), this));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createFilePanel(statusInfo));
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(this.createAttrListPanel());
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(jButton);
    }

    @Override
    public void init() {
        this.fileField.setText("");
        this.certAttrPanel.init();
        this.pubKeyAttrPanel.init();
    }

    @Override
    public void executeCommand(ActionEvent actionEvent) {
        new ImportCertTask(this.statusInfo, this.objectTablePanel, this.fileField.getText(), this.certAttrPanel.getAttributeList(), this.pubKeyAttrPanel.getAttributeList()).execute();
    }
}

