/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view.objMng;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import p11cat.Constants;
import p11cat.Messages;
import p11cat.StatusInfo;
import p11cat.controller.CommandAction;
import p11cat.controller.task.GenKeyPairTask;
import p11cat.view.CommandNodePanel;
import p11cat.view.objMng.ObjectTablePanel;
import p11cat.view.objMng.OverwriteAttrPanel;

class GenKeyPairPanel
extends CommandNodePanel
implements ActionListener {
    private static final long serialVersionUID = -5509902926592234712L;
    private static final String[] mechStr = new String[]{Messages.getString("P11CAT.ObjMng.Gen.KeyPair.RSA"), Messages.getString("P11CAT.ObjMng.Gen.KeyPair.ECC"), Messages.getString("P11CAT.ObjMng.Gen.KeyPair.EC_Edwards")};
    private static final long[] mech = new long[]{0L, 4160L, 4181L};
    private static final Constants.Attr[][] pubKeyAttr = new Constants.Attr[][]{Constants.GEN_RSA_PUB_KEY_ATTR_LIST, Constants.GEN_ECC_PUB_KEY_ATTR_LIST, Constants.GEN_ECC_PUB_KEY_ATTR_LIST};
    private static final Constants.Attr[][] prvKeyAttr = new Constants.Attr[][]{Constants.GEN_RSA_PRV_KEY_ATTR_LIST, Constants.GEN_ECC_PRV_KEY_ATTR_LIST, Constants.GEN_ECC_PRV_KEY_ATTR_LIST};
    private StatusInfo statusInfo;
    private ObjectTablePanel objectTablePanel;
    private JComboBox mechComboBox;
    private OverwriteAttrPanel pubKeyAttrPanel;
    private OverwriteAttrPanel prvKeyAttrPanel;

    private JPanel createAttrListPanel() {
        JPanel jPanel = new JPanel();
        this.pubKeyAttrPanel = new OverwriteAttrPanel(this.statusInfo, Messages.getString("P11CAT.AttributeList.LabelPubKey"));
        this.pubKeyAttrPanel.setAttrArray(pubKeyAttr[0]);
        this.prvKeyAttrPanel = new OverwriteAttrPanel(this.statusInfo, Messages.getString("P11CAT.AttributeList.LabelPrvKey"));
        this.prvKeyAttrPanel.setAttrArray(prvKeyAttr[0]);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("P11CAT.AttributeList.BorderTitle")));
        jPanel.add(this.pubKeyAttrPanel);
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        jPanel.add(this.prvKeyAttrPanel);
        return jPanel;
    }

    public GenKeyPairPanel(StatusInfo statusInfo, ObjectTablePanel objectTablePanel) {
        this.statusInfo = statusInfo;
        this.objectTablePanel = objectTablePanel;
        this.mechComboBox = new JComboBox<String>(mechStr);
        this.mechComboBox.setSelectedItem(mechStr[0]);
        this.mechComboBox.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(new JLabel(Messages.getString("P11CAT.ObjMng.Gen.KeyPair.LabelMech")));
        jPanel.add(this.mechComboBox);
        JButton jButton = new JButton(new CommandAction(Messages.getString("P11CAT.ObjMng.Gen"), this));
        this.setLayout(new BoxLayout(this, 1));
        this.add(jPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(this.createAttrListPanel());
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(jButton);
    }

    @Override
    public void init() {
        this.pubKeyAttrPanel.init();
        this.prvKeyAttrPanel.init();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        if (jComboBox != null) {
            int n = jComboBox.getSelectedIndex();
            this.pubKeyAttrPanel.setAttrArray(pubKeyAttr[n]);
            this.prvKeyAttrPanel.setAttrArray(prvKeyAttr[n]);
        }
    }

    @Override
    public void executeCommand(ActionEvent actionEvent) {
        int n = this.mechComboBox.getSelectedIndex();
        new GenKeyPairTask(this.statusInfo, this.objectTablePanel, mech[n], mechStr[n], this.pubKeyAttrPanel.getAttributeList(), this.prvKeyAttrPanel.getAttributeList()).execute();
    }
}

