/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view.login;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import p11cat.LayoutHelper;
import p11cat.Messages;
import p11cat.StatusInfo;
import p11cat.controller.BrowseAction;
import p11cat.view.CommandNodePanel;
import p11cat.view.login.AuthPanelLoginButton;

class AuthPanel
extends JPanel
implements ItemListener {
    private static final long serialVersionUID = -6143147550300980920L;
    private static final String CMD_PASSWORD = "P";
    private static final String CMD_KEY_FILE = "K";
    private static final String CMD_SMARTCARD = "S";
    private String cmd = "P";
    private CardLayout cardLayout;
    private JPanel cardPanel;
    private JTextField userNameField = new JTextField(20);
    private JPasswordField passwordField;
    private JTextField keyfileField;
    private JPasswordField keyfilePwdField;
    private JTextField keyspecField;
    private AuthPanelLoginButton loginButton;

    private void setDeepEnabled(Component component, boolean bl) {
        if (component == this.loginButton && bl) {
            return;
        }
        component.setEnabled(bl);
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.setDeepEnabled(container.getComponent(i), bl);
            }
        }
    }

    private JPanel createRadioButtonPanel() {
        JPanel jPanel = new JPanel();
        JRadioButton jRadioButton = new JRadioButton(Messages.getString("P11CAT.Login.Generic.RadioButton.Password"));
        jRadioButton.setActionCommand(CMD_PASSWORD);
        jRadioButton.setSelected(true);
        JRadioButton jRadioButton2 = new JRadioButton(Messages.getString("P11CAT.Login.Generic.RadioButton.KeyFile"));
        jRadioButton2.setActionCommand(CMD_KEY_FILE);
        JRadioButton jRadioButton3 = new JRadioButton(Messages.getString("P11CAT.Login.Generic.RadioButton.Smartcard"));
        jRadioButton3.setActionCommand(CMD_SMARTCARD);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jRadioButton);
        jPanel.add(jRadioButton2);
        jPanel.add(jRadioButton3);
        jRadioButton.addItemListener(this);
        jRadioButton2.addItemListener(this);
        jRadioButton3.addItemListener(this);
        return jPanel;
    }

    private JPanel createPasswordPanel() {
        JPanel jPanel = new JPanel();
        this.passwordField = new JPasswordField(20);
        this.passwordField.setText("");
        this.passwordField.setMaximumSize(new Dimension(this.passwordField.getMaximumSize().width, this.passwordField.getPreferredSize().height));
        JLabel jLabel = new JLabel(Messages.getString("P11CAT.Login.Generic.LabelPassword"));
        jLabel.setLabelFor(this.passwordField);
        SpringLayout springLayout = new SpringLayout();
        jPanel.setLayout(springLayout);
        jPanel.add(jLabel);
        jPanel.add(this.passwordField);
        int[][] nArrayArray = new int[][]{{0, 1}};
        int[] nArray = new int[]{0, 5, 0};
        int[] nArray2 = new int[]{5, 5};
        LayoutHelper.makeSpringGrid(jPanel, nArrayArray, nArray, nArray2);
        return jPanel;
    }

    private JPanel createKeyfilePanel(StatusInfo statusInfo) {
        JPanel jPanel = new JPanel();
        this.keyfileField = new JTextField(20);
        this.keyfileField.setText("");
        JLabel jLabel = new JLabel(Messages.getString("P11CAT.Login.Generic.LabelKeyFile"));
        jLabel.setLabelFor(this.keyfileField);
        JButton jButton = new JButton(new BrowseAction(statusInfo, this.keyfileField, Messages.getString("P11CAT.Login.Generic.BrowseTitle")));
        this.keyfilePwdField = new JPasswordField(20);
        this.keyfilePwdField.setText("");
        JLabel jLabel2 = new JLabel(Messages.getString("P11CAT.Login.Generic.LabelKeyFilePwd"));
        jLabel2.setLabelFor(this.keyfilePwdField);
        SpringLayout springLayout = new SpringLayout();
        jPanel.setLayout(springLayout);
        jPanel.add(jLabel);
        jPanel.add(this.keyfileField);
        jPanel.add(jButton);
        jPanel.add(jLabel2);
        jPanel.add(this.keyfilePwdField);
        int[][] nArrayArray = new int[][]{{0, 1, 2}, {3, 4, -1}};
        int[] nArray = new int[]{0, 5, 5, 0};
        int[] nArray2 = new int[]{5, 5, 5};
        LayoutHelper.makeSpringGrid(jPanel, nArrayArray, nArray, nArray2);
        return jPanel;
    }

    private JPanel createSmartcardPanel() {
        JPanel jPanel = new JPanel();
        this.keyspecField = new JTextField(20);
        this.keyspecField.setText("");
        this.keyspecField.setMaximumSize(new Dimension(this.keyspecField.getMaximumSize().width, this.keyspecField.getPreferredSize().height));
        JLabel jLabel = new JLabel(Messages.getString("P11CAT.Login.Generic.LabelSmartcard"));
        jLabel.setLabelFor(this.keyspecField);
        SpringLayout springLayout = new SpringLayout();
        jPanel.setLayout(springLayout);
        jPanel.add(jLabel);
        jPanel.add(this.keyspecField);
        int[][] nArrayArray = new int[][]{{0, 1}};
        int[] nArray = new int[]{0, 5, 0};
        int[] nArray2 = new int[]{5, 5};
        LayoutHelper.makeSpringGrid(jPanel, nArrayArray, nArray, nArray2);
        return jPanel;
    }

    private JPanel createCardPanel(StatusInfo statusInfo) {
        this.cardLayout = new CardLayout();
        JPanel jPanel = new JPanel(this.cardLayout);
        JPanel jPanel2 = this.createPasswordPanel();
        jPanel.add((Component)jPanel2, CMD_PASSWORD);
        JPanel jPanel3 = this.createKeyfilePanel(statusInfo);
        jPanel.add((Component)jPanel3, CMD_KEY_FILE);
        JPanel jPanel4 = this.createSmartcardPanel();
        jPanel.add((Component)jPanel4, CMD_SMARTCARD);
        return jPanel;
    }

    public AuthPanel(StatusInfo statusInfo, CommandNodePanel commandNodePanel) {
        this.userNameField.setText("");
        JLabel jLabel = new JLabel(Messages.getString("P11CAT.Login.Generic.LabelUserName"));
        jLabel.setLabelFor(this.userNameField);
        JLabel jLabel2 = new JLabel(Messages.getString("P11CAT.Login.Generic.LabelAuthToken"));
        JPanel jPanel = this.createRadioButtonPanel();
        this.cardPanel = this.createCardPanel(statusInfo);
        JTextField[] jTextFieldArray = new JTextField[]{this.userNameField, this.passwordField, this.keyfileField, this.keyspecField};
        this.loginButton = new AuthPanelLoginButton(commandNodePanel, this, jTextFieldArray);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.loginButton);
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        this.add(jLabel);
        this.add(this.userNameField);
        this.add(jLabel2);
        this.add(jPanel);
        this.add(this.cardPanel);
        this.add(jPanel2);
        int[][] nArrayArray = new int[][]{{0, 1, -1}, {2, 3, -1}, {-1, 4, -1}, {-1, 5, -1}};
        int[] nArray = new int[]{5, 10, 5, 5, 5};
        int[] nArray2 = new int[]{5, 5, 5, 5, 5};
        LayoutHelper.makeSpringGrid(this, nArrayArray, nArray, nArray2);
    }

    public void init() {
        this.userNameField.setText("");
        this.clearAuthToken();
        this.loginButton.setEnabled(false);
    }

    public void clearAuthToken() {
        this.passwordField.setText("");
        this.keyfileField.setText("");
        this.keyfilePwdField.setText("");
        this.keyspecField.setText("");
    }

    public String getUserName() {
        return this.userNameField.getText();
    }

    public String getAuthToken() {
        if (this.cmd.equals(CMD_PASSWORD)) {
            return new String(this.passwordField.getPassword());
        }
        if (this.cmd.equals(CMD_KEY_FILE)) {
            String string = this.keyfileField.getText();
            String string2 = new String(this.keyfilePwdField.getPassword());
            if (string2.equals("")) {
                return string;
            }
            return string + "#" + string2;
        }
        if (this.cmd.equals(CMD_SMARTCARD)) {
            return this.keyspecField.getText();
        }
        return "";
    }

    public void setDeepEnabled(boolean bl) {
        this.setDeepEnabled(this, bl);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        JRadioButton jRadioButton = (JRadioButton)itemEvent.getItem();
        this.cmd = jRadioButton.getActionCommand();
        this.cardLayout.show(this.cardPanel, this.cmd);
        this.loginButton.updateButton();
    }
}

