/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view.backup;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import p11cat.Messages;
import p11cat.StatusInfo;
import p11cat.controller.BrowseAction;
import p11cat.controller.CommandAction;
import p11cat.controller.task.BackupInfoTask;
import p11cat.model.InfoTableModel;
import p11cat.view.CommandNodePanel;
import p11cat.view.ListenerButton;
import p11cat.view.Table;

class BackupInfoPanel
extends CommandNodePanel {
    private static final long serialVersionUID = 4062372843421784860L;
    private StatusInfo statusInfo;
    private JTextField fileField;
    private Table table;
    private ListenerButton showButton;

    private JPanel createFilePanel(StatusInfo statusInfo) {
        JPanel jPanel = new JPanel();
        this.fileField = new JTextField(30);
        this.fileField.setText("");
        JLabel jLabel = new JLabel(Messages.getString("P11CAT.BackupRestore.Info.LabelFile"));
        jLabel.setLabelFor(this.fileField);
        JButton jButton = new JButton(new BrowseAction(statusInfo, this.fileField, Messages.getString("P11CAT.BackupRestore.Info.BrowseTitle")));
        JTextField[] jTextFieldArray = new JTextField[]{this.fileField};
        this.showButton = new ListenerButton(new CommandAction(Messages.getString("P11CAT.BackupRestore.Info.ButtonText"), this), jTextFieldArray);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jLabel);
        jPanel.add(this.fileField);
        jPanel.add(jButton);
        jPanel.add(this.showButton);
        return jPanel;
    }

    public BackupInfoPanel(StatusInfo statusInfo) {
        this.statusInfo = statusInfo;
        this.table = new Table();
        this.table.setModel(new InfoTableModel(null, null));
        this.table.setTableHeader(null);
        this.table.setFocusable(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setBorder(BorderFactory.createLineBorder(this.table.getBackground()));
        this.table.setPreferredScrollableViewportSize(new Dimension(100, 75));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createFilePanel(statusInfo));
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(new JScrollPane(jScrollPane));
        this.add(Box.createRigidArea(new Dimension(0, 10)));
    }

    @Override
    public void init() {
        this.fileField.setText("");
        this.table.setModel(new InfoTableModel(null, null));
        this.showButton.setEnabled(false);
    }

    @Override
    public void executeCommand(ActionEvent actionEvent) {
        new BackupInfoTask(this.statusInfo, this.table, this.fileField.getText()).execute();
    }
}

