/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import p11cat.Constants;
import p11cat.Messages;
import p11cat.controller.EnableAction;
import p11cat.controller.LogoutAction;
import p11cat.controller.OpenCardAction;
import p11cat.controller.SlotTableListener;
import p11cat.model.AuthState;
import p11cat.model.Slot;
import p11cat.model.SlotTableModel;
import p11cat.view.StatusBar;
import p11cat.view.StatusTable;
import p11cat.view.Table;
import p11cat.view.renderer.LabelCellRenderer;
import p11cat.view.renderer.SlotIdCellRenderer;

public class SlotTable
extends Table {
    private static final long serialVersionUID = 273989979848174209L;
    private static long authState;
    private static boolean generic;
    private StatusBar statusBar;
    private SlotTableModel model;
    private SlotTableListener listener;
    private SlotIdCellRenderer slotIdRenderer;
    private LabelCellRenderer initStateRenderer;
    private LabelCellRenderer loginStatusRenderer;
    private boolean isP11Init = false;
    private long selectedSlotId = -1L;
    private Vector<EnableAction> actions = new Vector();

    private void updateActions() {
        for (int i = 0; i < this.actions.size(); ++i) {
            this.actions.elementAt(i).setEnabled(this);
        }
    }

    private SlotIdCellRenderer getSlotIdRenderer() {
        if (this.slotIdRenderer == null) {
            this.slotIdRenderer = new SlotIdCellRenderer();
        }
        this.slotIdRenderer.setHorizontalAlignment(0);
        return this.slotIdRenderer;
    }

    private LabelCellRenderer getInitStateRenderer() {
        if (this.initStateRenderer == null) {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/camera_test.png"));
            ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/cancel.png"));
            Constants.InitStatus[] initStatusArray = new Constants.InitStatus[]{Constants.InitStatus.TRUE, Constants.InitStatus.FALSE, Constants.InitStatus.ERROR};
            Icon[] iconArray = new ImageIcon[]{imageIcon, null, imageIcon2};
            String[] stringArray = new String[]{null, null, Messages.getString("P11CAT.SlotPanel.InitStatus.Error")};
            Color[] colorArray = new Color[]{null, null, Color.red};
            this.initStateRenderer = new LabelCellRenderer((Object[])initStatusArray, iconArray, stringArray, colorArray);
        }
        this.initStateRenderer.setHorizontalAlignment(0);
        return this.initStateRenderer;
    }

    private LabelCellRenderer getLoginStatusRenderer() {
        if (this.loginStatusRenderer == null) {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/gpg.png"));
            AuthState authState = new AuthState(SlotTable.getCurrentAuthState());
            Object[] objectArray = new Object[]{"00000000"};
            Icon[] iconArray = new ImageIcon[]{null, imageIcon};
            String[] stringArray = new String[]{null, authState.getHexString()};
            this.loginStatusRenderer = new LabelCellRenderer(objectArray, iconArray, stringArray);
        }
        return this.loginStatusRenderer;
    }

    public SlotTable(OpenCardAction openCardAction, StatusTable statusTable, StatusBar statusBar) {
        this.statusBar = statusBar;
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.listener = new SlotTableListener(this, openCardAction);
        this.getSelectionModel().addListSelectionListener(this.listener);
        this.model = new SlotTableModel(statusTable);
        this.setModel(this.model);
        Slot slot = new Slot(699050L, Constants.InitStatus.ERROR, Constants.InitStatus.ERROR, 0L);
        this.model.addSlot(slot);
        this.adjustColumnWidth();
        this.model.clear();
    }

    public void init(boolean bl) {
        this.isP11Init = bl;
        this.model.clear();
        this.updateActions();
        this.setEnabled(bl);
    }

    public void addSlot(Slot slot) {
        this.model.addSlot(slot);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.getSlotIdRenderer();
            }
            case 1: 
            case 2: {
                return this.getInitStateRenderer();
            }
            case 3: {
                return this.getLoginStatusRenderer();
            }
        }
        return super.getCellRenderer(n, n2);
    }

    public boolean isP11Init() {
        return this.isP11Init;
    }

    public long getSelectedSlotId() {
        return this.selectedSlotId;
    }

    public boolean hasError(int n) {
        return ((Constants.InitStatus)((Object)this.getValueAt(n, 1))).equals((Object)Constants.InitStatus.ERROR) || ((Constants.InitStatus)((Object)this.getValueAt(n, 2))).equals((Object)Constants.InitStatus.ERROR);
    }

    public Constants.InitStatus getCurrentTokenInitStatus() {
        return this.getSelectedRow() < 0 ? Constants.InitStatus.FALSE : (Constants.InitStatus)((Object)this.getValueAt(this.getSelectedRow(), 1));
    }

    public Constants.InitStatus getCurrentPinInitStatus() {
        return this.getSelectedRow() < 0 ? Constants.InitStatus.FALSE : (Constants.InitStatus)((Object)this.getValueAt(this.getSelectedRow(), 2));
    }

    public int getLoggedIntoRow() {
        return this.convertRowIndexToView(this.model.getLoggedRow());
    }

    public long getActiveSlotId() {
        int n = this.getLoggedIntoRow();
        if (n >= 0) {
            return (Long)this.getValueAt(n, 0);
        }
        return -1L;
    }

    public void registerAction(EnableAction enableAction) {
        this.actions.addElement(enableAction);
    }

    public void updateAfterSlotChange() {
        int n = this.getSelectedRow();
        if (n >= 0) {
            this.selectedSlotId = (Long)this.getValueAt(n, 0);
            this.updateSelectedRow();
        } else {
            this.selectedSlotId = -1L;
        }
        if (n < 0 || this.hasError(n)) {
            this.statusBar.update(-1L);
        } else {
            this.statusBar.update(this.selectedSlotId);
        }
    }

    public void updateSelectedRow() {
        if (this.getSelectedRow() >= 0) {
            this.model.updateRow(this.convertRowIndexToModel(this.getSelectedRow()));
            this.updateActions();
        }
    }

    public void updateLoginStatus(long l) {
        if (this.getSelectedRow() >= 0) {
            SlotTable.setCurrentAuthState(l);
            this.model.setLoginStatus(l, this.convertRowIndexToModel(this.getSelectedRow()));
            this.updateSelectedRow();
        }
        this.setEnabled(l == 0L);
    }

    public void logout(boolean bl) {
        for (int i = 0; i < this.actions.size(); ++i) {
            EnableAction enableAction = this.actions.elementAt(i);
            if (!(enableAction instanceof LogoutAction)) continue;
            ((LogoutAction)enableAction).logout(bl);
            break;
        }
        this.setEnabled(this.isP11Init);
    }

    public void logoutAtRestart(StatusTable statusTable) {
        long l = this.getActiveSlotId();
        if (l >= 0L) {
            long l2 = SlotTable.getCurrentAuthState();
            for (int i = 0; i < this.actions.size(); ++i) {
                EnableAction enableAction = this.actions.elementAt(i);
                if (!(enableAction instanceof LogoutAction)) continue;
                ((LogoutAction)enableAction).logoutAtRestart(statusTable, l2, l);
                break;
            }
        }
        this.setEnabled(this.isP11Init);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        String string = null;
        if (n2 == 0) {
            string = this.getValueAt(n, n2).toString();
        }
        return string;
    }

    public static void setCurrentAuthState(long l) {
        authState = l;
        if (l == 0L) {
            generic = false;
        }
    }

    public static long getCurrentAuthState() {
        return authState;
    }

    public static void setGeneric(boolean bl) {
        generic = bl;
    }

    public static boolean isGeneric() {
        return generic;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.setBackground(UIManager.getColor("Table.background"));
        } else {
            this.setBackground(UIManager.getColor("Table.gridcolor"));
        }
    }

    public void setSoftlocked(boolean bl) {
        if (bl) {
            this.setEnabled(false);
        } else if (authState == 0L) {
            this.setEnabled(true);
        }
    }

    static {
        generic = false;
    }
}

