/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view;

import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import p11cat.controller.OpenCardExpandNodeAction;
import p11cat.view.Card;
import p11cat.view.CmdTreeUI;
import p11cat.view.editor.CmdTreeCellEditor;
import p11cat.view.renderer.CmdTreeCellRenderer;

public abstract class CmdTreePanel
extends Card {
    private static final long serialVersionUID = 7341986845079951024L;
    protected JTree tree;
    protected boolean oneNodeExpanded;
    private OpenCardExpandNodeAction[] actions;

    private void createCmdTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("");
        for (int i = 0; i < this.actions.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.actions[i]);
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(this.actions[i]);
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.setRootVisible(false);
        this.tree.setRowHeight(0);
        this.tree.setUI(new CmdTreeUI());
        this.tree.setBackground(this.getBackground());
        this.tree.setEditable(true);
        this.tree.setToggleClickCount(1);
        CmdTreeCellRenderer cmdTreeCellRenderer = new CmdTreeCellRenderer();
        this.tree.setCellRenderer(cmdTreeCellRenderer);
        this.tree.setCellEditor(new CmdTreeCellEditor(this.tree, cmdTreeCellRenderer));
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                TreePath treePath = treeExpansionEvent.getPath();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                OpenCardExpandNodeAction openCardExpandNodeAction = (OpenCardExpandNodeAction)defaultMutableTreeNode.getUserObject();
                if (!defaultMutableTreeNode.isLeaf()) {
                    if (!openCardExpandNodeAction.isEnabled()) {
                        throw new ExpandVetoException(treeExpansionEvent);
                    }
                    openCardExpandNodeAction.getNodePanel().init();
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }
        });
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getPath();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                OpenCardExpandNodeAction openCardExpandNodeAction = (OpenCardExpandNodeAction)defaultMutableTreeNode.getUserObject();
                if (!defaultMutableTreeNode.isLeaf()) {
                    if (!openCardExpandNodeAction.isEnabled()) {
                        CmdTreePanel.this.tree.getSelectionModel().removeSelectionPath(treePath);
                    } else if (CmdTreePanel.this.oneNodeExpanded) {
                        for (int i = 0; i < CmdTreePanel.this.tree.getRowCount(); ++i) {
                            if (treePath.equals(CmdTreePanel.this.tree.getPathForRow(i))) continue;
                            CmdTreePanel.this.tree.collapseRow(i);
                        }
                    }
                }
            }
        });
    }

    public CmdTreePanel(String string, boolean bl) {
        super(string);
        this.oneNodeExpanded = bl;
    }

    public void addActions(OpenCardExpandNodeAction[] openCardExpandNodeActionArray) {
        this.actions = openCardExpandNodeActionArray;
    }

    @Override
    public void init() {
        if (this.tree == null) {
            this.createCmdTree();
            JScrollPane jScrollPane = new JScrollPane(this.tree);
            jScrollPane.setBorder(null);
            this.add((Component)jScrollPane, "Center");
        }
        this.collapseAll();
    }

    public void collapseAll() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.collapseRow(i);
        }
        this.tree.clearSelection();
    }

    public void expand(int n) {
        this.tree.expandRow(n);
    }
}

