/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import p11cat.Constants;
import p11cat.model.Attribute;
import p11cat.model.AttributeTableModel;
import p11cat.view.Table;
import p11cat.view.editor.AttributeTableCellEditor;
import p11cat.view.renderer.AttributeTableCellRenderer;

public class AttributeTable
extends Table {
    private static final long serialVersionUID = -249802129293588077L;
    private AttributeTableModel model;

    public AttributeTable() {
        this.setAutoCreateRowSorter(true);
        this.getTableHeader().setReorderingAllowed(false);
    }

    public void init(AttributeTableModel attributeTableModel) {
        this.model = attributeTableModel;
        this.setModel(attributeTableModel);
        this.getColumnModel().getColumn(2).setCellRenderer(new AttributeTableCellRenderer());
        this.getColumnModel().getColumn(2).setCellEditor(new AttributeTableCellEditor());
    }

    public Attribute getAttributeByRow(int n) {
        int n2 = this.convertRowIndexToModel(n);
        return this.model.getAttributeByIndex(n2);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.model != null) {
            Point point = mouseEvent.getPoint();
            int n = this.rowAtPoint(point);
            int n2 = this.columnAtPoint(point);
            String string = this.getValueAt(n, n2).toString();
            if (n2 == 2) {
                Attribute attribute = (Attribute)this.getValueAt(n, n2);
                if (attribute != null) {
                    string = attribute.getValue();
                }
                Constants.DataType dataType = (Constants.DataType)((Object)this.getValueAt(n, 1));
                switch (dataType) {
                    case BYTE_ARRAY: {
                        if (!string.startsWith("0x")) break;
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int i = 2; i < string.length() - 1; i += 2) {
                            String string2 = string.substring(i, i + 2);
                            int n3 = Integer.parseInt(string2, 16);
                            stringBuilder.append((char)n3);
                        }
                        string = string + "  (" + stringBuilder.toString() + ")";
                        break;
                    }
                    case BIG_INT: {
                        if (!string.startsWith("0x")) break;
                        BigInteger bigInteger = new BigInteger(string.substring(2), 16);
                        string = string + "  (" + bigInteger.toString() + ")";
                    }
                }
            }
            return string;
        }
        return super.getToolTipText();
    }
}

