/*
 * Decompiled with CFR 0.152.
 */
package p11cat.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import p11cat.Constants;
import p11cat.Messages;
import p11cat.StatusInfo;
import p11cat.model.Attribute;
import p11cat.model.AttributeTableModel;
import p11cat.view.AttributeTable;

public class AttrTemplatePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 6061184150536967984L;
    private static final String CMD_DELETE = "Delete";
    private static final String CMD_ADD = "Add";
    private JComboBox comboBox;
    private JButton deleteButton;
    private JButton addButton;
    private AttributeTable table;
    private AttributeTableModel model;
    private Constants.Attr[] attrArray = Constants.Attr.values();

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.deleteButton = new JButton(Messages.getString("P11CAT.ButtonText.Delete"));
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/editdelete.png")));
        this.deleteButton.setActionCommand(CMD_DELETE);
        this.deleteButton.addActionListener(this);
        this.deleteButton.setEnabled(false);
        this.addButton = new JButton(Messages.getString("P11CAT.ButtonText.Add"));
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/filenew.png")));
        this.addButton.setActionCommand(CMD_ADD);
        this.addButton.addActionListener(this);
        this.comboBox = new JComboBox();
        jToolBar.add(this.comboBox);
        jToolBar.add(this.addButton);
        jToolBar.addSeparator();
        jToolBar.add(this.deleteButton);
        return jToolBar;
    }

    private void addAttrToComboBox(Attribute attribute) {
        boolean bl = true;
        for (int i = 0; i < this.comboBox.getItemCount() && bl; ++i) {
            Attribute attribute2 = (Attribute)this.comboBox.getItemAt(i);
            if (attribute2.getName().compareTo(attribute.getName()) <= 0) continue;
            this.comboBox.insertItemAt(attribute, i);
            bl = false;
        }
        if (bl) {
            this.comboBox.addItem(attribute);
        }
        if (attribute.getName().equals(Constants.Attr.CKA_LABEL.toString())) {
            this.comboBox.setSelectedItem(attribute);
        }
    }

    private void addAttrToComboBox(Constants.Attr attr) {
        switch (attr.getDataType()) {
            case CK_MECHANISM_TYPE_PTR: 
            case CK_ATTRIBUTE_PTR: 
            case ULONG_MASK: 
            case BYTE_PTR: {
                break;
            }
            default: {
                Attribute attribute = Attribute.attributeFactory(attr);
                attribute.setDefaultValue();
                this.addAttrToComboBox(attribute);
            }
        }
    }

    public AttrTemplatePanel(StatusInfo statusInfo) {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.createToolBar(), "North");
        this.model = new AttributeTableModel(null, statusInfo);
        this.table = new AttributeTable();
        this.table.init(this.model);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    AttrTemplatePanel.this.deleteButton.setEnabled(AttrTemplatePanel.this.table.getSelectedRowCount() > 0);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.add((Component)jScrollPane, "Center");
    }

    public void setAttrArray(Constants.Attr[] attrArray) {
        this.attrArray = attrArray;
    }

    public boolean init(String string) {
        Object object;
        int n;
        this.comboBox.removeAllItems();
        for (n = 0; n < this.attrArray.length; ++n) {
            object = this.attrArray[n];
            this.addAttrToComboBox((Constants.Attr)((Object)object));
        }
        if (this.model.init(string)) {
            block1: for (n = 0; n < this.model.getRowCount(); ++n) {
                object = this.model.getAttributeByIndex(n).getName();
                for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
                    Attribute attribute = (Attribute)this.comboBox.getItemAt(i);
                    if (!attribute.getName().equals(object)) continue;
                    this.comboBox.removeItem(attribute);
                    continue block1;
                }
            }
            return true;
        }
        return false;
    }

    public String getAttributeList() {
        String string = "";
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            Attribute attribute = this.table.getAttributeByRow(i);
            String string2 = attribute.getName();
            String string3 = attribute.getValue();
            String string4 = i == 0 ? "" : ",";
            string = string3 == null ? string + string4 + string2 + "=" : string + string4 + string2 + "=" + string3;
        }
        return string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_DELETE)) {
            int n = this.table.getSelectedRowCount();
            if (n > 0) {
                int[] nArray = this.table.getSelectedRows();
                for (int i = 0; i < n; ++i) {
                    int n2 = this.table.convertRowIndexToModel(nArray[i]);
                    this.model.setAttributeMarked(n2, true);
                    Attribute attribute = this.model.getAttributeByIndex(n2);
                    attribute.setDefaultValue();
                    this.addAttrToComboBox(attribute);
                }
                this.model.removeMarkedAttributes();
            }
        } else if (string.equals(CMD_ADD)) {
            Attribute attribute = (Attribute)this.comboBox.getSelectedItem();
            this.model.addAttribute(attribute);
            this.comboBox.removeItem(attribute);
            this.table.scrollToLastRow();
        }
        this.addButton.setEnabled(this.comboBox.getItemCount() > 0);
    }
}

