/*
 * Decompiled with CFR 0.152.
 */
package p11cat.model;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import p11cat.Messages;
import p11cat.StatusInfo;
import p11cat.model.P11Object;

public class ObjectTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5883794216175064535L;
    private String[] columnNames = new String[]{Messages.getString("P11CAT.ObjectTablePanel.Col.Class"), Messages.getString("P11CAT.ObjectTablePanel.Col.Type"), Messages.getString("P11CAT.ObjectTablePanel.Col.Label"), Messages.getString("P11CAT.ObjectTablePanel.Col.Id")};
    private Vector<P11Object> objects = new Vector();
    public static final int COLUMN_CLASS = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_LABEL = 2;
    public static final int COLUMN_ID = 3;

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.objects.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        P11Object p11Object = this.objects.elementAt(n);
        switch (n2) {
            case 0: {
                return p11Object.getObjectClass();
            }
            case 1: {
                return p11Object.getObjectType();
            }
            case 2: {
                return p11Object.getLabel();
            }
            case 3: {
                return p11Object.getID();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public int addObject(P11Object p11Object) {
        int n = this.objects.size();
        this.objects.addElement(p11Object);
        this.fireTableRowsInserted(n, n);
        return n;
    }

    public void clear() {
        this.objects.removeAllElements();
        this.fireTableDataChanged();
    }

    public void updateObject(int n, StatusInfo statusInfo) {
        P11Object p11Object = this.objects.elementAt(n);
        try {
            p11Object.update();
        }
        catch (Exception exception) {
            statusInfo.printException(exception, statusInfo.getActiveSlotId());
        }
        this.fireTableRowsUpdated(n, n);
    }

    public long getObjectHandle(int n) {
        return this.objects.elementAt(n).getObjectHandle();
    }

    public boolean isObjectMarked(int n) {
        return this.objects.elementAt(n).isMarked();
    }

    public void setObjectMarked(int n, boolean bl) {
        this.objects.elementAt(n).setMarked(bl);
    }

    public void setObjectMarkedAll(boolean bl) {
        for (int i = 0; i < this.objects.size(); ++i) {
            this.objects.elementAt(i).setMarked(bl);
        }
    }

    public void removeMarkedObjects() {
        Iterator<P11Object> iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isMarked()) continue;
            iterator.remove();
        }
        this.fireTableDataChanged();
    }
}

