/*
 * Decompiled with CFR 0.152.
 */
package p11cat.controller;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import p11cat.Messages;
import p11cat.StatusInfo;
import p11cat.controller.EnableAction;

public abstract class FileChooserAction
extends EnableAction {
    private static final long serialVersionUID = 3608690441919981163L;
    private JFileChooser chooser = new JFileChooser();
    private boolean isOpenDialog;
    protected StatusInfo statusInfo;

    public FileChooserAction(String string, String string2, boolean bl, StatusInfo statusInfo, EnableAction.EnableCondition enableCondition) {
        super(string, enableCondition);
        this.chooser.setDialogTitle(string2);
        this.isOpenDialog = bl;
        this.statusInfo = statusInfo;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        File file = this.statusInfo.getLastDirectory();
        if (file != null) {
            this.chooser.setCurrentDirectory(file);
        }
        int n = this.isOpenDialog ? this.chooser.showOpenDialog(null) : this.chooser.showSaveDialog(null);
        File file2 = this.chooser.getSelectedFile();
        if (file2 != null && n == 0) {
            int n2;
            this.statusInfo.setLastDirectory(this.chooser.getCurrentDirectory());
            if (!this.isOpenDialog && file2.exists() && (n2 = JOptionPane.showConfirmDialog(this.chooser, Messages.getString("P11CAT.FileExistsDialog.Message"), Messages.getString("P11CAT.FileExistsDialog.Title"), 0)) != 0) {
                return;
            }
            this.execute(file2.getPath());
        }
    }

    public abstract void execute(String var1);
}

