/*
 * Decompiled with CFR 0.152.
 */
package p11cat.controller;

import javax.swing.AbstractAction;
import p11cat.Constants;
import p11cat.model.AuthState;
import p11cat.view.SlotTable;
import p11cat.view.objMng.ObjectTable;

public abstract class EnableAction
extends AbstractAction {
    private static final long serialVersionUID = -871265085633358982L;
    private EnableCondition enableCondition;

    private boolean isNoLoginOrLoggedSlotSelected(SlotTable slotTable) {
        int n = slotTable.getSelectedRow();
        int n2 = slotTable.getLoggedIntoRow();
        return n2 < 0 || n2 == n;
    }

    public EnableAction(String string, EnableCondition enableCondition) {
        super(string);
        this.enableCondition = enableCondition;
        this.setEnabled(enableCondition.equals((Object)EnableCondition.ALWAYS_TRUE));
    }

    public EnableCondition getEnableCondition() {
        return this.enableCondition;
    }

    public void setEnabled(SlotTable slotTable) {
        if (this.enableCondition.equals((Object)EnableCondition.ALWAYS_TRUE)) {
            return;
        }
        if (this.enableCondition.equals((Object)EnableCondition.ST_IS_P11_INIT)) {
            this.setEnabled(slotTable.isP11Init());
            return;
        }
        if (slotTable.getSelectedRow() < 0 || slotTable.hasError(slotTable.getSelectedRow())) {
            this.setEnabled(false);
            return;
        }
        boolean bl = false;
        boolean bl2 = slotTable.getSelectedRow() == slotTable.getLoggedIntoRow();
        AuthState authState = new AuthState(SlotTable.getCurrentAuthState());
        switch (this.enableCondition) {
            case ST_SLOT_SELECTED_NO_ERROR: {
                bl = true;
                break;
            }
            case ST_NO_LOGIN_OR_LOGGED_SLOT_SELECTED: {
                bl = this.isNoLoginOrLoggedSlotSelected(slotTable);
                break;
            }
            case ST_NO_LOGIN_AND_TOKEN_INIT: {
                bl = authState.isZero() && slotTable.getCurrentTokenInitStatus().equals((Object)Constants.InitStatus.TRUE);
                break;
            }
            case ST_NO_LOGIN_AND_PIN_INIT: {
                bl = authState.isZero() && slotTable.getCurrentPinInitStatus().equals((Object)Constants.InitStatus.TRUE);
                break;
            }
            case ST_LOGIN: {
                bl = !authState.isZero();
                break;
            }
            case ST_LOGIN_SO: {
                bl = authState.isSO() && bl2;
                break;
            }
            case ST_LOGIN_SO_AND_PIN_NOT_INIT: {
                bl = authState.isSO() && slotTable.getCurrentPinInitStatus().equals((Object)Constants.InitStatus.FALSE) && bl2;
                break;
            }
            case ST_LOGIN_USER: {
                bl = authState.isUser() && bl2;
                break;
            }
            case ST_LOGIN_USER_OR_KEYM: {
                bl = (authState.isUser() || authState.isKeyManager()) && bl2;
                break;
            }
            case ST_LOGIN_SO_OR_USER: {
                bl = (authState.isSO() || authState.isUser()) && bl2;
                break;
            }
            case ST_LOGIN_SO_ONLY_OR_USER_ONLY: {
                bl = bl2 && (authState.isSO() && !authState.isUser() && !SlotTable.isGeneric() || authState.isUser() && !authState.isSO() && !SlotTable.isGeneric());
                break;
            }
            case ST_LOGIN_ADMIN_AND_TOKEN_INIT: {
                bl = authState.isAdmin() && slotTable.getCurrentTokenInitStatus().equals((Object)Constants.InitStatus.TRUE);
                break;
            }
            case ST_FOR_INIT_TOKEN: {
                if (!slotTable.getCurrentTokenInitStatus().equals((Object)Constants.InitStatus.TRUE)) {
                    bl = authState.isAdmin();
                    break;
                }
                bl = authState.isZero();
                break;
            }
            case ST_LOGIN_KEY_MANAGER: {
                bl = authState.isKeyManager() && bl2;
                break;
            }
        }
        this.setEnabled(bl);
    }

    public void setEnabled(ObjectTable objectTable) {
        if (this.enableCondition.equals((Object)EnableCondition.ALWAYS_TRUE)) {
            return;
        }
        boolean bl = false;
        switch (this.enableCondition) {
            case OT_OBJECTS_SELECTED: {
                bl = objectTable.getSelectedRowCount() > 0;
                break;
            }
            case OT_ONE_OBJECT_SELECTED: {
                bl = objectTable.getSelectedRowCount() == 1;
                break;
            }
            case OT_CERT_SELECTED: {
                if (objectTable.getSelectedRowCount() != 1) break;
                String string = (String)objectTable.getValueAt(objectTable.getSelectedRow(), 0);
                bl = string.equals(Constants.ObjClass.CKO_CERTIFICATE.toString());
                break;
            }
            case OT_OBJECTS_SELECTED_AND_LOGIN_USER_OR_KEYM: {
                AuthState authState = new AuthState(SlotTable.getCurrentAuthState());
                bl = objectTable.getSelectedRowCount() > 0 && (authState.isUser() || authState.isKeyManager());
                break;
            }
        }
        this.setEnabled(bl);
    }

    public static enum EnableCondition {
        ALWAYS_TRUE,
        ST_IS_P11_INIT,
        ST_SLOT_SELECTED_NO_ERROR,
        ST_NO_LOGIN_OR_LOGGED_SLOT_SELECTED,
        ST_NO_LOGIN_AND_TOKEN_INIT,
        ST_NO_LOGIN_AND_PIN_INIT,
        ST_LOGIN,
        ST_LOGIN_SO,
        ST_LOGIN_SO_AND_PIN_NOT_INIT,
        ST_LOGIN_USER,
        ST_LOGIN_USER_OR_KEYM,
        ST_LOGIN_SO_OR_USER,
        ST_LOGIN_SO_ONLY_OR_USER_ONLY,
        ST_LOGIN_ADMIN_AND_TOKEN_INIT,
        ST_FOR_INIT_TOKEN,
        ST_LOGIN_KEY_MANAGER,
        OT_OBJECTS_SELECTED,
        OT_ONE_OBJECT_SELECTED,
        OT_CERT_SELECTED,
        OT_OBJECTS_SELECTED_AND_LOGIN_USER_OR_KEYM;

    }
}

